package com.ejianc.business.tender.stuff.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.rmat.bean.RmatDocumentSupplierEntity;
import com.ejianc.business.tender.stuff.bean.*;
import com.ejianc.business.tender.stuff.service.*;
import com.ejianc.business.tender.stuff.vo.StuffDocumentSellVO;
import com.ejianc.business.tender.stuff.vo.StuffDocumentSellVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.tender.stuff.mapper.StuffDocumentSellMapper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 招标文件报价表
 * 
 * @author generator
 * 
 */
@Service("stuffDocumentSellService")
public class StuffDocumentSellServiceImpl extends BaseServiceImpl<StuffDocumentSellMapper, StuffDocumentSellEntity> implements IStuffDocumentSellService{
    @Autowired
    private IStuffPicketageService stuffPicketageService;
    @Autowired
    private IStuffPicketageRefsupplierService stuffPicketageRefsupplierService;
    @Autowired
    private IStuffInviteDetailBidderService bidderService;
    @Autowired
    private IStuffInviteDetailRecordService recordService;

    @Override
    public List<StuffDocumentSellEntity> selectMaterialType(Long documentId) {
        return baseMapper.selectMaterialType(documentId);
    }

    @Override
    public List<StuffDocumentSellVO> queryListByIds(Long id) {
        StuffPicketageRefsupplierEntity stuffPicketageRefsupplierEntity = stuffPicketageRefsupplierService.selectById(id);
        List<StuffDocumentSellVO> stuffDocumentSellVOList = new ArrayList<>();
        List<StuffDocumentSellVO> stuffDocumentSellVOS = new ArrayList<>();
        StuffPicketageEntity stuffPicketageEntity = stuffPicketageService.selectById(stuffPicketageRefsupplierEntity.getPicketageId());
        //流程定标
        if (stuffPicketageRefsupplierEntity.getPicketageFlag()==0){
            LambdaQueryWrapper<StuffDocumentSellEntity> listWrapper = Wrappers.lambdaQuery();
            listWrapper.eq(StuffDocumentSellEntity::getDocumentId,stuffPicketageEntity.getDocumentId());
            listWrapper.eq(StuffDocumentSellEntity::getSupplierId,stuffPicketageRefsupplierEntity.getSupplierId());
            if (stuffPicketageRefsupplierEntity.getPurchaseType() == 0){
                listWrapper.eq(StuffDocumentSellEntity::getProjectId,stuffPicketageRefsupplierEntity.getProjectId());
            }
            listWrapper.eq(StuffDocumentSellEntity::getTenderFlag,1);

            List<StuffDocumentSellEntity> documentSellList = super.list(listWrapper);
            stuffDocumentSellVOList = BeanMapper.mapList(documentSellList,StuffDocumentSellVO.class);
            for (StuffDocumentSellVO stuffDocumentSellVO : stuffDocumentSellVOList){
                BigDecimal tenderNum = stuffDocumentSellVO.getTenderNum();
                BigDecimal signNum = stuffDocumentSellVO.getSignNum() == null ? BigDecimal.ZERO : stuffDocumentSellVO.getSignNum();
                stuffDocumentSellVO.setSurplusNum(tenderNum.subtract(signNum));
            }
            stuffDocumentSellVOS = stuffDocumentSellVOList.stream().filter(s -> s.getSurplusNum().compareTo(BigDecimal.ZERO) == 1).collect(Collectors.toList());

        }
        //直接定标
        else if (stuffPicketageRefsupplierEntity.getPicketageFlag()==1){
            List<StuffInviteDetailBidderEntity> bidderEntityList1 = bidderService.list(new QueryWrapper<StuffInviteDetailBidderEntity>().eq("invite_id", stuffPicketageRefsupplierEntity.getPicketageId()).eq("supplier_id",stuffPicketageRefsupplierEntity.getSupplierId()));
            List<StuffInviteDetailBidderEntity> bidderEntityList = bidderEntityList1.stream().filter(t -> t.getNum().compareTo(t.getSignNum() == null ? BigDecimal.ZERO : t.getSignNum()) > 0).collect(Collectors.toList());
            for (StuffInviteDetailBidderEntity bidderEntity : bidderEntityList) {
                StuffDocumentSellVO stuffDocumentSellVO = new StuffDocumentSellVO();
                StuffInviteDetailRecordEntity recordEntity = recordService.selectById(bidderEntity.getInviteDetailId());
                stuffDocumentSellVO.setId(bidderEntity.getId());
                stuffDocumentSellVO.setProjectId(recordEntity.getDetailProjectId());
                stuffDocumentSellVO.setProjectName(recordEntity.getDetailProjectName());
                stuffDocumentSellVO.setMaterialId(recordEntity.getMaterialId());
                stuffDocumentSellVO.setMaterialName(recordEntity.getMaterialName());
                stuffDocumentSellVO.setMaterialCode(recordEntity.getMaterialCode());
                stuffDocumentSellVO.setMaterialTypeId(recordEntity.getMaterialTypeId());
                stuffDocumentSellVO.setMaterialTypeName(recordEntity.getMaterialTypeName());
                stuffDocumentSellVO.setUnit(recordEntity.getUnit());
                stuffDocumentSellVO.setSpec(recordEntity.getSpec());
                stuffDocumentSellVO.setDetailId(bidderEntity.getId());
                stuffDocumentSellVO.setSupplierId(bidderEntity.getSupplierId());
                stuffDocumentSellVO.setSupplierName(bidderEntity.getSupplierName());
                stuffDocumentSellVO.setBrand(bidderEntity.getBrand());
                stuffDocumentSellVO.setPrice(bidderEntity.getPrice());
                stuffDocumentSellVO.setPriceTax(bidderEntity.getTaxPrice());
                stuffDocumentSellVO.setRate(bidderEntity.getTaxBidderRate());
                stuffDocumentSellVO.setTenderNum(bidderEntity.getNum());
                stuffDocumentSellVO.setTenderMoney(bidderEntity.getMoney());
                stuffDocumentSellVO.setTenderMoneyTax(bidderEntity.getTaxMoney());
                stuffDocumentSellVO.setSellTax(bidderEntity.getTaxBidder());
                stuffDocumentSellVO.setSignNum(bidderEntity.getSignNum() == null ? BigDecimal.ZERO : bidderEntity.getSignNum());
                stuffDocumentSellVO.setSurplusNum(bidderEntity.getNum().subtract(bidderEntity.getSignNum() == null ? BigDecimal.ZERO : bidderEntity.getSignNum()));
                stuffDocumentSellVOS.add(stuffDocumentSellVO);
            }
        }
        return stuffDocumentSellVOS;
    }
}
