package com.ejianc.business.tender.stuff.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.stuff.bean.StuffInviteEntity;
import com.ejianc.business.tender.stuff.bean.StuffPicketageEntity;
import com.ejianc.business.tender.stuff.bean.StuffWinnoticeEntity;
import com.ejianc.business.tender.stuff.service.IStuffInviteService;
import com.ejianc.business.tender.stuff.service.IStuffPicketageService;
import com.ejianc.business.tender.stuff.service.IStuffWinnoticeService;
import com.ejianc.business.tender.stuff.vo.StuffPicketageSupplierVO;
import com.ejianc.business.tender.stuff.vo.TenderStageEnum;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import jdk.nashorn.internal.ir.WhileNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.tender.stuff.mapper.StuffPicketageSupplierMapper;
import com.ejianc.business.tender.stuff.bean.StuffPicketageSupplierEntity;
import com.ejianc.business.tender.stuff.service.IStuffPicketageSupplierService;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 定标供应商表
 * 
 * @author generator
 * 
 */
@Service("stuffPicketageSupplierService")
public class StuffPicketageSupplierServiceImpl extends BaseServiceImpl<StuffPicketageSupplierMapper, StuffPicketageSupplierEntity> implements IStuffPicketageSupplierService{
    @Autowired
    private IStuffPicketageSupplierService stuffPicketageSupplierService;
    @Autowired
    private IStuffPicketageService stuffPicketageService;
    @Autowired
    private IStuffWinnoticeService stuffWinnoticeService;
    @Autowired
    private IStuffInviteService stuffInviteService;
    @Autowired
    private IProcessService processService;
    @Override
    public List<StuffPicketageSupplierVO> queryDetail(Long id) {
        LambdaQueryWrapper<StuffPicketageSupplierEntity> lambdaSupplierList = Wrappers.lambdaQuery();
        lambdaSupplierList.eq(StuffPicketageSupplierEntity::getPicketageId,id);
        List<StuffPicketageSupplierEntity> listSupplier = stuffPicketageSupplierService.list(lambdaSupplierList);
        List<StuffPicketageSupplierVO> stuffPicketageSupplierVOS = BeanMapper.mapList(listSupplier, StuffPicketageSupplierVO.class);

        return stuffPicketageSupplierVOS;
    }
}
