package com.ejianc.business.tender.sub.controller.api;

import com.ejianc.business.tender.common.vo.TenderPicketageVO;
import com.ejianc.business.tender.sub.service.ISubDocumentSellService;
import com.ejianc.business.tender.sub.service.ISubPicketageRefsupplierService;
import com.ejianc.business.tender.sub.vo.SubDocumentSellVO;
import com.ejianc.business.tender.sub.vo.SubSupplierDataVO;
import com.ejianc.foundation.support.api.ICustomerApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2020/6/23 10:30
 */
@RestController
@RequestMapping("/api/subPicketageRefsupplier/")
public class TenderSubApi {


    @Autowired
    private ISubPicketageRefsupplierService subPicketageRefsupplierService;

    @Autowired
    private ISupplierApi supplierApi;

    @Autowired
    private ICustomerApi customerApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private ISubDocumentSellService subDocumentSellService;

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "updateById", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> updateById(@RequestParam Long id,@RequestParam Integer occupyFlag) {
        String s = subPicketageRefsupplierService.updateById(id,occupyFlag);
        return CommonResponse.success("删除成功！");
    }
    @ApiOperation("更新签订状态")
    @RequestMapping(value = "updateStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateStatus(@RequestBody TenderPicketageVO tenderPicketageVO) {
        String s = subPicketageRefsupplierService.updateStatus(tenderPicketageVO,0);
        return CommonResponse.success(s);
    }
    @ApiOperation("删除操作-更新签订状态")
    @RequestMapping(value = "delUpdateStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delUpdateStatus(@RequestBody TenderPicketageVO tenderPicketageVO) {
        String s = subPicketageRefsupplierService.updateStatus(tenderPicketageVO,1);
        return CommonResponse.success(s);
    }
    @ApiOperation("根据项目id,supplierId查询中标列表(树形)")
    @RequestMapping(value = "queryTreeByIds", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SubDocumentSellVO>> queryTreeByIds(@RequestParam Long id) {
        List<SubDocumentSellVO> list = subDocumentSellService.queryTreeByIds(id);
        return CommonResponse.success("查询详情数据成功！",list);
    }
    @ApiOperation("根据项目id,supplierId查询中标列表(树形)")
    @RequestMapping(value = "queryTreeList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SubSupplierDataVO>> queryTreeList(@RequestParam Long id) {
        List<SubSupplierDataVO> list = subDocumentSellService.queryTreeList(id);
        return CommonResponse.success("查询详情数据成功！",list);
    }


}
