package com.ejianc.business.tender.sub.service;

import com.ejianc.business.tender.sub.vo.SubDocumentRecordVO;
import com.ejianc.business.tender.sub.vo.SubDocumentSellVO;
import com.ejianc.business.tender.sub.vo.SubDocumentSupplierSellVO;
import com.ejianc.business.tender.sub.vo.SubDocumentVO;
import com.ejianc.business.tender.sub.bean.SubDocumentEntity;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

/**
 * 招标文件主表
 * 
 * @author generator
 * 
 */
public interface ISubDocumentService extends IBaseService<SubDocumentEntity> {

    SubDocumentVO publishDocument(Long id) throws Exception;

    SubDocumentVO bidDocument(Long id);

    SubDocumentVO queryDetail(Long id);

    SubDocumentVO queryDocDetail(Long id,Integer talkNum);


    List<SubDocumentSellVO> getSchemeDetail(SubDocumentSellVO subDocumentSellVO);

    SubDocumentSupplierSellVO getSupplierSchemeDetail(Long supplierDetailId, Long documentId);

    SubDocumentVO extendDocument(SubDocumentRecordVO subDocumentRecordVO);

    SubDocumentSupplierSellVO getSupplierSchemeTalkDetail(Long supplierDetailId, Long talkId);

    SubDocumentVO publishManyDocument(Long id) throws InvocationTargetException, IllegalAccessException;

    CommonResponse delSupplier(Long id);

    SubDocumentVO saveManyDocument(Long id);

    SubDocumentSupplierSellVO getSupplierSchemeDetailTalk(Long supplierDetailId, Long talkId);

    SubDocumentVO saveDocument(Long noticeId);

    SubDocumentVO queryDetailNum(Long documentId);

    Boolean supplierPushSell(HttpServletRequest request, MultipartFile file);

    String uploadById(Long attachId,Long inviteId);

    String deleteFileById(Long sourceId, List<String> fileNames);

    SubDocumentSupplierSellVO getSupplierSchemeDetailDb(Long schemeId, Long documentId);

    SubDocumentVO saveOrUpdate(SubDocumentVO saveorUpdateVO);

    SubDocumentVO queryDetail1(Long documentId, Integer num);

    /**
     * 检查所选专家数量
     * 规则：
     *      1.集团专家、项目专家比例1:2，集团专家向上取整
     *      2.评标专家数必须为单数
     * @param documentId
     * @return
     */
    CommonResponse<Boolean> checkExpertNum(Long documentId);
}
