package com.ejianc.business.tender.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import groovy.util.logging.Slf4j;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Component
@Slf4j
public class ThirdSystemUtils {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private final String GCY_CACHE_KEY_PREFIX = "GCY::";//工程云

//    private final String GF_CACHE_KEY_PREFIX = "GF::";//供方

    public String  getToken(String tokenUrl,CacheManager cacheManager){

        String key = GCY_CACHE_KEY_PREFIX + "ACCESS_TOKEN";
        String accessroken = cacheManager.get(key);
        logger.debug("获取accessroken:=====" + accessroken);
        if(StringUtils.isBlank(accessroken)){
            JSONObject result = getForObject(tokenUrl);
            JSONObject dataObject = (JSONObject) result.get("data");
            if((Boolean) dataObject.get("querysucflag")){
                accessroken = (String) dataObject.get("access_token");
                Integer expiresTime = (Integer) dataObject.get("expires_in");
                cacheManager.setex(key, accessroken, expiresTime);
            }else{
                throw new BusinessException((String) dataObject.get("errormsg"));
            }
            logger.debug("获取accessroken:" + accessroken);
        }
        return  accessroken;
    }

    public JSONObject getForObject(String url){
        JSONObject result;
        Map<String, String> headers = new HashMap<>();
        try {
            result = JSONObject.parseObject(HttpTookit.get(url, null, headers));
        } catch (Exception e) {
            logger.error(e.getMessage());
            throw new BusinessException("调用第三方服务调用报错");
        }
        return  result;
    }

    private CommonResponse<JSONObject> sendGetReq(String tokenUrl,String url, Map<String, Object> params,CacheManager cacheManager) throws Exception {
        Map<String, String> headers = new HashMap<>(5);
        String accessToken = getToken(tokenUrl,cacheManager);
        if(null == accessToken) {
            throw new BusinessException("获取服务accessToken失败！");
        }
        headers.put("access_token", accessToken);
        String reqResp =  HttpTookit.get(url, params, headers, 10000, 20000);
        logger.info("发送get请求【地址： {}, 参数：{}, header: {}】, 响应结果：{}", url, JSON.toJSONString(params), headers, reqResp);

        JSONObject jsonData = JSONObject.parseObject(reqResp);
        if(0!=Integer.parseInt(jsonData.get("code").toString())) {
            return CommonResponse.error(null != jsonData.get("msg") ? jsonData.get("msg").toString() : "调用接口失败！");
        }
        return CommonResponse.success(jsonData);
    }

    public CommonResponse<JSONObject> sendPostReq(String tokenUrl,String url, String paramJson,CacheManager cacheManager) throws Exception {
        Map<String, String> headers = new HashMap<>(5);
        String accessToken = getToken(tokenUrl,cacheManager);
        if(null == accessToken) {
            throw new BusinessException("获取服务accessToken失败！");
        }
        headers.put("access_token", accessToken);
        String reqResp =  HttpTookit.postByJson(url, paramJson, headers, 10000, 20000);
        logger.info("发送post请求【地址： {}, 参数：{}, header: {}】, 响应结果：{}", url, paramJson, headers, reqResp);

        JSONObject jsonData = JSONObject.parseObject(reqResp);
        if(0!=Integer.parseInt(jsonData.get("code").toString())) {
            return CommonResponse.error(null != jsonData.get("msg") ? jsonData.get("msg").toString() : "调用接口失败！");
        }
        return CommonResponse.success(jsonData);
    }
    public boolean upFile(String basehost,String sourceType,String sourceId,String billType,MultipartFile file,HttpServletRequest request){
        String authority = request.getHeader("authority");
        logger.info("获取认证信息authority-{}"+authority);
        if(null != authority) {
            InvocationInfoProxy.setExtendAttribute("authority", authority);
            Map<String,String> params = new HashMap<>();
            params.put("sourceType", sourceType);
            params.put("sourceId", sourceId);
            params.put("billType", billType);
            params.put("originalFileNameStr", file.getOriginalFilename());
            Map<String,String> headers = new HashMap<>();
            headers.put("authority", authority);
            AttachmentVO attachmentVO = null;
            try {
                //保存新的模板文件
                String fileUploadRespStr = postUpFile(basehost +"ejc-file-web/attachment/upload", params, headers, file.getInputStream(),file.getOriginalFilename());
                logger.info("模板文件信息--"+fileUploadRespStr);
                CommonResponse<List<AttachmentVO>> attachmentResp = JSONObject.parseObject(fileUploadRespStr, CommonResponse.class);
                logger.info("上传文件返回信息--"+attachmentResp);
                if(!attachmentResp.isSuccess()) {
                    logger.error("保存模板文件失败sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, 原因：{}",
                            sourceId, sourceType, billType, file.getOriginalFilename(), attachmentResp.getMsg());
                    return false;
                }
                attachmentVO = JSONObject.parseObject(JSONObject.toJSONString(attachmentResp.getData().get(0)), AttachmentVO.class);
            } catch (Exception e) {
                logger.error("保存模板文件失败sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, 原因：",
                        sourceId, sourceType, billType, file.getOriginalFilename(), e);
                return false;
            }
            logger.info("模板文件保存成功：{}", JSONObject.toJSONString(attachmentVO));
        } else {
            return false;
        }
        return true;
    }


    public static String postUpFile(String url, Map<String, String> params, Map<String, String> headers, InputStream inputStream,String fileName) throws Exception {
        String charset = "UTF-8";
        HttpClient client = null;

        HttpPost post = new HttpPost(url);
        HttpServletRequest request = null;
        String result = "";
        Integer connTimeout = 10000;
        Integer readTimeout = 10000;

        try {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.setCharset(Charset.forName("UTF-8")).addBinaryBody("file",
                    inputStream, ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8"), fileName);
            for(String key : params.keySet()) {
                builder.addPart(key, new StringBody(params.get(key), ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8")));
            }
            HttpEntity entity = builder.build();
            post.setEntity(entity);

            RequestConfig.Builder customReqConf = RequestConfig.custom();
            if (connTimeout != null) {
                customReqConf.setConnectTimeout(connTimeout);
            }

            if (readTimeout != null) {
                customReqConf.setSocketTimeout(readTimeout);
            }

            post.setConfig(customReqConf.build());
            if (null != headers) {
                String key = null;
                Iterator it = headers.keySet().iterator();

                while(it.hasNext()) {
                    key = (String)it.next();
                    post.addHeader(key, (String)headers.get(key));
                }
            } else {
                request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
                post.addHeader("authority", request.getHeader("authority"));
                post.addHeader("ejc-token", request.getHeader("ejc-token"));
            }

            HttpResponse res;
            if (url.startsWith("https")) {
                client = HttpTookit.createSSLInsecureClient();
                res = ((HttpClient)client).execute(post);
            } else {
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
                cm.setMaxTotal(128);
                cm.setDefaultMaxPerRoute(128);
                client = HttpClients.custom().setConnectionManager(cm).build();
                res = ((HttpClient)client).execute(post);
            }
            result = IOUtils.toString(res.getEntity().getContent(), charset);
            JSONObject jsonObject = JSONObject.parseObject(result);
            String code = jsonObject.getString("code");
            if(!"0".equals(code)){
                throw new BusinessException("网络异常！请联系管理员");
            }

        } finally {
            post.releaseConnection();
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                ((CloseableHttpClient)client).close();
            }
        }

        return result;
    }

    public String postFile(String tokenUrl, String url, Map<String, String> params, Map<String, String> headers, Map<String, byte[]> map,CacheManager cacheManager) throws Exception {
        String charset = "UTF-8";
        HttpClient client = null;

        //token
        String accessToken = getToken(tokenUrl,cacheManager);
        if(null == accessToken) {
            throw new BusinessException("获取服务accessToken失败！");
        }
        headers.put("access_token", accessToken);
        HttpPost post = new HttpPost(url);
        HttpServletRequest request = null;
        String result = "";
        Integer connTimeout = 10000;
        Integer readTimeout = 10000;

        try {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.setCharset(Charset.forName("UTF-8"));
            if (!map.isEmpty()){
                map.forEach((key,value) ->{
                    builder.addBinaryBody("file",
                            new ByteArrayInputStream(value), ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8"), key);
                });
            }
            for(String key : params.keySet()) {
                builder.addPart(key, new StringBody(params.get(key), ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8")));
            }
            HttpEntity entity = builder.build();
            post.setEntity(entity);

            RequestConfig.Builder customReqConf = RequestConfig.custom();
            if (connTimeout != null) {
                customReqConf.setConnectTimeout(connTimeout);
            }

            if (readTimeout != null) {
                customReqConf.setSocketTimeout(readTimeout);
            }

            post.setConfig(customReqConf.build());
            if (null != headers) {
                String key = null;
                Iterator it = headers.keySet().iterator();

                while(it.hasNext()) {
                    key = (String)it.next();
                    post.addHeader(key, (String)headers.get(key));
                }
            } else {
                request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
                post.addHeader("authority", request.getHeader("authority"));
                post.addHeader("ejc-token", request.getHeader("ejc-token"));
            }

            HttpResponse res;
            if (url.startsWith("https")) {
                client = HttpTookit.createSSLInsecureClient();
                res = ((HttpClient)client).execute(post);
            } else {
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
                cm.setMaxTotal(128);
                cm.setDefaultMaxPerRoute(128);
                client = HttpClients.custom().setConnectionManager(cm).build();
                res = ((HttpClient)client).execute(post);
            }

            result = IOUtils.toString(res.getEntity().getContent(), charset);
            JSONObject jsonObject = JSONObject.parseObject(result);
            String code = jsonObject.getString("code");
            if(!"0".equals(code)){
                throw new BusinessException("网络异常！请联系管理员");
            }
        } finally {
            post.releaseConnection();
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                ((CloseableHttpClient)client).close();
            }
        }

        return result;
    }
}
