/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rent.bean.RentDocumentEntity;
import com.ejianc.business.tender.rent.bean.RentDocumentSchemeEntity;
import com.ejianc.business.tender.rent.bean.RentDocumentSellEntity;
import com.ejianc.business.tender.rent.bean.RentDocumentSupplierEntity;
import com.ejianc.business.tender.rent.bean.RentInviteEntity;
import com.ejianc.business.tender.rent.bean.RentTalkDetailEntity;
import com.ejianc.business.tender.rent.bean.RentTalkEntity;
import com.ejianc.business.tender.rent.bean.RentTalkRecordDetailEntity;
import com.ejianc.business.tender.rent.bean.RentTalkRecordEntity;
import com.ejianc.business.tender.rent.mapper.RentTalkMapper;
import com.ejianc.business.tender.rent.service.IRentDocumentSchemeService;
import com.ejianc.business.tender.rent.service.IRentDocumentSellService;
import com.ejianc.business.tender.rent.service.IRentDocumentService;
import com.ejianc.business.tender.rent.service.IRentDocumentSupplierService;
import com.ejianc.business.tender.rent.service.IRentInviteService;
import com.ejianc.business.tender.rent.service.IRentTalkDetailService;
import com.ejianc.business.tender.rent.service.IRentTalkRecordDetailService;
import com.ejianc.business.tender.rent.service.IRentTalkRecordService;
import com.ejianc.business.tender.rent.service.IRentTalkService;
import com.ejianc.business.tender.rent.vo.RentDocumentSellVO;
import com.ejianc.business.tender.rent.vo.RentDocumentSupplierTbVO;
import com.ejianc.business.tender.rent.vo.RentDocumentSupplierVO;
import com.ejianc.business.tender.rent.vo.RentDocumentVO;
import com.ejianc.business.tender.rent.vo.RentQuotationMaterialVO;
import com.ejianc.business.tender.rent.vo.RentQuotationSchemeVO;
import com.ejianc.business.tender.rent.vo.RentQuotationSupplierVO;
import com.ejianc.business.tender.rent.vo.RentSupplierSellVO;
import com.ejianc.business.tender.rent.vo.RentTalkDetailVO;
import com.ejianc.business.tender.rent.vo.RentTalkRecordVO;
import com.ejianc.business.tender.rent.vo.RentTalkVO;
import com.ejianc.business.tender.rent.vo.SupplierReplenishVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="rentTalkService")
public class RentTalkServiceImpl
extends BaseServiceImpl<RentTalkMapper, RentTalkEntity>
implements IRentTalkService {
    @Value(value="${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value(value="${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value(value="${gysUrl.updateSupOffer}")
    private String updateSupOffer;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private CacheManager cacheManager;
    private static final String BILL_CODE = "invite-talk-code";
    @Autowired
    private IRentTalkDetailService rentTalkDetailService;
    @Autowired
    private IRentTalkRecordService rentTalkRecordService;
    @Autowired
    private IRentTalkRecordDetailService rentTalkRecordDetailService;
    @Autowired
    private IRentDocumentSellService rentDocumentSellService;
    @Autowired
    private IRentDocumentService rentDocumentService;
    @Autowired
    private IRentInviteService rentInviteService;
    @Autowired
    private IRentDocumentSupplierService rentDocumentSupplierService;
    @Autowired
    private IRentDocumentSchemeService rentDocumentSchemeService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IProcessService processService;
    private static final String BILL_SUPPLIER_TYPE = "BT202202000003";
    @Autowired
    private IAttachmentApi attachmentApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    @Transactional
    public RentTalkVO publishTalk(Long id) {
        RentTalkEntity rentTalkEntity = (RentTalkEntity)((Object)super.selectById((Serializable)id));
        rentTalkEntity.setPublishFlag(0);
        super.updateById((Object)rentTalkEntity);
        RentDocumentSupplierTbVO rentDocumentSupplierTbVO = new RentDocumentSupplierTbVO();
        rentDocumentSupplierTbVO.setSourceId(rentTalkEntity.getInviteId().toString());
        rentDocumentSupplierTbVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u6d3d\u5546\u8c08\u5224");
        rentDocumentSupplierTbVO.setNoticeType(Integer.valueOf(4));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatStart = simpleDateFormat.format(rentTalkEntity.getTalkStartTime());
        rentDocumentSupplierTbVO.setOfferStartTime(formatStart);
        String formatEnd = simpleDateFormat.format(rentTalkEntity.getTalkEndTime());
        rentDocumentSupplierTbVO.setOfferEndTime(formatEnd);
        rentDocumentSupplierTbVO.setMemo(rentTalkEntity.getMemo());
        rentDocumentSupplierTbVO.setTalkMoney(rentTalkEntity.getTalkMoney());
        rentDocumentSupplierTbVO.setTalkNum(rentTalkEntity.getTalkNum());
        rentDocumentSupplierTbVO.setTenderName(rentTalkEntity.getTalkName());
        rentDocumentSupplierTbVO.setSystemId((String)this.proSupplierApi.getEjcCloudSystemCode().getData());
        String stringFb = JSONObject.toJSONString((Object)rentDocumentSupplierTbVO);
        this.logger.info("\u6d3d\u5546\u8c08\u5224\u53d1\u5e03" + stringFb);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.saveOrUpdateUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u6d3d\u5546\u8c08\u5224\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return this.queryDetail(id);
    }

    @Override
    public RentTalkVO extendTalk(RentTalkDetailVO rentTalkDetailVO) {
        RentTalkDetailEntity rentDocumentRecordEntity = (RentTalkDetailEntity)((Object)BeanMapper.map((Object)rentTalkDetailVO, RentTalkDetailEntity.class));
        this.rentTalkDetailService.save((Object)rentDocumentRecordEntity);
        RentTalkEntity rentTalkEntity = (RentTalkEntity)((Object)super.selectById((Serializable)rentTalkDetailVO.getTalkId()));
        rentTalkEntity.setTalkEndTime(rentTalkDetailVO.getNewTime());
        boolean b = super.updateById((Object)rentTalkEntity);
        RentSupplierSellVO supplierSellVO = new RentSupplierSellVO();
        supplierSellVO.setSourceId(Long.toString(rentTalkEntity.getInviteId()));
        supplierSellVO.setOfferEndTime(rentTalkDetailVO.getNewTime());
        String stringFb = JSONObject.toJSONString((Object)supplierSellVO);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.updateTimeUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u6d3d\u5546\u8c08\u5224\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return this.queryDetail(rentTalkDetailVO.getTalkId());
    }

    @Override
    public RentTalkVO saveTalk(Long documentId) {
        RentTalkEntity entity = new RentTalkEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        RentDocumentEntity documentEntity = (RentDocumentEntity)((Object)this.rentDocumentService.selectById(documentId));
        documentEntity.setNextFlag(0);
        this.rentDocumentService.saveOrUpdate((Object)documentEntity);
        RentDocumentEntity rentDocumentEntity = (RentDocumentEntity)((Object)this.rentDocumentService.selectById(documentId));
        RentInviteEntity rentInviteEntity = (RentInviteEntity)((Object)this.rentInviteService.selectById(rentDocumentEntity.getInviteId()));
        entity.setProjectCode(rentDocumentEntity.getProjectCode());
        entity.setInviteId(rentDocumentEntity.getInviteId());
        entity.setProjectId(rentDocumentEntity.getProjectId());
        entity.setProjectName(rentDocumentEntity.getProjectName());
        entity.setOrgId(rentDocumentEntity.getOrgId());
        entity.setOrgName(rentDocumentEntity.getOrgName());
        entity.setParentOrgId(rentDocumentEntity.getParentOrgId());
        entity.setParentOrgName(rentDocumentEntity.getParentOrgName());
        entity.setBrandFlag(rentDocumentEntity.getBrandFlag());
        entity.setBillId(documentId);
        entity.setTalkNum(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        String taikNumName = "\u7b2c" + entity.getTalkNum() + "\u8f6e\u62a5\u4ef7";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(rentDocumentEntity.getPurchaseType());
        entity.setTalkName(rentInviteEntity.getTenderName());
        super.save((Object)entity);
        rentInviteEntity.setTenderStage(7);
        this.rentInviteService.updateById((Object)rentInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u6d3d\u5546\u8c08\u5224");
        processEntity.setTenderId(rentDocumentEntity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("rent/talkNegotiate");
        this.processService.saveOrUpdate((Object)processEntity);
        RentTalkVO vo = (RentTalkVO)BeanMapper.map((Object)((Object)entity), RentTalkVO.class);
        RentTalkVO rentTalkVO = this.queryDetail(vo.getId());
        return rentTalkVO;
    }

    @Override
    public RentTalkVO queryDetail(Long id) {
        RentTalkEntity rentTalkEntity = (RentTalkEntity)((Object)super.selectById((Serializable)id));
        RentTalkVO rentTalkVO = (RentTalkVO)BeanMapper.map((Object)((Object)rentTalkEntity), RentTalkVO.class);
        Integer talkNum = rentTalkEntity.getTalkNum();
        if (rentTalkEntity.getPublishFlag() == 1) {
            talkNum = talkNum - 1;
        }
        RentDocumentVO rentDocumentVO = this.rentDocumentService.queryDocDetail(rentTalkEntity.getBillId(), talkNum);
        rentTalkVO.setRentDocumentDetailSellList(rentDocumentVO.getRentDocumentDetailSellList());
        rentTalkVO.setRentDocumentSupplierSchemeList(rentDocumentVO.getRentDocumentSupplierSchemeList());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(RentDocumentSupplierEntity::getDocumentId, (Object)rentTalkEntity.getBillId());
        lambda.eq(RentDocumentSupplierEntity::getTalkNum, (Object)0);
        List supplierList = this.rentDocumentSupplierService.list((Wrapper)lambda);
        List documentSupplierVOList = BeanMapper.mapList((Iterable)supplierList, RentDocumentSupplierVO.class);
        rentTalkVO.setRentDocumentSupplierList(documentSupplierVOList);
        LambdaQueryWrapper lambdaRecord = Wrappers.lambdaQuery();
        lambdaRecord.eq(RentTalkRecordEntity::getBillId, (Object)rentTalkEntity.getBillId());
        lambdaRecord.orderByAsc(RentTalkRecordEntity::getTalkNum);
        List rentTalkRecordEntityList = this.rentTalkRecordService.list((Wrapper)lambdaRecord);
        List rentTalkRecordList = BeanMapper.mapList((Iterable)rentTalkRecordEntityList, RentTalkRecordVO.class);
        rentTalkVO.setTalkRecordEntityList(rentTalkRecordList);
        return rentTalkVO;
    }

    @Override
    @Transactional
    public RentTalkVO againSaveTalk(Long id) {
        RentTalkEntity entity = new RentTalkEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        RentTalkEntity rentTalkEntity = (RentTalkEntity)((Object)super.selectById((Serializable)id));
        entity.setProjectCode(rentTalkEntity.getProjectCode());
        entity.setProjectId(rentTalkEntity.getProjectId());
        entity.setProjectName(rentTalkEntity.getProjectName());
        entity.setOrgId(rentTalkEntity.getOrgId());
        entity.setOrgName(rentTalkEntity.getOrgName());
        entity.setParentOrgId(rentTalkEntity.getParentOrgId());
        entity.setParentOrgName(rentTalkEntity.getParentOrgName());
        entity.setBrandFlag(rentTalkEntity.getBrandFlag());
        entity.setBillId(rentTalkEntity.getBillId());
        entity.setInviteId(rentTalkEntity.getInviteId());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setTalkNum(rentTalkEntity.getTalkNum() + 1);
        String taikNumName = "\u7b2c" + entity.getTalkNum() + "\u8f6e\u62a5\u4ef7";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(rentTalkEntity.getPurchaseType());
        super.save((Object)entity);
        RentTalkRecordEntity rentTalkRecordEntity = (RentTalkRecordEntity)((Object)BeanMapper.map((Object)((Object)rentTalkEntity), RentTalkRecordEntity.class));
        rentTalkRecordEntity.setTalkId(rentTalkEntity.getId());
        rentTalkRecordEntity.setId(null);
        this.rentTalkRecordService.save((Object)rentTalkRecordEntity);
        List<RentTalkDetailEntity> rentTalkDetailList = rentTalkEntity.getRentTalkDetailList();
        List rentTalkRecordDetailEntityList = BeanMapper.mapList(rentTalkDetailList, RentTalkRecordDetailEntity.class);
        for (RentTalkRecordDetailEntity rentTalkRecordDetailEntity : rentTalkRecordDetailEntityList) {
            rentTalkRecordDetailEntity.setId(null);
            rentTalkRecordDetailEntity.setRecordId(rentTalkRecordEntity.getId());
        }
        this.rentTalkRecordDetailService.saveBatch(rentTalkRecordDetailEntityList);
        super.removeById((Serializable)id, false);
        LambdaQueryWrapper lambdaProcess = Wrappers.lambdaQuery();
        lambdaProcess.eq(ProcessEntity::getBillId, (Object)id);
        lambdaProcess.eq(ProcessEntity::getTenderId, (Object)rentTalkEntity.getInviteId());
        ProcessEntity processEntity = (ProcessEntity)((Object)this.processService.getOne((Wrapper)lambdaProcess));
        processEntity.setBillId(entity.getId());
        this.processService.updateById((Object)processEntity);
        RentTalkVO vo = (RentTalkVO)BeanMapper.map((Object)((Object)entity), RentTalkVO.class);
        this.addLastSell(rentTalkEntity.getTalkNum(), rentTalkEntity.getBillId());
        return this.queryDetail(entity.getId());
    }

    @Override
    public RentTalkVO replenishSell(Long id) {
        RentTalkEntity rentTalkEntity = (RentTalkEntity)((Object)super.selectById((Serializable)id));
        Integer talkNum = rentTalkEntity.getTalkNum();
        Long billId = rentTalkEntity.getBillId();
        this.addLastSell(talkNum, billId);
        return new RentTalkVO();
    }

    @Override
    public Boolean getSellFull(Long id) {
        RentTalkEntity rentTalkEntity = (RentTalkEntity)((Object)super.selectById((Serializable)id));
        Integer talkNum = rentTalkEntity.getTalkNum();
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(RentDocumentSupplierEntity::getDocumentId, (Object)rentTalkEntity.getBillId());
        lambdaSupplier.eq(RentDocumentSupplierEntity::getTalkNum, (Object)talkNum);
        List supplierList = this.rentDocumentSupplierService.list((Wrapper)lambdaSupplier);
        LambdaQueryWrapper lambdaSupplierFirst = Wrappers.lambdaQuery();
        lambdaSupplierFirst.eq(RentDocumentSupplierEntity::getDocumentId, (Object)rentTalkEntity.getBillId());
        lambdaSupplierFirst.eq(RentDocumentSupplierEntity::getTalkNum, (Object)0);
        List supplierListFirst = this.rentDocumentSupplierService.list((Wrapper)lambdaSupplierFirst);
        if (supplierListFirst == null || supplierListFirst.size() == 0) {
            return false;
        }
        if (supplierList.size() != supplierListFirst.size()) {
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> querySupplierList(Long talkId) {
        HashMap<String, Object> stringListMap = new HashMap<String, Object>();
        RentTalkEntity rentTalkEntity = (RentTalkEntity)((Object)((RentTalkMapper)this.baseMapper).selectById(talkId));
        ArrayList<RentQuotationMaterialVO> materialVOList = new ArrayList<RentQuotationMaterialVO>();
        List<RentDocumentSellEntity> rentDocumentSellEntities = this.rentDocumentSellService.selectMaterialType(rentTalkEntity.getBillId());
        Integer talkNum = rentDocumentSellEntities.get(0).getTalkNum();
        List sellEntityList = BeanMapper.mapList(rentDocumentSellEntities, RentDocumentSellVO.class);
        Map<Long, List<RentDocumentSellVO>> collect = sellEntityList.stream().filter(map -> map.getProjectId() != null).collect(Collectors.groupingBy(RentDocumentSellVO::getProjectId));
        for (List<RentDocumentSellVO> sellVOS : collect.values()) {
            Map<Long, List<RentDocumentSellVO>> listMap = sellVOS.stream().filter(map -> map.getMaterialId() != null).collect(Collectors.groupingBy(RentDocumentSellVO::getMaterialId));
            for (Long materialTypeId : listMap.keySet()) {
                RentQuotationMaterialVO materialVO = new RentQuotationMaterialVO();
                List<RentDocumentSellVO> materialTypeList = listMap.get(materialTypeId);
                for (RentDocumentSellVO sellVO : materialTypeList) {
                    materialVO = (RentQuotationMaterialVO)BeanMapper.map((Object)sellVO, RentQuotationMaterialVO.class);
                }
                List rentQuotationSupplierVOS = BeanMapper.mapList(materialTypeList, RentQuotationSupplierVO.class);
                List supplierVOS = rentQuotationSupplierVOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<RentQuotationSupplierVO>(Comparator.comparing(RentQuotationSupplierVO::getSupplierId))), ArrayList::new));
                materialVO.setSupplierList(supplierVOS);
                Map<Long, List<RentDocumentSellVO>> supplierMap = materialTypeList.stream().filter(map -> map.getSupplierId() != null).collect(Collectors.groupingBy(RentDocumentSellVO::getSupplierId));
                for (RentQuotationSupplierVO supplierVO : materialVO.getSupplierList()) {
                    List<RentDocumentSellVO> rentDocumentSellVOS = supplierMap.get(supplierVO.getSupplierId());
                    for (RentDocumentSellVO rentDocumentSellVO : rentDocumentSellVOS) {
                        supplierVO.setSupplierName(rentDocumentSellVO.getSupplierName());
                    }
                    List rentQuotationSchemeVOS = BeanMapper.mapList(rentDocumentSellVOS, RentQuotationSchemeVO.class);
                    List schemeVOS = rentQuotationSchemeVOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<RentQuotationSchemeVO>(Comparator.comparing(f -> f.getSchemeName()))), ArrayList::new));
                    supplierVO.setSchemeList(schemeVOS);
                    Map<String, List<RentDocumentSellVO>> schemeMap = rentDocumentSellVOS.stream().filter(map -> map.getSchemeName() != null).collect(Collectors.groupingBy(RentDocumentSellVO::getSchemeName));
                    for (RentQuotationSchemeVO rentQuotationSchemeVO : supplierVO.getSchemeList()) {
                        List<RentDocumentSellVO> priceList = schemeMap.get(rentQuotationSchemeVO.getSchemeName());
                        if (priceList.size() < talkNum + 1) {
                            RentDocumentSellVO documentSellVO = new RentDocumentSellVO();
                            documentSellVO.setPrice(BigDecimal.valueOf(-1L));
                            documentSellVO.setPriceTax(BigDecimal.valueOf(-1L));
                            documentSellVO.setMoney(BigDecimal.valueOf(-1L));
                            documentSellVO.setMoneyTax(BigDecimal.valueOf(-1L));
                            documentSellVO.setTalkNum(talkNum);
                            priceList.add(0, documentSellVO);
                        }
                        rentQuotationSchemeVO.setPriceList(priceList);
                    }
                }
                materialVOList.add(materialVO);
            }
        }
        stringListMap.put("MaterialTypeList", materialVOList);
        stringListMap.put("offerNum", rentDocumentSellEntities.get(0).getTalkNum());
        return stringListMap;
    }

    @Override
    public RentTalkVO saveOrUpdates(RentTalkVO saveorUpdateVO) {
        RentTalkEntity entity = (RentTalkEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, RentTalkEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        RentTalkVO vo = (RentTalkVO)BeanMapper.map((Object)((Object)entity), RentTalkVO.class);
        RentTalkVO rentTalkVO = this.queryDetail(vo.getId());
        return rentTalkVO;
    }

    private void addLastSell(Integer talkNum, Long docId) {
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(RentDocumentSupplierEntity::getDocumentId, (Object)docId);
        lambdaSupplier.eq(RentDocumentSupplierEntity::getTalkNum, (Object)talkNum);
        List supplierList = this.rentDocumentSupplierService.list((Wrapper)lambdaSupplier);
        LambdaQueryWrapper lambdaSupplierLast = Wrappers.lambdaQuery();
        lambdaSupplierLast.eq(RentDocumentSupplierEntity::getDocumentId, (Object)docId);
        lambdaSupplierLast.eq(RentDocumentSupplierEntity::getTalkNum, (Object)(talkNum - 1));
        List supplierListLast = this.rentDocumentSupplierService.list((Wrapper)lambdaSupplierLast);
        List supplierPk = supplierList.stream().map(RentDocumentSupplierEntity::getSupplierId).collect(Collectors.toList());
        List documentSupplierEntityDataList = supplierListLast.stream().filter(s -> !supplierPk.contains(s.getSupplierId())).collect(Collectors.toList());
        List documentSupplierEntityNewList = BeanMapper.mapList(documentSupplierEntityDataList, RentDocumentSupplierEntity.class);
        if (documentSupplierEntityNewList.size() == 0) {
            return;
        }
        ArrayList<SupplierReplenishVO> replenishVOArrayList = new ArrayList<SupplierReplenishVO>();
        RentDocumentEntity rentDocumentEntity = (RentDocumentEntity)((Object)this.rentDocumentService.selectById(docId));
        for (RentDocumentSupplierEntity rentDocumentSupplierEntity : documentSupplierEntityNewList) {
            SupplierReplenishVO supplierReplenishVO = new SupplierReplenishVO();
            supplierReplenishVO.setSourceId(Long.toString(rentDocumentEntity.getInviteId()));
            supplierReplenishVO.setTalkNum(talkNum);
            supplierReplenishVO.setTenantId(Long.toString(rentDocumentSupplierEntity.getSupplierTenantId()));
            replenishVOArrayList.add(supplierReplenishVO);
        }
        String stringFb = JSONObject.toJSONString(replenishVOArrayList);
        this.logger.info("\u518d\u6b21\u6d3d\u5546\u63a8\u9001\u4f9b\u65b9\u63a5\u53e3\u6570\u636e:" + stringFb);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.updateSupOffer, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u518d\u6b21\u6d3d\u5546\u63a8\u9001\u4f9b\u65b9\u63a5\u53e3\u6570\u636eresponse:" + stringCommonResponse.getMsg());
        }
        List supplierPkNew = documentSupplierEntityNewList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        for (RentDocumentSupplierEntity rentDocumentSupplierEntity : documentSupplierEntityNewList) {
            rentDocumentSupplierEntity.setId(IdWorker.getId());
            rentDocumentSupplierEntity.setTalkNum(talkNum);
        }
        this.rentDocumentSupplierService.saveBatch(documentSupplierEntityNewList);
        LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
        lambdaScheme.eq(RentDocumentSchemeEntity::getDocumentId, (Object)docId);
        lambdaScheme.eq(RentDocumentSchemeEntity::getTalkNum, (Object)(talkNum - 1));
        lambdaScheme.in(RentDocumentSchemeEntity::getDocumentSupplierId, supplierPkNew);
        List schemeList = this.rentDocumentSchemeService.list((Wrapper)lambdaScheme);
        List schemePkList = schemeList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        for (RentDocumentSchemeEntity rentDocumentSchemeEntity : schemeList) {
            rentDocumentSchemeEntity.setId(IdWorker.getId());
            rentDocumentSchemeEntity.setTalkNum(talkNum);
            for (RentDocumentSupplierEntity rentDocumentSupplierEntity : documentSupplierEntityNewList) {
                if (!rentDocumentSchemeEntity.getSupplierId().equals(rentDocumentSupplierEntity.getSupplierId())) continue;
                rentDocumentSchemeEntity.setDocumentSupplierId(rentDocumentSupplierEntity.getId());
            }
        }
        this.rentDocumentSchemeService.saveBatch(schemeList);
        for (RentDocumentSupplierEntity rentDocumentSupplierEntity : documentSupplierEntityNewList) {
            for (RentDocumentSupplierEntity rentDocumentSupplierLastEntity : supplierListLast) {
                CommonResponse responseCopy;
                if (!rentDocumentSupplierEntity.getSupplierId().equals(rentDocumentSupplierLastEntity.getSupplierId()) || (responseCopy = this.attachmentApi.copyFilesFromSourceBillToTargetBill(rentDocumentSupplierLastEntity.getId().toString(), BILL_SUPPLIER_TYPE, "supplierFileType", rentDocumentSupplierEntity.getId().toString(), BILL_SUPPLIER_TYPE, "supplierFileType")).isSuccess()) continue;
                throw new BusinessException("\u518d\u6b21\u6d3d\u5546\u9644\u4ef6\u590d\u5236\u5931\u8d25:" + responseCopy.getMsg());
            }
        }
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(RentDocumentSellEntity::getDocumentId, (Object)docId);
        lambdaSell.eq(RentDocumentSellEntity::getTalkNum, (Object)(talkNum - 1));
        lambdaSell.in(RentDocumentSellEntity::getSchemeId, schemePkList);
        List sellList = this.rentDocumentSellService.list((Wrapper)lambdaSell);
        for (RentDocumentSellEntity rentDocumentSellEntity : sellList) {
            rentDocumentSellEntity.setId(null);
            rentDocumentSellEntity.setTalkNum(talkNum);
            for (RentDocumentSchemeEntity rentDocumentSchemeEntity : schemeList) {
                if (!rentDocumentSellEntity.getSupplierId().equals(rentDocumentSchemeEntity.getSupplierId()) || !rentDocumentSellEntity.getSchemeName().equals(rentDocumentSchemeEntity.getSchemeName())) continue;
                rentDocumentSellEntity.setSchemeId(rentDocumentSchemeEntity.getId());
            }
        }
        this.rentDocumentSellService.saveBatch(sellList);
    }
}

