/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.rmat.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.tender.rmat.bean.RmatAdviceEntity;
import com.ejianc.business.tender.rmat.bean.RmatBidEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.rmat.mapper.RmatAdviceMapper;
import com.ejianc.business.tender.rmat.service.IRmatAdviceService;
import com.ejianc.business.tender.rmat.service.IRmatBidService;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.rmat.vo.RmatAdviceSupplierPushVO;
import com.ejianc.business.tender.rmat.vo.RmatAdviceVO;
import com.ejianc.business.tender.stuff.service.IStuffAdviceService;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="rmatAdviceService")
public class RmatAdviceServiceImpl
extends BaseServiceImpl<RmatAdviceMapper, RmatAdviceEntity>
implements IRmatAdviceService {
    @Autowired
    private IRmatInviteService rmatInviteService;
    @Autowired
    private IStuffAdviceService stuffAdviceService;
    private final String PUSH_ADVICE_SERVER_URL = "/ejc-supbid-web/openapi/bid/saveBid";
    @Autowired
    private IProSupplierApi proSupplierApi;
    private static final String BILL_TYPE = "BT220317000000005";
    @Autowired
    private IRmatBidService rmatBidService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISignatureCommonApi signatureCommonApi;

    @Override
    public CommonResponse<String> changeStatus(Long billId, int status, String refCode) {
        RmatAdviceEntity rmatAdviceEntity = (RmatAdviceEntity)((Object)super.selectById((Serializable)billId));
        if (status == 5 || status == 6 || status == 7 || status == 8) {
            rmatAdviceEntity.setSignFlag(0);
        }
        if (status == 2 || status == 3) {
            rmatAdviceEntity.setSignFlag(1);
        }
        if (status == 4) {
            rmatAdviceEntity.setSignFlag(2);
            ContractVO cv = new ContractVO();
            cv.setContractId(rmatAdviceEntity.getId());
            cv.setContractName(rmatAdviceEntity.getTitleName());
            cv.setBillType(BILL_TYPE);
            cv.setSourceType("tenderAdvice");
            ArrayList<ContractVO> cvs = new ArrayList<ContractVO>();
            cvs.add(cv);
            CommonResponse signResp = this.signatureCommonApi.fetchSignedContract(cvs);
            if (!signResp.isSuccess()) {
                throw new BusinessException("\u540c\u6b65\u7b7e\u7ae0\u9644\u4ef6\u5931\u8d25!");
            }
        }
        super.updateById((Object)rmatAdviceEntity);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f!");
    }

    @Override
    @Transactional
    public String sendAdvice(Long id) {
        RmatAdviceEntity rmatAdviceEntity = (RmatAdviceEntity)((Object)super.selectById((Serializable)id));
        rmatAdviceEntity.setSendFlag(0);
        super.updateById((Object)rmatAdviceEntity);
        RmatInviteEntity rmatInviteEntity = (RmatInviteEntity)((Object)this.rmatInviteService.selectById(rmatAdviceEntity.getInviteId()));
        RmatAdviceSupplierPushVO rmatAdviceSupplierPushVO = (RmatAdviceSupplierPushVO)BeanMapper.map((Object)((Object)rmatAdviceEntity), RmatAdviceSupplierPushVO.class);
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25" + ejcCloudSystemCode.getMsg());
        }
        rmatAdviceSupplierPushVO.setSystemId((String)ejcCloudSystemCode.getData());
        rmatAdviceSupplierPushVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u6750\u6599\u4e2d\u6807\u901a\u77e5\u4e66");
        rmatAdviceSupplierPushVO.setSourceId(rmatAdviceEntity.getId().toString());
        rmatAdviceSupplierPushVO.setBidTitle(rmatAdviceEntity.getTitleName());
        rmatAdviceSupplierPushVO.setSourceProjectId(rmatAdviceEntity.getProjectId() != null ? rmatAdviceEntity.getProjectId().toString() : null);
        rmatAdviceSupplierPushVO.setSourceOrgId(rmatAdviceEntity.getOrgId().toString());
        rmatAdviceSupplierPushVO.setSourceUnitId(rmatAdviceEntity.getUnitId().toString());
        rmatAdviceSupplierPushVO.setType(CommonUtils.getGysType(4));
        rmatAdviceSupplierPushVO.setTenderType(rmatInviteEntity.getTenderType());
        rmatAdviceSupplierPushVO.setBidDate(rmatAdviceEntity.getNoticeDate());
        rmatAdviceSupplierPushVO.setMoney(rmatAdviceEntity.getMoney());
        rmatAdviceSupplierPushVO.setMoneyTax(rmatAdviceEntity.getMoneyTax());
        String dataInfo = JSONObject.toJSONString((Object)rmatAdviceSupplierPushVO);
        boolean b = this.stuffAdviceService.pushBillToSupCenter(dataInfo, rmatAdviceEntity.getSupplierId(), rmatAdviceEntity.getId(), BILL_TYPE, "/ejc-supbid-web/openapi/bid/saveBid", rmatAdviceEntity.getTitleName());
        if (!b) {
            throw new BusinessException("\u63a8\u9001\u4f9b\u65b9\u5931\u8d25!");
        }
        return null;
    }

    @Override
    public List<RmatAdviceVO> queryAdviceList(Long id) {
        RmatBidEntity rmatBidEntity = (RmatBidEntity)((Object)this.rmatBidService.selectById(id));
        LambdaQueryWrapper lambdaAdvice = Wrappers.lambdaQuery();
        lambdaAdvice.eq(RmatAdviceEntity::getInviteId, (Object)rmatBidEntity.getInviteId());
        List list = super.list((Wrapper)lambdaAdvice);
        List rmatAdviceVOS = BeanMapper.mapList((Iterable)list, RmatAdviceVO.class);
        if (CollectionUtils.isNotEmpty((Collection)rmatAdviceVOS)) {
            List data;
            List attachIds = rmatAdviceVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
            HashMap map = new HashMap();
            map.put("sourceIds", attachIds);
            JSONObject itemJSONObj = JSONObject.parseObject((String)JSON.toJSONString(map));
            CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(itemJSONObj);
            if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(data = (List)listCommonResponse.getData()))) {
                Map attacMap = data.stream().filter(s -> s.getSourceType().equals("tenderAdvice")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                for (RmatAdviceVO rmatAdviceVO : rmatAdviceVOS) {
                    AttachmentVO attachmentVO = (AttachmentVO)attacMap.get(rmatAdviceVO.getId());
                    if (attachmentVO == null) continue;
                    rmatAdviceVO.setAttachId(attachmentVO.getId());
                    rmatAdviceVO.setFileName(attachmentVO.getFileName());
                    rmatAdviceVO.setFilePath(attachmentVO.getFilePath());
                }
            }
        }
        return rmatAdviceVOS;
    }
}

