package com.ejianc.business.tender.stuff.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.stuff.vo.StuffDocumentExpertVO;
import com.ejianc.business.tender.stuff.vo.StuffDocumentVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.tender.stuff.mapper.StuffDocumentExpertMapper;
import com.ejianc.business.tender.stuff.bean.StuffDocumentExpertEntity;
import com.ejianc.business.tender.stuff.service.IStuffDocumentExpertService;

import java.sql.Wrapper;
import java.util.List;

/**
 * 招标文件专家表
 * 
 * @author generator
 * 
 */
@Service("stuffDocumentExpertService")
public class StuffDocumentExpertServiceImpl extends BaseServiceImpl<StuffDocumentExpertMapper, StuffDocumentExpertEntity> implements IStuffDocumentExpertService{

    @Override
    public List<StuffDocumentExpertEntity> addBatch(StuffDocumentVO stuffDocumentVO) {

        //先删后增
        LambdaQueryWrapper<StuffDocumentExpertEntity> expertWrapper = Wrappers.lambdaQuery();
        expertWrapper.eq(StuffDocumentExpertEntity::getDocumentId,stuffDocumentVO.getId());
        super.remove(expertWrapper);

        //新增
        List<StuffDocumentExpertVO> expertVOList = stuffDocumentVO.getExpertVOList();
        if(CollectionUtils.isNotEmpty(expertVOList)){
            for (StuffDocumentExpertVO stuffDocument: expertVOList){
                stuffDocument.setDocumentId(stuffDocumentVO.getId());
                stuffDocument.setId(null);
            }
            List<StuffDocumentExpertEntity> stuffDocumentExpertEntities = BeanMapper.mapList(expertVOList, StuffDocumentExpertEntity.class);
            super.saveBatch(stuffDocumentExpertEntities);
            return stuffDocumentExpertEntities;
        }

        return null;
    }

    @Override
    public List<StuffDocumentExpertEntity> deleteByIds(List<Long> vos) {
        Long pk = vos.stream().findFirst().get();
        StuffDocumentExpertEntity stuffDocumentExpertEntity = super.selectById(pk);
        Long documentId = stuffDocumentExpertEntity.getDocumentId();
        super.removeByIds(vos,true);
        LambdaQueryWrapper<StuffDocumentExpertEntity> expertWrapper = Wrappers.lambdaQuery();
        expertWrapper.eq(StuffDocumentExpertEntity::getDocumentId,documentId);
        List<StuffDocumentExpertEntity> list = super.list(expertWrapper);
        return list;
    }
}
