/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.expert.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.tender.expert.bean.TemplateDetailEntity;
import com.ejianc.business.tender.expert.bean.TemplateEntity;
import com.ejianc.business.tender.expert.mapper.TemplateMapper;
import com.ejianc.business.tender.expert.service.ITemplateDetailService;
import com.ejianc.business.tender.expert.service.ITemplateService;
import com.ejianc.business.tender.expert.vo.TemplateVO;
import com.ejianc.business.tender.util.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="templateService")
public class TemplateServiceImpl
extends BaseServiceImpl<TemplateMapper, TemplateEntity>
implements ITemplateService {
    @Autowired
    private ITemplateDetailService detailService;
    @Autowired
    private ITemplateService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "SCORING_TEMPLATE";

    @Override
    public TemplateVO saveUpdate(TemplateVO saveorUpdateVO) {
        List<TemplateDetailEntity> templateDetailEntities;
        TemplateEntity entity = (TemplateEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, TemplateEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (CollectionUtils.isNotEmpty(templateDetailEntities = entity.getTemplateDetailEntities()) && null == entity.getId()) {
            for (TemplateDetailEntity detailEntity : templateDetailEntities) {
                detailEntity.setId(null);
                detailEntity.setParentId(null);
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        List<TemplateDetailEntity> templateDetailEntities2 = entity.getTemplateDetailEntities();
        if (CollectionUtils.isNotEmpty(templateDetailEntities2)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (TemplateDetailEntity detailEntity2 : templateDetailEntities2) {
                idMap.put(detailEntity2.getTid(), detailEntity2.getId());
            }
            for (TemplateDetailEntity detailEntity2 : templateDetailEntities2) {
                if (!StringUtils.isNotEmpty((CharSequence)detailEntity2.getTpid())) continue;
                detailEntity2.setParentId((Long)idMap.get(detailEntity2.getTpid()));
            }
            this.detailService.saveOrUpdateBatch(templateDetailEntities2, templateDetailEntities2.size(), false);
        }
        return this.query(entity.getId());
    }

    @Override
    public TemplateVO query(Long id) {
        TemplateEntity entity = (TemplateEntity)((Object)this.service.selectById(id));
        TemplateVO vo = (TemplateVO)BeanMapper.map((Object)((Object)entity), TemplateVO.class);
        List templateDetailEntities = vo.getTemplateDetailEntities();
        templateDetailEntities.forEach(val -> {
            val.setTid(this.objToString(val.getId()));
            val.setTpid(this.objToString(val.getParentId()));
            val.setRowState("edit");
        });
        List templateDetailVOList = TreeNodeBUtil.buildTree((List)templateDetailEntities);
        vo.setTemplateDetailEntities(templateDetailVOList);
        return vo;
    }

    private String objToString(Object obj) {
        if (obj == null) {
            return null;
        }
        return String.valueOf(obj);
    }
}

