/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.stuff.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.stuff.bean.StuffBidDetailEntity;
import com.ejianc.business.tender.stuff.bean.StuffBidEntity;
import com.ejianc.business.tender.stuff.bean.StuffBidSupplierEntity;
import com.ejianc.business.tender.stuff.bean.StuffDocumentEntity;
import com.ejianc.business.tender.stuff.bean.StuffDocumentSellEntity;
import com.ejianc.business.tender.stuff.bean.StuffDocumentSupplierEntity;
import com.ejianc.business.tender.stuff.bean.StuffInviteEntity;
import com.ejianc.business.tender.stuff.bean.StuffNoticeEntity;
import com.ejianc.business.tender.stuff.bean.StuffPicketageEntity;
import com.ejianc.business.tender.stuff.bean.StuffPicketageSupplierEntity;
import com.ejianc.business.tender.stuff.bean.StuffWinnoticeEntity;
import com.ejianc.business.tender.stuff.mapper.StuffBidMapper;
import com.ejianc.business.tender.stuff.service.IStuffBidDetailService;
import com.ejianc.business.tender.stuff.service.IStuffBidService;
import com.ejianc.business.tender.stuff.service.IStuffBidSupplierService;
import com.ejianc.business.tender.stuff.service.IStuffDocumentSellService;
import com.ejianc.business.tender.stuff.service.IStuffDocumentService;
import com.ejianc.business.tender.stuff.service.IStuffDocumentSupplierService;
import com.ejianc.business.tender.stuff.service.IStuffInviteService;
import com.ejianc.business.tender.stuff.service.IStuffNoticeService;
import com.ejianc.business.tender.stuff.service.IStuffPicketageService;
import com.ejianc.business.tender.stuff.service.IStuffPicketageSupplierService;
import com.ejianc.business.tender.stuff.service.IStuffWinnoticeService;
import com.ejianc.business.tender.stuff.vo.StuffBidDetailVO;
import com.ejianc.business.tender.stuff.vo.StuffBidSupplierVO;
import com.ejianc.business.tender.stuff.vo.StuffBidVO;
import com.ejianc.business.tender.stuff.vo.StuffDocumentSellVO;
import com.ejianc.business.tender.stuff.vo.StuffPicketageSupplierVO;
import com.ejianc.business.tender.stuff.vo.StuffPicketageVO;
import com.ejianc.business.tender.stuff.vo.TenderStageEnum;
import com.ejianc.business.tender.stuff.vo.WinbidDetailVO;
import com.ejianc.business.tender.stuff.vo.WinbidVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="stuffBidService")
public class StuffBidServiceImpl
extends BaseServiceImpl<StuffBidMapper, StuffBidEntity>
implements IStuffBidService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IStuffPicketageService stuffPicketageService;
    @Autowired
    private IStuffNoticeService stuffNoticeService;
    @Autowired
    private IStuffWinnoticeService stuffWinnoticeService;
    @Autowired
    private IStuffDocumentService stuffDocumentService;
    @Autowired
    private IStuffInviteService stuffInviteService;
    @Autowired
    private IStuffBidDetailService stuffBidDetailService;
    @Autowired
    private IStuffDocumentSellService stuffDocumentSellService;
    @Autowired
    private IStuffBidSupplierService stuffBidSupplierService;
    @Autowired
    private IStuffDocumentSupplierService stuffDocumentSupplierService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IStuffPicketageSupplierService stuffPicketageSupplierService;
    @Autowired
    private IOrgApi iOrgApi;
    @Value(value="${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value(value="${gysUrl.winbidSavesUrl}")
    private String winbidSavesUrl;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CacheManager cacheManager;
    private static final String BILL_CODE = "invite-bid-code";

    @Override
    public StuffBidVO saveBid(Long picketageId) {
        StuffBidEntity entity = new StuffBidEntity();
        entity.setPicketageId(picketageId);
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        StuffPicketageEntity stuffPicketageEntity = (StuffPicketageEntity)((Object)this.stuffPicketageService.selectById(picketageId));
        StuffInviteEntity inviteEntity = (StuffInviteEntity)((Object)this.stuffInviteService.selectById(stuffPicketageEntity.getInviteId()));
        entity.setInviteId(stuffPicketageEntity.getInviteId());
        entity.setBidName(inviteEntity.getTenderName());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        super.saveOrUpdate((Object)entity, false);
        StuffBidVO vo = (StuffBidVO)BeanMapper.map((Object)((Object)entity), StuffBidVO.class);
        stuffPicketageEntity.setBidId(entity.getId());
        this.stuffPicketageService.updateById((Object)stuffPicketageEntity);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(StuffDocumentSellEntity::getDocumentId, (Object)stuffPicketageEntity.getDocumentId());
        lambdaSell.eq(StuffDocumentSellEntity::getTenderFlag, (Object)1);
        List sellList = this.stuffDocumentSellService.list((Wrapper)lambdaSell);
        List stuffDocumentSellVOS = BeanMapper.mapList((Iterable)sellList, StuffDocumentSellVO.class);
        Map<Long, List<StuffDocumentSellVO>> sellMap = stuffDocumentSellVOS.stream().collect(Collectors.groupingBy(StuffDocumentSellVO::getSupplierId));
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(StuffDocumentSupplierEntity::getDocumentId, (Object)stuffPicketageEntity.getDocumentId());
        lambdaSupplier.eq(StuffDocumentSupplierEntity::getTalkNum, (Object)0);
        List supplierList = this.stuffDocumentSupplierService.list((Wrapper)lambdaSupplier);
        Map supplierEntityMap = supplierList.stream().collect(Collectors.toMap(StuffDocumentSupplierEntity::getSupplierId, Function.identity(), (k1, k2) -> k2));
        ArrayList supplierVOList = new ArrayList();
        ArrayList stuffBidDetailEntityList = new ArrayList();
        sellMap.forEach((key, value) -> {
            StuffBidSupplierVO stuffBidSupplierVO = new StuffBidSupplierVO();
            stuffBidSupplierVO.setSupplierId(key);
            stuffBidSupplierVO.setSupplierName(((StuffDocumentSellVO)value.stream().findFirst().get()).getSupplierName());
            StuffDocumentSupplierEntity stuffDocumentSupplierEntity = (StuffDocumentSupplierEntity)((Object)((Object)supplierEntityMap.get(key)));
            stuffBidSupplierVO.setLinkName(stuffDocumentSupplierEntity.getLinkName());
            stuffBidSupplierVO.setSupplierMobile(stuffDocumentSupplierEntity.getLinkMobile());
            stuffBidSupplierVO.setId(Long.valueOf(IdWorker.getId()));
            BigDecimal tenderMoneyTax = BigDecimal.ZERO;
            BigDecimal tenderMoney = BigDecimal.ZERO;
            for (StuffDocumentSellVO stuffDocumentSellVO : value) {
                tenderMoneyTax = tenderMoneyTax.add(stuffDocumentSellVO.getTenderMoneyTax() == null ? BigDecimal.ZERO : stuffDocumentSellVO.getTenderMoneyTax());
                tenderMoney = tenderMoney.add(stuffDocumentSellVO.getTenderMoney() == null ? BigDecimal.ZERO : stuffDocumentSellVO.getTenderMoney());
                StuffBidDetailEntity stuffBidDetailEntity = (StuffBidDetailEntity)((Object)((Object)BeanMapper.map((Object)stuffDocumentSellVO, StuffBidDetailEntity.class)));
                stuffBidDetailEntity.setMoney(stuffDocumentSellVO.getTenderMoney());
                stuffBidDetailEntity.setMoneyTax(stuffDocumentSellVO.getTenderMoneyTax());
                stuffBidDetailEntity.setId(null);
                stuffBidDetailEntity.setBidSupplierId(stuffBidSupplierVO.getId());
                stuffBidDetailEntity.setBidId(entity.getId());
                stuffBidDetailEntityList.add(stuffBidDetailEntity);
            }
            stuffBidSupplierVO.setMoneyTax(tenderMoneyTax);
            stuffBidSupplierVO.setMoney(tenderMoney);
            stuffBidSupplierVO.setBidId(entity.getId());
            supplierVOList.add(stuffBidSupplierVO);
        });
        List stuffBidSupplierEntities = BeanMapper.mapList(supplierVOList, StuffBidSupplierEntity.class);
        this.stuffBidSupplierService.saveBatch(stuffBidSupplierEntities);
        this.stuffBidDetailService.saveBatch(stuffBidDetailEntityList);
        String tenderUnitNum = "";
        List<StuffBidDetailEntity> bidDetailEntityList = ((StuffBidMapper)this.baseMapper).selectBidSupplier(entity.getId());
        for (StuffBidDetailEntity stuffBidDetailEntity : bidDetailEntityList) {
            StuffBidSupplierEntity supplierEntity = (StuffBidSupplierEntity)((Object)this.stuffBidSupplierService.selectById(stuffBidDetailEntity.getBidSupplierId()));
            BigDecimal sumNum = stuffBidDetailEntity.getTenderNum().setScale(4, 4);
            String name = supplierEntity.getSupplierName() + "(" + sumNum + "),";
            tenderUnitNum = tenderUnitNum + name;
        }
        if (tenderUnitNum.length() > 1) {
            tenderUnitNum = tenderUnitNum.substring(0, tenderUnitNum.length() - 1);
        }
        inviteEntity.setTenderUnitNum(tenderUnitNum);
        this.stuffInviteService.saveOrUpdate((Object)inviteEntity);
        StuffBidVO stuffBidVO = (StuffBidVO)BeanMapper.map((Object)((Object)entity), StuffBidVO.class);
        return stuffBidVO;
    }

    @Override
    public StuffBidVO queryDetail(Long bidId) {
        StuffBidEntity stuffBidEntity = (StuffBidEntity)((Object)super.selectById((Serializable)bidId));
        StuffBidVO stuffBidVO = (StuffBidVO)BeanMapper.map((Object)((Object)stuffBidEntity), StuffBidVO.class);
        List stuffBidDetailList = stuffBidVO.getStuffBidDetailList();
        Map<Long, List<StuffBidDetailVO>> detailMap = stuffBidDetailList.stream().collect(Collectors.groupingBy(StuffBidDetailVO::getBidSupplierId));
        List stuffBidSupplierList = stuffBidVO.getStuffBidSupplierList();
        for (StuffBidSupplierVO stuffBidSupplierVO : stuffBidSupplierList) {
            stuffBidSupplierVO.setStuffBidDetailList(detailMap.get(stuffBidSupplierVO.getId()));
        }
        stuffBidVO.setStuffBidSupplierList(stuffBidSupplierList);
        return stuffBidVO;
    }

    @Override
    @Transactional
    public StuffBidVO publishBid(StuffBidVO saveorUpdateVO) {
        StuffBidEntity entity = (StuffBidEntity)((Object)super.selectById((Serializable)saveorUpdateVO.getId()));
        entity.setBidContent(saveorUpdateVO.getBidContent());
        entity.setBidName(saveorUpdateVO.getBidName());
        entity.setPublishFlag(0);
        entity.setBillState(1);
        StuffBidVO vo = (StuffBidVO)BeanMapper.map((Object)((Object)entity), StuffBidVO.class);
        StuffInviteEntity stuffInviteEntity = (StuffInviteEntity)((Object)this.stuffInviteService.selectById(entity.getInviteId()));
        WinbidVO winbidVO = new WinbidVO();
        winbidVO.setSourceId(Long.toString(entity.getInviteId()));
        winbidVO.setBillCode(stuffInviteEntity.getBillCode());
        if (winbidVO.getPurchaseType() == null || winbidVO.getPurchaseType() == 1) {
            winbidVO.setSourceProjectId(null);
        } else {
            winbidVO.setSourceProjectId(Long.toString(stuffInviteEntity.getProjectId()));
        }
        winbidVO.setProjectName(stuffInviteEntity.getProjectName());
        winbidVO.setProjectCode(stuffInviteEntity.getProjectCode());
        winbidVO.setSourceOrgId(Long.toString(stuffInviteEntity.getOrgId()));
        winbidVO.setOrgName(stuffInviteEntity.getOrgName());
        winbidVO.setUnitName(stuffInviteEntity.getUnitName());
        winbidVO.setSourceUnitId(Long.toString(stuffInviteEntity.getUnitId()));
        winbidVO.setType("MATERIAL");
        winbidVO.setTenderName(stuffInviteEntity.getTenderName());
        winbidVO.setTenderType(stuffInviteEntity.getTenderType());
        winbidVO.setSystemId((String)this.proSupplierApi.getEjcCloudSystemCode().getData());
        LambdaQueryWrapper lambdaDoc = Wrappers.lambdaQuery();
        lambdaDoc.eq(StuffDocumentEntity::getInviteId, (Object)entity.getInviteId());
        StuffDocumentEntity stuffDocumentEntity = (StuffDocumentEntity)((Object)this.stuffDocumentService.getOne((Wrapper)lambdaDoc));
        winbidVO.setNoticeBidTime(stuffDocumentEntity.getBidTime());
        winbidVO.setNoticeWinbidTime(new Date());
        if (stuffInviteEntity.getTenderType() == 2 || stuffInviteEntity.getTenderType() == 3 || stuffInviteEntity.getTenderType() == 4 || stuffInviteEntity.getTenderType() == 5) {
            winbidVO.setSourceEmployeeId(Long.toString(stuffDocumentEntity.getEmployeeId()));
            winbidVO.setEmployeeName(stuffDocumentEntity.getEmployeeName());
            winbidVO.setEmployeeMobile(stuffDocumentEntity.getEmployeeMobile());
            winbidVO.setPurchaseType(stuffDocumentEntity.getPurchaseType());
        } else {
            LambdaQueryWrapper lambdaNotice = Wrappers.lambdaQuery();
            lambdaNotice.eq(StuffNoticeEntity::getInviteId, (Object)entity.getInviteId());
            StuffNoticeEntity noticeEntity = (StuffNoticeEntity)((Object)this.stuffNoticeService.getOne((Wrapper)lambdaNotice));
            winbidVO.setSourceEmployeeId(Long.toString(noticeEntity.getEmployeeId()));
            winbidVO.setEmployeeName(noticeEntity.getEmployeeName());
            winbidVO.setEmployeeMobile(noticeEntity.getEmployeeMobile());
            winbidVO.setPurchaseType(noticeEntity.getPurchaseType());
        }
        StuffBidVO stuffBidVO = this.queryDetail(entity.getId());
        List stuffBidSupplierList = stuffBidVO.getStuffBidSupplierList();
        ArrayList<WinbidVO> winbidVOList = new ArrayList<WinbidVO>();
        for (StuffBidSupplierVO stuffBidSupplierVO : stuffBidSupplierList) {
            WinbidVO winbidVONew = (WinbidVO)BeanMapper.map((Object)winbidVO, WinbidVO.class);
            SupplierDTO supplierVO = (SupplierDTO)this.shareSupplierApi.queryById(stuffBidSupplierVO.getSupplierId()).getData();
            winbidVONew.setTenantId(supplierVO.getTenant());
            winbidVONew.setWinbidMoneyTax(stuffBidSupplierVO.getMoneyTax());
            winbidVONew.setWinbidMoney(stuffBidSupplierVO.getMoney());
            winbidVONew.setContent(stuffBidVO.getBidContent());
            winbidVONew.setWinbidType(Integer.valueOf(0));
            List stuffBidDetailList = stuffBidSupplierVO.getStuffBidDetailList();
            HashMap<String, List> map = new HashMap<String, List>();
            for (StuffBidDetailVO stuffBidDetailVO : stuffBidDetailList) {
                String s = null;
                if (stuffBidDetailVO.getMaterialId() == null) {
                    s = stuffBidDetailVO.getMaterialTypeId().toString() + (stuffBidDetailVO.getCalculateType() == null ? "" : stuffBidDetailVO.getCalculateType().toString()) + stuffBidDetailVO.getRate() + stuffBidDetailVO.getSchemeId();
                }
                if (stuffBidDetailVO.getMaterialId() != null) {
                    s = stuffBidDetailVO.getCalculateType() == null ? stuffBidDetailVO.getMaterialId().toString() + stuffBidDetailVO.getMaterialTypeId().toString() + stuffBidDetailVO.getRate() + stuffBidDetailVO.getSchemeId() : stuffBidDetailVO.getMaterialId().toString() + stuffBidDetailVO.getMaterialTypeId().toString() + stuffBidDetailVO.getCalculateType().toString() + stuffBidDetailVO.getRate() + stuffBidDetailVO.getSchemeId();
                }
                if (map.containsKey(s)) {
                    List stuffBidDetailVOS = (List)map.get(s);
                    stuffBidDetailVOS.add(stuffBidDetailVO);
                    map.put(s, stuffBidDetailVOS);
                    continue;
                }
                ArrayList<StuffBidDetailVO> stuffBidDetailVOList = new ArrayList<StuffBidDetailVO>();
                stuffBidDetailVOList.add(stuffBidDetailVO);
                map.put(s, stuffBidDetailVOList);
            }
            ArrayList winbidDetailVOList = new ArrayList();
            map.forEach((key, value) -> {
                BigDecimal tenderNum = BigDecimal.ZERO;
                BigDecimal money = BigDecimal.ZERO;
                BigDecimal moneyTax = BigDecimal.ZERO;
                BigDecimal tax = BigDecimal.ZERO;
                for (StuffBidDetailVO stuffBidDetailVOLast : value) {
                    tenderNum = tenderNum.add(stuffBidDetailVOLast.getTenderNum() == null ? BigDecimal.ZERO : stuffBidDetailVOLast.getTenderNum());
                    money = money.add(stuffBidDetailVOLast.getMoney() == null ? BigDecimal.ZERO : stuffBidDetailVOLast.getMoney());
                    moneyTax = moneyTax.add(stuffBidDetailVOLast.getMoneyTax() == null ? BigDecimal.ZERO : stuffBidDetailVOLast.getMoneyTax());
                    tax = tax.add(stuffBidDetailVOLast.getSellTax() == null ? BigDecimal.ZERO : stuffBidDetailVOLast.getSellTax());
                }
                StuffBidDetailVO first = (StuffBidDetailVO)value.stream().findFirst().get();
                WinbidDetailVO winbidDetailVO = new WinbidDetailVO();
                winbidDetailVO.setSourceId(Long.toString(entity.getInviteId()));
                winbidDetailVO.setSourceMaterialId(first.getMaterialId() == null ? null : Long.toString(first.getMaterialId()));
                winbidDetailVO.setMaterialName(first.getMaterialName());
                winbidDetailVO.setMaterialCode(first.getMaterialCode());
                winbidDetailVO.setSourceMaterialTypeId(Long.toString(first.getMaterialTypeId()));
                winbidDetailVO.setMaterialTypeName(first.getMaterialTypeName());
                winbidDetailVO.setUnit(first.getUnit());
                winbidDetailVO.setSpec(first.getSpec());
                winbidDetailVO.setBrand(first.getMaterialBrand());
                winbidDetailVO.setSupplierBrand(first.getBrand());
                winbidDetailVO.setPrice(first.getPrice());
                winbidDetailVO.setPriceTax(first.getPriceTax());
                winbidDetailVO.setMoney(money);
                winbidDetailVO.setMoneyTax(moneyTax);
                winbidDetailVO.setTax(tax);
                winbidDetailVO.setCalculateType(first.getCalculateType());
                winbidDetailVO.setMemo(first.getMaterialMemo());
                winbidDetailVO.setSupplierMemo(first.getMemo());
                winbidDetailVO.setMoney(money);
                winbidDetailVO.setRate(first.getRate());
                winbidDetailVO.setTenderNum(tenderNum);
                winbidDetailVO.setNum(first.getNum());
                winbidDetailVOList.add(winbidDetailVO);
            });
            winbidVONew.setWinbidDetailList(winbidDetailVOList);
            winbidVOList.add(winbidVONew);
        }
        String stringFb = JSONObject.toJSONString(winbidVOList);
        this.logger.info("\u63a8\u9001\u4f9b\u65b9\u4e2d\u6807\u4fe1\u606f:" + stringFb);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.winbidSavesUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u4e2d\u6807\u540c\u6b65\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return this.queryDetail(vo.getId());
    }

    @Override
    public StuffBidVO queryDbDetail(Long picketage) {
        return null;
    }

    @Override
    public StuffBidVO nextPaper(Long winnoticeId) {
        StuffBidEntity entity = new StuffBidEntity();
        StuffWinnoticeEntity stuffWinnoticeEntity = (StuffWinnoticeEntity)((Object)this.stuffWinnoticeService.selectById(winnoticeId));
        StuffInviteEntity stuffInviteEntity = (StuffInviteEntity)((Object)this.stuffInviteService.selectById(stuffWinnoticeEntity.getInviteId()));
        entity.setInviteId(stuffWinnoticeEntity.getInviteId());
        entity.setBidName(stuffInviteEntity.getTenderName());
        entity.setPurchaseType(stuffInviteEntity.getPurchaseType());
        entity.setWinnoticeId(winnoticeId);
        super.saveOrUpdate((Object)entity, false);
        stuffWinnoticeEntity.setNextFlag(1);
        this.stuffWinnoticeService.updateById((Object)stuffWinnoticeEntity);
        stuffInviteEntity.setTenderStage(TenderStageEnum.BID_NOTICE_STATE.getTenderTypeCode());
        this.stuffInviteService.updateById((Object)stuffInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getDescription());
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(0);
        processEntity.setFrontendUrl("stuff/winLetter");
        this.processService.saveOrUpdate((Object)processEntity);
        StuffBidVO stuffBidVO = (StuffBidVO)BeanMapper.map((Object)((Object)entity), StuffBidVO.class);
        return stuffBidVO;
    }

    @Override
    public List<StuffPicketageSupplierVO> querySupplierList(Long picketageId) {
        StuffBidEntity stuffBidEntity = (StuffBidEntity)((Object)super.selectById((Serializable)picketageId));
        StuffWinnoticeEntity stuffWinnoticeEntity = (StuffWinnoticeEntity)((Object)this.stuffWinnoticeService.selectById(stuffBidEntity.getWinnoticeId()));
        LambdaQueryWrapper lambdaSupplierList = Wrappers.lambdaQuery();
        lambdaSupplierList.eq(StuffPicketageSupplierEntity::getPicketageId, (Object)stuffWinnoticeEntity.getPicketageId());
        List listSupplier = this.stuffPicketageSupplierService.list((Wrapper)lambdaSupplierList);
        List stuffPicketageSupplierVOS = BeanMapper.mapList((Iterable)listSupplier, StuffPicketageSupplierVO.class);
        return stuffPicketageSupplierVOS;
    }

    @Override
    @Transactional
    public StuffPicketageVO insertProcess(Long picketageId) {
        StuffPicketageEntity stuffPicketageEntity = (StuffPicketageEntity)((Object)this.stuffPicketageService.selectById(picketageId));
        StuffInviteEntity stuffInviteEntity = (StuffInviteEntity)((Object)this.stuffInviteService.selectById(stuffPicketageEntity.getInviteId()));
        stuffInviteEntity.setTenderStage(TenderStageEnum.BID_NOTICE_STATE.getTenderTypeCode());
        this.stuffInviteService.updateById((Object)stuffInviteEntity);
        stuffPicketageEntity.setBidStatus(1);
        this.stuffPicketageService.updateById((Object)stuffPicketageEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(stuffPicketageEntity.getBidId());
        processEntity.setBillName(TenderStageEnum.BID_NOTICE_STATE.getDescription());
        processEntity.setTenderId(stuffInviteEntity.getId());
        processEntity.setType(0);
        processEntity.setFrontendUrl("stuff/winLetter");
        this.processService.saveOrUpdate((Object)processEntity);
        StuffPicketageVO stuffPicketageVO = (StuffPicketageVO)BeanMapper.map((Object)((Object)stuffPicketageEntity), StuffPicketageVO.class);
        return stuffPicketageVO;
    }

    @Override
    public List<StuffPicketageSupplierVO> querySupplierDetail(Long id) {
        StuffBidEntity stuffBidEntity = (StuffBidEntity)((Object)super.selectById((Serializable)id));
        return this.stuffPicketageService.querySupplierList(stuffBidEntity.getPicketageId());
    }
}

