/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.sub.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.business.tender.stuff.vo.TenderStageEnum;
import com.ejianc.business.tender.sub.bean.SubInviteDetailBidderEntity;
import com.ejianc.business.tender.sub.bean.SubInviteDetailEntity;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.bean.SubPicketageRefsupplierEntity;
import com.ejianc.business.tender.sub.service.ISubBatPlanService;
import com.ejianc.business.tender.sub.service.ISubInviteDetailService;
import com.ejianc.business.tender.sub.service.ISubInviteService;
import com.ejianc.business.tender.sub.service.ISubPicketageRefsupplierService;
import com.ejianc.business.tender.sub.vo.SubInviteDetailBidderVO;
import com.ejianc.business.tender.sub.vo.SubInviteDetailVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="subInvite")
public class SubInviteBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private ISubInviteService service;
    @Autowired
    private ISubInviteDetailService detailService;
    @Autowired
    private ISubPicketageRefsupplierService picketageRefsupplierService;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private ISubBatPlanService subBatPlanService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        if (BillStateEnum.COMMITED_STATE.getBillStateCode() == state || BillStateEnum.PASSED_STATE.getBillStateCode() == state) {
            SubInviteEntity inviteEntity;
            SubInviteEntity subInviteEntity = (SubInviteEntity)((Object)this.service.selectById(billId));
            List<Object> subInviteDetailEntities = new ArrayList();
            subInviteDetailEntities = subInviteEntity.getPurchaseType() == 0 ? this.service.selectSumDetail(billId) : this.service.selectOrgSumDetail(billId);
            for (SubInviteDetailVO subInviteDetailVO : subInviteDetailEntities) {
                subInviteDetailVO.setNum(subInviteDetailVO.getSumNum());
                subInviteDetailVO.setMny(subInviteDetailVO.getSumMoney());
                subInviteDetailVO.setTaxMny(subInviteDetailVO.getSumMoneyTax());
                subInviteDetailVO.setPlanNum(subInviteDetailVO.getSumPlanNum());
                subInviteDetailVO.setTax(subInviteDetailVO.getSumTax());
                subInviteDetailVO.setMemo(subInviteDetailVO.getSumMemo());
                this.detailService.saveOrUpdate(BeanMapper.map((Object)subInviteDetailVO, SubInviteDetailEntity.class));
            }
            if (subInviteEntity.getEstablishType() == 1 && CollectionUtils.isNotEmpty(subInviteEntity.getSubDetailBidder())) {
                List<String> planIdList = subInviteEntity.getSubDetailBidder().stream().map(SubInviteDetailBidderEntity::getPlanId).map(String::valueOf).distinct().collect(Collectors.toList());
                this.subBatPlanService.updateBatPlanByQuoteType(planIdList, BatPlanEnum.PLAN_STATE_OVER.getPlanState(), 0);
            }
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((inviteEntity = (SubInviteEntity)((Object)this.service.selectById(billId))).getSubDetailBidder())) {
                List<SubInviteDetailBidderVO> list = this.service.selectDetailBidder(billId);
                String tenderUnitNum = "";
                for (SubInviteDetailBidderVO detailBidderVO : list) {
                    SubPicketageRefsupplierEntity subPicketageRefsupplierEntity = new SubPicketageRefsupplierEntity();
                    subPicketageRefsupplierEntity.setPicketageId(billId);
                    subPicketageRefsupplierEntity.setPicketageName(inviteEntity.getTenderName() + "\u5b9a\u6807");
                    subPicketageRefsupplierEntity.setPicketageDate(new Date());
                    subPicketageRefsupplierEntity.setMoney(detailBidderVO.getSumMoney());
                    subPicketageRefsupplierEntity.setMoneyTax(detailBidderVO.getSumTaxMoney());
                    subPicketageRefsupplierEntity.setSupplierId(inviteEntity.getSupplierId());
                    subPicketageRefsupplierEntity.setSupplierName(inviteEntity.getSupplierName());
                    if (inviteEntity.getTeamId() != null) {
                        subPicketageRefsupplierEntity.setTeamId(inviteEntity.getTeamId());
                        subPicketageRefsupplierEntity.setTeamCode(inviteEntity.getTeamCode());
                        subPicketageRefsupplierEntity.setTeamName(inviteEntity.getTeamName());
                    }
                    subPicketageRefsupplierEntity.setSubContent(inviteEntity.getSubContent());
                    subPicketageRefsupplierEntity.setSubContentName(inviteEntity.getSubContentName());
                    subPicketageRefsupplierEntity.setProjectId(inviteEntity.getProjectId());
                    subPicketageRefsupplierEntity.setProjectName(inviteEntity.getProjectName());
                    subPicketageRefsupplierEntity.setProjectCode(inviteEntity.getProjectCode());
                    subPicketageRefsupplierEntity.setOrgId(inviteEntity.getOrgId());
                    subPicketageRefsupplierEntity.setOrgName(inviteEntity.getOrgName());
                    subPicketageRefsupplierEntity.setParentOrgId(inviteEntity.getParentOrgId());
                    subPicketageRefsupplierEntity.setParentOrgName(inviteEntity.getParentOrgName());
                    subPicketageRefsupplierEntity.setOccupyFlag(0);
                    subPicketageRefsupplierEntity.setPicketageFlag(1);
                    subPicketageRefsupplierEntity.setSignStatus(0);
                    subPicketageRefsupplierEntity.setPurchaseType(inviteEntity.getPurchaseType());
                    this.picketageRefsupplierService.saveOrUpdate((Object)subPicketageRefsupplierEntity);
                    BigDecimal sumNum = detailBidderVO.getSumNum().setScale(4, 4);
                    tenderUnitNum = tenderUnitNum + inviteEntity.getSupplierName() + "(" + sumNum + "),";
                }
                if (tenderUnitNum.length() > 1) {
                    tenderUnitNum = tenderUnitNum.substring(0, tenderUnitNum.length() - 1);
                }
                inviteEntity.setTenderUnitNum(tenderUnitNum);
                this.service.saveOrUpdate((Object)inviteEntity);
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        SubInviteEntity inviteEntity = (SubInviteEntity)((Object)this.service.selectById(billId));
        if (inviteEntity.getOccupyState() != null && inviteEntity.getOccupyState() == 1) {
            return CommonResponse.error((String)"\u62db\u6807\u5df2\u88ab\u5360\u7528,\u4e0d\u80fd\u64a4\u56de!");
        }
        if (inviteEntity.getTenderStage() > 1) {
            return CommonResponse.error((String)("\u62db\u6807\u5904\u4e8e" + TenderStageEnum.getEnumByStateCode((Integer)inviteEntity.getTenderStage()).getDescription() + ",\u4e0d\u80fd\u64a4\u56de!"));
        }
        if (inviteEntity.getEstablishType() == 1) {
            QueryWrapper refWrapper = new QueryWrapper();
            refWrapper.eq((Object)"picketage_id", (Object)inviteEntity.getId());
            List refsupplierEntityList = this.picketageRefsupplierService.list((Wrapper)refWrapper);
            for (SubPicketageRefsupplierEntity refsupplierEntity : refsupplierEntityList) {
                if (refsupplierEntity.getSignStatus() == 0) continue;
                return CommonResponse.error((String)"\u5b58\u5728\u5df2\u7b7e\u8ba2\u5408\u540c,\u4e0d\u80fd\u64a4\u56de!");
            }
            this.picketageRefsupplierService.remove((Wrapper)refWrapper);
        }
        this.detailService.delByInviteId(inviteEntity.getId());
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        SubInviteEntity subInviteEntity = (SubInviteEntity)((Object)this.service.selectById(billId));
        if (subInviteEntity.getEstablishType() == 1 && CollectionUtils.isNotEmpty(subInviteEntity.getSubDetailBidder())) {
            List<String> planIdList = subInviteEntity.getSubDetailBidder().stream().map(SubInviteDetailBidderEntity::getPlanId).map(String::valueOf).distinct().collect(Collectors.toList());
            this.subBatPlanService.updateBatPlanByQuoteType(planIdList, BatPlanEnum.PLAN_STATE_EXEC.getPlanState(), 1);
        }
        return CommonResponse.success();
    }

    public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other) {
        JSONArray arr = new JSONArray();
        this.logger.info("sign:{}", (Object)sign);
        if ("choseCostUser".equals(sign)) {
            SubInviteEntity entity = (SubInviteEntity)((Object)this.service.selectById(billId));
            Long projectId = entity.getProjectId();
            JSONObject jsonObject = new JSONObject();
            CommonResponse commonResponse = this.projectPoolApi.queryProjectPoolById(projectId);
            if (!commonResponse.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u5931\u8d25!");
            }
            JSONArray array = (JSONArray)commonResponse.getData();
            List vos = JSONObject.parseArray((String)array.toJSONString(), ProjectPoolSetVO.class);
            this.logger.info("vos:{}", (Object)JSONObject.toJSONString((Object)vos));
            ProjectPoolSetVO vo = (ProjectPoolSetVO)vos.get(0);
            Long costAdapter = vo.getCostAdapter();
            String costAdapterName = vo.getCostAdapterName();
            this.logger.info("userId:{}", (Object)costAdapter);
            this.logger.info("userName:{}", (Object)costAdapterName);
            jsonObject.put("userId", (Object)costAdapter);
            jsonObject.put("userName", (Object)costAdapterName);
            arr.add((Object)jsonObject);
        }
        return CommonResponse.success((Object)arr);
    }
}

