/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.prosub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentEntity;
import com.ejianc.business.tender.prosub.bean.ProsubInviteEntity;
import com.ejianc.business.tender.prosub.bean.ProsubPicketageEntity;
import com.ejianc.business.tender.prosub.bean.ProsubPicketageSupplierEntity;
import com.ejianc.business.tender.prosub.bean.ProsubWinnoticeEntity;
import com.ejianc.business.tender.prosub.mapper.ProsubWinnoticeMapper;
import com.ejianc.business.tender.prosub.service.IProsubBidDetailService;
import com.ejianc.business.tender.prosub.service.IProsubBidSupplierService;
import com.ejianc.business.tender.prosub.service.IProsubDocumentSellService;
import com.ejianc.business.tender.prosub.service.IProsubDocumentService;
import com.ejianc.business.tender.prosub.service.IProsubDocumentSupplierService;
import com.ejianc.business.tender.prosub.service.IProsubInviteService;
import com.ejianc.business.tender.prosub.service.IProsubNoticeService;
import com.ejianc.business.tender.prosub.service.IProsubPicketageService;
import com.ejianc.business.tender.prosub.service.IProsubPicketageSupplierService;
import com.ejianc.business.tender.prosub.service.IProsubWinnoticeService;
import com.ejianc.business.tender.prosub.vo.ProsubPicketageSupplierVO;
import com.ejianc.business.tender.prosub.vo.ProsubWinDetailVO;
import com.ejianc.business.tender.prosub.vo.ProsubWinVO;
import com.ejianc.business.tender.prosub.vo.ProsubWinnoticeVO;
import com.ejianc.business.tender.sub.vo.TenderStageEnum;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="prosubWinnoticeService")
public class ProsubWinnoticeServiceImpl
extends BaseServiceImpl<ProsubWinnoticeMapper, ProsubWinnoticeEntity>
implements IProsubWinnoticeService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProsubPicketageService subPicketageService;
    @Autowired
    private IProsubNoticeService subNoticeService;
    @Autowired
    private IProsubDocumentService subDocumentService;
    @Autowired
    private IProsubInviteService subInviteService;
    @Autowired
    private IProsubBidDetailService subBidDetailService;
    @Autowired
    private IProsubDocumentSellService subDocumentSellService;
    @Autowired
    private IProsubBidSupplierService subBidSupplierService;
    @Autowired
    private IProsubDocumentSupplierService subDocumentSupplierService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private CacheManager cacheManager;
    @Value(value="${gysUrl.winSaveOrUpdateUrl}")
    private String winSaveOrUpdateUrl;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IProsubPicketageSupplierService subPicketageSupplierService;
    private static final String BILL_TYPE = "ZZYJ202302070003";
    @Autowired
    private ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    @Transactional
    public ProsubWinnoticeVO saveWinnotice(Long picketageId) {
        ProsubWinnoticeEntity entity = new ProsubWinnoticeEntity();
        entity.setPicketageId(picketageId);
        ProsubPicketageEntity subPicketageEntity = (ProsubPicketageEntity)((Object)this.subPicketageService.selectById(picketageId));
        ProsubInviteEntity inviteEntity = (ProsubInviteEntity)((Object)this.subInviteService.selectById(subPicketageEntity.getInviteId()));
        entity.setInviteId(subPicketageEntity.getInviteId());
        entity.setTitleName(inviteEntity.getTenderName() + "\u4e2d\u6807\u516c\u544a");
        entity.setInviteName(inviteEntity.getTenderName());
        entity.setUnitId(inviteEntity.getUnitId());
        entity.setUnitName(inviteEntity.getUnitName());
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setProjectCode(inviteEntity.getProjectCode());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        ProsubDocumentEntity subDocumentEntity = (ProsubDocumentEntity)((Object)this.subDocumentService.selectById(subPicketageEntity.getDocumentId()));
        entity.setEmployeeId(subDocumentEntity.getEmployeeId());
        entity.setEmployeeName(subDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(subDocumentEntity.getEmployeeMobile());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setSignFlag(0);
        entity.setLineTypeName(CommonUtils.getTypeName(1));
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode((Integer)inviteEntity.getTenderType()).getDescription());
        super.saveOrUpdate((Object)entity, false);
        subPicketageEntity.setWinnoticeStatus(1);
        subPicketageEntity.setWinnoticeId(entity.getId());
        this.subPicketageService.updateById((Object)subPicketageEntity);
        List<ProsubPicketageSupplierEntity> picketageSupplierList = subPicketageEntity.getPicketageSupplierList();
        for (ProsubPicketageSupplierEntity subPicketageSupplierEntity : picketageSupplierList) {
            subPicketageSupplierEntity.setWinnoticeId(entity.getId());
        }
        this.subPicketageSupplierService.updateBatchById(picketageSupplierList);
        inviteEntity.setTenderStage(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getTenderTypeCode());
        this.subInviteService.updateById((Object)inviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getDescription());
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(6);
        processEntity.setFrontendUrl("prosub/winnotice");
        this.processService.saveOrUpdate((Object)processEntity);
        ProsubWinnoticeVO subWinnoticeVO = (ProsubWinnoticeVO)BeanMapper.map((Object)((Object)entity), ProsubWinnoticeVO.class);
        return subWinnoticeVO;
    }

    @Override
    public ProsubWinnoticeVO queryDetail(Long id) {
        Map attacMap;
        AttachmentVO attachmentVO;
        List data;
        Long id1;
        CommonResponse listCommonResponse;
        ProsubWinnoticeEntity subWinnoticeEntity = (ProsubWinnoticeEntity)((Object)super.selectById((Serializable)id));
        ProsubWinnoticeVO subWinnoticeVO = (ProsubWinnoticeVO)BeanMapper.map((Object)((Object)subWinnoticeEntity), ProsubWinnoticeVO.class);
        ProsubPicketageEntity subPicketageEntity = (ProsubPicketageEntity)((Object)this.subPicketageService.selectById(subWinnoticeEntity.getPicketageId()));
        List<ProsubPicketageSupplierEntity> picketageSupplierList = subPicketageEntity.getPicketageSupplierList();
        List subPicketageSupplierList = BeanMapper.mapList(picketageSupplierList, ProsubPicketageSupplierVO.class);
        subWinnoticeVO.setPicketageSupplierList(subPicketageSupplierList);
        if (subWinnoticeVO != null && (listCommonResponse = this.attachmentApi.queryListBySourceId(id1 = subWinnoticeVO.getId(), BILL_TYPE, "tenderWinnotice", "")).isSuccess() && CollectionUtils.isNotEmpty((Collection)(data = (List)listCommonResponse.getData())) && (attachmentVO = (AttachmentVO)(attacMap = data.stream().filter(s -> s.getSourceType().equals("tenderWinnotice")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()))).get(subWinnoticeVO.getId())) != null) {
            subWinnoticeVO.setAttachId(attachmentVO.getId());
            subWinnoticeVO.setFileName(attachmentVO.getFileName());
            subWinnoticeVO.setFilePath(attachmentVO.getFilePath());
        }
        return subWinnoticeVO;
    }

    @Override
    public ProsubWinnoticeVO publishWinnotice(Long id) {
        ProsubWinnoticeEntity subWinnoticeEntity = (ProsubWinnoticeEntity)((Object)super.selectById((Serializable)id));
        subWinnoticeEntity.setPublishFlag(0);
        super.updateById((Object)subWinnoticeEntity);
        ProsubPicketageEntity subPicketageEntity = (ProsubPicketageEntity)((Object)this.subPicketageService.selectById(subWinnoticeEntity.getPicketageId()));
        subPicketageEntity.setWinnoticeStatus(2);
        this.subPicketageService.updateById((Object)subPicketageEntity);
        ProsubInviteEntity subInviteEntity = (ProsubInviteEntity)((Object)this.subInviteService.selectById(subPicketageEntity.getInviteId()));
        ProsubWinVO winVO = new ProsubWinVO();
        winVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u4e2d\u6807\u516c\u544a");
        winVO.setSourceId(Long.toString(subWinnoticeEntity.getInviteId()));
        winVO.setBillCode(subInviteEntity.getBillCode());
        if (subInviteEntity.getPurchaseType() == 0) {
            winVO.setSourceProjectId(Long.toString(subInviteEntity.getProjectId()));
            winVO.setProjectName(subInviteEntity.getProjectName());
            winVO.setProjectCode(subInviteEntity.getProjectCode());
        }
        if (subInviteEntity.getPurchaseType() == 1) {
            winVO.setOrgName(subInviteEntity.getOrgName());
            winVO.setSourceOrgId(Long.toString(subInviteEntity.getOrgId()));
        }
        winVO.setSourceUnitId(Long.toString(subInviteEntity.getUnitId()));
        winVO.setUnitName(subInviteEntity.getUnitName());
        winVO.setType("MATERIAL");
        winVO.setTenderName(subInviteEntity.getTenderName());
        winVO.setTenderType(subInviteEntity.getTenderType());
        winVO.setSourceEmployeeId(Long.toString(subWinnoticeEntity.getEmployeeId()));
        winVO.setEmployeeName(subWinnoticeEntity.getEmployeeName());
        winVO.setEmployeeMobile(subWinnoticeEntity.getEmployeeMobile());
        winVO.setPurchaseType(subInviteEntity.getPurchaseType());
        winVO.setWinDate(subWinnoticeEntity.getWinDate());
        winVO.setWinTitle(subWinnoticeEntity.getTitleName());
        winVO.setStopDate(subWinnoticeEntity.getStopDate());
        winVO.setSystemId((String)this.proSupplierApi.getEjcCloudSystemCode().getData());
        List<ProsubPicketageSupplierEntity> picketageSupplierList = subPicketageEntity.getPicketageSupplierList();
        ArrayList<ProsubWinDetailVO> winDetailVOS = new ArrayList<ProsubWinDetailVO>();
        for (ProsubPicketageSupplierEntity subPicketageSupplierEntity : picketageSupplierList) {
            ProsubWinDetailVO subWinDetailVO = new ProsubWinDetailVO();
            subWinDetailVO.setWinId(subWinnoticeEntity.getId());
            subWinDetailVO.setSupplierName(subPicketageSupplierEntity.getSupplierName());
            subWinDetailVO.setTenderFlag(subPicketageSupplierEntity.getTenderFlag());
            SupplierDTO supplierVO = (SupplierDTO)this.shareSupplierApi.queryById(subPicketageSupplierEntity.getSupplierId()).getData();
            subWinDetailVO.setTenantId(supplierVO.getTenant());
            subWinDetailVO.setMoney(subPicketageSupplierEntity.getMoneyTax());
            winDetailVOS.add(subWinDetailVO);
        }
        winVO.setWinDetailList(winDetailVOS);
        String stringFb = JSONObject.toJSONString((Object)winVO);
        this.logger.info("\u4e2d\u6807\u516c\u544a\u53d1\u5e03" + stringFb);
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.winSaveOrUpdateUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u4e2d\u6807\u516c\u544a\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return this.queryDetail(id);
    }

    @Override
    public ProsubWinnoticeVO saveOrUpdates(ProsubWinnoticeEntity entity) {
        super.saveOrUpdate((Object)entity, false);
        return this.queryDetail(entity.getId());
    }

    @Override
    public CommonResponse<String> changeStatus(Long billId, int status, String refCode) {
        ProsubWinnoticeEntity prosubWinnoticeEntity = (ProsubWinnoticeEntity)((Object)super.selectById((Serializable)billId));
        if (status == 5 || status == 6 || status == 7 || status == 8) {
            prosubWinnoticeEntity.setSignFlag(0);
        }
        if (status == 2 || status == 3) {
            prosubWinnoticeEntity.setSignFlag(1);
        }
        if (status == 4) {
            prosubWinnoticeEntity.setSignFlag(2);
            ContractVO cv = new ContractVO();
            cv.setContractId(prosubWinnoticeEntity.getId());
            cv.setContractName(prosubWinnoticeEntity.getTitleName());
            cv.setBillType(BILL_TYPE);
            cv.setSourceType("tenderWinnotice");
            ArrayList<ContractVO> cvs = new ArrayList<ContractVO>();
            cvs.add(cv);
            CommonResponse signResp = this.signatureCommonApi.fetchSignedContract(cvs);
            if (!signResp.isSuccess()) {
                throw new BusinessException("\u540c\u6b65\u7b7e\u7ae0\u9644\u4ef6\u5931\u8d25!");
            }
        }
        super.updateById((Object)prosubWinnoticeEntity);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f!");
    }
}

