package com.ejianc.business.tender.equipment.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentExpertVO;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 招标文件主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tender_equipment_document")
public class EquipmentDocumentEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="invite_id")
    private Long inviteId; // 招标立项主键
    @TableField(value="notice_id")
    private Long noticeId; // 招标公告主键
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="document_name")
    private String documentName; // 文件名称
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="employee_id")
    private Long employeeId; // 招标联系人
    @TableField(value="employee_name")
    private String employeeName; // 招标联系人名称
    @TableField(value="employee_mobile")
    private String employeeMobile; // 招标联系人电话
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="value_type")
    private Integer valueType; // 计价方式(0-固定单价,1-浮动单价,2-固定总额)
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="purchase_type")
    private Integer purchaseType; // 采购方式(0-项目采购,1-单位采购)
    @TableField(value="project_link_name")
    private String projectLinkName; // 项目联系人
    @TableField(value="project_link_phone")
    private String projectLinkPhone; // 项目联系人电话
    @TableField(value="offer_start_time")
    private Date offerStartTime; // 报价开始时间
    @TableField(value="offer_end_time")
    private Date offerEndTime; // 报价结束时间
    @TableField(value="brand_flag")
    private Integer brandFlag; // 是否允许多品牌报价,0-是,1-否
    @TableField(value="publish_flag")
    private Integer publishFlag; // 是否发布,0-是,1-否
    @TableField(value="bid_flag")
    private Integer bidFlag; // 是否开标,0-是,1-否
    @TableField(value="next_flag")
    private Integer nextFlag; // 是否下一步,0-是,1-否
    @TableField(value="unit_id")
    private Long unitId; // 招标单位ID
    @TableField(value="unit_name")
    private String unitName; // 招标单位名称
    @TableField(value="document_content")
    private String documentContent; // 文件内容
    @TableField(value="bid_time")
    private Date bidTime; //开标时间
    @TableField(value="tender_type")
    private Integer tenderType; // 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标，6-洽商谈判)
    @TableField(value="purchase_id")
    private String purchaseId; // 采购方式ID
    @TableField(value="purchase_name")
    private String purchaseName; // 采购方式名称


    @TableField(exist=false)
    @SubEntity(serviceName="equipmentDocumentDetailService",pidName = "documentId")
    private List<EquipmentDocumentDetailEntity> equipmentDocumentDetailList = new ArrayList<>(); // 招标文件物料详情表
    @TableField(exist=false)
    @SubEntity(serviceName="equipmentDocumentRecordService",pidName = "documentId")
    private List<EquipmentDocumentRecordEntity> equipmentDocumentRecordList = new ArrayList<>(); // 招标文件截止日期变更记录表
    @TableField(exist=false)
    @SubEntity(serviceName="equipmentDocumentSchemeService",pidName = "documentId")
    private List<EquipmentDocumentSchemeEntity> equipmentDocumentSchemeList = new ArrayList<>(); // 招标文件方案表
    @TableField(exist=false)
    @SubEntity(serviceName="equipmentDocumentSellService",pidName = "documentId")
    private List<EquipmentDocumentSellEntity> equipmentDocumentSellList = new ArrayList<>(); // 招标文件报价表
    @TableField(exist=false)
    @SubEntity(serviceName="equipmentDocumentSupplierService",pidName = "documentId")
    private List<EquipmentDocumentSupplierEntity> equipmentDocumentSupplierList = new ArrayList<>(); // 招标文件供应商标
    @TableField(exist=false)
    @SubEntity(serviceName="equipmentDocumentExpertService",pidName = "documentId")
    private List<EquipmentDocumentExpertVO> expertVOList = new ArrayList<>();
    @TableField(value="settlement_clause")
    private String settlementClause; // 结算条款

    public String getSettlementClause() {
        return settlementClause;
    }

    public void setSettlementClause(String settlementClause) {
        this.settlementClause = settlementClause;
    }
    public List<EquipmentDocumentExpertVO> getExpertVOList() {
        return expertVOList;
    }

    public void setExpertVOList(List<EquipmentDocumentExpertVO> expertVOList) {
        this.expertVOList = expertVOList;
    }

    public String getPurchaseId() {
        return purchaseId;
    }

    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }

    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }

    public Integer getNextFlag() {
        return nextFlag;
    }

    public void setNextFlag(Integer nextFlag) {
        this.nextFlag = nextFlag;
    }

    public Date getBidTime() {
        return bidTime;
    }

    public void setBidTime(Date bidTime) {
        this.bidTime = bidTime;
    }

    public String getDocumentContent() {
        return documentContent;
    }

    public void setDocumentContent(String documentContent) {
        this.documentContent = documentContent;
    }

    public Integer getTenderType() {
        return tenderType;
    }

    public void setTenderType(Integer tenderType) {
        this.tenderType = tenderType;
    }

    /**
     * 招标立项主键
     */
    public Long getInviteId() {
        return inviteId;
    }

    /**
     * 招标立项主键
     */
    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }
    /**
     * 招标公告主键
     */
    public Long getNoticeId() {
        return noticeId;
    }

    /**
     * 招标公告主键
     */
    public void setNoticeId(Long noticeId) {
        this.noticeId = noticeId;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 文件名称
     */
    public String getDocumentName() {
        return documentName;
    }

    /**
     * 文件名称
     */
    public void setDocumentName(String documentName) {
        this.documentName = documentName;
    }
    /**
     * 项目ID
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 招标联系人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 招标联系人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 招标联系人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 招标联系人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 招标联系人电话
     */
    public String getEmployeeMobile() {
        return employeeMobile;
    }

    /**
     * 招标联系人电话
     */
    public void setEmployeeMobile(String employeeMobile) {
        this.employeeMobile = employeeMobile;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 计价方式(0-固定单价,1-浮动单价,2-固定总额)
     */
    public Integer getValueType() {
        return valueType;
    }

    /**
     * 计价方式(0-固定单价,1-浮动单价,2-固定总额)
     */
    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 采购方式(0-项目采购,1-单位采购)
     */
    public Integer getPurchaseType() {
        return purchaseType;
    }

    /**
     * 采购方式(0-项目采购,1-单位采购)
     */
    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }
    /**
     * 项目联系人
     */
    public String getProjectLinkName() {
        return projectLinkName;
    }

    /**
     * 项目联系人
     */
    public void setProjectLinkName(String projectLinkName) {
        this.projectLinkName = projectLinkName;
    }
    /**
     * 项目联系人电话
     */
    public String getProjectLinkPhone() {
        return projectLinkPhone;
    }

    /**
     * 项目联系人电话
     */
    public void setProjectLinkPhone(String projectLinkPhone) {
        this.projectLinkPhone = projectLinkPhone;
    }
    /**
     * 报价开始时间
     */
    public Date getOfferStartTime() {
        return offerStartTime;
    }

    /**
     * 报价开始时间
     */
    public void setOfferStartTime(Date offerStartTime) {
        this.offerStartTime = offerStartTime;
    }
    /**
     * 报价结束时间
     */
    public Date getOfferEndTime() {
        return offerEndTime;
    }

    /**
     * 报价结束时间
     */
    public void setOfferEndTime(Date offerEndTime) {
        this.offerEndTime = offerEndTime;
    }
    /**
     * 是否允许多品牌报价,0-是,1-否
     */
    public Integer getBrandFlag() {
        return brandFlag;
    }

    /**
     * 是否允许多品牌报价,0-是,1-否
     */
    public void setBrandFlag(Integer brandFlag) {
        this.brandFlag = brandFlag;
    }
    /**
     * 是否发布,0-是,1-否
     */
    public Integer getPublishFlag() {
        return publishFlag;
    }

    /**
     * 是否发布,0-是,1-否
     */
    public void setPublishFlag(Integer publishFlag) {
        this.publishFlag = publishFlag;
    }
    /**
     * 是否开标,0-是,1-否
     */
    public Integer getBidFlag() {
        return bidFlag;
    }

    /**
     * 是否开标,0-是,1-否
     */
    public void setBidFlag(Integer bidFlag) {
        this.bidFlag = bidFlag;
    }
    /**
     * 招标单位ID
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 招标单位ID
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 招标单位名称
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 招标单位名称
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public List<EquipmentDocumentDetailEntity> getEquipmentDocumentDetailList() {
        return equipmentDocumentDetailList;
    }

    public void setEquipmentDocumentDetailList(List<EquipmentDocumentDetailEntity> equipmentDocumentDetailList) {
        this.equipmentDocumentDetailList = equipmentDocumentDetailList;
    }

    public List<EquipmentDocumentRecordEntity> getEquipmentDocumentRecordList() {
        return equipmentDocumentRecordList;
    }

    public void setEquipmentDocumentRecordList(List<EquipmentDocumentRecordEntity> equipmentDocumentRecordList) {
        this.equipmentDocumentRecordList = equipmentDocumentRecordList;
    }

    public List<EquipmentDocumentSchemeEntity> getEquipmentDocumentSchemeList() {
        return equipmentDocumentSchemeList;
    }

    public void setEquipmentDocumentSchemeList(List<EquipmentDocumentSchemeEntity> equipmentDocumentSchemeList) {
        this.equipmentDocumentSchemeList = equipmentDocumentSchemeList;
    }

    public List<EquipmentDocumentSellEntity> getEquipmentDocumentSellList() {
        return equipmentDocumentSellList;
    }

    public void setEquipmentDocumentSellList(List<EquipmentDocumentSellEntity> equipmentDocumentSellList) {
        this.equipmentDocumentSellList = equipmentDocumentSellList;
    }

    public List<EquipmentDocumentSupplierEntity> getEquipmentDocumentSupplierList() {
        return equipmentDocumentSupplierList;
    }

    public void setEquipmentDocumentSupplierList(List<EquipmentDocumentSupplierEntity> equipmentDocumentSupplierList) {
        this.equipmentDocumentSupplierList = equipmentDocumentSupplierList;
    }
}
