package com.ejianc.business.tender.equipment.mapper;

import com.ejianc.business.tender.equipment.bean.EquipmentDocumentSchemeEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.math.BigDecimal;
import java.util.List;

/**
 * 招标文件方案表
 * 
 * @author generator
 * 
 */
@Mapper
public interface EquipmentDocumentSchemeMapper extends BaseCrudMapper<EquipmentDocumentSchemeEntity> {

    List<EquipmentDocumentSchemeEntity> selectEquipmentSchemeList(@Param("id") Long id, @Param("supplierId") Long supplierId);
    @Select("SELECT * FROM `ejc_tender_equipment_document_scheme` WHERE document_id = #{documentId} and dr =0")
    List<EquipmentDocumentSchemeEntity> selectSupplier(Long documentId);
    @Update("UPDATE ejc_tender_equipment_document_scheme set score= #{score}  where id= #{id} and supplier_id = #{supplierId} and document_id =#{documentId} ")
    Boolean updateScore(@Param("id") Long id, @Param("supplierId") Long supplierId, @Param("documentId") Long documentId, @Param("score") BigDecimal score);
}
