package com.ejianc.business.tender.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.proequipmentcorppur.purchaseApply.vo.api.ICorpPurchaseApplyApi;
import com.ejianc.business.proequipmentcorppur.purchaseplan.api.ICorpPurchasePlanApi;
import com.ejianc.business.purchaseplan.vo.api.IPurchasePlanApi;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteDetailRecordEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.equipment.mapper.EquipmentInviteMapper;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.equipment.vo.EquipmentInviteDetailBidderVO;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.equipment.vo.EquipmentInviteDetailVO;
import com.ejianc.business.tender.equipment.vo.EquipmentInviteVO;
import com.ejianc.business.tender.rmat.bean.RmatInviteDetailRecordEntity;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.service.ISubInviteService;
import com.ejianc.business.tender.sub.vo.SubInviteVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 材料立项主表
 * 
 * @author generator
 * 
 */
@Service("equipmentInviteService")
public class EquipmentInviteServiceImpl extends BaseServiceImpl<EquipmentInviteMapper, EquipmentInviteEntity> implements IEquipmentInviteService {
    @Autowired
    private IEquipmentInviteService equipmentInviteService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private ISubInviteService subInviteService;

    @Autowired
    private IPurchasePlanApi batPlanApi;

    @Autowired
    private ICorpPurchaseApplyApi corpPurchasePlanApi;

    @Override
    public void updateTenderStage(String id, int tenderStage) {
        baseMapper.updateTenderStage(id,tenderStage);
    }

    @Override
    public void updateAbolishType(String id, int abolishType) {
        baseMapper.updateAbolishType(id,abolishType);
    }

    @Override
    public List<EquipmentInviteDetailVO> selectSumDetail(Long inviteId) {
        return baseMapper.selectSumDetail(inviteId);
    }

    @Override
    public List<EquipmentInviteDetailVO> selectOrgSumDetail(Long inviteId) {
        return baseMapper.selectOrgSumDetail(inviteId);
    }

    @Override
    public Map<String, Object> getAbolishType(Long tenderId) {
        Map<String, Object> map = new HashMap<>();
        LambdaQueryWrapper<ProcessEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(ProcessEntity::getTenderId, tenderId);
        lambda.eq(ProcessEntity::getBillId, tenderId);
        List<ProcessEntity> list = processService.list(lambda);
        switch (list.get(0).getType()){
            case 0: map = equipmentInviteService.getSuffAbolishType(tenderId);break;
            case 1: map = equipmentInviteService.getSubAbolishType(tenderId);break;
        }
        return map;
    }

    @Override
    public Map<String, Object> getSuffAbolishType(Long tenderId) {
        Map<String, Object> map = new HashMap<>();
        EquipmentInviteEntity equipmentInviteEntity = equipmentInviteService.selectById(tenderId);
        EquipmentInviteVO vo = BeanMapper.map(equipmentInviteEntity, EquipmentInviteVO.class);
        if(vo.getAbolishType()==null){
            vo.setAbolishType(0);
        }
        map.put("abolishType", vo.getAbolishType());
        map.put("employeeId",vo.getEmployeeId());
        return map;
    }

    @Override
    public Map<String, Object> getSubAbolishType(Long tenderId) {
        Map<String, Object> map = new HashMap<>();
        SubInviteEntity subInviteEntity = subInviteService.selectById(tenderId);
        SubInviteVO vo = BeanMapper.map(subInviteEntity, SubInviteVO.class);
        if(vo.getAbolishType()==null){
            vo.setAbolishType(0);
        }
        map.put("abolishType", vo.getAbolishType());
        map.put("employeeId",vo.getEmployeeId());
        return map;
    }

    @Override
    public List<EquipmentInviteDetailBidderVO> selectDetailBidder(Long inviteId) {
        return baseMapper.selectDetailBidder(inviteId);
    }

    @Override
    public void updateApiState(EquipmentInviteEntity entity, Integer BatchPlanState, Integer MaterialBatchPlanState) {
        List<String> batPlanList = entity.getEquipmentDetailRecord().stream().map(EquipmentInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct().collect(Collectors.toList());
        //if (entity.getPurchaseType()==0){
            if (CollectionUtils.isNotEmpty(batPlanList)) {
                CommonResponse<String> response = batPlanApi.updateBatPlanQuote(batPlanList, BatchPlanState);
                if (!response.isSuccess()) {
                    throw new BusinessException("修改计划状态失败" + response.getMsg());
                }
            }
//        }else {
//            if (CollectionUtils.isNotEmpty(batPlanList)) {
//                CommonResponse<String> response = corpPurchasePlanApi.updateBatApplyByQuoteType(batPlanList, MaterialBatchPlanState);
//                if (!response.isSuccess()) {
//                    throw new BusinessException("修改公司设备采购计划状态失败" + response.getMsg());
//                }
//            }
//        }
    }
}
