package com.ejianc.business.tender.equipment.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.assist.material.vo.MaterialBatchPlanEnum;
import com.ejianc.business.pro.rmat.vo.BatchPlanEnum;
import com.ejianc.business.promaterial.plan.api.IBatPlanApi;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.business.purchaseplan.vo.PurchasePlanEnum;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.equipment.bean.*;
import com.ejianc.business.tender.equipment.service.*;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.equipment.vo.EquipmentBidVO;
import com.ejianc.business.tender.stuff.bean.StuffDocumentSellEntity;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("equipmentPicketage")
public class EquipmentPicketageBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private IEquipmentPicketageService equipmentPicketageService;
	@Autowired
	private IEquipmentBidService equipmentBidService;
	@Autowired
	private IEquipmentAdviceService equipmentAdviceService;
	@Autowired
	private IEquipmentWinnoticeService equipmentWinnoticeService;
	@Autowired
	private IEquipmentInviteService equipmentInviteService;
	@Autowired
	private IEquipmentBidDetailService equipmentBidDetailService;
	@Autowired
	private IEquipmentDocumentSellService equipmentDocumentSellService;
	@Autowired
	private IEquipmentBidSupplierService equipmentBidSupplierService;
	@Autowired
	private IEquipmentDocumentSupplierService equipmentDocumentSupplierService;
	@Autowired
	private IProcessService processService;
	@Autowired
	private IShareSupplierApi shareSupplierApi;
	@Autowired
	private IEquipmentPicketageRefsupplierService equipmentPicketageRefsupplierService;
	@Autowired
	private IEquipmentPicketageSupplierService equipmentPicketageSupplierService;
	@Autowired
	private IEquipmentInviteDetailRecordService equipmentInviteDetailRecordService;
	@Autowired
	private IBatPlanApi batPlanApi;

	@Value("${gysUrl.updateTimeUrl}")
	private String updateTimeUrl;

	@Value("${gysUrl.winbidSavesUrl}")
	private String winbidSavesUrl;
	private static final String BILL_CODE = "invite-bid-code";//此处需要根据实际修改
	@Autowired
	private IProjectPoolApi projectPoolApi;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		EquipmentBidVO equipmentBidVO = equipmentBidService.saveBid(billId);
		equipmentBidService.publishBid(equipmentBidVO);

		//处理参照表,只处理项目线的数据
		//查询出所有定标的数据

		EquipmentPicketageEntity equipmentPicketageEntity = equipmentPicketageService.selectById(billId);
		EquipmentInviteEntity equipmentInviteEntity = equipmentInviteService.selectById(equipmentPicketageEntity.getInviteId());

		// 完成采购计划
		QueryParam equipmentInviteDetailQueryParam = new QueryParam();
		equipmentInviteDetailQueryParam.getParams()
				.put("invite_id", new Parameter(QueryParam.EQ, equipmentInviteEntity.getId()));
		List<EquipmentInviteDetailRecordEntity> equipmentInviteDetailEntityList = equipmentInviteDetailRecordService
				.queryList(equipmentInviteDetailQueryParam);
		// 获取采购计划ID
		if (CollectionUtils.isNotEmpty(equipmentInviteDetailEntityList)) {
//			List<String> planIdList = equipmentInviteDetailEntityList.stream()
//					.map(EquipmentInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct()
//					.collect(Collectors.toList());
			// 释放采购计划
			equipmentInviteService.updateApiState(equipmentInviteEntity, PurchasePlanEnum.PLAN_STATE_OVER.getPlanState(), PurchasePlanEnum.PLAN_STATE_OVER.getPlanState());

		}

//		if (equipmentInviteEntity.getPurchaseType().equals(0)) {

		LambdaQueryWrapper<EquipmentDocumentSellEntity> sellWrapper = Wrappers.lambdaQuery();
		sellWrapper.eq(EquipmentDocumentSellEntity::getDocumentId, equipmentPicketageEntity.getDocumentId());
		sellWrapper.eq(EquipmentDocumentSellEntity::getTenderFlag, 1);
		List<EquipmentDocumentSellEntity> equipmentDocumentSellList = equipmentDocumentSellService.list(sellWrapper);

		//项目招标
		//改造-0905
		Map<Long, ProjectPoolSetVO> proMap = new HashMap<>();
		//if (equipmentInviteEntity.getPurchaseType().equals(0)){
			List<Long> projectPks = equipmentDocumentSellList.stream().map(EquipmentDocumentSellEntity::getProjectId).collect(Collectors.toList());
			CommonResponse<JSONArray> jsonArrayCommonResponse = projectPoolApi.queryProjectByIds(projectPks);

			if (jsonArrayCommonResponse.isSuccess()){
				JSONArray data = jsonArrayCommonResponse.getData();
				List<ProjectPoolSetVO> projectRegisterVOS = data.toJavaList(ProjectPoolSetVO.class);
				proMap = projectRegisterVOS.stream().collect(Collectors.toMap(ProjectPoolSetVO::getId, Function.identity()));
			}
		//}

		Map<String, List<EquipmentDocumentSellEntity>> dataMap = new HashMap<>();
		for (EquipmentDocumentSellEntity equipmentDocumentSellEntity : equipmentDocumentSellList) {
			//改造-0905
			//if (equipmentInviteEntity.getPurchaseType().equals(0)){
				ProjectPoolSetVO projectPoolSetVO = proMap.get(equipmentDocumentSellEntity.getProjectId());
				if (projectPoolSetVO != null){
					equipmentDocumentSellEntity.setOrgId(projectPoolSetVO.getProjectDepartmentId());
					equipmentDocumentSellEntity.setOrgName(projectPoolSetVO.getProjectDepartmentName());
				}
			//}
			String s = null;
			//if (equipmentInviteEntity.getPurchaseType().equals(0)){
				s = equipmentDocumentSellEntity.getProjectId().toString() + equipmentDocumentSellEntity.getSupplierId()
						.toString();
//			}
//			if (equipmentInviteEntity.getPurchaseType().equals(1)){
//				s = equipmentDocumentSellEntity.getSupplierId()
//						.toString();
//			}
			if (dataMap.containsKey(s)) {
				List<EquipmentDocumentSellEntity> equipmentDocumentSellEntityList = dataMap.get(s);
				equipmentDocumentSellEntityList.add(equipmentDocumentSellEntity);
				dataMap.put(s,equipmentDocumentSellEntityList);
			}else {
				List<EquipmentDocumentSellEntity> equipmentDocumentSellEntities = new ArrayList<>();
				equipmentDocumentSellEntities.add(equipmentDocumentSellEntity);
				dataMap.put(s,equipmentDocumentSellEntities);
			}
		}
		List<EquipmentPicketageRefsupplierEntity> equipmentPicketageRefsupplierEntities = new ArrayList<>();
		dataMap.forEach((key,value) -> {
			EquipmentPicketageRefsupplierEntity equipmentPicketageRefsupplierEntity = new EquipmentPicketageRefsupplierEntity();
			EquipmentDocumentSellEntity equipmentSellEntity = value.stream().findFirst().get();
			equipmentPicketageRefsupplierEntity.setSupplierId(equipmentSellEntity.getSupplierId());
			equipmentPicketageRefsupplierEntity.setSupplierName(equipmentSellEntity.getSupplierName());
			equipmentPicketageRefsupplierEntity.setProjectId(equipmentSellEntity.getProjectId());
			equipmentPicketageRefsupplierEntity.setProjectName(equipmentSellEntity.getProjectName());
			equipmentPicketageRefsupplierEntity.setProjectCode(equipmentInviteEntity.getProjectCode());
			equipmentPicketageRefsupplierEntity.setPicketageId(billId);
			equipmentPicketageRefsupplierEntity.setOccupyFlag(0);
			SupplierDTO supplierVO = shareSupplierApi.queryById(equipmentSellEntity.getSupplierId()).getData();
			equipmentPicketageRefsupplierEntity.setSupplierTenantId(supplierVO.getTenant());
			equipmentPicketageRefsupplierEntity.setPicketageName(equipmentPicketageEntity.getPicketageName());
			equipmentPicketageRefsupplierEntity.setPicketageDate(new Date());
			//改造-0905
			//if (equipmentPicketageEntity.getPurchaseType().equals(0)){
				equipmentPicketageRefsupplierEntity.setOrgId(equipmentSellEntity.getOrgId());
				equipmentPicketageRefsupplierEntity.setOrgName(equipmentSellEntity.getOrgName());
//			}
//			if (equipmentPicketageEntity.getPurchaseType().equals(1)){
//				equipmentPicketageRefsupplierEntity.setOrgId(equipmentPicketageEntity.getOrgId());
//				equipmentPicketageRefsupplierEntity.setOrgName(equipmentPicketageEntity.getOrgName());
//			}
			equipmentPicketageRefsupplierEntity.setOrgId(equipmentInviteEntity.getOrgId());
			equipmentPicketageRefsupplierEntity.setOrgName(equipmentInviteEntity.getOrgName());
			equipmentPicketageRefsupplierEntity.setParentOrgId(equipmentInviteEntity.getParentOrgId());
			equipmentPicketageRefsupplierEntity.setParentOrgName(equipmentInviteEntity.getParentOrgName());
			equipmentPicketageRefsupplierEntity.setPicketageFlag(0);
			BigDecimal tenderMoney = BigDecimal.ZERO;
			BigDecimal tenderMoneyTax = BigDecimal.ZERO;
			for (EquipmentDocumentSellEntity equipmentDocumentSellEntity : value){
				tenderMoney = tenderMoney.add(equipmentDocumentSellEntity.getTenderMoney());
				tenderMoneyTax = tenderMoneyTax.add(equipmentDocumentSellEntity.getTenderMoneyTax());
			}
			equipmentPicketageRefsupplierEntity.setMoney(tenderMoney.setScale(2, BigDecimal.ROUND_HALF_UP));
			equipmentPicketageRefsupplierEntity.setMoneyTax(tenderMoneyTax.setScale(2, BigDecimal.ROUND_HALF_UP));
			equipmentPicketageRefsupplierEntity.setSignStatus(TenderSignStatusEnum.未签订.getCode());
			equipmentPicketageRefsupplierEntity.setPurchaseType(equipmentInviteEntity.getPurchaseType());
			equipmentPicketageRefsupplierEntities.add(equipmentPicketageRefsupplierEntity);
		});
		equipmentPicketageRefsupplierService.saveBatch(equipmentPicketageRefsupplierEntities);
//		}

		//生成中标通知书类表数据
		List<EquipmentPicketageSupplierEntity> picketageSupplierList = equipmentPicketageEntity.getPicketageSupplierList();
		List<EquipmentAdviceEntity> equipmentAdviceList = BeanMapper.mapList(picketageSupplierList, EquipmentAdviceEntity.class);
		for (EquipmentAdviceEntity equipmentAdviceEntity : equipmentAdviceList){
			equipmentAdviceEntity.setTitleName(equipmentInviteEntity.getTenderName());
			equipmentAdviceEntity.setUnitId(equipmentInviteEntity.getUnitId());
			equipmentAdviceEntity.setUnitName(equipmentInviteEntity.getUnitName());
			equipmentAdviceEntity.setProjectId(equipmentInviteEntity.getProjectId());
			equipmentAdviceEntity.setProjectName(equipmentInviteEntity.getProjectName());
			equipmentAdviceEntity.setOrgId(equipmentInviteEntity.getOrgId());
			equipmentAdviceEntity.setOrgName(equipmentInviteEntity.getOrgName());
			equipmentAdviceEntity.setParentOrgId(equipmentInviteEntity.getParentOrgId());
			equipmentAdviceEntity.setParentOrgName(equipmentInviteEntity.getParentOrgName());
			equipmentAdviceEntity.setParentOrgName(equipmentInviteEntity.getParentOrgName());
			equipmentAdviceEntity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode(equipmentInviteEntity.getTenderType()).getDescription());
			equipmentAdviceEntity.setLineTypeName(CommonUtils.getTypeName(2));
			equipmentAdviceEntity.setPurchaseType(equipmentInviteEntity.getPurchaseType());
			equipmentAdviceEntity.setScFlag(1);
			equipmentAdviceEntity.setSendFlag(1);
			equipmentAdviceEntity.setSignFlag(0);
			equipmentAdviceEntity.setId(null);
			equipmentAdviceEntity.setInviteId(equipmentInviteEntity.getId());
		}
		equipmentAdviceService.saveOrUpdateBatch(equipmentAdviceList);



		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("该功能不支持！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 审批--获取当前节点的审批人---从服务中选择
	 *
	 * @param billId 单据id
	 * @param billTypeCode 单据类型编码
	 * @param sign 节点标志
	 * @return
	 */
	@Override
	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other){
		JSONArray arr = new JSONArray();
		logger.info("sign:{}",sign);

		//根据标识判断是否（成本相关人员审批的）节点
		if ("choseCostUser".equals(sign)){
			//获取表单详情数据

			//根据项目id获取项目基本信息中的成本对接人信息
			EquipmentPicketageEntity entity = equipmentPicketageService.selectById(billId);
			Long projectId = entity.getProjectId();

			JSONObject jsonObject = new JSONObject();
			CommonResponse<JSONArray> commonResponse = projectPoolApi.queryProjectPoolById(projectId);


			if(!commonResponse.isSuccess()){
				throw new BusinessException("查询项目失败!");
			}
			JSONArray array = commonResponse.getData();
			List<ProjectPoolSetVO> vos = JSONObject.parseArray(array.toJSONString(), ProjectPoolSetVO.class);

			logger.info("vos:{}",JSONObject.toJSONString(vos));

			ProjectPoolSetVO vo = vos.get(0);
			Long costAdapter = vo.getCostAdapter();
			String costAdapterName = vo.getCostAdapterName();

			logger.info("userId:{}",costAdapter);
			logger.info("userName:{}",costAdapterName);


			jsonObject.put("userId",costAdapter);
			jsonObject.put("userName",costAdapterName);

			arr.add(jsonObject);

		}
		return CommonResponse.success(arr);
	}

}
