package com.ejianc.business.tender.equipment.service.impl;

import com.ejianc.business.tender.equipment.bean.EquipmentTalkRecordEntity;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentService;
import com.ejianc.business.tender.equipment.service.IEquipmentTalkRecordService;
import com.ejianc.business.tender.equipment.mapper.EquipmentTalkRecordMapper;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentVO;
import com.ejianc.business.tender.equipment.vo.EquipmentTalkRecordVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 洽商谈判记录主表
 * 
 * @author generator
 * 
 */
@Service("equipmentTalkRecordService")
public class EquipmentTalkRecordServiceImpl extends BaseServiceImpl<EquipmentTalkRecordMapper, EquipmentTalkRecordEntity> implements IEquipmentTalkRecordService {
    @Autowired
    private IEquipmentDocumentService equipmentDocumentService;
    @Override
    public EquipmentTalkRecordVO queryDetail(Long id) {
        EquipmentTalkRecordEntity equipmentTalkRecordEntity = super.selectById(id);
        EquipmentTalkRecordVO equipmentTalkRecordVO = BeanMapper.map(equipmentTalkRecordEntity, EquipmentTalkRecordVO.class);

        //确认轮数
        Integer talkNum = equipmentTalkRecordVO.getTalkNum();
        EquipmentDocumentVO equipmentDocumentVO = equipmentDocumentService.queryDocDetail(equipmentTalkRecordVO.getBillId(), talkNum);
        equipmentTalkRecordVO.setEquipmentDocumentDetailSellList(equipmentDocumentVO.getEquipmentDocumentDetailSellList());
        equipmentTalkRecordVO.setEquipmentDocumentSupplierSchemeList(equipmentDocumentVO.getEquipmentDocumentSupplierSchemeList());

        return equipmentTalkRecordVO;
    }
}
