package com.ejianc.business.tender.expert.mapper;

import com.ejianc.business.tender.expert.vo.ExpertRecordVO;
import com.ejianc.business.tender.sub.bean.SubDocumentSchemeEntity;
import com.ejianc.business.tender.sub.bean.SubDocumentSupplierEntity;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.tender.expert.bean.ExpertRecordEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.math.BigDecimal;
import java.util.List;

/**
 * 评标记录表
 * 
 * @author generator
 * 
 */
@Mapper
public interface ExpertRecordMapper extends BaseCrudMapper<ExpertRecordEntity> {
    @Select("select * from ejc_tender_expert_record where dr =0 group by supplier_id")
    List<ExpertRecordVO> selectDetail();
    @Select("select * from ejc_tender_expert_record where employee_id = #{employeeId} and document_id = #{documentId} and dr =0 ")
    List<ExpertRecordVO> selectBySupplier(Long employeeId, Long documentId);
    @Select("SELECT SUM( sum_score ) FROM `ejc_tender_expert_record`  WHERE document_scheme_id = #{id} AND supplier_id = #{supplierId} AND document_id = #{documentId} AND  dr = 0")
    BigDecimal selectScore(@Param("id") Long id, @Param("supplierId") Long supplierId, @Param("documentId") Long documentId);
}

