package com.ejianc.business.tender.expert.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.expert.bean.ExpertRecordEntity;
import com.ejianc.business.tender.expert.bean.TemplateDetailEntity;
import com.ejianc.business.tender.expert.service.ITemplateDetailService;
import com.ejianc.business.tender.expert.vo.ExpertVO;
import com.ejianc.business.tender.expert.vo.TemplateDetailVO;
import com.ejianc.business.tender.expert.vo.TemplateVO;
import com.ejianc.business.tender.util.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.tender.expert.mapper.TemplateMapper;
import com.ejianc.business.tender.expert.bean.TemplateEntity;
import com.ejianc.business.tender.expert.service.ITemplateService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 评标模板主表
 * 
 * @author generator
 * 
 */
@Service("templateService")
public class TemplateServiceImpl extends BaseServiceImpl<TemplateMapper, TemplateEntity> implements ITemplateService{
    @Autowired
    private ITemplateDetailService detailService;
    @Autowired
    private ITemplateService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "SCORING_TEMPLATE";//此处需要根据实际修改
    @Override
    public TemplateVO saveUpdate(TemplateVO saveorUpdateVO) {
        TemplateEntity entity = BeanMapper.map(saveorUpdateVO, TemplateEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //保存前清空主键和父主键，重新生成
        List<TemplateDetailEntity> templateDetailEntities = entity.getTemplateDetailEntities();
        if (CollectionUtils.isNotEmpty(templateDetailEntities) && null == entity.getId()) {
            for (TemplateDetailEntity detailEntity : templateDetailEntities) {
                detailEntity.setId(null);
                detailEntity.setParentId(null);
            }
        }
        service.saveOrUpdate(entity, false);
        List<TemplateDetailEntity> templateDetailEntities2 = entity.getTemplateDetailEntities();
        if (CollectionUtils.isNotEmpty(templateDetailEntities2)) {
            Map<String, Long> idMap = new HashMap<>();
            for (TemplateDetailEntity detailEntity2 : templateDetailEntities2) {
                idMap.put(detailEntity2.getTid(), detailEntity2.getId());
            }
            for (TemplateDetailEntity detailEntity2 : templateDetailEntities2) {
                if (StringUtils.isNotEmpty(detailEntity2.getTpid())) {
                    detailEntity2.setParentId(idMap.get(detailEntity2.getTpid()));
                }
            }
            detailService.saveOrUpdateBatch(templateDetailEntities2, templateDetailEntities2.size(), false);
        }
        return query(entity.getId());
    }

    @Override
    public TemplateVO query(Long id) {
        TemplateEntity entity = service.selectById(id);
        TemplateVO vo = BeanMapper.map(entity, TemplateVO.class);
        List<TemplateDetailVO> templateDetailEntities = vo.getTemplateDetailEntities();
        templateDetailEntities.forEach(val->{
            val.setTid(this.objToString(val.getId()));
            val.setTpid(this.objToString(val.getParentId()));
            val.setRowState("edit");
        });
        List<TemplateDetailVO> templateDetailVOList = TreeNodeBUtil.buildTree(templateDetailEntities);
        vo.setTemplateDetailEntities(templateDetailVOList);
        return vo;
    }
    /**
     * Object转String
     * @param obj 需要转换的obj
     * @return 转换后的String
     */
    private String objToString(Object obj){
        if (obj == null) return null;
        return String.valueOf(obj);
    }
}
