package com.ejianc.business.tender.prosub.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.tender.sub.bean.SubBidDetailEntity;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.List;

/**
 * 中标主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tender_prosub_bid")
public class ProsubBidEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="invite_id")
    private Long inviteId; // 招标立项主键
    @TableField(value="document_id")
    private Long documentId; // 招标文件主键
    @TableField(value="picketage_id")
    private Long picketageId; // 定标主键
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bid_name")
    private String bidName; // 中标名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="publish_flag")
    private Integer publishFlag; // 是否发布,0-是,1-否
    @TableField(value="purchase_id")
    private String purchaseId; // 采购方式ID
    @TableField(value="purchase_name")
    private String purchaseName; // 采购方式名称

    @TableField(value="bid_content")
    private String bidContent; // 中标内容
    @TableField(value="purchase_type")
    private Integer purchaseType;//采购方式(0-项目采购,1-单位采购)
    @TableField(value="winnotice_id")
    private Long winnoticeId;//中标公告主键

    @TableField(value="next_flag")
    private Integer nextFlag; // 是否下一步,0-是,1-否
    @TableField(exist=false)
    @SubEntity(serviceName="prosubBidDetailService",pidName = "bidId")
    private List<ProsubBidDetailEntity> subBidDetailList = new ArrayList<>(); // 中标明细表
    @TableField(exist=false)
    @SubEntity(serviceName="prosubBidSupplierService",pidName = "bidId")
    private List<ProsubBidSupplierEntity> subBidSupplierList = new ArrayList<>(); // 中标供应商表

    public Long getWinnoticeId() {
        return winnoticeId;
    }

    public void setWinnoticeId(Long winnoticeId) {
        this.winnoticeId = winnoticeId;
    }

    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    public Integer getNextFlag() {
        return nextFlag;
    }

    public void setNextFlag(Integer nextFlag) {
        this.nextFlag = nextFlag;
    }

    public String getBidContent() {
        return bidContent;
    }

    public void setBidContent(String bidContent) {
        this.bidContent = bidContent;
    }

    /**
     * 招标立项主键
     */
    public Long getInviteId() {
        return inviteId;
    }

    /**
     * 招标立项主键
     */
    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }
    /**
     * 招标文件主键
     */
    public Long getDocumentId() {
        return documentId;
    }

    /**
     * 招标文件主键
     */
    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }
    /**
     * 定标主键
     */
    public Long getPicketageId() {
        return picketageId;
    }

    /**
     * 定标主键
     */
    public void setPicketageId(Long picketageId) {
        this.picketageId = picketageId;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 中标名称
     */
    public String getBidName() {
        return bidName;
    }

    /**
     * 中标名称
     */
    public void setBidName(String bidName) {
        this.bidName = bidName;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 是否发布,0-是,1-否
     */
    public Integer getPublishFlag() {
        return publishFlag;
    }

    /**
     * 是否发布,0-是,1-否
     */
    public void setPublishFlag(Integer publishFlag) {
        this.publishFlag = publishFlag;
    }
    /**
     * 采购方式ID
     */
    public String getPurchaseId() {
        return purchaseId;
    }

    /**
     * 采购方式ID
     */
    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }
    /**
     * 采购方式名称
     */
    public String getPurchaseName() {
        return purchaseName;
    }

    /**
     * 采购方式名称
     */
    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }

    public List<ProsubBidDetailEntity> getSubBidDetailList() {
        return subBidDetailList;
    }

    public void setSubBidDetailList(List<ProsubBidDetailEntity> subBidDetailList) {
        this.subBidDetailList = subBidDetailList;
    }

    public List<ProsubBidSupplierEntity> getSubBidSupplierList() {
        return subBidSupplierList;
    }

    public void setSubBidSupplierList(List<ProsubBidSupplierEntity> subBidSupplierList) {
        this.subBidSupplierList = subBidSupplierList;
    }
}
