package com.ejianc.business.tender.prosub.controller;

import com.ejianc.business.tender.prosub.service.IProsubPicketageService;
import com.ejianc.business.tender.prosub.service.impl.ProsubPicketageBpmServiceImpl;
import com.ejianc.business.tender.prosub.vo.ProsubPicketageSupplierVO;
import com.ejianc.business.tender.prosub.vo.ProsubPicketageVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;

/**
 * 定标主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("prosub/prosubPicketage")
@Api(value = "定标主表", tags = {"定标主表"})
public class ProsubPicketageController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "invite-picketage-code";//此处需要根据实际修改

    @Autowired
    private IProsubPicketageService service;
    @Autowired
    private ProsubPicketageBpmServiceImpl subPicketageBpmService;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProsubPicketageVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody ProsubPicketageVO saveorUpdateVO) {
        ProsubPicketageVO ProsubPicketageVO = service.saveOrUpdates(saveorUpdateVO);
    	return CommonResponse.success("初始化基础数据成功！",ProsubPicketageVO);
    }
    @ApiOperation("新增或者修改子表供应商")
    @RequestMapping(value = "/saveSupplierBatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProsubPicketageVO> saveSupplierBatch(@RequestBody ProsubPicketageVO saveorUpdateVO) {
        ProsubPicketageVO subPicketageVO = service.saveSupplierBatch(saveorUpdateVO);
        return CommonResponse.success("更新成功！",subPicketageVO);
    }
    @ApiOperation("专家评标下一步接口")
    @RequestMapping(value = "/savePicketage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProsubPicketageVO> savePicketage(@RequestParam Long evaluationId) {
        ProsubPicketageVO ProsubPicketageVO = service.savePicketage(evaluationId);
        return CommonResponse.success("初始化基础数据成功！",ProsubPicketageVO);
    }
    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProsubPicketageVO> queryDetail(@RequestParam Long id) {
        ProsubPicketageVO ProsubPicketageVO = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",ProsubPicketageVO);
    }

    @ApiOperation("紧急招标询价等下一步接口")
    @RequestMapping(value = "/saveManyPicketage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProsubPicketageVO> saveManyPicketage(@RequestParam Long documentId) {
        ProsubPicketageVO ProsubPicketageVO = service.saveManyPicketage(documentId);
        return CommonResponse.success("初始化基础数据成功！",ProsubPicketageVO);
    }

    @ApiOperation("查询供应商列表详情")
    @RequestMapping(value = "/querySupplierList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ProsubPicketageSupplierVO>> querySupplierList(@RequestParam Long picketageId) {
        List<ProsubPicketageSupplierVO> list = service.querySupplierList(picketageId);
        return CommonResponse.success("查询详情数据成功！",list);
    }
    @ApiOperation("test")
    @RequestMapping(value = "/test", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProsubPicketageSupplierVO> test() {

        subPicketageBpmService.afterApprovalProcessor(538375801402298439L,0,"11");
        return  null;
    }


}
