package com.ejianc.business.tender.prosub.service.impl;

import com.ejianc.business.tender.prosub.bean.ProsubTalkRecordEntity;
import com.ejianc.business.tender.prosub.mapper.ProsubTalkRecordMapper;
import com.ejianc.business.tender.prosub.service.IProsubDocumentService;
import com.ejianc.business.tender.prosub.service.IProsubTalkRecordService;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentVO;
import com.ejianc.business.tender.prosub.vo.ProsubTalkRecordVO;
import com.ejianc.business.tender.sub.bean.SubTalkRecordEntity;
import com.ejianc.business.tender.sub.mapper.SubTalkRecordMapper;
import com.ejianc.business.tender.sub.vo.SubDocumentVO;
import com.ejianc.business.tender.sub.vo.SubTalkRecordVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 洽商谈判记录主表
 * 
 * @author generator
 * 
 */
@Service("prosubTalkRecordService")
public class ProsubTalkRecordServiceImpl extends BaseServiceImpl<ProsubTalkRecordMapper, ProsubTalkRecordEntity> implements IProsubTalkRecordService {
    @Autowired
    private IProsubDocumentService subDocumentService;
    @Override
    public ProsubTalkRecordVO queryDetail(Long id) {
        ProsubTalkRecordEntity subTalkRecordEntity = super.selectById(id);
        ProsubTalkRecordVO subTalkRecordVO = BeanMapper.map(subTalkRecordEntity, ProsubTalkRecordVO.class);

        //确认轮数
        Integer talkNum = subTalkRecordVO.getTalkNum();
        ProsubDocumentVO subDocumentVO = subDocumentService.queryDocDetail(subTalkRecordVO.getBillId(), talkNum);
        subTalkRecordVO.setSubDocumentDetailSellList(subDocumentVO.getSubDocumentDetailSellList());
        subTalkRecordVO.setSubDocumentSupplierSchemeList(subDocumentVO.getSubDocumentSupplierSchemeList());

        return subTalkRecordVO;
    }
}
