package com.ejianc.business.tender.rent.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.common.vo.SupplyFileVo;
import com.ejianc.business.tender.rent.vo.RentNoticeSupplierDetailTbVO;
import com.ejianc.business.tender.rent.vo.RentNoticeSupplierVO;
import com.ejianc.business.tender.rent.vo.RentNoticeVO;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rent.bean.*;
import com.ejianc.business.tender.rent.service.*;
import com.ejianc.business.tender.rent.bean.RentNoticeEntity;
import com.ejianc.business.tender.rent.bean.RentNoticeSupplierEntity;
import com.ejianc.business.tender.util.ThirdSystemUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 招标公告主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("rentNotice")
@Api(value = "招标公告主表", tags = {"招标公告主表"})
public class RentNoticeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;

    @Value("${gysUrl.updateSupStatusUrl}")
    private String updateSupStatusUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;


    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "invite-notice-code";;//此处需要根据实际修改

    @Autowired
    private IRentNoticeService service;

    @Autowired
    private IRentInviteService inviteService;

    @Autowired
    private IRentInviteDetailService inviteDetailService;

    @Autowired
    private IRentInviteDetailRecordService inviteDetailRecordService;

    @Autowired
    private IRentNoticeDetailService noticeDetailService;

    @Autowired
    private IProcessService processSerice;

    @Autowired
    private IRentNoticeSupplierDetailService noticeSupplierDetailService;

    @Autowired
    private IRentInviteSupplierService inviteSupplierService;

    @Autowired
    private IRentNoticeSupplierService noticeSupplierService;

    @Autowired
    private IRentNoticeChangeService changeService;

    @Autowired
    private CacheManager cacheManager;

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IShareSupplierApi shareSupplierApi;

    @Autowired
    private ISystemDataPushService systemDataPushService;

    private static final String BILL_SUPPLIER_TYPE = "BT211215000000005";
    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Autowired
    private IAttachmentApi attachmentApi;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RentNoticeVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody RentNoticeVO saveorUpdateVO) {
    	RentNoticeEntity entity = BeanMapper.map(saveorUpdateVO, RentNoticeEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	RentNoticeVO vo = BeanMapper.map(entity, RentNoticeVO.class);

        //保存招标过程记录表
//        ProcessEntity processEntity = new ProcessEntity();
//        processEntity.setBillId(entity.getId());
//        processEntity.setBillName(entity.getNoticeName());
//        processEntity.setTenderId(entity.getId());
//        processEntity.setType(3);
//        processEntity.setFrontendUrl("rent/invite/card");
//        processSerice.saveOrUpdate(processEntity);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentNoticeVO> queryDetail(@RequestParam Long id) {
    	RentNoticeEntity entity = service.selectById(id);
    	RentNoticeVO vo = BeanMapper.map(entity, RentNoticeVO.class);
        //处理供应商附件信息
        if (!service.selectFile(vo)){
            CommonResponse.success("供应商附件查询失败！");
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentNoticeVO> vos) {
        service.removeByIds(vos.stream().map(RentNoticeVO::getId).collect(Collectors.toList()),true);
        processSerice.remove(new LambdaQueryWrapper<ProcessEntity>().in(ProcessEntity::getBillId,vos.stream().map(RentNoticeVO::getId).collect(Collectors.toList())));
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RentNoticeVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<RentNoticeEntity> page = service.queryPage(param,false);
        IPage<RentNoticeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentNoticeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @ApiOperation("获取当前登录人手机号")
    @RequestMapping(value = "/queryPhone", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryPhone() {
        String mobilePhone = employeeApi.getById(sessionManager.getUserContext().getEmployeeId()).getData().getMobilePhone();
        return CommonResponse.success("查询列表数据成功！",mobilePhone);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<RentNoticeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("RentNotice-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refRentNoticeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RentNoticeVO>> refRentNoticeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<RentNoticeEntity> page = service.queryPage(param,false);
        IPage<RentNoticeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentNoticeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @ApiOperation("点击下一步进行下个页面数据初始化")
    @RequestMapping(value = "/nextStep", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentNoticeEntity> nextStep(String id) throws InvocationTargetException, IllegalAccessException {
        //主表赋值
        RentInviteEntity rentInviteEntity = inviteService.selectById(id);
        RentNoticeEntity rentNoticeEntity = new RentNoticeEntity();
        BeanUtils.copyProperties(rentNoticeEntity, rentInviteEntity);
        rentNoticeEntity.setNoticeName(rentInviteEntity.getTenderName());
        rentNoticeEntity.setInviteId(rentInviteEntity.getId());
        rentNoticeEntity.setId(null);
        rentNoticeEntity.setCreateTime(null);
        rentNoticeEntity.setUpdateTime(null);
        rentNoticeEntity.setBillCode(null);
        rentNoticeEntity.setBillState(null);
        rentNoticeEntity.setCreateUserCode(null);
        rentNoticeEntity.setUpdateUserCode(null);
        rentNoticeEntity.setSyncEsFlag(null);
        rentNoticeEntity.setVersion(null);
        rentNoticeEntity.setTenantId(null);
        rentNoticeEntity.setMemo(null);
        rentNoticeEntity.setEmployeeId(null);
        rentNoticeEntity.setEmployeeName(null);
        service.saveOrUpdate(rentNoticeEntity);
        //子表赋值
        List<RentInviteDetailEntity> rentInviteDetailList = inviteDetailService.list(new LambdaQueryWrapper<RentInviteDetailEntity>().eq(RentInviteDetailEntity::getInviteId,id).eq(RentInviteDetailEntity::getDr,0));
        RentNoticeDetailEntity rentNoticeDetailEntity = new RentNoticeDetailEntity();
        if (CollectionUtil.isNotEmpty(rentInviteDetailList)){
            for (RentInviteDetailEntity rentInviteDetailEntity : rentInviteDetailList) {
                BeanUtils.copyProperties(rentNoticeDetailEntity, rentInviteDetailEntity);
                rentNoticeDetailEntity.setNoticeId(rentNoticeEntity.getId());
                rentNoticeDetailEntity.setId(null);
                rentNoticeDetailEntity.setCreateTime(null);
                rentNoticeDetailEntity.setUpdateTime(null);
                rentNoticeDetailEntity.setCreateUserCode(null);
                rentNoticeDetailEntity.setUpdateUserCode(null);
                rentNoticeDetailEntity.setSyncEsFlag(null);
                rentNoticeDetailEntity.setVersion(null);
                rentNoticeDetailEntity.setTenantId(null);
                noticeDetailService.saveOrUpdate(rentNoticeDetailEntity);
            }
        }
        //供应商
        List<RentInviteSupplierEntity> rentInviteSupplierList = inviteSupplierService.list(new LambdaQueryWrapper<RentInviteSupplierEntity>().eq(RentInviteSupplierEntity::getInviteId, id).eq(RentInviteSupplierEntity::getDr, 0));
        RentNoticeSupplierDetailEntity rentNoticeSupplierDetailEntity = new RentNoticeSupplierDetailEntity();
        if (CollectionUtil.isNotEmpty(rentInviteSupplierList)){
            for (RentInviteSupplierEntity rentInviteSupplierEntity : rentInviteSupplierList) {
                BeanUtils.copyProperties(rentNoticeSupplierDetailEntity, rentInviteSupplierEntity);
                rentNoticeSupplierDetailEntity.setInviteId(rentNoticeEntity.getInviteId());
                rentNoticeSupplierDetailEntity.setId(null);
                rentNoticeSupplierDetailEntity.setCreateTime(null);
                rentNoticeSupplierDetailEntity.setUpdateTime(null);
                rentNoticeSupplierDetailEntity.setCreateUserCode(null);
                rentNoticeSupplierDetailEntity.setUpdateUserCode(null);
                rentNoticeSupplierDetailEntity.setSyncEsFlag(null);
                rentNoticeSupplierDetailEntity.setVersion(null);
                rentNoticeSupplierDetailEntity.setTenantId(null);
                noticeSupplierDetailService.saveOrUpdate(rentNoticeSupplierDetailEntity);
            }
        }
        //回写招标阶段
        Integer tenderStage = 2;
        inviteService.updateTenderStage(id,tenderStage);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(rentNoticeEntity.getId());
        processEntity.setBillName("招标公告");
        processEntity.setTenderId(rentNoticeEntity.getInviteId());
        processEntity.setType(3);
        processEntity.setFrontendUrl("rent/notice");
        processSerice.saveOrUpdate(processEntity);
        return CommonResponse.success("初始化数据成功", rentNoticeEntity);
    }
    @ApiOperation("延长截止时间")
    @RequestMapping(value = "/extend", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse extend(@RequestBody RentNoticeChangeEntity rentNoticeChangeEntity) {
        service.updateEndTime(rentNoticeChangeEntity.getNoticeId(), rentNoticeChangeEntity.getNewTime());
        RentNoticeEntity rentNoticeEntity = service.selectById(rentNoticeChangeEntity.getNoticeId());
        //调用第三方报名接口
        Map<String, Object> map = new HashMap<>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("sourceId", rentNoticeEntity.getInviteId());
        map.put("noticeEndTime",sdf.format(rentNoticeChangeEntity.getNewTime()));
        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(updateTimeUrl, RequestMethod.POST, JSON.toJSONString(map), appId,appSecret,appHost);
            if (!response.isSuccess()){
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }
        changeService.saveOrUpdate(rentNoticeChangeEntity);
        return CommonResponse.success("延长截止时间成功！");
    }

    @ApiOperation("发布公告")
    @RequestMapping(value = "/publish", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse publish(@RequestBody RentNoticeVO rentNoticeVO) throws InvocationTargetException, IllegalAccessException {
        return service.publish(rentNoticeVO);
    }
    @ApiOperation("报名情况")
    @RequestMapping(value = "/signUp", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> signUp(HttpServletRequest request) {
        logger.info("进入报名接口request-{},file-{}", request);
        String notice = request.getParameter("bmNoticeVO");
        logger.info("报名实体信息-{}",notice);
        RentNoticeSupplierVO rentNoticeSupplierVO = JSON.parseObject(notice, new TypeReference<RentNoticeSupplierVO>() { });

        RentNoticeSupplierEntity rentNoticeSupplierEntity = BeanMapper.map(rentNoticeSupplierVO, RentNoticeSupplierEntity.class);
        rentNoticeSupplierEntity.setNoticeId(service.selectNotice(rentNoticeSupplierVO.getSourceId()));
        rentNoticeSupplierEntity.setSourceSupplierTenantId(rentNoticeSupplierVO.getTenantId().toString());
        rentNoticeSupplierEntity.setSupplierId(Long.valueOf(rentNoticeSupplierVO.getSourceSupplierId()));
        SupplierDTO supplierVO = shareSupplierApi.queryById(Long.valueOf(rentNoticeSupplierVO.getSourceSupplierId())).getData();
        rentNoticeSupplierEntity.setSupplierName(supplierVO.getName());
        rentNoticeSupplierEntity.setSupplierEmployeeId(rentNoticeSupplierVO.getEmployeeId());
        rentNoticeSupplierEntity.setSupplierEmployeeName(rentNoticeSupplierVO.getEmployeeName());
        rentNoticeSupplierEntity.setSupplierEmployeeMobile(rentNoticeSupplierVO.getEmployeeMobile());
        rentNoticeSupplierEntity.setId(null);
        rentNoticeSupplierEntity.setState(0);
        //查询是否已经报名
        LambdaQueryWrapper<RentNoticeEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(RentNoticeEntity::getInviteId, rentNoticeSupplierVO.getSourceId());
        List<RentNoticeEntity> noticeEntityList = service.list(queryWrapper);
        LambdaQueryWrapper<RentNoticeSupplierEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(RentNoticeSupplierEntity::getSourceSupplierId, rentNoticeSupplierVO.getSourceSupplierId())
                .eq(RentNoticeSupplierEntity::getNoticeId, noticeEntityList.get(0).getId())
                .eq(RentNoticeSupplierEntity::getDr, 0);
        List<RentNoticeSupplierEntity> supplierEntityList = noticeSupplierService.list(lambdaQueryWrapper);
        if (CollectionUtil.isNotEmpty(supplierEntityList)) {
            noticeSupplierService.removeById(supplierEntityList.get(0).getId());
        }
        boolean b = noticeSupplierService.saveOrUpdate(rentNoticeSupplierEntity);
        //处理附件
        List<SupplyFileVo> pzList = rentNoticeSupplierVO.getSupplyFileList();
        logger.info("报名文件:{}", JSONObject.toJSONString(pzList));
        if(CollectionUtils.isNotEmpty(pzList)){
            List<AttachmentVO> list = new ArrayList<>();
            pzList.forEach(e->{
                AttachmentVO attachmentVO = new AttachmentVO();
                attachmentVO.setBillType(BILL_SUPPLIER_TYPE);
                attachmentVO.setSourceId(rentNoticeSupplierEntity.getId());
                attachmentVO.setSourceType("BmSupplierFileType");
                attachmentVO.setFilePath(e.getFilePath());
                attachmentVO.setOnlinePath(e.getFilePath());
                attachmentVO.setFileName(e.getFileName());
                attachmentVO.setId(e.getFileId());
                list.add(attachmentVO);
                logger.info("保存文件信息:{}", JSONObject.toJSONString(attachmentVO));
            });
            CommonResponse<String> stringCommonResponse = attachmentApi.insertBatch(list);
            logger.info(request+"报名文件上传结果-{}",JSONObject.toJSONString(stringCommonResponse));
        }
        //删除之前附件
//        CommonResponse<List<AttachmentVO>> fileResp = attachmentApi
//                .queryListBySourceId(rentNoticeSupplierEntity.getId(), BILL_SUPPLIER_TYPE, "BmSupplierFileType", null);
//        // 查询成功并有相应的文件
//        if (fileResp.isSuccess() && CollectionUtils.isNotEmpty(fileResp.getData())) {
//            logger.info("删除文件信息：{}", JSONObject.toJSONString(fileResp.getData()));
//            String ids = fileResp.getData().stream().map(AttachmentVO::getId).map(String::valueOf)
//                    .collect(Collectors.joining(","));
//            attachmentApi.delete(ids);
//        }
////        logger.info(request + "报名文件名称- {}" + file.getOriginalFilename());
////        Boolean upFlag = new ThirdSystemUtils().upFile(BASE_HOST,"BmSupplierFileType",Long.toString(rentNoticeSupplierEntity.getId()),BILL_SUPPLIER_TYPE,file,request);
////        logger.info(request+"报名文件上传结果-{}",upFlag);
//        String authority = request.getHeader("authority");
//        String nameSourceTypeMapping = request.getParameter("fileSourceType");
//        Map mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);
//        FileUtil.getInstance()
//                .handleReqFile((MultipartHttpServletRequest) request, mp, BILL_SUPPLIER_TYPE, authority, Long.toString(rentNoticeSupplierEntity.getId()));

        return CommonResponse.success("报名情况接口掉用成功",b);
    }

    @ApiOperation("剔除供应商")
    @RequestMapping(value = "/deleteSupplier", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse deleteSupplier(@RequestBody RentNoticeSupplierVO rentNoticeSupplierVO) {
        List<RentNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<>();
        RentNoticeEntity rentNoticeEntity = service.selectById(rentNoticeSupplierVO.getNoticeId());
        RentNoticeSupplierDetailTbVO rentNoticeSupplierDetailTbVO = new RentNoticeSupplierDetailTbVO();
        rentNoticeSupplierDetailTbVO.setSourceId(rentNoticeEntity.getInviteId().toString());
        rentNoticeSupplierDetailTbVO.setTenantId(rentNoticeSupplierVO.getTenantId());
        rentNoticeSupplierDetailTbVO.setSourceSupplierId(rentNoticeSupplierVO.getSupplierId().toString());
        rentNoticeSupplierDetailTbVO.setOutReason(rentNoticeSupplierVO.getOutReason()==null?"超时未报名":rentNoticeSupplierVO.getOutReason());
        supplierDetailTbVOList.add(rentNoticeSupplierDetailTbVO);

        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(updateSupStatusUrl, RequestMethod.POST, JSON.toJSONString(supplierDetailTbVOList), appId,appSecret,appHost);
            if (!response.isSuccess()){
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }
        //更新供应商状态
        noticeSupplierService.updateState(rentNoticeSupplierVO.getId());
        return CommonResponse.success("剔除供应商成功");
    }

}
