package com.ejianc.business.tender.rent.controller;

import com.ejianc.business.tender.rent.vo.RentWinnoticeVO;
import com.ejianc.business.tender.rent.bean.RentWinnoticeEntity;
import com.ejianc.business.tender.rent.service.IRentWinnoticeService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;

/**
 * 中标公告表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("rentWinnotice")
@Api(value = "中标公告表", tags = {"中标公告表"})
public class RentWinnoticeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IRentWinnoticeService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "rent-winnotice-code";

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RentWinnoticeVO> saveOrUpdates(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody RentWinnoticeVO saveorUpdateVO) {
    	RentWinnoticeEntity entity = BeanMapper.map(saveorUpdateVO, RentWinnoticeEntity.class);
        if(entity.getBillCode() == null){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        RentWinnoticeVO vo = service.saveOrUpdates(entity);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @ApiOperation("发布接口")
    @RequestMapping(value = "/publishWinnotice", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentWinnoticeVO> publishWinnotice(@RequestParam Long id) throws Exception {
        return CommonResponse.success("发布成功！",service.publishWinnotice(id));
    }
    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentWinnoticeVO> queryDetail(@RequestParam Long id) {
        RentWinnoticeVO rentWinnoticeVO = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",rentWinnoticeVO);
    }
    @ApiOperation("生成中公告接口")
    @RequestMapping(value = "/saveWinnotice", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentWinnoticeVO> saveWinnotice(@RequestParam Long picketageId) {
        RentWinnoticeVO rentWinnoticeVO = service.saveWinnotice(picketageId);
        return CommonResponse.success("保存或修改单据成功！",rentWinnoticeVO);
    }

}
