package com.ejianc.business.tender.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.rent.vo.*;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rent.bean.*;
import com.ejianc.business.tender.rent.mapper.RentBidMapper;
import com.ejianc.business.tender.rent.service.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 中标主表
 * 
 * @author generator
 * 
 */
@Service("rentBidService")
public class RentBidServiceImpl extends BaseServiceImpl<RentBidMapper, RentBidEntity> implements IRentBidService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRentPicketageService rentPicketageService;
    @Autowired
    private IRentNoticeService rentNoticeService;
    @Autowired
    private IRentWinnoticeService rentWinnoticeService;
    @Autowired
    private IRentDocumentService rentDocumentService;
    @Autowired
    private IRentInviteService rentInviteService;
    @Autowired
    private IRentBidDetailService rentBidDetailService;
    @Autowired
    private IRentDocumentSellService rentDocumentSellService;
    @Autowired
    private IRentBidSupplierService rentBidSupplierService;
    @Autowired
    private IRentDocumentSupplierService rentDocumentSupplierService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IRentPicketageSupplierService rentPicketageSupplierService;
    @Autowired
    private IOrgApi iOrgApi;
    @Value("${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;

    @Value("${gysUrl.winbidSavesUrl}")
    private String winbidSavesUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    private org.slf4j.Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CacheManager cacheManager;
    private static final String BILL_CODE = "invite-bid-code";//此处需要根据实际修改
    @Override
    public RentBidVO saveBid(Long picketageId) {
        RentBidEntity entity = new RentBidEntity();
        entity.setPicketageId(picketageId);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        RentPicketageEntity rentPicketageEntity = rentPicketageService.selectById(picketageId);
        RentInviteEntity inviteEntity = rentInviteService.selectById(rentPicketageEntity.getInviteId());
        entity.setInviteId(rentPicketageEntity.getInviteId());
        entity.setBidName(inviteEntity.getTenderName());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        super.saveOrUpdate(entity, false);
        RentBidVO vo = BeanMapper.map(entity, RentBidVO.class);

        //回写定标数据
//        rentPicketageEntity.setBidStatus(1);
        rentPicketageEntity.setBidId(entity.getId());
        rentPicketageService.updateById(rentPicketageEntity);

        //处理供应商信息
        //获取材料明细报价
        LambdaQueryWrapper<RentDocumentSellEntity> lambdaSell = Wrappers.<RentDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(RentDocumentSellEntity::getDocumentId, rentPicketageEntity.getDocumentId());
        lambdaSell.eq(RentDocumentSellEntity::getTenderFlag, 1);
        List<RentDocumentSellEntity> sellList = rentDocumentSellService.list(lambdaSell);
        List<RentDocumentSellVO> rentDocumentSellVOS = BeanMapper.mapList(sellList, RentDocumentSellVO.class);
        Map<Long, List<RentDocumentSellVO>> sellMap = rentDocumentSellVOS.stream().
                collect(Collectors.groupingBy(RentDocumentSellVO::getSupplierId));

        //查看供应商信息
        LambdaQueryWrapper<RentDocumentSupplierEntity> lambdaSupplier = Wrappers.<RentDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(RentDocumentSupplierEntity::getDocumentId, rentPicketageEntity.getDocumentId());
        lambdaSupplier.eq(RentDocumentSupplierEntity::getTalkNum, 0);
        List<RentDocumentSupplierEntity> supplierList = rentDocumentSupplierService.list(lambdaSupplier);
        Map<Long, RentDocumentSupplierEntity> supplierEntityMap = supplierList.stream().collect(Collectors.toMap(RentDocumentSupplierEntity::getSupplierId, Function.identity()));

        //遍历map,组合数据返回
        ArrayList<RentBidSupplierVO> supplierVOList = new ArrayList<>();
        List<RentBidDetailEntity> rentBidDetailEntityList = new ArrayList<>();
        sellMap.forEach((key,value) -> {
            RentBidSupplierVO rentBidSupplierVO = new RentBidSupplierVO();
            rentBidSupplierVO.setSupplierId(key);
            rentBidSupplierVO.setSupplierName(value.stream().findFirst().get().getSupplierName());
            RentDocumentSupplierEntity rentDocumentSupplierEntity = supplierEntityMap.get(key);
            rentBidSupplierVO.setLinkName(rentDocumentSupplierEntity.getLinkName());
            rentBidSupplierVO.setSupplierMobile(rentDocumentSupplierEntity.getLinkMobile());
            rentBidSupplierVO.setId(IdWorker.getId());

            //汇总中标金额
            BigDecimal tenderMoneyTax = BigDecimal.ZERO;
            BigDecimal tenderMoney = BigDecimal.ZERO;

            for (RentDocumentSellVO rentDocumentSellVO : value) {
                //汇总金额
                tenderMoneyTax = tenderMoneyTax
                        .add(rentDocumentSellVO.getTenderMoneyTax() == null ? BigDecimal.ZERO : rentDocumentSellVO
                                .getTenderMoneyTax());
                tenderMoney = tenderMoney
                        .add(rentDocumentSellVO.getTenderMoney() == null ? BigDecimal.ZERO : rentDocumentSellVO
                                .getTenderMoney());
                RentBidDetailEntity rentBidDetailEntity = BeanMapper.map(rentDocumentSellVO, RentBidDetailEntity.class);
                rentBidDetailEntity.setMoney(rentDocumentSellVO.getTenderMoney());
                rentBidDetailEntity.setMoneyTax(rentDocumentSellVO.getTenderMoneyTax());
                rentBidDetailEntity.setId(null);
                rentBidDetailEntity.setBidSupplierId(rentBidSupplierVO.getId());
                rentBidDetailEntity.setBidId(entity.getId());
                rentBidDetailEntityList.add(rentBidDetailEntity);

            }
            rentBidSupplierVO.setMoneyTax(tenderMoneyTax);
            rentBidSupplierVO.setMoney(tenderMoney);
            rentBidSupplierVO.setBidId(entity.getId());
            supplierVOList.add(rentBidSupplierVO);
        });

        //新增供应商
        List<RentBidSupplierEntity> rentBidSupplierEntities = BeanMapper.mapList(supplierVOList, RentBidSupplierEntity.class);
        rentBidSupplierService.saveBatch(rentBidSupplierEntities);
        rentBidDetailService.saveBatch(rentBidDetailEntityList);

        //回写中标供应商和数量
        String tenderUnitNum = new String();
        //查询中标供应商
        List<RentBidDetailEntity> bidDetailEntityList = baseMapper.selectBidSupplier(entity.getId());
        for (RentBidDetailEntity rentBidDetailEntity : bidDetailEntityList) {
            RentBidSupplierEntity supplierEntity = rentBidSupplierService.selectById(rentBidDetailEntity.getBidSupplierId());
            BigDecimal sumNum = rentBidDetailEntity.getTenderNum().setScale(4,BigDecimal.ROUND_HALF_UP);
            String name = supplierEntity.getSupplierName()+"("+sumNum+"),";
            tenderUnitNum += name;
        }
        if (tenderUnitNum.length() > 1) {
            tenderUnitNum = tenderUnitNum.substring(0,tenderUnitNum.length() -1);
        }
        inviteEntity.setTenderUnitNum(tenderUnitNum);
        rentInviteService.saveOrUpdate(inviteEntity);

        RentBidVO rentBidVO = BeanMapper.map(entity, RentBidVO.class);
        return rentBidVO;
    }

    @Override
    public RentBidVO queryDetail(Long bidId) {
        RentBidEntity rentBidEntity = super.selectById(bidId);
        RentBidVO rentBidVO = BeanMapper.map(rentBidEntity, RentBidVO.class);
        //组合数据
        List<RentBidDetailVO> rentBidDetailList  = rentBidVO.getRentBidDetailList();
        Map<Long, List<RentBidDetailVO>> detailMap = rentBidDetailList.stream().
                collect(Collectors.groupingBy(RentBidDetailVO::getBidSupplierId));
        List<RentBidSupplierVO> rentBidSupplierList = rentBidVO.getRentBidSupplierList();
        for (RentBidSupplierVO rentBidSupplierVO : rentBidSupplierList){
            rentBidSupplierVO.setRentBidDetailList(detailMap.get(rentBidSupplierVO.getId()));
        }
        rentBidVO.setRentBidSupplierList(rentBidSupplierList);
        return rentBidVO;
//
    }
    @Transactional
    @Override
    public RentBidVO publishBid(RentBidVO saveorUpdateVO) {
        RentBidEntity entity = super.selectById(saveorUpdateVO.getId());
        entity.setBidContent(saveorUpdateVO.getBidContent());
        entity.setBidName(saveorUpdateVO.getBidName());
        entity.setPublishFlag(0);
        entity.setBillState(1);
        RentBidVO vo = BeanMapper.map(entity, RentBidVO.class);


        //获取中标信息
        RentInviteEntity rentInviteEntity = rentInviteService.selectById(entity.getInviteId());
        RentWinbidVO winbidVO = new RentWinbidVO();
        winbidVO.setSourceId(Long.toString(entity.getInviteId()));
        winbidVO.setBillCode(rentInviteEntity.getBillCode());
        if (winbidVO.getPurchaseType()==null || winbidVO.getPurchaseType()==1){
            winbidVO.setSourceProjectId(null);
        }else {
            winbidVO.setSourceProjectId(Long.toString(rentInviteEntity.getProjectId()));
        }
        winbidVO.setProjectName(rentInviteEntity.getProjectName());
        winbidVO.setProjectCode(rentInviteEntity.getProjectCode());
        winbidVO.setSourceOrgId(Long.toString(rentInviteEntity.getOrgId()));
        winbidVO.setOrgName(rentInviteEntity.getOrgName());
        winbidVO.setUnitName(rentInviteEntity.getUnitName());
        winbidVO.setSourceUnitId(Long.toString(rentInviteEntity.getUnitId()));
        winbidVO.setType("RENT");
        winbidVO.setTenderName(rentInviteEntity.getTenderName());
        winbidVO.setTenderType(rentInviteEntity.getTenderType());
        winbidVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());

        LambdaQueryWrapper<RentDocumentEntity> lambdaDoc = Wrappers.<RentDocumentEntity>lambdaQuery();
        lambdaDoc.eq(RentDocumentEntity::getInviteId, entity.getInviteId());
        RentDocumentEntity rentDocumentEntity = rentDocumentService.getOne(lambdaDoc);
        winbidVO.setNoticeBidTime(rentDocumentEntity.getBidTime());
        winbidVO.setNoticeWinbidTime(new Date());

        if (rentInviteEntity.getTenderType()==2 || rentInviteEntity.getTenderType()==3 ||rentInviteEntity.getTenderType()==4 ||rentInviteEntity.getTenderType()==5){
            winbidVO.setSourceEmployeeId(Long.toString(rentDocumentEntity.getEmployeeId()));
            winbidVO.setEmployeeName(rentDocumentEntity.getEmployeeName());
            winbidVO.setEmployeeMobile(rentDocumentEntity.getEmployeeMobile());
            winbidVO.setPurchaseType(rentDocumentEntity.getPurchaseType());
        }else {
            //查询招标公告
            LambdaQueryWrapper<RentNoticeEntity> lambdaNotice = Wrappers.<RentNoticeEntity>lambdaQuery();
            lambdaNotice.eq(RentNoticeEntity::getInviteId, entity.getInviteId());
            RentNoticeEntity noticeEntity = rentNoticeService.getOne(lambdaNotice);
            winbidVO.setSourceEmployeeId(Long.toString(noticeEntity.getEmployeeId()));
            winbidVO.setEmployeeName(noticeEntity.getEmployeeName());
            winbidVO.setEmployeeMobile(noticeEntity.getEmployeeMobile());
            winbidVO.setPurchaseType(noticeEntity.getPurchaseType());
        }

        //处理供应商信息
        RentBidVO rentBidVO = queryDetail(entity.getId());
        List<RentBidSupplierVO> rentBidSupplierList = rentBidVO.getRentBidSupplierList();
        //转换数据,推送供应商中标信息
        List<RentWinbidVO> winbidVOList = new ArrayList<>();
        for (RentBidSupplierVO rentBidSupplierVO : rentBidSupplierList){
            RentWinbidVO winbidVONew = BeanMapper.map(winbidVO,RentWinbidVO.class);
            SupplierDTO supplierVO = shareSupplierApi.queryById(rentBidSupplierVO.getSupplierId()).getData();
            winbidVONew.setTenantId(supplierVO.getTenant());
            winbidVONew.setWinbidMoneyTax(rentBidSupplierVO.getMoneyTax());
            winbidVONew.setWinbidMoney(rentBidSupplierVO.getMoney());
            winbidVONew.setContent(rentBidVO.getBidContent());
            winbidVONew.setWinbidType(0);

            List<RentBidDetailVO> rentBidDetailList = rentBidSupplierVO.getRentBidDetailList();
            Map<String,List<RentBidDetailVO>> map = new HashMap<>();
            for (RentBidDetailVO rentBidDetailVO : rentBidDetailList){
                String s = null;
                if (rentBidDetailVO.getMaterialId() == null){
                     s = rentBidDetailVO.getMaterialTypeId().toString()+
                             rentBidDetailVO.getRate() +
                             rentBidDetailVO.getSchemeId() +
                             rentBidDetailVO.getPlanEnterDate() +
                             rentBidDetailVO.getPlanLeaveDate();
                }
                if (rentBidDetailVO.getMaterialId() != null){
                     s = rentBidDetailVO.getMaterialId().toString() +
                             rentBidDetailVO.getMaterialTypeId().toString() +
                             rentBidDetailVO.getRate() +
                             rentBidDetailVO.getSchemeId() +
                             rentBidDetailVO.getPlanEnterDate() +
                             rentBidDetailVO.getPlanLeaveDate();
                }
                if (map.containsKey(s)){
                    List<RentBidDetailVO> rentBidDetailVOS = map.get(s);
                    rentBidDetailVOS.add(rentBidDetailVO);
                    map.put(s,rentBidDetailVOS);
                }else {
                    List<RentBidDetailVO> rentBidDetailVOList = new ArrayList<>();
                    rentBidDetailVOList.add(rentBidDetailVO);
                    map.put(s,rentBidDetailVOList);
                }
            }
            //处理中标详情数据
            List<RentWinbidDetailVO> winbidDetailVOList = new ArrayList<>();
            map.forEach((key,value) ->{
                BigDecimal tenderNum = BigDecimal.ZERO;
                BigDecimal money = BigDecimal.ZERO;
                BigDecimal moneyTax = BigDecimal.ZERO;
                BigDecimal tax = BigDecimal.ZERO;
                for (RentBidDetailVO rentBidDetailVOLast : value){
                    tenderNum = tenderNum.add((rentBidDetailVOLast.getTenderNum() == null) ? BigDecimal.ZERO : rentBidDetailVOLast.getTenderNum());
                    money = money.add((rentBidDetailVOLast.getMoney() == null) ? BigDecimal.ZERO : rentBidDetailVOLast.getMoney());
                    moneyTax = moneyTax.add((rentBidDetailVOLast.getMoneyTax() == null) ? BigDecimal.ZERO : rentBidDetailVOLast.getMoneyTax());
                    tax = tax.add((rentBidDetailVOLast.getSellTax() == null) ? BigDecimal.ZERO : rentBidDetailVOLast.getSellTax());
                }
                RentBidDetailVO first = value.stream().findFirst().get();
                RentWinbidDetailVO winbidDetailVO = new RentWinbidDetailVO();
                winbidDetailVO.setSourceId(Long.toString(entity.getInviteId()));
                winbidDetailVO.setSourceMaterialId(Long.toString(first.getMaterialId()));
                winbidDetailVO.setMaterialName(first.getMaterialName());
                winbidDetailVO.setMaterialCode(first.getMaterialCode());
                winbidDetailVO.setSourceMaterialTypeId(Long.toString(first.getMaterialTypeId()));
                winbidDetailVO.setMaterialTypeName(first.getMaterialTypeName());
                winbidDetailVO.setUnit(first.getUnit());
                winbidDetailVO.setSpec(first.getSpec());
                winbidDetailVO.setBrand(first.getMaterialBrand());
                winbidDetailVO.setSupplierBrand(first.getBrand());
                winbidDetailVO.setPrice(first.getPrice());
                winbidDetailVO.setPriceTax(first.getPriceTax());
                winbidDetailVO.setMoney(money);
                winbidDetailVO.setMoneyTax(moneyTax);
                winbidDetailVO.setTax(tax);
                winbidDetailVO.setCalculateType(first.getCalculateType());
                winbidDetailVO.setMemo(first.getMaterialMemo());
                winbidDetailVO.setSupplierMemo(first.getMemo());
                winbidDetailVO.setMoney(money);
                winbidDetailVO.setRate(first.getRate());
                winbidDetailVO.setTenderNum(tenderNum);
                winbidDetailVO.setNum(first.getNum());
                winbidDetailVOList.add(winbidDetailVO);
            });
            winbidVONew.setRentWinbidDetailList(winbidDetailVOList);
            winbidVOList.add(winbidVONew);
        }
        String stringFb = JSONObject.toJSONString(winbidVOList);
        logger.info("推送供方中标信息:" +stringFb);
        //调用供方接口
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(winbidSavesUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("中标同步接口报错" + stringCommonResponse.getMsg());
        }

        return queryDetail(vo.getId());
    }

    @Override
    public RentBidVO queryDbDetail(Long picketage) {

        return null;
    }

    @Override
    public RentBidVO nextPaper(Long winnoticeId) {
        RentBidEntity entity = new RentBidEntity();
        RentWinnoticeEntity rentWinnoticeEntity = rentWinnoticeService.selectById(winnoticeId);
        RentInviteEntity rentInviteEntity = rentInviteService.selectById(rentWinnoticeEntity.getInviteId());
        entity.setInviteId(rentWinnoticeEntity.getInviteId());
        entity.setBidName(rentInviteEntity.getTenderName());
        entity.setPurchaseType(rentInviteEntity.getPurchaseType());
        entity.setWinnoticeId(winnoticeId);
        super.saveOrUpdate(entity, false);

        //回写中标公告状态
        rentWinnoticeEntity.setNextFlag(1);
        rentWinnoticeService.updateById(rentWinnoticeEntity);

        //回写招标阶段
        rentInviteEntity.setTenderStage(TenderStageEnum.BID_NOTICE_STATE.getTenderTypeCode());
        rentInviteService.updateById(rentInviteEntity);

        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getDescription());
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(3);
        processEntity.setFrontendUrl("rent/winLetter");
        processService.saveOrUpdate(processEntity);

        RentBidVO rentBidVO = BeanMapper.map(entity, RentBidVO.class);
        return rentBidVO;
    }

    @Override
    public List<RentPicketageSupplierVO> querySupplierList(Long picketageId) {
        RentBidEntity rentBidEntity = super.selectById(picketageId);

        RentWinnoticeEntity rentWinnoticeEntity = rentWinnoticeService.selectById(rentBidEntity.getWinnoticeId());
        LambdaQueryWrapper<RentPicketageSupplierEntity> lambdaSupplierList = Wrappers.lambdaQuery();
        lambdaSupplierList.eq(RentPicketageSupplierEntity::getPicketageId,rentWinnoticeEntity.getPicketageId());
        List<RentPicketageSupplierEntity> listSupplier = rentPicketageSupplierService.list(lambdaSupplierList);
        List<RentPicketageSupplierVO> rentPicketageSupplierVOS = BeanMapper.mapList(listSupplier, RentPicketageSupplierVO.class);

        return rentPicketageSupplierVOS;
    }
    @Transactional
    @Override
    public RentPicketageVO insertProcess(Long picketageId) {

        RentPicketageEntity rentPicketageEntity = rentPicketageService.selectById(picketageId);
        RentInviteEntity rentInviteEntity = rentInviteService.selectById(rentPicketageEntity.getInviteId());
        //回写招标阶段
        rentInviteEntity.setTenderStage(TenderStageEnum.BID_NOTICE_STATE.getTenderTypeCode());
        rentInviteService.updateById(rentInviteEntity);

        //回写定标数据
        rentPicketageEntity.setBidStatus(1);
        rentPicketageService.updateById(rentPicketageEntity);

        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(rentPicketageEntity.getBidId());
        processEntity.setBillName(TenderStageEnum.BID_NOTICE_STATE.getDescription());
        processEntity.setTenderId(rentInviteEntity.getId());
        processEntity.setType(3);
        processEntity.setFrontendUrl("rent/winLetter");
        processService.saveOrUpdate(processEntity);
        RentPicketageVO rentPicketageVO = BeanMapper.map(rentPicketageEntity, RentPicketageVO.class);
        return rentPicketageVO;
    }

    @Override
    public List<RentPicketageSupplierVO> querySupplierDetail(Long id) {
        RentBidEntity rentBidEntity = super.selectById(id);
        return rentPicketageService.querySupplierList(rentBidEntity.getPicketageId());
    }
}
