package com.ejianc.business.tender.rent.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.rent.api.IRentPlanApi;
import com.ejianc.business.rent.vo.RentPlanEnum;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.rent.vo.RentBidVO;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rent.bean.*;
import com.ejianc.business.tender.rent.service.*;
import com.ejianc.business.tender.stuff.bean.StuffDocumentSellEntity;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("rentPicketage")
public class RentPicketageBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private IRentPicketageService rentPicketageService;
	@Autowired
	private IRentBidService rentBidService;
	@Autowired
	private IRentWinnoticeService rentWinnoticeService;
	@Autowired
	private IRentInviteService rentInviteService;
	@Autowired
	private IRentBidDetailService rentBidDetailService;
	@Autowired
	private IRentDocumentSellService rentDocumentSellService;
	@Autowired
	private IRentBidSupplierService rentBidSupplierService;
	@Autowired
	private IRentDocumentSupplierService rentDocumentSupplierService;
	@Autowired
	private IProcessService processService;
	@Autowired
	private IShareSupplierApi shareSupplierApi;
	@Autowired
	private IRentAdviceService rentAdviceService;
	@Autowired
	private IRentPicketageRefsupplierService rentPicketageRefsupplierService;
	@Autowired
	private IRentPicketageSupplierService rentPicketageSupplierService;
	@Autowired
	private IRentInviteDetailRecordService rentInviteDetailRecordService;
	@Autowired
	private IRentPlanApi batPlanApi;

	@Value("${gysUrl.updateTimeUrl}")
	private String updateTimeUrl;

	@Value("${gysUrl.winbidSavesUrl}")
	private String winbidSavesUrl;
	private static final String BILL_CODE = "invite-bid-code";//此处需要根据实际修改
	@Autowired
	private IProjectPoolApi projectPoolApi;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		RentBidVO rentBidVO = rentBidService.saveBid(billId);
		rentBidService.publishBid(rentBidVO);

		//处理参照表,只处理项目线的数据
		//查询出所有定标的数据

		RentPicketageEntity rentPicketageEntity = rentPicketageService.selectById(billId);
		RentInviteEntity rentInviteEntity = rentInviteService.selectById(rentPicketageEntity.getInviteId());

		// 完成采购计划
		if (rentInviteEntity.getEstablishType()==1){
			// 获取采购计划ID
			if (CollectionUtils.isNotEmpty(rentInviteEntity.getRentDetailRecord())) {
				// 释放采购计划
				rentInviteService.updateApiState(rentInviteEntity, RentPlanEnum.PLAN_STATE_OVER.getPlanState(), RentPlanEnum.PLAN_STATE_OVER.getPlanState());
			}
		}

//		if (rentInviteEntity.getPurchaseType().equals(0)) {
		LambdaQueryWrapper<RentDocumentSellEntity> sellWrapper = Wrappers.lambdaQuery();
		sellWrapper.eq(RentDocumentSellEntity::getDocumentId, rentPicketageEntity.getDocumentId());
		sellWrapper.eq(RentDocumentSellEntity::getTenderFlag, 1);
		List<RentDocumentSellEntity> rentDocumentSellList = rentDocumentSellService.list(sellWrapper);
		//项目招标
		//改造-0905
		Map<Long, ProjectPoolSetVO> proMap = new HashMap<>();
		//if (rentInviteEntity.getPurchaseType().equals(0)){
			List<Long> projectPks = rentDocumentSellList.stream().map(RentDocumentSellEntity::getProjectId).collect(Collectors.toList());
			CommonResponse<JSONArray> jsonArrayCommonResponse = projectPoolApi.queryProjectByIds(projectPks);

			if (jsonArrayCommonResponse.isSuccess()){
				JSONArray data = jsonArrayCommonResponse.getData();
				List<ProjectPoolSetVO> projectRegisterVOS = data.toJavaList(ProjectPoolSetVO.class);
				proMap = projectRegisterVOS.stream().collect(Collectors.toMap(ProjectPoolSetVO::getId, Function.identity()));
			}
		//}
		Map<String, List<RentDocumentSellEntity>> dataMap = new HashMap<>();
		for (RentDocumentSellEntity rentDocumentSellEntity : rentDocumentSellList) {
			//改造-0905
			//if (rentInviteEntity.getPurchaseType().equals(0)){
				ProjectPoolSetVO projectPoolSetVO = proMap.get(rentDocumentSellEntity.getProjectId());
				if (projectPoolSetVO != null){
					rentDocumentSellEntity.setOrgId(projectPoolSetVO.getProjectDepartmentId());
					rentDocumentSellEntity.setOrgName(projectPoolSetVO.getProjectDepartmentName());
				}
			//}
			String s = null;
			//if (rentInviteEntity.getPurchaseType().equals(0)){
				s = rentDocumentSellEntity.getProjectId().toString() + rentDocumentSellEntity.getSupplierId()
						.toString();
//			}
//			if (rentInviteEntity.getPurchaseType().equals(1)){
//				s = rentDocumentSellEntity.getSupplierId()
//						.toString();
//			}
			if (dataMap.containsKey(s)) {
				List<RentDocumentSellEntity> rentDocumentSellEntityList = dataMap.get(s);
				rentDocumentSellEntityList.add(rentDocumentSellEntity);
				dataMap.put(s,rentDocumentSellEntityList);
			}else {
				List<RentDocumentSellEntity> rentDocumentSellEntities = new ArrayList<>();
				rentDocumentSellEntities.add(rentDocumentSellEntity);
				dataMap.put(s,rentDocumentSellEntities);
			}
		}
		List<RentPicketageRefsupplierEntity> rentPicketageRefsupplierEntities = new ArrayList<>();
		dataMap.forEach((key,value) -> {
			RentPicketageRefsupplierEntity rentPicketageRefsupplierEntity = new RentPicketageRefsupplierEntity();
			RentDocumentSellEntity rentSellEntity = value.stream().findFirst().get();
			rentPicketageRefsupplierEntity.setSupplierId(rentSellEntity.getSupplierId());
			rentPicketageRefsupplierEntity.setSupplierName(rentSellEntity.getSupplierName());
			rentPicketageRefsupplierEntity.setProjectId(rentSellEntity.getProjectId());
			rentPicketageRefsupplierEntity.setProjectName(rentSellEntity.getProjectName());
			rentPicketageRefsupplierEntity.setProjectCode(rentInviteEntity.getProjectCode());
			rentPicketageRefsupplierEntity.setPicketageId(billId);
			rentPicketageRefsupplierEntity.setOccupyFlag(0);
			SupplierDTO supplierVO = shareSupplierApi.queryById(rentSellEntity.getSupplierId()).getData();
			rentPicketageRefsupplierEntity.setSupplierTenantId(supplierVO.getTenant());
			rentPicketageRefsupplierEntity.setPicketageName(rentPicketageEntity.getPicketageName());
			rentPicketageRefsupplierEntity.setPicketageDate(new Date());
			//改造-0905
			//if (rentInviteEntity.getPurchaseType().equals(0)){
				rentPicketageRefsupplierEntity.setOrgId(rentSellEntity.getOrgId());
				rentPicketageRefsupplierEntity.setOrgName(rentSellEntity.getOrgName());
//			}
//			if (rentInviteEntity.getPurchaseType().equals(1)){
//				rentPicketageRefsupplierEntity.setOrgId(rentInviteEntity.getOrgId());
//				rentPicketageRefsupplierEntity.setOrgName(rentInviteEntity.getOrgName());
//			}

			rentPicketageRefsupplierEntity.setParentOrgId(rentInviteEntity.getParentOrgId());
			rentPicketageRefsupplierEntity.setParentOrgName(rentInviteEntity.getParentOrgName());
			rentPicketageRefsupplierEntity.setPicketageFlag(0);
			rentPicketageRefsupplierEntity.setRentType(rentInviteEntity.getRentType());
			rentPicketageRefsupplierEntity.setSignStatus(TenderSignStatusEnum.未签订.getCode());
			rentPicketageRefsupplierEntity.setPurchaseType(rentInviteEntity.getPurchaseType());
			BigDecimal tenderMoney = BigDecimal.ZERO;
			BigDecimal tenderMoneyTax = BigDecimal.ZERO;
			for (RentDocumentSellEntity rentDocumentSellEntity : value){
				tenderMoney = tenderMoney.add(rentDocumentSellEntity.getTenderMoney());
				tenderMoneyTax = tenderMoneyTax.add(rentDocumentSellEntity.getTenderMoneyTax());
			}
			rentPicketageRefsupplierEntity.setMoney(tenderMoney.setScale(2, BigDecimal.ROUND_HALF_UP));
			rentPicketageRefsupplierEntity.setMoneyTax(tenderMoneyTax.setScale(2, BigDecimal.ROUND_HALF_UP));
			rentPicketageRefsupplierEntities.add(rentPicketageRefsupplierEntity);
		});
		rentPicketageRefsupplierService.saveBatch(rentPicketageRefsupplierEntities);


//		}
//生成中标通知书类表数据
		List<RentPicketageSupplierEntity> picketageSupplierList = rentPicketageEntity.getPicketageSupplierList();
		List<RentAdviceEntity> rentAdviceList = BeanMapper.mapList(picketageSupplierList, RentAdviceEntity.class);
		for (RentAdviceEntity rentAdviceEntity : rentAdviceList){
			rentAdviceEntity.setTitleName(rentInviteEntity.getTenderName());
			rentAdviceEntity.setUnitId(rentInviteEntity.getUnitId());
			rentAdviceEntity.setUnitName(rentInviteEntity.getUnitName());
			rentAdviceEntity.setProjectId(rentInviteEntity.getProjectId());
			rentAdviceEntity.setProjectName(rentInviteEntity.getProjectName());
			rentAdviceEntity.setOrgId(rentInviteEntity.getOrgId());
			rentAdviceEntity.setOrgName(rentInviteEntity.getOrgName());
			rentAdviceEntity.setParentOrgId(rentInviteEntity.getParentOrgId());
			rentAdviceEntity.setParentOrgName(rentInviteEntity.getParentOrgName());
			rentAdviceEntity.setParentOrgName(rentInviteEntity.getParentOrgName());
			rentAdviceEntity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode(rentInviteEntity.getTenderType()).getDescription());
			rentAdviceEntity.setLineTypeName(CommonUtils.getTypeName(3));
			rentAdviceEntity.setPurchaseType(rentInviteEntity.getPurchaseType());
			rentAdviceEntity.setScFlag(1);
			rentAdviceEntity.setSendFlag(1);
			rentAdviceEntity.setSignFlag(0);
			rentAdviceEntity.setId(null);
			rentAdviceEntity.setInviteId(rentInviteEntity.getId());
		}
		rentAdviceService.saveBatch(rentAdviceList);

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("该功能不支持！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}
	/**
	 * 审批--获取当前节点的审批人---从服务中选择
	 *
	 * @param billId 单据id
	 * @param billTypeCode 单据类型编码
	 * @param sign 节点标志
	 * @return
	 */
	@Override
	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other){
		JSONArray arr = new JSONArray();
		logger.info("sign:{}",sign);

		//根据标识判断是否（成本相关人员审批的）节点
		if ("choseCostUser".equals(sign)){
			//获取表单详情数据

			//根据项目id获取项目基本信息中的成本对接人信息
			RentPicketageEntity entity = rentPicketageService.selectById(billId);
			Long projectId = entity.getProjectId();

			JSONObject jsonObject = new JSONObject();
			CommonResponse<JSONArray> commonResponse = projectPoolApi.queryProjectPoolById(projectId);


			if(!commonResponse.isSuccess()){
				throw new BusinessException("查询项目失败!");
			}
			JSONArray array = commonResponse.getData();
			List<ProjectPoolSetVO> vos = JSONObject.parseArray(array.toJSONString(), ProjectPoolSetVO.class);

			logger.info("vos:{}",JSONObject.toJSONString(vos));

			ProjectPoolSetVO vo = vos.get(0);
			Long costAdapter = vo.getCostAdapter();
			String costAdapterName = vo.getCostAdapterName();

			logger.info("userId:{}",costAdapter);
			logger.info("userName:{}",costAdapterName);


			jsonObject.put("userId",costAdapter);
			jsonObject.put("userName",costAdapterName);

			arr.add(jsonObject);

		}
		return CommonResponse.success(arr);
	}

}
