package com.ejianc.business.tender.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.common.vo.TenderPicketageDetailVO;
import com.ejianc.business.tender.common.vo.TenderPicketageVO;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.rent.bean.RentPicketageRefsupplierEntity;
import com.ejianc.business.tender.rent.mapper.RentPicketageRefsupplierMapper;
import com.ejianc.business.tender.rent.service.*;
import com.ejianc.business.tender.rent.bean.*;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 定标供应商参照表(下游单据使用)
 * 
 * @author generator
 * 
 */
@Service("rentPicketageRefsupplierService")
public class RentPicketageRefsupplierServiceImpl extends BaseServiceImpl<RentPicketageRefsupplierMapper, RentPicketageRefsupplierEntity> implements IRentPicketageRefsupplierService {
    @Autowired
    private IRentInviteService rentInviteService;
    @Autowired
    private IRentPicketageService rentPicketageService;
    @Autowired
    private IRentDocumentSellService rentDocumentSellService;
    @Autowired
    private IRentInviteDetailBidderService rentInviteDetailBidderService;
    @Autowired
    private IRentInviteDetailService rentInviteDetailService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Transactional
    @Override
    public String updateById(Long id,Integer occupyFlag) {
//        占用状态0-未占用,1-已占用,2-已完成
        RentPicketageRefsupplierEntity rentPicketageRefsupplierEntity = super.selectById(id);
        rentPicketageRefsupplierEntity.setOccupyFlag(occupyFlag);
        super.updateById(rentPicketageRefsupplierEntity);
        return "更新成功!";
    }
    @Override
    @Transactional
    public String updateStatus(TenderPicketageVO tenderPicketageVO, Integer type) {
        logger.info("修改类型"+type);
        String stringFb = JSONObject.toJSONString(tenderPicketageVO);
        logger.info("设备租赁定标占用参数"+stringFb);
        RentPicketageRefsupplierEntity rentPicketageRefsupplierEntity = super.selectById(tenderPicketageVO.getId());
        //picketageFlag 定标类型0-流程定标,1-直接定标0

        Integer picketageFlag = rentPicketageRefsupplierEntity.getPicketageFlag();
        if (type == 1){
            tenderPicketageVO.setContractMoney(tenderPicketageVO.getContractMoney().negate());
            tenderPicketageVO.setContractMoneyTax(tenderPicketageVO.getContractMoneyTax().negate());
            List<TenderPicketageDetailVO> detailList = tenderPicketageVO.getTenderPicketageDetailList();
            for (TenderPicketageDetailVO tenderPicketageDetailVO : detailList){
                tenderPicketageDetailVO.setSignNum(tenderPicketageDetailVO.getSignNum().negate());
            }
        }
        RentPicketageEntity rentPicketageEntity = rentPicketageService.selectById(rentPicketageRefsupplierEntity.getPicketageId());
        RentInviteEntity rentInviteEntity = null;
        if(picketageFlag == 0){
            rentInviteEntity = rentInviteService.selectById(rentPicketageEntity.getInviteId());
        }
        if(picketageFlag == 1){
            rentInviteEntity = rentInviteService.selectById(rentPicketageRefsupplierEntity.getPicketageId());
        }

        //根据子表id更新签订数量
//        List<TenderPicketageDetailVO> tenderPicketageDetailList = tenderPicketageVO.getTenderPicketageDetailList();
//        List<Long> sellIds = tenderPicketageDetailList.stream().map(TenderPicketageDetailVO::getId).collect(Collectors.toList());
//        Map<Long, TenderPicketageDetailVO> detailVOMap = tenderPicketageDetailList.stream().collect(Collectors.toMap(TenderPicketageDetailVO::getId, Function.identity()));
//        Boolean allSign = null;
//        Boolean anySign = null;

        //更新参照表状态
        BigDecimal contractMoney = rentPicketageRefsupplierEntity.getContractMoney() == null ? BigDecimal.ZERO : rentPicketageRefsupplierEntity.getContractMoney();
        BigDecimal contractMoneyTax = rentPicketageRefsupplierEntity.getContractMoneyTax() == null ? BigDecimal.ZERO : rentPicketageRefsupplierEntity.getContractMoneyTax();
        rentPicketageRefsupplierEntity.setContractMoney(contractMoney.add(tenderPicketageVO.getContractMoney()));
        rentPicketageRefsupplierEntity.setContractMoneyTax(contractMoneyTax.add(tenderPicketageVO.getContractMoneyTax()));
        if (rentPicketageRefsupplierEntity.getContractMoneyTax().compareTo(rentPicketageRefsupplierEntity.getMoneyTax())  > -1){
            rentPicketageRefsupplierEntity.setSignStatus(TenderSignStatusEnum.全部已签.getCode());
        }
        if (rentPicketageRefsupplierEntity.getContractMoneyTax().compareTo(rentPicketageRefsupplierEntity.getMoneyTax()) == -1){
            rentPicketageRefsupplierEntity.setSignStatus(TenderSignStatusEnum.部分签订.getCode());
        }
        if (rentPicketageRefsupplierEntity.getContractMoneyTax().compareTo(BigDecimal.ZERO) == 0){
            rentPicketageRefsupplierEntity.setSignStatus(TenderSignStatusEnum.未签订.getCode());
        }
        super.updateById(rentPicketageRefsupplierEntity);

        //更新招标状态
        LambdaQueryWrapper<RentPicketageRefsupplierEntity> lambdaRef = Wrappers.<RentPicketageRefsupplierEntity>lambdaQuery();
        lambdaRef.eq(RentPicketageRefsupplierEntity::getPicketageId, rentPicketageRefsupplierEntity.getPicketageId());
        List<RentPicketageRefsupplierEntity> picketageRefsupplierList = super.list(lambdaRef);
        //签订状态:0-未签订,1-部分签订,2-全部已签,3-已关闭
        Boolean inviteWSign = picketageRefsupplierList.stream().allMatch(e -> e.getSignStatus() == TenderSignStatusEnum.未签订.getCode());
        Boolean inviteAllSign = picketageRefsupplierList.stream().allMatch(e -> e.getSignStatus() == TenderSignStatusEnum.全部已签.getCode());
        Boolean inviteAllCloseSign = picketageRefsupplierList.stream().allMatch(e -> e.getSignStatus() == TenderSignStatusEnum.已关闭.getCode());
        Integer signStatus = null;
        if (inviteWSign) {
            signStatus = TenderSignStatusEnum.未签订.getCode();
        }
        if (inviteAllSign) {
            signStatus = TenderSignStatusEnum.全部已签.getCode();
        }
        if (inviteAllCloseSign) {
            signStatus = TenderSignStatusEnum.已关闭.getCode();
        }
        if (!inviteWSign && !inviteAllSign && !inviteAllCloseSign) {
            signStatus = TenderSignStatusEnum.部分签订.getCode();
        }

        rentInviteEntity.setSignStatus(signStatus);
        //更新参照表状态
        rentInviteService.updateById(rentInviteEntity);

        return "更新成功";
    }
}
