package com.ejianc.business.tender.rmat.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.common.vo.SupplyFileVo;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rmat.vo.RmatNoticeSupplierDetailTbVO;
import com.ejianc.business.tender.rmat.vo.RmatNoticeSupplierVO;
import com.ejianc.business.tender.rmat.vo.RmatNoticeVO;
import com.ejianc.business.tender.rmat.bean.*;
import com.ejianc.business.tender.rmat.service.*;
import com.ejianc.business.tender.rmat.bean.RmatNoticeEntity;
import com.ejianc.business.tender.rmat.bean.RmatNoticeSupplierEntity;
import com.ejianc.business.tender.util.ThirdSystemUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 招标公告主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("rmatNotice")
@Api(value = "招标公告主表", tags = {"招标公告主表"})
public class RmatNoticeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;

    @Value("${gysUrl.updateSupStatusUrl}")
    private String updateSupStatusUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;


    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "invite-notice-code";;//此处需要根据实际修改

    @Autowired
    private IRmatNoticeService service;

    @Autowired
    private IRmatInviteService inviteService;

    @Autowired
    private IRmatInviteDetailService inviteDetailService;

    @Autowired
    private IRmatInviteDetailRecordService inviteDetailRecordService;

    @Autowired
    private IRmatNoticeDetailService noticeDetailService;

    @Autowired
    private IProcessService processSerice;

    @Autowired
    private IRmatNoticeSupplierDetailService noticeSupplierDetailService;

    @Autowired
    private IRmatInviteSupplierService inviteSupplierService;

    @Autowired
    private IRmatNoticeSupplierService noticeSupplierService;

    @Autowired
    private IRmatNoticeChangeService changeService;

    @Autowired
    private CacheManager cacheManager;

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IShareSupplierApi shareSupplierApi;

    @Autowired
    private ISystemDataPushService systemDataPushService;

    private static final String BILL_SUPPLIER_TYPE = "BT211215000000005";
    @Value("${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private IAttachmentApi attachmentApi;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RmatNoticeVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody RmatNoticeVO saveorUpdateVO) {
    	RmatNoticeEntity entity = BeanMapper.map(saveorUpdateVO, RmatNoticeEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	RmatNoticeVO vo = BeanMapper.map(entity, RmatNoticeVO.class);

        //保存招标过程记录表
//        ProcessEntity processEntity = new ProcessEntity();
//        processEntity.setBillId(entity.getId());
//        processEntity.setBillName(entity.getNoticeName());
//        processEntity.setTenderId(entity.getId());
//        processEntity.setType(4);
//        processEntity.setFrontendUrl("rmat/invite/card");
//        processSerice.saveOrUpdate(processEntity);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RmatNoticeVO> queryDetail(@RequestParam Long id) {
    	RmatNoticeEntity entity = service.selectById(id);
    	RmatNoticeVO vo = BeanMapper.map(entity, RmatNoticeVO.class);
        //处理供应商附件信息
        if (!service.selectFile(vo)){
            CommonResponse.success("供应商附件查询失败！");
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RmatNoticeVO> vos) {
        service.removeByIds(vos.stream().map(RmatNoticeVO::getId).collect(Collectors.toList()),true);
        processSerice.remove(new LambdaQueryWrapper<ProcessEntity>().in(ProcessEntity::getBillId,vos.stream().map(RmatNoticeVO::getId).collect(Collectors.toList())));
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RmatNoticeVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<RmatNoticeEntity> page = service.queryPage(param,false);
        IPage<RmatNoticeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), RmatNoticeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @ApiOperation("获取当前登录人手机号")
    @RequestMapping(value = "/queryPhone", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryPhone() {
        String mobilePhone = employeeApi.getById(sessionManager.getUserContext().getEmployeeId()).getData().getMobilePhone();
        return CommonResponse.success("查询列表数据成功！",mobilePhone);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<RmatNoticeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("RmatNotice-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refRmatNoticeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RmatNoticeVO>> refRmatNoticeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<RmatNoticeEntity> page = service.queryPage(param,false);
        IPage<RmatNoticeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RmatNoticeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @ApiOperation("点击下一步进行下个页面数据初始化")
    @RequestMapping(value = "/nextStep", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RmatNoticeEntity> nextStep(String id) throws InvocationTargetException, IllegalAccessException {
        //主表赋值
        RmatInviteEntity rmatInviteEntity = inviteService.selectById(id);
        RmatNoticeEntity rmatNoticeEntity = new RmatNoticeEntity();
        BeanUtils.copyProperties(rmatNoticeEntity, rmatInviteEntity);
        rmatNoticeEntity.setNoticeName(rmatInviteEntity.getTenderName());
        rmatNoticeEntity.setInviteId(rmatInviteEntity.getId());
        rmatNoticeEntity.setId(null);
        rmatNoticeEntity.setCreateTime(null);
        rmatNoticeEntity.setUpdateTime(null);
        rmatNoticeEntity.setBillCode(null);
        rmatNoticeEntity.setBillState(null);
        rmatNoticeEntity.setCreateUserCode(null);
        rmatNoticeEntity.setUpdateUserCode(null);
        rmatNoticeEntity.setSyncEsFlag(null);
        rmatNoticeEntity.setVersion(null);
        rmatNoticeEntity.setTenantId(null);
        rmatNoticeEntity.setMemo(null);
        rmatNoticeEntity.setEmployeeId(null);
        rmatNoticeEntity.setEmployeeName(null);
        service.saveOrUpdate(rmatNoticeEntity);
        //子表赋值
        List<RmatInviteDetailEntity> rmatInviteDetailList = inviteDetailService.list(new LambdaQueryWrapper<RmatInviteDetailEntity>().eq(RmatInviteDetailEntity::getInviteId,id).eq(RmatInviteDetailEntity::getDr,0));
        RmatNoticeDetailEntity rmatNoticeDetailEntity = new RmatNoticeDetailEntity();
        if (CollectionUtil.isNotEmpty(rmatInviteDetailList)){
            for (RmatInviteDetailEntity rmatInviteDetailEntity : rmatInviteDetailList) {
                BeanUtils.copyProperties(rmatNoticeDetailEntity, rmatInviteDetailEntity);
                rmatNoticeDetailEntity.setNoticeId(rmatNoticeEntity.getId());
                rmatNoticeDetailEntity.setId(null);
                rmatNoticeDetailEntity.setCreateTime(null);
                rmatNoticeDetailEntity.setUpdateTime(null);
                rmatNoticeDetailEntity.setCreateUserCode(null);
                rmatNoticeDetailEntity.setUpdateUserCode(null);
                rmatNoticeDetailEntity.setSyncEsFlag(null);
                rmatNoticeDetailEntity.setVersion(null);
                rmatNoticeDetailEntity.setTenantId(null);
                noticeDetailService.saveOrUpdate(rmatNoticeDetailEntity);
            }
        }
        //供应商
        List<RmatInviteSupplierEntity> rmatInviteSupplierList = inviteSupplierService.list(new LambdaQueryWrapper<RmatInviteSupplierEntity>().eq(RmatInviteSupplierEntity::getInviteId, id).eq(RmatInviteSupplierEntity::getDr, 0));
        RmatNoticeSupplierDetailEntity rmatNoticeSupplierDetailEntity = new RmatNoticeSupplierDetailEntity();
        if (CollectionUtil.isNotEmpty(rmatInviteSupplierList)){
            for (RmatInviteSupplierEntity rmatInviteSupplierEntity : rmatInviteSupplierList) {
                BeanUtils.copyProperties(rmatNoticeSupplierDetailEntity, rmatInviteSupplierEntity);
                rmatNoticeSupplierDetailEntity.setInviteId(rmatNoticeEntity.getInviteId());
                rmatNoticeSupplierDetailEntity.setId(null);
                rmatNoticeSupplierDetailEntity.setCreateTime(null);
                rmatNoticeSupplierDetailEntity.setUpdateTime(null);
                rmatNoticeSupplierDetailEntity.setCreateUserCode(null);
                rmatNoticeSupplierDetailEntity.setUpdateUserCode(null);
                rmatNoticeSupplierDetailEntity.setSyncEsFlag(null);
                rmatNoticeSupplierDetailEntity.setVersion(null);
                rmatNoticeSupplierDetailEntity.setTenantId(null);
                noticeSupplierDetailService.saveOrUpdate(rmatNoticeSupplierDetailEntity);
            }
        }
        //回写招标阶段
        Integer tenderStage = 2;
        inviteService.updateTenderStage(id,tenderStage);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(rmatNoticeEntity.getId());
        processEntity.setBillName("招标公告");
        processEntity.setTenderId(rmatNoticeEntity.getInviteId());
        processEntity.setType(4);
        processEntity.setFrontendUrl("rmat/notice");
        processSerice.saveOrUpdate(processEntity);
        return CommonResponse.success("初始化数据成功", rmatNoticeEntity);
    }
    @ApiOperation("延长截止时间")
    @RequestMapping(value = "/extend", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse extend(@RequestBody RmatNoticeChangeEntity rmatNoticeChangeEntity) {
        service.updateEndTime(rmatNoticeChangeEntity.getNoticeId(), rmatNoticeChangeEntity.getNewTime());
        RmatNoticeEntity rmatNoticeEntity = service.selectById(rmatNoticeChangeEntity.getNoticeId());
        //调用第三方报名接口
        Map<String, Object> map = new HashMap<>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("sourceId", rmatNoticeEntity.getInviteId());
        map.put("noticeEndTime",sdf.format(rmatNoticeChangeEntity.getNewTime()));
        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(updateTimeUrl, RequestMethod.POST, JSON.toJSONString(map), appId,appSecret,appHost);
            if (!response.isSuccess()){
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }
        changeService.saveOrUpdate(rmatNoticeChangeEntity);
        return CommonResponse.success("延长截止时间成功！");
    }

    @ApiOperation("发布公告")
    @RequestMapping(value = "/publish", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse publish(@RequestBody RmatNoticeVO rmatNoticeVO) throws InvocationTargetException, IllegalAccessException {
        return service.publish(rmatNoticeVO);
    }
    @ApiOperation("报名情况")
    @RequestMapping(value = "/signUp", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> signUp(HttpServletRequest request) {
        logger.info("进入报名接口request-{},file-{}", request);
        String notice = request.getParameter("bmNoticeVO");
        logger.info("报名实体信息-{}",notice);
        RmatNoticeSupplierVO rmatNoticeSupplierVO = JSON.parseObject(notice, new TypeReference<RmatNoticeSupplierVO>() { });

        RmatNoticeSupplierEntity rmatNoticeSupplierEntity = BeanMapper.map(rmatNoticeSupplierVO, RmatNoticeSupplierEntity.class);
        rmatNoticeSupplierEntity.setNoticeId(service.selectNotice(rmatNoticeSupplierVO.getSourceId()));
        rmatNoticeSupplierEntity.setSourceSupplierTenantId(rmatNoticeSupplierVO.getTenantId().toString());
        rmatNoticeSupplierEntity.setSupplierId(Long.valueOf(rmatNoticeSupplierVO.getSourceSupplierId()));
        SupplierDTO supplierVO = shareSupplierApi.queryById(Long.valueOf(rmatNoticeSupplierVO.getSourceSupplierId())).getData();
        rmatNoticeSupplierEntity.setSupplierName(supplierVO.getName());
        rmatNoticeSupplierEntity.setSupplierEmployeeId(rmatNoticeSupplierVO.getEmployeeId());
        rmatNoticeSupplierEntity.setSupplierEmployeeName(rmatNoticeSupplierVO.getEmployeeName());
        rmatNoticeSupplierEntity.setSupplierEmployeeMobile(rmatNoticeSupplierVO.getEmployeeMobile());
        rmatNoticeSupplierEntity.setId(null);
        rmatNoticeSupplierEntity.setState(0);
        //查询是否已经报名
        LambdaQueryWrapper<RmatNoticeEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(RmatNoticeEntity::getInviteId, rmatNoticeSupplierVO.getSourceId());
        List<RmatNoticeEntity> noticeEntityList = service.list(queryWrapper);
        LambdaQueryWrapper<RmatNoticeSupplierEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(RmatNoticeSupplierEntity::getSourceSupplierId, rmatNoticeSupplierVO.getSourceSupplierId())
                .eq(RmatNoticeSupplierEntity::getNoticeId, noticeEntityList.get(0).getId())
                .eq(RmatNoticeSupplierEntity::getDr, 0);
        List<RmatNoticeSupplierEntity> supplierEntityList = noticeSupplierService.list(lambdaQueryWrapper);
        if (CollectionUtil.isNotEmpty(supplierEntityList)) {
            noticeSupplierService.removeById(supplierEntityList.get(0).getId());
        }
        boolean b = noticeSupplierService.saveOrUpdate(rmatNoticeSupplierEntity);
        //处理附件
        List<SupplyFileVo> pzList = rmatNoticeSupplierVO.getSupplyFileList();
        logger.info("报名文件:{}", JSONObject.toJSONString(pzList));
        if(CollectionUtils.isNotEmpty(pzList)){
            List<AttachmentVO> list = new ArrayList<>();
            pzList.forEach(e->{
                AttachmentVO attachmentVO = new AttachmentVO();
                attachmentVO.setBillType(BILL_SUPPLIER_TYPE);
                attachmentVO.setSourceId(rmatNoticeSupplierEntity.getId());
                attachmentVO.setSourceType("BmSupplierFileType");
                attachmentVO.setFilePath(e.getFilePath());
                attachmentVO.setOnlinePath(e.getFilePath());
                attachmentVO.setFileName(e.getFileName());
                attachmentVO.setId(e.getFileId());
                list.add(attachmentVO);
                logger.info("保存文件信息:{}", JSONObject.toJSONString(attachmentVO));
            });
            CommonResponse<String> stringCommonResponse = attachmentApi.insertBatch(list);
            logger.info(request+"报名文件上传结果-{}",JSONObject.toJSONString(stringCommonResponse));
        }

//        //删除之前附件
//        CommonResponse<List<AttachmentVO>> fileResp = attachmentApi
//                .queryListBySourceId(rmatNoticeSupplierEntity.getId(), BILL_SUPPLIER_TYPE, "BmSupplierFileType", null);
//        // 查询成功并有相应的文件
//        if (fileResp.isSuccess() && CollectionUtils.isNotEmpty(fileResp.getData())) {
//            logger.info("删除文件信息：{}", JSONObject.toJSONString(fileResp.getData()));
//            String ids = fileResp.getData().stream().map(AttachmentVO::getId).map(String::valueOf)
//                    .collect(Collectors.joining(","));
//            attachmentApi.delete(ids);
//        }
////        logger.info(request + "报名文件名称- {}" + file.getOriginalFilename());
////        Boolean upFlag = new ThirdSystemUtils().upFile(BASE_HOST,"BmSupplierFileType",Long.toString(rmatNoticeSupplierEntity.getId()),BILL_SUPPLIER_TYPE,file,request);
////        logger.info(request+"报名文件上传结果-{}",upFlag);
//        String authority = request.getHeader("authority");
//        String nameSourceTypeMapping = request.getParameter("fileSourceType");
//        Map mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);
//        FileUtil.getInstance()
//                .handleReqFile((MultipartHttpServletRequest) request, mp, BILL_SUPPLIER_TYPE, authority, Long.toString(rmatNoticeSupplierEntity.getId()));

        return CommonResponse.success("报名情况接口掉用成功",b);
    }

    @ApiOperation("剔除供应商")
    @RequestMapping(value = "/deleteSupplier", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse deleteSupplier(@RequestBody RmatNoticeSupplierVO rmatNoticeSupplierVO) {
        List<RmatNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<>();
        RmatNoticeEntity rmatNoticeEntity = service.selectById(rmatNoticeSupplierVO.getNoticeId());
        RmatNoticeSupplierDetailTbVO rmatNoticeSupplierDetailTbVO = new RmatNoticeSupplierDetailTbVO();
        rmatNoticeSupplierDetailTbVO.setSourceId(rmatNoticeEntity.getInviteId().toString());
        rmatNoticeSupplierDetailTbVO.setTenantId(rmatNoticeSupplierVO.getTenantId());
        rmatNoticeSupplierDetailTbVO.setSourceSupplierId(rmatNoticeSupplierVO.getSupplierId().toString());
        rmatNoticeSupplierDetailTbVO.setOutReason(rmatNoticeSupplierVO.getOutReason()==null?"超时未报名":rmatNoticeSupplierVO.getOutReason());
        supplierDetailTbVOList.add(rmatNoticeSupplierDetailTbVO);

        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(updateSupStatusUrl, RequestMethod.POST, JSON.toJSONString(supplierDetailTbVOList), appId,appSecret,appHost);
            if (!response.isSuccess()){
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }
        //更新供应商状态
        noticeSupplierService.updateState(rmatNoticeSupplierVO.getId());
        return CommonResponse.success("剔除供应商成功");
    }

}
