package com.ejianc.business.tender.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentSellVO;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rmat.vo.*;
import com.ejianc.business.tender.rmat.bean.*;
import com.ejianc.business.tender.rmat.mapper.RmatTalkMapper;
import com.ejianc.business.tender.rmat.service.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 洽商谈判主表
 * 
 * @author generator
 * 
 */
@Service("rmatTalkService")
public class RmatTalkServiceImpl extends BaseServiceImpl<RmatTalkMapper, RmatTalkEntity> implements IRmatTalkService {
    @Value("${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;

    @Value("${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value("${gysUrl.updateSupOffer}")
    private String updateSupOffer;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private CacheManager cacheManager;
    private static final String BILL_CODE = "invite-talk-code";
    @Autowired
    private IRmatTalkDetailService rmatTalkDetailService;
    @Autowired
    private IRmatTalkRecordService rmatTalkRecordService;
    @Autowired
    private IRmatTalkRecordDetailService rmatTalkRecordDetailService;
    @Autowired
    private IRmatDocumentSellService rmatDocumentSellService;
    @Autowired
    private IRmatDocumentService rmatDocumentService;
    @Autowired
    private IRmatInviteService rmatInviteService;
    @Autowired
    private IRmatDocumentSupplierService rmatDocumentSupplierService;
    @Autowired
    private IRmatDocumentSchemeService rmatDocumentSchemeService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IProcessService processService;
    private static final String BILL_SUPPLIER_TYPE = "BT202202000005";
    @Autowired
    private IAttachmentApi attachmentApi;

    private org.slf4j.Logger logger = LoggerFactory.getLogger(this.getClass());

    @Transactional
    @Override
    public RmatTalkVO publishTalk(Long id) {
        //更新发布状态
        RmatTalkEntity rmatTalkEntity = super.selectById(id);
        rmatTalkEntity.setPublishFlag(0);
        super.updateById(rmatTalkEntity);

        //推送供应商
        RmatDocumentSupplierTbVO rmatDocumentSupplierTbVO = new RmatDocumentSupplierTbVO();
        rmatDocumentSupplierTbVO.setSourceId(rmatTalkEntity.getInviteId().toString());
        rmatDocumentSupplierTbVO.setSourceType("郑州一建洽商谈判");
        rmatDocumentSupplierTbVO.setNoticeType(4);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatStart = simpleDateFormat.format(rmatTalkEntity.getTalkStartTime());
        rmatDocumentSupplierTbVO.setOfferStartTime(formatStart);
        String formatEnd = simpleDateFormat.format(rmatTalkEntity.getTalkEndTime());
        rmatDocumentSupplierTbVO.setOfferEndTime(formatEnd);
        rmatDocumentSupplierTbVO.setMemo(rmatTalkEntity.getMemo());
        rmatDocumentSupplierTbVO.setTalkMoney(rmatTalkEntity.getTalkMoney());
        rmatDocumentSupplierTbVO.setTalkNum(rmatTalkEntity.getTalkNum());
        rmatDocumentSupplierTbVO.setTenderName(rmatTalkEntity.getTalkName());
        rmatDocumentSupplierTbVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());
        String stringFb = JSONObject.toJSONString(rmatDocumentSupplierTbVO);
        logger.info("洽商谈判发布" + stringFb);
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("洽商谈判同步供方接口报错" + stringCommonResponse.getMsg());
        }

        return queryDetail(id);
    }

    @Override
    public RmatTalkVO extendTalk(RmatTalkDetailVO rmatTalkDetailVO) {
        RmatTalkDetailEntity rmatDocumentRecordEntity = BeanMapper.map(rmatTalkDetailVO, RmatTalkDetailEntity.class);
        rmatTalkDetailService.save(rmatDocumentRecordEntity);
        RmatTalkEntity rmatTalkEntity = super.selectById(rmatTalkDetailVO.getTalkId());
        rmatTalkEntity.setTalkEndTime(rmatTalkDetailVO.getNewTime());
        boolean b = super.updateById(rmatTalkEntity);

        //推送供方
        RmatSupplierSellVO supplierSellVO = new RmatSupplierSellVO();
        supplierSellVO.setSourceId(Long.toString(rmatTalkEntity.getInviteId()));
        supplierSellVO.setOfferEndTime(rmatTalkDetailVO.getNewTime());

        String stringFb = JSONObject.toJSONString(supplierSellVO);

        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(updateTimeUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("洽商谈判同步供方接口报错" + stringCommonResponse.getMsg());
        }

        return queryDetail(rmatTalkDetailVO.getTalkId());
    }

    @Override
    public RmatTalkVO saveTalk(Long documentId) {
        RmatTalkEntity entity = new RmatTalkEntity();
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        RmatDocumentEntity documentEntity = rmatDocumentService.selectById(documentId);
        documentEntity.setNextFlag(0);
        rmatDocumentService.saveOrUpdate(documentEntity);
        //查询招标立项信息
        RmatDocumentEntity rmatDocumentEntity = rmatDocumentService.selectById(documentId);
        RmatInviteEntity rmatInviteEntity = rmatInviteService.selectById(rmatDocumentEntity.getInviteId());
        entity.setProjectCode(rmatDocumentEntity.getProjectCode());
        entity.setInviteId(rmatDocumentEntity.getInviteId());
        entity.setProjectId(rmatDocumentEntity.getProjectId());
        entity.setProjectName(rmatDocumentEntity.getProjectName());
        entity.setOrgId(rmatDocumentEntity.getOrgId());
        entity.setOrgName(rmatDocumentEntity.getOrgName());
        entity.setParentOrgId(rmatDocumentEntity.getParentOrgId());
        entity.setParentOrgName(rmatDocumentEntity.getParentOrgName());
        entity.setBrandFlag(rmatDocumentEntity.getBrandFlag());
        entity.setBillId(documentId);
        entity.setTalkNum(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        String taikNumName = "第" + entity.getTalkNum() + "轮报价";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(rmatDocumentEntity.getPurchaseType());
        entity.setTalkName(rmatInviteEntity.getTenderName());
        super.save(entity);

        //回写招标阶段

        rmatInviteEntity.setTenderStage(7);
        rmatInviteService.updateById(rmatInviteEntity);

        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("洽商谈判");
        processEntity.setTenderId(rmatDocumentEntity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("rmat/talkNegotiate");
        processService.saveOrUpdate(processEntity);

        RmatTalkVO vo = BeanMapper.map(entity, RmatTalkVO.class);

        RmatTalkVO rmatTalkVO = queryDetail(vo.getId());
        return rmatTalkVO;
    }

    @Override
    public RmatTalkVO queryDetail(Long id) {
        RmatTalkEntity rmatTalkEntity = super.selectById(id);
        RmatTalkVO rmatTalkVO = BeanMapper.map(rmatTalkEntity, RmatTalkVO.class);

        //确认轮数
        Integer talkNum = rmatTalkEntity.getTalkNum();
        if (rmatTalkEntity.getPublishFlag() == 1){
            talkNum = talkNum - 1;
        }
        RmatDocumentVO rmatDocumentVO = rmatDocumentService.queryDocDetail(rmatTalkEntity.getBillId(), talkNum);

        //查询供应商报价方案数据


        rmatTalkVO.setRmatDocumentDetailSellList(rmatDocumentVO.getRmatDocumentDetailSellList());
        rmatTalkVO.setRmatDocumentSupplierSchemeList(rmatDocumentVO.getRmatDocumentSupplierSchemeList());

        //查询首轮报价的供应商信息
        LambdaQueryWrapper<RmatDocumentSupplierEntity> lambda = Wrappers.<RmatDocumentSupplierEntity>lambdaQuery();
        lambda.eq(RmatDocumentSupplierEntity::getDocumentId, rmatTalkEntity.getBillId());
        lambda.eq(RmatDocumentSupplierEntity::getTalkNum, 0);
        List<RmatDocumentSupplierEntity> supplierList = rmatDocumentSupplierService.list(lambda);
        List<RmatDocumentSupplierVO> documentSupplierVOList = BeanMapper.mapList(supplierList,RmatDocumentSupplierVO.class);
        rmatTalkVO.setRmatDocumentSupplierList(documentSupplierVOList);

        //查询变更历史记录
        LambdaQueryWrapper<RmatTalkRecordEntity> lambdaRecord = Wrappers.lambdaQuery();
        lambdaRecord.eq(RmatTalkRecordEntity::getBillId,rmatTalkEntity.getBillId());
        lambdaRecord.orderByAsc(RmatTalkRecordEntity::getTalkNum);
        List<RmatTalkRecordEntity> rmatTalkRecordEntityList = rmatTalkRecordService.list(lambdaRecord);
        List<RmatTalkRecordVO> rmatTalkRecordList = BeanMapper.mapList(rmatTalkRecordEntityList, RmatTalkRecordVO.class);
        rmatTalkVO.setTalkRecordEntityList(rmatTalkRecordList);
        return rmatTalkVO;
    }
    @Transactional
    @Override
    public RmatTalkVO againSaveTalk(Long id) {
        RmatTalkEntity entity = new RmatTalkEntity();
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //查询招标立项信息
        RmatTalkEntity rmatTalkEntity = super.selectById(id);
        entity.setProjectCode(rmatTalkEntity.getProjectCode());
        entity.setProjectId(rmatTalkEntity.getProjectId());
        entity.setProjectName(rmatTalkEntity.getProjectName());
        entity.setOrgId(rmatTalkEntity.getOrgId());
        entity.setOrgName(rmatTalkEntity.getOrgName());
        entity.setParentOrgId(rmatTalkEntity.getParentOrgId());
        entity.setParentOrgName(rmatTalkEntity.getParentOrgName());
        entity.setBrandFlag(rmatTalkEntity.getBrandFlag());
        entity.setBillId(rmatTalkEntity.getBillId());
        entity.setInviteId(rmatTalkEntity.getInviteId());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setTalkNum(rmatTalkEntity.getTalkNum() + 1);
        String taikNumName = "第" + entity.getTalkNum() + "轮报价";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(rmatTalkEntity.getPurchaseType());
        super.save(entity);

        //保存历史记录表
        RmatTalkRecordEntity rmatTalkRecordEntity =  BeanMapper.map(rmatTalkEntity, RmatTalkRecordEntity.class);
        rmatTalkRecordEntity.setTalkId(rmatTalkEntity.getId());
        rmatTalkRecordEntity.setId(null);
        rmatTalkRecordService.save(rmatTalkRecordEntity);
        //新增历史记录子表
        List<RmatTalkDetailEntity> rmatTalkDetailList = rmatTalkEntity.getRmatTalkDetailList();
        List<RmatTalkRecordDetailEntity> rmatTalkRecordDetailEntityList = BeanMapper.mapList(rmatTalkDetailList, RmatTalkRecordDetailEntity.class);
        for (RmatTalkRecordDetailEntity rmatTalkRecordDetailEntity : rmatTalkRecordDetailEntityList){
            rmatTalkRecordDetailEntity.setId(null);
            rmatTalkRecordDetailEntity.setRecordId(rmatTalkRecordEntity.getId());
        }
        rmatTalkRecordDetailService.saveBatch(rmatTalkRecordDetailEntityList);

        //删除老数据
        super.removeById(id,false);

        //修改进展表信息
        LambdaQueryWrapper<ProcessEntity> lambdaProcess = Wrappers.<ProcessEntity>lambdaQuery();
        lambdaProcess.eq(ProcessEntity::getBillId,id);
        lambdaProcess.eq(ProcessEntity::getTenderId,rmatTalkEntity.getInviteId());
        ProcessEntity processEntity = processService.getOne(lambdaProcess);
        processEntity.setBillId(entity.getId());
        processService.updateById(processEntity);
        RmatTalkVO vo = BeanMapper.map(entity, RmatTalkVO.class);
        addLastSell(rmatTalkEntity.getTalkNum(),rmatTalkEntity.getBillId());

        return queryDetail(entity.getId());
    }

    @Override
    public RmatTalkVO replenishSell(Long id) {
        RmatTalkEntity rmatTalkEntity = super.selectById(id);

        Integer talkNum = rmatTalkEntity.getTalkNum();
        Long billId = rmatTalkEntity.getBillId();
        addLastSell(talkNum,billId);

        return new RmatTalkVO();
    }

    @Override
    public Boolean getSellFull(Long id) {
        //获取最新轮数
        RmatTalkEntity rmatTalkEntity = super.selectById(id);
        Integer talkNum = rmatTalkEntity.getTalkNum();
        LambdaQueryWrapper<RmatDocumentSupplierEntity> lambdaSupplier = Wrappers.<RmatDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(RmatDocumentSupplierEntity::getDocumentId, rmatTalkEntity.getBillId());
        lambdaSupplier.eq(RmatDocumentSupplierEntity::getTalkNum, talkNum);
        List<RmatDocumentSupplierEntity> supplierList = rmatDocumentSupplierService.list(lambdaSupplier);
        LambdaQueryWrapper<RmatDocumentSupplierEntity> lambdaSupplierFirst = Wrappers.<RmatDocumentSupplierEntity>lambdaQuery();
        lambdaSupplierFirst.eq(RmatDocumentSupplierEntity::getDocumentId, rmatTalkEntity.getBillId());
        lambdaSupplierFirst.eq(RmatDocumentSupplierEntity::getTalkNum, 0);
        List<RmatDocumentSupplierEntity> supplierListFirst = rmatDocumentSupplierService.list(lambdaSupplierFirst);
        if (supplierListFirst == null || supplierListFirst.size() == 0){
            return false;
        }
        if (supplierList.size() != supplierListFirst.size()){
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> querySupplierList(Long talkId) {
        Map<String, Object> stringListMap = new HashMap<>();
        RmatTalkEntity rmatTalkEntity = baseMapper.selectById(talkId);
        List<RmatQuotationMaterialVO> materialVOList = new ArrayList<>();
        //查询所有数据
        List<RmatDocumentSellEntity> rmatDocumentSellEntities = rmatDocumentSellService.selectMaterialType(rmatTalkEntity.getBillId());
        Integer talkNum = rmatDocumentSellEntities.get(0).getTalkNum();
        List<RmatDocumentSellVO> sellEntityList = BeanMapper.mapList(rmatDocumentSellEntities, RmatDocumentSellVO.class);
        //根据项目分组
        Map<Long, List<RmatDocumentSellVO>> collect = sellEntityList.stream().filter(map -> map.getProjectId() != null).collect(Collectors.groupingBy(RmatDocumentSellVO::getProjectId));
        for (List<RmatDocumentSellVO> sellVOS : collect.values()) {
            //根据材料分类
            Map<Long, List<RmatDocumentSellVO>> listMap = sellVOS.stream().filter(map->map.getMaterialId() != null).collect(Collectors.groupingBy(RmatDocumentSellVO::getMaterialId));
            for (Long materialTypeId : listMap.keySet()) {
                RmatQuotationMaterialVO materialVO = new RmatQuotationMaterialVO();
                //获取供应商
                List<RmatDocumentSellVO> materialTypeList = listMap.get(materialTypeId);
                for (RmatDocumentSellVO sellVO : materialTypeList) {
                    materialVO  =  BeanMapper.map(sellVO, RmatQuotationMaterialVO.class);
                }
                List<RmatQuotationSupplierVO> rmatQuotationSupplierVOS = BeanMapper.mapList(materialTypeList, RmatQuotationSupplierVO.class);
                //供应商ID去重
                List<RmatQuotationSupplierVO> supplierVOS = rmatQuotationSupplierVOS.stream()
                        .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(RmatQuotationSupplierVO::getSupplierId))), ArrayList::new));
                materialVO.setSupplierList(supplierVOS);
                //根据供应商分类
                Map<Long, List<RmatDocumentSellVO>> supplierMap = materialTypeList.stream().filter(map->map.getSupplierId() != null).collect(Collectors.groupingBy(RmatDocumentSellVO::getSupplierId));

                for (RmatQuotationSupplierVO supplierVO : materialVO.getSupplierList()) {
                    //获取方案
                    List<RmatDocumentSellVO> rmatDocumentSellVOS = supplierMap.get(supplierVO.getSupplierId());
                    for (RmatDocumentSellVO rmatDocumentSellVO : rmatDocumentSellVOS) {
                        supplierVO.setSupplierName(rmatDocumentSellVO.getSupplierName());
                    }
                    List<RmatQuotationSchemeVO> rmatQuotationSchemeVOS = BeanMapper.mapList(rmatDocumentSellVOS, RmatQuotationSchemeVO.class);
                    //根据方案名称去重
                    List<RmatQuotationSchemeVO> schemeVOS = rmatQuotationSchemeVOS.stream()
                            .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(f -> f.getSchemeName()))), ArrayList::new));
                    supplierVO.setSchemeList(schemeVOS);
                    Map<String, List<RmatDocumentSellVO>> schemeMap = rmatDocumentSellVOS.stream().filter(map->map.getSchemeName() != null).collect(Collectors.groupingBy(RmatDocumentSellVO::getSchemeName));
                    for (RmatQuotationSchemeVO rmatQuotationSchemeVO : supplierVO.getSchemeList()) {
                        List<RmatDocumentSellVO> priceList = schemeMap.get(rmatQuotationSchemeVO.getSchemeName());
                        //如果轮数小于最大轮数，添加一个空的对象
                        if (priceList.size()<talkNum+1){
                            RmatDocumentSellVO documentSellVO = new RmatDocumentSellVO();
                            documentSellVO.setPrice(BigDecimal.valueOf(-1));
                            documentSellVO.setPriceTax(BigDecimal.valueOf(-1));
                            documentSellVO.setMoney(BigDecimal.valueOf(-1));
                            documentSellVO.setMoneyTax(BigDecimal.valueOf(-1));
                            documentSellVO.setTalkNum(talkNum);
                            priceList.add(0,documentSellVO);
                        }
                        rmatQuotationSchemeVO.setPriceList(priceList);
                    }
                }
                materialVOList.add(materialVO);
            }
        }
        stringListMap.put("MaterialTypeList",materialVOList);
        stringListMap.put("offerNum",rmatDocumentSellEntities.get(0).getTalkNum());
        return stringListMap;
    }

    @Override
    public RmatTalkVO saveOrUpdates(RmatTalkVO saveorUpdateVO) {
        RmatTalkEntity entity = BeanMapper.map(saveorUpdateVO, RmatTalkEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        RmatTalkVO vo = BeanMapper.map(entity, RmatTalkVO.class);
        RmatTalkVO rmatTalkVO = queryDetail(vo.getId());
        return rmatTalkVO;
    }

    private void addLastSell(Integer talkNum, Long docId) {
        //补足未报价供应商信息
        //查询上一轮数
        //查询报价信息,判断本轮没有报价的供应商
        LambdaQueryWrapper<RmatDocumentSupplierEntity> lambdaSupplier = Wrappers.<RmatDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(RmatDocumentSupplierEntity::getDocumentId, docId);
        lambdaSupplier.eq(RmatDocumentSupplierEntity::getTalkNum, talkNum);
        List<RmatDocumentSupplierEntity> supplierList = rmatDocumentSupplierService.list(lambdaSupplier);

        //查询
        LambdaQueryWrapper<RmatDocumentSupplierEntity> lambdaSupplierLast = Wrappers.<RmatDocumentSupplierEntity>lambdaQuery();
        lambdaSupplierLast.eq(RmatDocumentSupplierEntity::getDocumentId, docId);
        lambdaSupplierLast.eq(RmatDocumentSupplierEntity::getTalkNum, talkNum - 1);
        List<RmatDocumentSupplierEntity> supplierListLast = rmatDocumentSupplierService.list(lambdaSupplierLast);
        List<Long> supplierPk = supplierList.stream().map(RmatDocumentSupplierEntity::getSupplierId).collect(Collectors.toList());
        List<RmatDocumentSupplierEntity> documentSuppliermatityDataList = supplierListLast.stream().filter(s -> !supplierPk.contains(s.getSupplierId())).collect(Collectors.toList());
        List<RmatDocumentSupplierEntity> documentSuppliermatityNewList = BeanMapper.mapList(documentSuppliermatityDataList, RmatDocumentSupplierEntity.class);
        if (documentSuppliermatityNewList.size() == 0){
            return;
        }

        //推送供应商数据提示信息
        List<SupplierReplenishVO> replenishVOArrayList = new ArrayList<>();
        RmatDocumentEntity rmatDocumentEntity = rmatDocumentService.selectById(docId);
        for (RmatDocumentSupplierEntity rmatDocumentSupplierEntity : documentSuppliermatityNewList){
            SupplierReplenishVO supplierReplenishVO = new SupplierReplenishVO();
            supplierReplenishVO.setSourceId(Long.toString(rmatDocumentEntity.getInviteId()));
            supplierReplenishVO.setTalkNum(talkNum);
            supplierReplenishVO.setTenantId(Long.toString(rmatDocumentSupplierEntity.getSupplierTenantId()));
            replenishVOArrayList.add(supplierReplenishVO);
        }
        String stringFb = JSONObject.toJSONString(replenishVOArrayList);
        logger.info("再次洽商推送供方接口数据:" + stringFb);
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(updateSupOffer, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("再次洽商推送供方接口数据response:" + stringCommonResponse.getMsg());
        }

        List<Long> supplierPkNew = documentSuppliermatityNewList.stream().map(RmatDocumentSupplierEntity::getId).collect(Collectors.toList());

        for (RmatDocumentSupplierEntity rmatDocumentSupplierEntity : documentSuppliermatityNewList){
            rmatDocumentSupplierEntity.setId(IdWorker.getId());
            rmatDocumentSupplierEntity.setTalkNum(talkNum);
        }
        rmatDocumentSupplierService.saveBatch(documentSuppliermatityNewList);

        //查询上一轮未报价供应商的方案
        LambdaQueryWrapper<RmatDocumentSchemeEntity> lambdaScheme = Wrappers.<RmatDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(RmatDocumentSchemeEntity::getDocumentId, docId);
        lambdaScheme.eq(RmatDocumentSchemeEntity::getTalkNum, talkNum - 1);
        lambdaScheme.in(RmatDocumentSchemeEntity::getDocumentSupplierId, supplierPkNew);
        List<RmatDocumentSchemeEntity> schemeList = rmatDocumentSchemeService.list(lambdaScheme);
        List<Long> schemePkList = schemeList.stream().map(RmatDocumentSchemeEntity::getId).collect(Collectors.toList());
        for (RmatDocumentSchemeEntity rmatDocumentSchemeEntity : schemeList){
            rmatDocumentSchemeEntity.setId(IdWorker.getId());
            rmatDocumentSchemeEntity.setTalkNum(talkNum);
            for (RmatDocumentSupplierEntity rmatDocumentSupplierEntity : documentSuppliermatityNewList){
                if (rmatDocumentSchemeEntity.getSupplierId().equals(rmatDocumentSupplierEntity.getSupplierId())){
                    rmatDocumentSchemeEntity.setDocumentSupplierId(rmatDocumentSupplierEntity.getId());
                }
            }
        }
        rmatDocumentSchemeService.saveBatch(schemeList);

        //复制上一轮未报价的供应商的附件信息
        for (RmatDocumentSupplierEntity rmatDocumentSupplierEntity : documentSuppliermatityNewList){
            for (RmatDocumentSupplierEntity rmatDocumentSupplierLastEntity : supplierListLast){
                if (rmatDocumentSupplierEntity.getSupplierId().equals(rmatDocumentSupplierLastEntity.getSupplierId())){
                    CommonResponse<String> responseCopy = attachmentApi.copyFilesFromSourceBillToTargetBill(
                            rmatDocumentSupplierLastEntity.getId().toString(),
                            BILL_SUPPLIER_TYPE,
                            "supplierFileType",
                            rmatDocumentSupplierEntity.getId().toString(),
                            BILL_SUPPLIER_TYPE,
                            "supplierFileType"
                    );
                    if (!responseCopy.isSuccess()) {
                        throw new BusinessException("再次洽商附件复制失败:" + responseCopy.getMsg());
                    }
                }

            }
        }
        //查询上一轮未报价供应商的方案详情
        LambdaQueryWrapper<RmatDocumentSellEntity> lambdaSell = Wrappers.<RmatDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(RmatDocumentSellEntity::getDocumentId, docId);
        lambdaSell.eq(RmatDocumentSellEntity::getTalkNum, talkNum - 1);
        lambdaSell.in(RmatDocumentSellEntity::getSchemeId, schemePkList);
        List<RmatDocumentSellEntity> sellList = rmatDocumentSellService.list(lambdaSell);
        for (RmatDocumentSellEntity rmatDocumentSellEntity : sellList){
            rmatDocumentSellEntity.setId(null);
            rmatDocumentSellEntity.setTalkNum(talkNum);
            for (RmatDocumentSchemeEntity rmatDocumentSchemeEntity : schemeList){
                if (rmatDocumentSellEntity.getSupplierId().equals(rmatDocumentSchemeEntity.getSupplierId()) &&
                        rmatDocumentSellEntity.getSchemeName().equals(rmatDocumentSchemeEntity.getSchemeName())){
                    rmatDocumentSellEntity.setSchemeId(rmatDocumentSchemeEntity.getId());
                }

            }
        }
        rmatDocumentSellService.saveBatch(sellList);
    }
}
