package com.ejianc.business.tender.stuff.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.assist.material.api.IMaterialBatchPlanApi;
import com.ejianc.business.promaterial.contract.api.IPromaterialContractApi;
import com.ejianc.business.promaterial.plan.api.IBatPlanApi;
import com.ejianc.business.promaterial.plan.vo.BatPlanDetailVO;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.business.promaterial.plan.vo.BatPlanVO;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.stuff.bean.*;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.stuff.service.IStuffInviteDetailRecordService;
import com.ejianc.business.tender.stuff.service.IStuffPicketageRefsupplierService;
import com.ejianc.business.tender.stuff.service.IStuffPicketageService;
import com.ejianc.business.tender.stuff.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.JsonMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.tender.stuff.service.IStuffInviteService;

/**
 * 材料立项主表
 *
 * @author generator
 */
@Controller
@RequestMapping("stuffInvite")
public class StuffInviteController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "TENDER_STUFF";//此处需要根据实际修改

    /** 参照查询：项目ID */
    private static final String CONDITION_PROJECT_ID = "projectId";
    /** 参照查询：组织ID */
    private static final String CONDITION_ORG_ID = "orgId";

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private IStuffInviteService service;

    @Autowired
    private IStuffInviteDetailRecordService detailRecordService;

    @Autowired
    private IProcessService processService;

    @Autowired
    private IBatPlanApi batPlanApi;

    @Autowired
    private IStuffPicketageService picketageService;

    @Autowired
    private IStuffPicketageRefsupplierService refsupplierService;

    @Autowired
    private IPromaterialContractApi contractApi;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IMaterialBatchPlanApi materialBatchPlanApi;



    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<StuffInviteVO> saveOrUpdate(@RequestBody StuffInviteVO saveorUpdateVO) {
        //处理子表供应商中标信息
        List<StuffInviteDetailRecordVO> stuffInviteDetailList = saveorUpdateVO.getStuffDetailRecord();
        List<StuffInviteDetailBidderEntity> bidderEntityList = new ArrayList<StuffInviteDetailBidderEntity>();
        if (CollectionUtils.isNotEmpty(stuffInviteDetailList)) {
            for (StuffInviteDetailRecordVO stuffInviteDetailVO : stuffInviteDetailList) {
                if (stuffInviteDetailVO.getId() == null) {
                    long id = IdWorker.getId();
                    stuffInviteDetailVO.setId(id);
                }
                List<StuffInviteDetailBidderVO> bidderList = stuffInviteDetailVO.getStuffDetailBidder();
                if (CollectionUtils.isNotEmpty(bidderList)) {
                    for (StuffInviteDetailBidderVO bidderVO : bidderList) {
                        bidderVO.setInviteDetailId(stuffInviteDetailVO.getId());
                        StuffInviteDetailBidderEntity bidderEntity = BeanMapper.map(bidderVO, StuffInviteDetailBidderEntity.class);
                        bidderEntityList.add(bidderEntity);
                    }
                }
            }
        }

        StuffInviteEntity entity = BeanMapper.map(saveorUpdateVO, StuffInviteEntity.class);
        if (CollectionUtils.isNotEmpty(bidderEntityList)) {
            entity.setStuffDetailBidder(bidderEntityList);
        }
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveorUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<String> oldPlanIdList = detailRecordService.list(new LambdaQueryWrapper<StuffInviteDetailRecordEntity>()
                .eq(StuffInviteDetailRecordEntity::getInviteId, saveorUpdateVO.getId()))
                .stream().map(StuffInviteDetailRecordEntity::getPlanId)
                .map(String::valueOf).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(oldPlanIdList)){
            //if (entity.getPurchaseType() == 0) {
                CommonResponse<String> response = batPlanApi.updateBatPlanQuote(oldPlanIdList, BatPlanEnum.PLAN_STATE_WAIT.getPlanState(),0);
                if (!response.isSuccess()) {
                    throw new BusinessException("修改批次计划状态失败" + response.getMsg());
                }
//            }else {
//                CommonResponse<String> response = materialBatchPlanApi.updateBatPlanQuote(oldPlanIdList, BatPlanEnum.PLAN_STATE_WAIT.getPlanState());
//                if (!response.isSuccess()) {
//                    throw new BusinessException("修改采购申请状态失败" + response.getMsg());
//                }
//            }
            }
        entity.setSignStatus(TenderSignStatusEnum.未签订.getCode());
        entity.setIsPushZcw(0);//默认未推送筑材网
        if (entity.getEstablishType()==0){
            entity.setTenderMoney(entity.getStuffDetailRecord().stream().map(StuffInviteDetailRecordEntity::getMoneyTax).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        service.saveOrUpdate(entity, false);
        StuffInviteVO vo = BeanMapper.map(entity, StuffInviteVO.class);

        //处理供应商子表信息
        List<StuffInviteDetailRecordVO> stuffInviteDetailVOList = vo.getStuffDetailRecord();
        List<StuffInviteDetailBidderVO> stuffInviteDetailBidderVOList = vo.getStuffDetailBidder();
        if (CollectionUtils.isNotEmpty(stuffInviteDetailBidderVOList)) {
            Map<Long, List<StuffInviteDetailBidderVO>> bidderMap = stuffInviteDetailBidderVOList.stream().
                    collect(Collectors.groupingBy(StuffInviteDetailBidderVO::getInviteDetailId));
            if (CollectionUtils.isNotEmpty(stuffInviteDetailVOList)) {
                for (StuffInviteDetailRecordVO stuffInviteDetailVO : stuffInviteDetailVOList) {
                    List<StuffInviteDetailBidderVO> stuffInviteDetailBidderVOS = bidderMap.get(stuffInviteDetailVO.getId());
                    if (CollectionUtils.isNotEmpty(stuffInviteDetailBidderVOS)) {
                        stuffInviteDetailVO.setStuffDetailBidder(stuffInviteDetailBidderVOS);
                    }
                }
            }
        }
        //修改计划状态
        List<String> planIdList = entity.getStuffDetailRecord().stream().map(StuffInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct().collect(Collectors.toList());
//        if (entity.getPurchaseType() == 0 ){
            CommonResponse<String> response = batPlanApi.updateBatPlanQuote(planIdList, BatPlanEnum.PLAN_STATE_EXEC.getPlanState(),0);
            if (!response.isSuccess()) {
                throw new BusinessException("修改批次计划状态失败" + response.getMsg());
            }
//        }else {
//            CommonResponse<String> response = materialBatchPlanApi.updateBatPlanQuote(planIdList, BatPlanEnum.PLAN_STATE_EXEC.getPlanState());
//            if (!response.isSuccess()) {
//                throw new BusinessException("修改采购申请状态失败" + response.getMsg());
//            }
//        }
        if (entity.getEstablishType()==1){
            //修改招标状态
            List<Long> inviteIdList = entity.getStuffDetailRecord().stream().map(StuffInviteDetailRecordEntity::getPlanId).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(inviteIdList)) {
                UpdateWrapper<StuffInviteEntity> wrapper = new UpdateWrapper<>();
                wrapper.set("occupy_state",1).in("id", inviteIdList);
                service.update(wrapper);
            }
        }


        //保存招标过程记录表
        if (!processService.selectByBillId(entity.getId())) {
            ProcessEntity processEntity = new ProcessEntity();
            processEntity.setBillId(entity.getId());
            if (vo.getEstablishType() == 1) {
                processEntity.setBillName("定标立项");
            }
            else {
                processEntity.setBillName("招标立项");
            }
            processEntity.setTenderId(entity.getId());
            processEntity.setType(0);
            processEntity.setFrontendUrl("stuff/invite/card");
            processService.saveOrUpdate(processEntity);
        }

        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffInviteVO> queryDetail(Long id) {
        StuffInviteEntity entity = service.selectById(id);
        StuffInviteVO vo = BeanMapper.map(entity, StuffInviteVO.class);
        //处理供应商子表信息
        List<StuffInviteDetailRecordVO> stuffInviteDetailVOList = vo.getStuffDetailRecord();
        List<StuffInviteDetailBidderVO> stuffInviteDetailBidderVOList = vo.getStuffDetailBidder();
        if (CollectionUtils.isNotEmpty(stuffInviteDetailBidderVOList)) {
            Map<Long, List<StuffInviteDetailBidderVO>> bidderMap = stuffInviteDetailBidderVOList.stream().
                    collect(Collectors.groupingBy(StuffInviteDetailBidderVO::getInviteDetailId));
            if (CollectionUtils.isNotEmpty(stuffInviteDetailVOList)) {
                for (StuffInviteDetailRecordVO stuffInviteDetailVO : stuffInviteDetailVOList) {
                    List<StuffInviteDetailBidderVO> stuffInviteDetailBidderVOS = bidderMap.get(stuffInviteDetailVO.getId());
                    if (CollectionUtils.isNotEmpty(stuffInviteDetailBidderVOS)) {
                        stuffInviteDetailVO.setStuffDetailBidder(stuffInviteDetailBidderVOS);
                    }
                }
            }
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<StuffInviteVO> vos) {
        List<Long> idList = vos.stream().map(StuffInviteVO::getId).collect(Collectors.toList());
        for (Long inviteId : idList) {
            StuffInviteEntity inviteEntity = service.selectById(inviteId);
            List<String> planIdList = detailRecordService.list(new LambdaQueryWrapper<StuffInviteDetailRecordEntity>()
                    .eq(StuffInviteDetailRecordEntity::getInviteId, inviteId))
                    .stream().map(StuffInviteDetailRecordEntity::getPlanId)
                    .map(String::valueOf).distinct().collect(Collectors.toList());
//            if (inviteEntity.getPurchaseType() == 0 ){
                CommonResponse<String> response = batPlanApi.updateBatPlanQuote(planIdList, BatPlanEnum.PLAN_STATE_WAIT.getPlanState(),0);
                if (!response.isSuccess()) {
                    throw new BusinessException("修改批次计划状态失败" + response.getMsg());
                }
//            }else {
//                CommonResponse<String> response = materialBatchPlanApi.updateBatPlanQuote(planIdList, BatPlanEnum.PLAN_STATE_WAIT.getPlanState());
//                if (!response.isSuccess()) {
//                    throw new BusinessException("修改采购申请状态失败" + response.getMsg());
//                }
//            }

            //修改招标状态
            if (inviteEntity.getEstablishType()==1){
                List<String> inviteIdList = detailRecordService.list(new LambdaQueryWrapper<StuffInviteDetailRecordEntity>()
                        .eq(StuffInviteDetailRecordEntity::getInviteId, inviteId))
                        .stream().map(StuffInviteDetailRecordEntity::getPlanId)
                        .map(String::valueOf).distinct().collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(inviteIdList)) {
                    UpdateWrapper<StuffInviteEntity> wrapper = new UpdateWrapper<>();
                    wrapper.set("occupy_state",0).in("id", inviteIdList);
                    service.update(wrapper);
                }
            }
        }
        service.removeByIds(vos.stream().map(StuffInviteVO::getId).collect(Collectors.toList()), true);
        processService.remove(new LambdaQueryWrapper<ProcessEntity>().in(ProcessEntity::getBillId, vos.stream().map(StuffInviteVO::getId).collect(Collectors.toList())));
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<StuffInviteVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("tenderName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("purchaseTypeName");
        fuzzyFields.add("tenderStage");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Parameter isMyOrder = param.getParams().get("isMyOrder");
        if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")&&isMyOrder.getValue().toString().contains("1")){
            param.getParams().remove("employeeId");
        }else if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")){
            param.getParams().put("employeeId", new Parameter(QueryParam.EQ, Long.valueOf(InvocationInfoProxy.getEmployeeId())));
        }else if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("1")){
            param.getParams().put("employeeId", new Parameter(QueryParam.NE, Long.valueOf(InvocationInfoProxy.getEmployeeId())));
        }
        param.getParams().remove("isMyOrder");
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<StuffInviteEntity> page = service.queryPage(param, false);
        IPage<StuffInviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), StuffInviteVO.class));
        for (StuffInviteVO record : pageData.getRecords()) {
            if(record.getTenderType() != null){
                switch (record.getTenderType()) {
                    case 0:
                        record.setTenderTypeName("平台公开招标");
                        break;
                    case 1:
                        record.setTenderTypeName("邀请招标");
                        break;
                    case 2:
                        record.setTenderTypeName("询价");
                        break;
                    case 3:
                        record.setTenderTypeName("竞争性谈判");
                        break;
                    case 4:
                        record.setTenderTypeName("单一来源");
                        break;
                    case 5:
                        record.setTenderTypeName("紧急招标");
                        break;
                }
                switch (record.getSignStatus()) {
                    case 0:
                        record.setSignStatusName("未签订");
                        break;
                    case 1:
                        record.setSignStatusName("部分签订");
                        break;
                    case 2:
                        record.setSignStatusName("全部已签");
                        break;
                    case 3:
                        record.setSignStatusName("已关闭");
                        break;
                }
            }
            record.setEstablishTypeName(record.getEstablishType() == 0 ? "招标立项" : "定标立项");
            record.setPurchaseTypeName(record.getPurchaseType() == 0 ? "项目采购" : "单位采购");
            record.setTenderStageName(TenderStageEnum.getEnumByStateCode(record.getTenderStage()).getDescription());
        }
        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        fuzzyFields.add("tenderName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("employeeName");
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<StuffInviteEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<StuffInviteVO> voList = JSON.parseArray(JSON.toJSONString(list), StuffInviteVO.class);
        for (StuffInviteVO stuffInviteVO : voList) {
            if(stuffInviteVO.getTenderType() != null) {
                switch (stuffInviteVO.getTenderType()) {
                    case 0:
                        stuffInviteVO.setTenderTypeName("平台公开招标");
                        break;
                    case 1:
                        stuffInviteVO.setTenderTypeName("邀请招标");
                        break;
                    case 2:
                        stuffInviteVO.setTenderTypeName("询价");
                        break;
                    case 3:
                        stuffInviteVO.setTenderTypeName("竞争性谈判");
                        break;
                    case 4:
                        stuffInviteVO.setTenderTypeName("单一来源");
                        break;
                    case 5:
                        stuffInviteVO.setTenderTypeName("紧急招标");
                        break;
                }
            }
            stuffInviteVO.setEstablishTypeName(stuffInviteVO.getEstablishType() == 0 ? "招标立项" : "定标立项");
            stuffInviteVO.setPurchaseTypeName(stuffInviteVO.getPurchaseType() == 0 ? "项目采购" : "单位采购");
            stuffInviteVO.setBillStateName(BillStateEnum.getEnumByStateCode(stuffInviteVO.getBillState()).getDescription());
            stuffInviteVO.setTenderStageName(TenderStageEnum.getEnumByStateCode(stuffInviteVO.getTenderStage()).getDescription());
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("材料立项.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refStuffInviteData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<StuffInviteVO>> refStuffInviteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                   String condition,
                                                                   String searchObject,
                                                                   String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        param.getParams().put("tenderPlatform", new Parameter(QueryParam.EQ, 2));
        param.getParams().put("occupyState", new Parameter(QueryParam.EQ, 0));

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("tenderName");

        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            // 项目id
            if (_con.containsKey(CONDITION_PROJECT_ID)) {
                Long projectId = Long.parseLong(_con.get(CONDITION_PROJECT_ID).toString());
                CommonResponse<List<Long>> projectResponse = projectPoolApi.queryProjectIdsByParentProjectId(projectId);
                if (!projectResponse.isSuccess()) {
                    throw new BusinessException("查询项目信息失败！");
                }
                param.getParams().put("projectId", new Parameter(QueryParam.IN, projectResponse.getData()));
            }
            // 组织id
            if (_con.containsKey(CONDITION_ORG_ID)) {
                Long orgId = Long.valueOf(_con.get(CONDITION_ORG_ID).toString());
                CommonResponse<OrgVO> orgResp = iOrgApi.getOneById(orgId);
                OrgVO orgVO = orgResp.getData();
                /** 数据隔离，如果查询组织为项目部，查询orgId，否则查询parentOrgId本下 */
                if (OrgVO.ORG_TYPE_DEPARTMENT.equals(orgVO.getOrgType())) {
                    param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
                }
                else {
                    param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi
                            .findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId)
                            .collect(Collectors.toList())));
                }
            }
            if(_con.containsKey("purchaseType")){
                Integer purchaseType = _con.getInteger("purchaseType");
                param.getParams().put("purchaseType", new Parameter(QueryParam.EQ,purchaseType));
            }
        }
        IPage<StuffInviteEntity> page = service.queryPage(param, false);
        IPage<StuffInviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), StuffInviteVO.class));

        if (CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<StuffInviteVO> stuffInviteVOList = pageData.getRecords();
            List<String> idList = stuffInviteVOList.stream().map(StuffInviteVO::getId).map(String::valueOf)
                    .collect(Collectors.toList());
            // 查询子表
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("inviteId", new Parameter(QueryParam.IN, idList));
            List<StuffInviteDetailRecordEntity> detailEntityList = detailRecordService.queryList(detailParam);
            List<StuffInviteDetailRecordVO> detailVOList = BeanMapper.mapList(detailEntityList, StuffInviteDetailRecordVO.class);
            Map<Long, List<StuffInviteDetailRecordVO>> detailMap = new HashMap<>();
            List<StuffInviteDetailRecordVO> mapList;
            // 按照planID对子表结果分组
            for (StuffInviteDetailRecordVO vo : detailVOList) {
                if (detailMap.containsKey(vo.getInviteId())) {
                    detailMap.get(vo.getInviteId()).add(vo);
                }
                else {
                    mapList = new ArrayList<>();
                    mapList.add(vo);
                    detailMap.put(vo.getInviteId(), mapList);
                }
            }
            // 将清单添加到主表中
            stuffInviteVOList.forEach(t -> {
                t.setStuffDetailRecord(detailMap.get(t.getId()));
            });
        }
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @Description saveOrUpdate 获取流/废标状态
     */
    @RequestMapping(value = "/getAType", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, Object>> getAType(Long tenderId) {
        Map<String, Object> map = service.getAbolishType(tenderId);
        return CommonResponse.success("查询流/废标状态成功！", map);
    }

    /**
     * @param
     * @Description 子表导出
     * @Return void
     */
    @RequestMapping(value = "/detailExcelExport", method = RequestMethod.GET)
    @ResponseBody
    public void detailExcelExport(Long id, HttpServletResponse response) {
        StuffInviteVO stuffInviteVO = queryDetail(id).getData();
        List<StuffInviteDetailRecordVO> detailList = stuffInviteVO.getStuffDetailRecord();
        for (StuffInviteDetailRecordVO recordVO : detailList) {
            switch (recordVO.getCalculateType()) {
                case 0:
                    recordVO.setCalculateTypeName("理计");
                    break;
                case 1:
                    recordVO.setCalculateTypeName("过磅");
                    break;
                case 2:
                    recordVO.setCalculateTypeName("点数");
                    break;
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", detailList);
        ExcelExport.getInstance().export("stuffInviteDetail.xlsx", beans, response);
    }

    @RequestMapping(value = "/queryContract", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SignContractVo>> queryContract(@RequestBody StuffInviteVO inviteVO) {
        Long refId;
        //招标立项
        if (inviteVO.getEstablishType() == 0) {
            StuffPicketageEntity picketageEntity = picketageService.list(new QueryWrapper<StuffPicketageEntity>().eq("invite_id", inviteVO.getId())).get(0);
            refId = picketageEntity.getId();
        }
        else {
            refId = inviteVO.getId();
        }
        logger.info("定标ID" + refId);
        List<StuffPicketageRefsupplierEntity> refsupplierList = refsupplierService.list(new QueryWrapper<StuffPicketageRefsupplierEntity>().eq("picketage_id", refId));
        List<String> idList = refsupplierList.stream().map(StuffPicketageRefsupplierEntity::getId).map(String::valueOf).collect(Collectors.toList());
        logger.info("定标参照ID" + JSONObject.toJSONString(idList));
        CommonResponse<List<SignContractVo>> response = contractApi.queryContractByTargetResultId(idList);
        if (!response.isSuccess()) {
            throw new BusinessException("查询合同失败" + response.getMsg());
        }
        response.getData().forEach(t -> t.setBillStateName(BillStateEnum.getEnumByStateCode(t.getBillState()).getDescription()));
        return CommonResponse.success(response.getData());
    }

    @RequestMapping(value = "/closeSignStatus", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse closeSignStatus(Long id) {
        StuffInviteEntity entity = service.selectById(id);
        Long refId = null;
        Integer tenderStage = entity.getTenderStage();
        Integer establishType = entity.getEstablishType();
        if (sessionManager.getUserContext().getEmployeeId().equals(entity.getEmployeeId())) {
            //处于未签订、部分签订
            if (entity.getSignStatus() == 0 || entity.getSignStatus() == 1) {
                //招标立项
                if (establishType == 0) {
                    if (tenderStage == 5 || tenderStage == 13 || tenderStage == 14) {
                        StuffPicketageEntity picketageEntity = picketageService.list(new QueryWrapper<StuffPicketageEntity>().eq("invite_id", id)).get(0);
                        refId = picketageEntity.getId();
                    }
                }
                //定标立项
                else {
                    if (entity.getBillState() == 1 || entity.getBillState() == 3) {
                        refId = id;
                    }
                }
            }
            else {
                throw new BusinessException("不符合关闭条件");
            }
            if (refId != null) {
                logger.info("定标ID" + refId);
                List<StuffPicketageRefsupplierEntity> refsupplierList = refsupplierService.list(new QueryWrapper<StuffPicketageRefsupplierEntity>().eq("picketage_id", refId));
                if (CollectionUtils.isNotEmpty(refsupplierList)){
                    refsupplierList.forEach(t -> t.setSignStatus(TenderSignStatusEnum.已关闭.getCode()));
                    refsupplierService.saveOrUpdateBatch(refsupplierList);
                    entity.setSignStatus(TenderSignStatusEnum.已关闭.getCode());
                    service.saveOrUpdate(entity);
                }else {
                    throw new BusinessException("不符合关闭条件");
                }
            }
            else {
                throw new BusinessException("不符合关闭条件");
            }
        }
        else {
            throw new BusinessException("只有招标经办人才能关闭");
        }
        return CommonResponse.success("关闭成功！");
    }
    /**
     * @Description  判断当前登录人和招标经办人是否相同
     */
    @RequestMapping(value = "/judgeEmployee", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> judgeEmployee (Long inviteId) {
        boolean flag = false;
        StuffInviteEntity entity = service.selectById(inviteId);
        if (sessionManager.getUserContext().getEmployeeId().equals(entity.getEmployeeId())) {
           flag = true;
        }
        return CommonResponse.success("查询数据成功！", flag);
    }

    /**
     * @Description  根据子表数据获取价格区间
     */
    @RequestMapping(value = "/queryHistoryPrice", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialPriceHistoryApiVO>> queryHistoryPrice (@RequestBody Map<String,Object> param) {

        IPage<MaterialPriceHistoryApiVO> vos = service.queryHistoryPrice(param);
        return CommonResponse.success("查询成功!",vos);

    }

}
