package com.ejianc.business.tender.stuff.controller;

import java.io.Serializable;

import com.ejianc.business.tender.stuff.vo.StuffPicketageSupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.tender.stuff.service.IStuffPicketageService;
import com.ejianc.business.tender.stuff.vo.StuffPicketageVO;

/**
 * 定标主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("stuffPicketage")
@Api(value = "定标主表", tags = {"定标主表"})
public class StuffPicketageController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "invite-picketage-code";//此处需要根据实际修改

    @Autowired
    private IStuffPicketageService service;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<StuffPicketageVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody StuffPicketageVO saveorUpdateVO) {
        StuffPicketageVO stuffPicketageVO = service.saveOrUpdates(saveorUpdateVO);
    	return CommonResponse.success("初始化基础数据成功！",stuffPicketageVO);
    }
    @ApiOperation("新增或者修改子表供应商")
    @RequestMapping(value = "/saveSupplierBatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<StuffPicketageVO> saveSupplierBatch(@RequestBody StuffPicketageVO saveorUpdateVO) {
        StuffPicketageVO stuffPicketageVO = service.saveSupplierBatch(saveorUpdateVO);
    	return CommonResponse.success("更新成功！",stuffPicketageVO);
    }

    @ApiOperation("专家评标下一步接口")
    @RequestMapping(value = "/savePicketage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffPicketageVO> savePicketage(@RequestParam Long evaluationId) {
        StuffPicketageVO stuffPicketageVO = service.savePicketage(evaluationId);
        return CommonResponse.success("初始化基础数据成功！",stuffPicketageVO);
    }
    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffPicketageVO> queryDetail(@RequestParam Long id) {
        StuffPicketageVO stuffPicketageVO = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",stuffPicketageVO);
    }

    @ApiOperation("紧急招标询价等下一步接口")
    @RequestMapping(value = "/saveManyPicketage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffPicketageVO> saveManyPicketage(@RequestParam Long documentId) {
        StuffPicketageVO stuffPicketageVO = service.saveManyPicketage(documentId);
        return CommonResponse.success("初始化基础数据成功！",stuffPicketageVO);
    }

    @ApiOperation("查询供应商列表详情")
    @RequestMapping(value = "/querySupplierList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<StuffPicketageSupplierVO>> querySupplierList(@RequestParam Long picketageId) {
        List<StuffPicketageSupplierVO> list = service.querySupplierList(picketageId);
        return CommonResponse.success("查询详情数据成功！",list);
    }


}
