package com.ejianc.business.tender.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.business.tender.sub.bean.SubBatPlanDetailEntity;
import com.ejianc.business.tender.sub.service.ISubBatPlanDetailService;
import com.ejianc.business.tender.sub.vo.SubBatPlanDetailVO;
import com.ejianc.business.tender.sub.vo.SubBatPlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.tender.sub.mapper.SubBatPlanMapper;
import com.ejianc.business.tender.sub.bean.SubBatPlanEntity;
import com.ejianc.business.tender.sub.service.ISubBatPlanService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 劳务分包采购计划
 * 
 * @author generator
 * 
 */
@Service("subBatPlanService")
public class SubBatPlanServiceImpl extends BaseServiceImpl<SubBatPlanMapper, SubBatPlanEntity> implements ISubBatPlanService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /** 参照查询：经办人字段名 */
    private static final String CONDITION_TRUSTEES_ID = "employeeId";
    /** 参照查询：项目ID */
    private static final String CONDITION_PROJECT_ID = "projectId";
    /** 参照查询：组织ID */
    private static final String CONDITION_ORG_ID = "orgId";
    /** 参照查询：是否集采 */
    private static final String PURCHASE_TYPE ="purchaseType";
    /** 参照查询：采购单位 */
    private static final String UNIT_ID ="unitId";

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private ISubBatPlanDetailService detailService;

    @Override
    public IPage<SubBatPlanVO> refSubBatPlanData(QueryParam param, String condition, String searchObject) {
        this.setDefaultParam(param);
        // 只查询待采购
        param.getParams().put("planState", new Parameter(QueryParam.EQ, BatPlanEnum.PLAN_STATE_WAIT.getPlanState()));
        // 单据状态
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
                        BillStateEnum.PASSED_STATE.getBillStateCode())));
        // searchObject做模糊查询处理
        if (StringUtils.isNotEmpty(searchObject)) {
            // 系统自带的searchObject实际上是做EQ处理的，在此置为null，手动做like处理
            param.setSearchObject(null);
            JSONObject searchJson = JSONObject.parseObject(searchObject);
            logger.info("参照查询searchObject：【{}】", searchJson);
            if (searchJson != null && !searchJson.isEmpty()) {
                for (Map.Entry<String, Object> entry : searchJson.entrySet()) {
                    param.getParams().put(entry.getKey(), new Parameter(QueryParam.LIKE, entry.getValue()));
                }
            }
        }

        param.getParams().put("valueType", new Parameter(QueryParam.IN, Arrays.asList(0,1,2)));

        if (StringUtils.isNotEmpty(condition)) {
            // 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            logger.info("参照查询condition：【{}】", _con);

            // 经办人
            if (_con.containsKey(CONDITION_TRUSTEES_ID)) {
                param.getParams().put("trusteesId", new Parameter(QueryParam.EQ, _con.get(CONDITION_TRUSTEES_ID)));
            }
            // 项目id
            if (_con.containsKey(CONDITION_PROJECT_ID)) {
                Long projectId = Long.parseLong(_con.get(CONDITION_PROJECT_ID).toString());
                CommonResponse<List<Long>> projectResponse = projectPoolApi.queryProjectIdsByParentProjectId(projectId);
                if (!projectResponse.isSuccess()) {
                    throw new BusinessException("查询项目信息失败！");
                }
                param.getParams().put("projectId", new Parameter(QueryParam.IN, projectResponse.getData()));
            }
            // 组织id
            if (_con.containsKey(CONDITION_ORG_ID)) {
                Long orgId = Long.valueOf(_con.get(CONDITION_ORG_ID).toString());
                CommonResponse<OrgVO> orgResp = iOrgApi.getOneById(orgId);
                OrgVO orgVO = orgResp.getData();
                /** 数据隔离，如果查询组织为项目部，查询orgId，否则查询parentOrgId本下 */
                if (OrgVO.ORG_TYPE_DEPARTMENT.equals(orgVO.getOrgType())) {
                    param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
                } else {
                    param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi
                            .findChildrenByParentIdWithoutProjectDept(orgId).getData().stream().map(OrgVO::getId)
                            .collect(Collectors.toList())));
                }
//                param.getParams().put("parentOrgId", new Parameter(QueryParam.EQ, ));
            }
            //是否集采
            if (_con.containsKey(PURCHASE_TYPE)) {
                param.getParams().put("purchaseType", new Parameter(QueryParam.EQ, _con.get(PURCHASE_TYPE)));
            }
            //单位id
            if (_con.containsKey(UNIT_ID)) {
                param.getParams().put("unitId", new Parameter(QueryParam.EQ, _con.get(UNIT_ID)));
            }

            //计价方式
            if (_con.containsKey("valueType") && "3".equals(_con.get("valueType"))) {
                param.getParams().put("valueType", new Parameter(QueryParam.EQ, _con.get("valueType")));
            }
        }
        IPage<SubBatPlanVO> pageData = this.queryBatPlanVO(param);
        // 查询采购清单
        if (CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<SubBatPlanVO> SubBatPlanVOS = pageData.getRecords();
            List<String> idList = SubBatPlanVOS.stream().map(SubBatPlanVO::getId).map(String::valueOf)
                    .collect(Collectors.toList());
            // 查询子表
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("planId", new Parameter(QueryParam.IN, idList));
            List<SubBatPlanDetailEntity> detailEntityList = detailService.queryList(detailParam);
            List<SubBatPlanDetailVO> detailVOList = BeanMapper.mapList(detailEntityList, SubBatPlanDetailVO.class);
            Map<Long, List<SubBatPlanDetailVO>> detailMap = new HashMap<>();
            List<SubBatPlanDetailVO> mapList;
            // 按照planID对子表结果分组
            for (SubBatPlanDetailVO vo : detailVOList) {
                if (detailMap.containsKey(vo.getPlanId())) {
                    detailMap.get(vo.getPlanId()).add(vo);
                } else {
                    mapList = new ArrayList<>();
                    mapList.add(vo);
                    detailMap.put(vo.getPlanId(), mapList);
                }
            }
            // 将采购计划清单添加到采购计划中
            SubBatPlanVOS.forEach(SubBatPlanVO  -> {
                SubBatPlanVO.setSubDetailRecord(detailMap.get(SubBatPlanVO.getId()));
            });
        }
        return pageData;
    }

    /**
     * 预制模糊查询字段
     *
     * @param param 查询参数
     */
    private void setDefaultParam(QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("planName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("trusteesName");
        fuzzyFields.add("purchaseName");
        // 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 数据隔离 本下 没有组织orgId的删除下面代码 */

        CommonResponse<List<OrgVO>> orgResponse = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgResponse.isSuccess()) {
            throw new BusinessException("查询失败，获取组织信息失败！");
        }
        List<OrgVO> orgVOList = orgResponse.getData();
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        // 查询本下
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            // 要求主表有orgId字段，保存单据所属组织
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        // 查询项目部
        else if (CollectionUtils.isNotEmpty(departmentIds)) {
            // 要求主表有parentOrgId字段，保存单据所属项目部
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
    }

    /**
     * 查询分页列表并转换成VO
     *
     * @param param 查询参数
     * @return 查询结果
     */
    private IPage<SubBatPlanVO> queryBatPlanVO(QueryParam param) {
        IPage<SubBatPlanEntity> page = super.queryPage(param, false);
        IPage<SubBatPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<SubBatPlanVO> SubBatPlanVOS = BeanMapper.mapList(page.getRecords(), SubBatPlanVO.class);
        // 采购阶段转义
        for (SubBatPlanVO vo : SubBatPlanVOS) {
            vo.setPlanStateName(BatPlanEnum.getDescriptionByStateCode(vo.getPlanState()));
        }
        pageData.setRecords(SubBatPlanVOS);
        return pageData;
    }

    /**
     * 修改采购计划状态
     *
     * @param idList    id列表
     * @param planState 引用类型
     */
    @Override
    public void updateBatPlanByQuoteType(List<String> idList, Integer planState,Integer establishType) {
        if (StringUtils.isEmpty(BatPlanEnum.getDescriptionByStateCode(planState))) {
            throw new BusinessException("计划状态错误");
        }
        // 批量更改
        if (CollectionUtils.isNotEmpty(idList)) {
            List<SubBatPlanEntity> entityList = (List<SubBatPlanEntity>) super.listByIds(idList);
            if (CollectionUtils.isNotEmpty(entityList)) {
                for (SubBatPlanEntity entity : entityList) {
                    // 采购完成不允许做其他操作(非定标立项)
                    if (establishType == 0) {//招标立项
                        if (BatPlanEnum.PLAN_STATE_OVER.getPlanState().equals(entity.getPlanState())) {
                            logger.info("采购计划编码【{}】计划名称【{}】已采购完成！", entity.getBillCode(), entity.getPlanName());
                            throw new BusinessException("采购计划编码【" + entity.getBillCode() + "】计划名称【" +
                                    entity.getPlanName() + "】已采购完成！");
                        }
                    }
                    entity.setPlanState(planState);
                }
//                entityList.forEach(entity -> {
//                    entity.setPlanState(planState);
//                });
                super.saveOrUpdateBatch(entityList);
            }
        }
    }
}
