package com.ejianc.business.tender.sub.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.contract.vo.ContractDetailVO;
import com.ejianc.business.promaterial.contract.vo.ContractVO;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.prosub.pricelib.vo.PriceContractCollectVO;
import com.ejianc.business.tender.sub.bean.SubInviteDetailEntity;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.mapper.SubInviteMapper;
import com.ejianc.business.tender.sub.service.ISubInviteService;
import com.ejianc.business.tender.sub.vo.SubInviteDetailBidderVO;
import com.ejianc.business.tender.sub.vo.SubInviteDetailRecordVO;
import com.ejianc.business.tender.sub.vo.SubInviteDetailVO;
import com.ejianc.business.tender.sub.vo.SubInviteVO;
import com.ejianc.business.tender.util.TreeNodeBUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 材料立项主表
 * 
 * @author generator
 * 
 */
@Service("subInviteService")
public class SubInviteServiceImpl extends BaseServiceImpl<SubInviteMapper, SubInviteEntity> implements ISubInviteService {
    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public void updateTenderStage(String id, int tenderStage) {
        baseMapper.updateTenderStage(id, tenderStage);
    }

    @Override
    public void updateAbolishType(String id, int abolishType) {
        baseMapper.updateAbolishType(id, abolishType);
    }

    @Override
    public List<SubInviteDetailVO> selectSumDetail(Long inviteId) {
        return baseMapper.selectSumDetail(inviteId);
    }

    @Override
    public List<SubInviteDetailVO> selectOrgSumDetail(Long inviteId) {
        return baseMapper.selectOrgSumDetail(inviteId);
    }

    @Override
    public SubInviteVO queryDetailTree(Long id) {
        Map<String, LinkedHashMap<String, String>> orderMap = new HashMap<>();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<>();
        orderParams.put("treeIndex", QueryParam.ASC);
        orderMap.put("subDetailRecord", orderParams);


        SubInviteEntity subInviteEntity = super.selectById(id, orderMap);
        SubInviteVO subInviteVO = BeanMapper.map(subInviteEntity, SubInviteVO.class);

        //明细子表排序为树形
        if (CollectionUtils.isNotEmpty(subInviteVO.getSubDetailRecord())) {
            for (SubInviteDetailRecordVO detail : subInviteVO.getSubDetailRecord()) {
                detail.setTid(detail.getId().toString());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            subInviteVO.setSubDetailRecord(TreeNodeBUtil.buildTree(subInviteVO.getSubDetailRecord()));
        }
        if (CollectionUtils.isNotEmpty(subInviteVO.getSubDetailBidder())) {
            for (SubInviteDetailBidderVO detail1 : subInviteVO.getSubDetailBidder()) {
                detail1.setTid(detail1.getId().toString());
                detail1.setTpid(detail1.getParentId() != null ? detail1.getParentId().toString() : null);
            }
            subInviteVO.setSubDetailBidder(TreeNodeBUtil.buildTree(subInviteVO.getSubDetailBidder()));
        }
        subInviteVO.setSubDetailBidder(subInviteVO.getSubDetailBidder());
        return subInviteVO;
    }

    @Override
    public List<SubInviteDetailBidderVO> selectDetailBidder(Long inviteId) {
        return baseMapper.selectDetailBidder(inviteId);
    }

    @Override
    public List<SubInviteDetailBidderVO> querySonDetail(Long inviteId) {
        return baseMapper.querySonDetail(inviteId);
    }

    @Override
    public IPage<PriceContractCollectVO> queryHistoryPrice(Map<String,Object> param) {
        logger.info("进入材料查询历史价格区间查询接口param-{}", param);


        //获取子表档案id
        List<Long> ids = JSON.parseArray(JSON.toJSONString(param.get("ids")), Long.class);
        //对子表信息按照档案id进行合并
        List<Long> docIdList = ids.stream().distinct().collect(Collectors.toList());

        /**
         * 实现分页、非分页二合一
         */
        if(param.get("pageIndex") == null || param.get("pageSize") == null){
            Page<PriceContractCollectVO> page = new Page<>();
            //调用价格库接口查询历史价格信息
            IPage<PriceContractCollectVO> priceContractCollectVOS = baseMapper.queryHistoryPrice(page,docIdList);
            page.setRecords(priceContractCollectVOS.getRecords());
            return page;

        }
        //获取分页信息
        long pageIndex = Long.parseLong(param.get("pageIndex").toString());//当前页
        long pageSize = Long.parseLong(param.get("pageSize").toString());//每页显示条数
        Page<PriceContractCollectVO> page = new Page<PriceContractCollectVO>(pageIndex,pageSize);
        //调用价格库接口查询历史价格信息
        Page<PriceContractCollectVO> priceContractCollectVOS = baseMapper.queryHistoryPrice(page,docIdList);


        return priceContractCollectVOS;
    }
}
