package com.ejianc.business.tender.util;

import com.ejianc.framework.core.exception.BusinessException;

public class CommonUtils {

    /** 材料招标0 */
    public static final int TYPE_MATERIAL = 0;
    /** 材料招标供应商类型 */
    public static final String GYS_TYPE_MATERIAL = "MATERIAL";

    /** 分包招标1 */
    public static final int TYPE_SUB = 1;
    /** 材料招标供应商类型 */
    public static final String GYS_TYPE_SUB = "SUB";

    /** 设备采购2 */
    public static final int TYPE_EQUIPMENT = 2;
    /** 设备采购供应商类型 */
    public static final String GYS_TYPE_PURCHASE = "PURCHASE";

    /** 设备租赁3 */
    public static final int TYPE_RENT = 3;
    /** 设备租赁供应商类型 */
    public static final String GYS_TYPE_RENT = "RENT";

    /** 周转材租赁4 */
    public static final int TYPE_RMAT = 4;
    /** 周转材租赁供应商类型 */
    public static final String GYS_TYPE_RMAT = "RMAT";

    /** 其他5 */
    public static final int TYPE_OTHER = 5;
    /** 其他供应商类型 */
    public static final String GYS_TYPE_OTHER = "OTHER";

    /** 专业分包招标6 */
    public static final int TYPE_PROSUB = 6;
    /** 业分包招标 */
    public static final String GYS_TYPE_PROSUB = "PROSUB";

    private CommonUtils() {

    }

    /**
     * 材料-MATERIAL,分包-SUB，设备采购-PURCHASE,设备租赁-RENT,周转材租赁-RMAT,其他-OTHER
     *
     * @param type 招标立项类型  0-材料,1-.....
     * @return 供应商材料类型
     */
    public static String getGysType(Integer type) {
        String gysType;
        switch (type) {
            case TYPE_MATERIAL:
                gysType = GYS_TYPE_MATERIAL;
                break;
            case TYPE_SUB:
                gysType = GYS_TYPE_SUB;
                break;
            case TYPE_EQUIPMENT:
                gysType = GYS_TYPE_PURCHASE;
                break;
            case TYPE_RENT:
                gysType = GYS_TYPE_RENT;
                break;
            case TYPE_RMAT:
                gysType = GYS_TYPE_RMAT;
                break;
            case TYPE_OTHER:
                gysType = GYS_TYPE_OTHER;
                break;
            case TYPE_PROSUB:
                gysType = GYS_TYPE_PROSUB;
                break;
            default:
                throw new BusinessException("招标立项类型不存在[" + type + "]");
        }
        return gysType;
    }
    /**
     * 材料-0,分包-1，设备采购-2,设备租赁-3,周转材租赁-4,其他-5
     *
     * @param type 招标立项类型  0-材料,1-.....
     * @return 招标类型名称
     */
    public static String getTypeName(Integer type) {
        String getTypeName;
        switch (type) {
            case TYPE_MATERIAL:
                getTypeName = "材料招标";
                break;
            case TYPE_SUB:
                getTypeName = "分包招标";
                break;
            case TYPE_EQUIPMENT:
                getTypeName = "设备采购";
                break;
            case TYPE_RENT:
                getTypeName = "设备租赁";
                break;
            case TYPE_RMAT:
                getTypeName = "周转材租赁";
                break;
            case TYPE_OTHER:
                getTypeName = "其他";
                break;
            case TYPE_PROSUB:
                getTypeName = "专业分包招标";
                break;
            default:
                throw new BusinessException("招标立项类型不存在[" + type + "]");
        }
        return getTypeName;
    }
}
