package com.ejianc.business.tender.other.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.other.bean.*;
import com.ejianc.business.tender.other.mapper.OtherBidMapper;
import com.ejianc.business.tender.other.service.*;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.other.vo.*;
import com.ejianc.business.tender.sub.vo.SubBidDetailVO;
import com.ejianc.business.tender.sub.vo.SubWinbidDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 中标主表
 * 
 * @author generator
 * 
 */
@Service("otherBidService")
public class OtherBidServiceImpl extends BaseServiceImpl<OtherBidMapper, OtherBidEntity> implements IOtherBidService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOtherPicketageService otherPicketageService;
    @Autowired
    private IOtherNoticeService otherNoticeService;
    @Autowired
    private IOtherWinnoticeService otherWinnoticeService;
    @Autowired
    private IOtherDocumentService otherDocumentService;
    @Autowired
    private IOtherInviteService otherInviteService;
    @Autowired
    private IOtherBidDetailService otherBidDetailService;
    @Autowired
    private IOtherDocumentSellService otherDocumentSellService;
    @Autowired
    private IOtherBidSupplierService otherBidSupplierService;
    @Autowired
    private IOtherDocumentSupplierService otherDocumentSupplierService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IOtherPicketageSupplierService otherPicketageSupplierService;
    @Autowired
    private IOrgApi iOrgApi;
    @Value("${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;

    @Value("${gysUrl.winbidSavesUrl}")
    private String winbidSavesUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    private org.slf4j.Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CacheManager cacheManager;
    private static final String BILL_CODE = "invite-bid-code";//此处需要根据实际修改
    @Override
    public OtherBidVO saveBid(Long picketageId) {
        OtherBidEntity entity = new OtherBidEntity();
        entity.setPicketageId(picketageId);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        OtherPicketageEntity otherPicketageEntity = otherPicketageService.selectById(picketageId);
        OtherInviteEntity inviteEntity = otherInviteService.selectById(otherPicketageEntity.getInviteId());
        entity.setInviteId(otherPicketageEntity.getInviteId());
        entity.setBidName(inviteEntity.getTenderName());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        super.saveOrUpdate(entity, false);
        OtherBidVO vo = BeanMapper.map(entity, OtherBidVO.class);

        //回写定标数据
//        otherPicketageEntity.setBidStatus(1);
        otherPicketageEntity.setBidId(entity.getId());
        otherPicketageService.updateById(otherPicketageEntity);

        //处理供应商信息
        //获取材料明细报价
        LambdaQueryWrapper<OtherDocumentSellEntity> lambdaSell = Wrappers.<OtherDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(OtherDocumentSellEntity::getDocumentId, otherPicketageEntity.getDocumentId());
        lambdaSell.eq(OtherDocumentSellEntity::getTenderFlag, 1);
        List<OtherDocumentSellEntity> sellList = otherDocumentSellService.list(lambdaSell);
        List<OtherDocumentSellVO> otherDocumentSellVOS = BeanMapper.mapList(sellList, OtherDocumentSellVO.class);
        Map<Long, List<OtherDocumentSellVO>> sellMap = otherDocumentSellVOS.stream().
                collect(Collectors.groupingBy(OtherDocumentSellVO::getSupplierId));

        //查看供应商信息
        LambdaQueryWrapper<OtherDocumentSupplierEntity> lambdaSupplier = Wrappers.<OtherDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(OtherDocumentSupplierEntity::getDocumentId, otherPicketageEntity.getDocumentId());
        lambdaSupplier.eq(OtherDocumentSupplierEntity::getTalkNum, 0);
        List<OtherDocumentSupplierEntity> supplierList = otherDocumentSupplierService.list(lambdaSupplier);
        Map<Long, OtherDocumentSupplierEntity> supplieotherityMap = supplierList.stream().collect(Collectors.toMap(OtherDocumentSupplierEntity::getSupplierId, Function.identity()));

        //遍历map,组合数据返回
        ArrayList<OtherBidSupplierVO> supplierVOList = new ArrayList<>();
        List<OtherBidDetailEntity> otherBidDetailEntityList = new ArrayList<>();
        sellMap.forEach((key,value) -> {
            OtherBidSupplierVO otherBidSupplierVO = new OtherBidSupplierVO();
            otherBidSupplierVO.setSupplierId(key);
            otherBidSupplierVO.setSupplierName(value.stream().findFirst().get().getSupplierName());
            OtherDocumentSupplierEntity otherDocumentSupplierEntity = supplieotherityMap.get(key);
            otherBidSupplierVO.setLinkName(otherDocumentSupplierEntity.getLinkName());
            otherBidSupplierVO.setSupplierMobile(otherDocumentSupplierEntity.getLinkMobile());
            otherBidSupplierVO.setId(IdWorker.getId());

            //汇总中标金额
            BigDecimal tenderMoneyTax = BigDecimal.ZERO;
            BigDecimal tenderMoney = BigDecimal.ZERO;

            for (OtherDocumentSellVO otherDocumentSellVO : value) {
                //汇总金额
                tenderMoneyTax = tenderMoneyTax
                        .add(otherDocumentSellVO.getTenderMoneyTax() == null ? BigDecimal.ZERO : otherDocumentSellVO
                                .getTenderMoneyTax());
                tenderMoney = tenderMoney
                        .add(otherDocumentSellVO.getTenderMoney() == null ? BigDecimal.ZERO : otherDocumentSellVO
                                .getTenderMoney());
                OtherBidDetailEntity otherBidDetailEntity = BeanMapper.map(otherDocumentSellVO, OtherBidDetailEntity.class);
                otherBidDetailEntity.setMoney(otherDocumentSellVO.getTenderMoney());
                otherBidDetailEntity.setMoneyTax(otherDocumentSellVO.getTenderMoneyTax());
                otherBidDetailEntity.setId(null);
                otherBidDetailEntity.setBidSupplierId(otherBidSupplierVO.getId());
                otherBidDetailEntity.setBidId(entity.getId());
                otherBidDetailEntityList.add(otherBidDetailEntity);

            }
            otherBidSupplierVO.setMoneyTax(tenderMoneyTax);
            otherBidSupplierVO.setMoney(tenderMoney);
            otherBidSupplierVO.setBidId(entity.getId());
            supplierVOList.add(otherBidSupplierVO);
        });

        //新增供应商
        List<OtherBidSupplierEntity> otherBidSupplieotherities = BeanMapper.mapList(supplierVOList, OtherBidSupplierEntity.class);
        otherBidSupplierService.saveBatch(otherBidSupplieotherities);
        otherBidDetailService.saveBatch(otherBidDetailEntityList);

        //回写中标供应商和数量
        String tenderUnitNum = new String();
        //查询中标供应商
        List<OtherBidDetailEntity> bidDetailEntityList = baseMapper.selectBidSupplier(entity.getId());
        for (OtherBidDetailEntity otherBidDetailEntity : bidDetailEntityList) {
            OtherBidSupplierEntity supplieotherity = otherBidSupplierService.selectById(otherBidDetailEntity.getBidSupplierId());
            BigDecimal sumNum = otherBidDetailEntity.getTenderNum().setScale(4,BigDecimal.ROUND_HALF_UP);
            String name = supplieotherity.getSupplierName()+"("+sumNum+"),";
            tenderUnitNum += name;
        }
        if (tenderUnitNum.length() > 1) {
            tenderUnitNum = tenderUnitNum.substring(0,tenderUnitNum.length() -1);
        }
        inviteEntity.setTenderUnitNum(tenderUnitNum);
        otherInviteService.saveOrUpdate(inviteEntity);

        OtherBidVO otherBidVO = BeanMapper.map(entity, OtherBidVO.class);
        return otherBidVO;
    }

    @Override
    public OtherBidVO queryDetail(Long bidId) {
        OtherBidEntity otherBidEntity = super.selectById(bidId);
        OtherBidVO otherBidVO = BeanMapper.map(otherBidEntity, OtherBidVO.class);
        //组合数据
        List<OtherBidDetailVO> otherBidDetailList  = otherBidVO.getOtherBidDetailList();
        Map<Long, List<OtherBidDetailVO>> detailMap = otherBidDetailList.stream().
                collect(Collectors.groupingBy(OtherBidDetailVO::getBidSupplierId));
        List<OtherBidSupplierVO> otherBidSupplierList = otherBidVO.getOtherBidSupplierList();
        for (OtherBidSupplierVO otherBidSupplierVO : otherBidSupplierList){
            otherBidSupplierVO.setOtherBidDetailList(detailMap.get(otherBidSupplierVO.getId()));
        }
        otherBidVO.setOtherBidSupplierList(otherBidSupplierList);
        return otherBidVO;
//
    }
    @Transactional
    @Override
    public OtherBidVO publishBid(OtherBidVO saveorUpdateVO) {
        OtherBidEntity entity = super.selectById(saveorUpdateVO.getId());
        entity.setBidContent(saveorUpdateVO.getBidContent());
        entity.setBidName(saveorUpdateVO.getBidName());
        entity.setPublishFlag(0);
        entity.setBillState(1);
        OtherBidVO vo = BeanMapper.map(entity, OtherBidVO.class);

        //获取中标信息
        OtherInviteEntity otherInviteEntity = otherInviteService.selectById(entity.getInviteId());
        OtherWinbidVO winbidVO = new OtherWinbidVO();
        winbidVO.setSourceId(Long.toString(entity.getInviteId()));
        winbidVO.setBillCode(otherInviteEntity.getBillCode());
        if (winbidVO.getPurchaseType()==null || winbidVO.getPurchaseType()==1){
            winbidVO.setSourceProjectId(null);
        }else {
            winbidVO.setSourceProjectId(Long.toString(otherInviteEntity.getProjectId()));
        }
        winbidVO.setProjectName(otherInviteEntity.getProjectName());
        winbidVO.setProjectCode(otherInviteEntity.getProjectCode());
        winbidVO.setSourceOrgId(Long.toString(otherInviteEntity.getOrgId()));
        winbidVO.setOrgName(otherInviteEntity.getOrgName());
        winbidVO.setUnitName(otherInviteEntity.getUnitName());
        winbidVO.setSourceUnitId(Long.toString(otherInviteEntity.getUnitId()));
        winbidVO.setType("OTHER");
        winbidVO.setTenderName(otherInviteEntity.getTenderName());
        winbidVO.setTenderType(otherInviteEntity.getTenderType());
        winbidVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());

        LambdaQueryWrapper<OtherDocumentEntity> lambdaDoc = Wrappers.<OtherDocumentEntity>lambdaQuery();
        lambdaDoc.eq(OtherDocumentEntity::getInviteId, entity.getInviteId());
        OtherDocumentEntity otherDocumentEntity = otherDocumentService.getOne(lambdaDoc);
        winbidVO.setNoticeBidTime(otherDocumentEntity.getBidTime());
        winbidVO.setNoticeWinbidTime(new Date());

        if (otherInviteEntity.getTenderType()==2 || otherInviteEntity.getTenderType()==3 ||otherInviteEntity.getTenderType()==4 ||otherInviteEntity.getTenderType()==5){
            winbidVO.setSourceEmployeeId(Long.toString(otherDocumentEntity.getEmployeeId()));
            winbidVO.setEmployeeName(otherDocumentEntity.getEmployeeName());
            winbidVO.setEmployeeMobile(otherDocumentEntity.getEmployeeMobile());
            winbidVO.setPurchaseType(otherDocumentEntity.getPurchaseType());
        }else {
            //查询招标公告
            LambdaQueryWrapper<OtherNoticeEntity> lambdaNotice = Wrappers.<OtherNoticeEntity>lambdaQuery();
            lambdaNotice.eq(OtherNoticeEntity::getInviteId, entity.getInviteId());
            OtherNoticeEntity noticeEntity = otherNoticeService.getOne(lambdaNotice);
            winbidVO.setSourceEmployeeId(Long.toString(noticeEntity.getEmployeeId()));
            winbidVO.setEmployeeName(noticeEntity.getEmployeeName());
            winbidVO.setEmployeeMobile(noticeEntity.getEmployeeMobile());
            winbidVO.setPurchaseType(noticeEntity.getPurchaseType());
        }

        //处理供应商信息
        OtherBidVO otherBidVO = queryDetail(entity.getId());
        List<OtherBidSupplierVO> otherBidSupplierList = otherBidVO.getOtherBidSupplierList();
        //转换数据,推送供应商中标信息
        List<OtherWinbidVO> winbidVOList = new ArrayList<>();
        for (OtherBidSupplierVO otherBidSupplierVO : otherBidSupplierList){
            OtherWinbidVO winbidVONew = BeanMapper.map(winbidVO,OtherWinbidVO.class);
            SupplierDTO supplierVO = shareSupplierApi.queryById(otherBidSupplierVO.getSupplierId()).getData();
            winbidVONew.setTenantId(supplierVO.getTenant());
            winbidVONew.setWinbidMoneyTax(otherBidSupplierVO.getMoneyTax());
            winbidVONew.setWinbidMoney(otherBidSupplierVO.getMoney());
            winbidVONew.setContent(otherBidVO.getBidContent());
            winbidVONew.setWinbidType(0);

            List<OtherBidDetailVO> otherBidDetailList = otherBidSupplierVO.getOtherBidDetailList();
            //处理中标详情数据
            List<OtherWinbidDetailVO> otherWinbidDetailVOList = new ArrayList<>();
            for (OtherBidDetailVO otherBidDetailVO : otherBidDetailList){
                OtherWinbidDetailVO otherWinbidDetailVO = new OtherWinbidDetailVO();
                otherWinbidDetailVO.setSourceId(Long.toString(entity.getInviteId()));
                otherWinbidDetailVO.setMaterialName(otherBidDetailVO.getMaterialName());
                otherWinbidDetailVO.setMaterialCode(otherBidDetailVO.getMaterialCode());
                otherWinbidDetailVO.setUnit(otherBidDetailVO.getUnit());
                otherWinbidDetailVO.setSpec(otherBidDetailVO.getSpec());
                otherWinbidDetailVO.setBrand(otherBidDetailVO.getMaterialBrand());
                otherWinbidDetailVO.setSupplierBrand(otherBidDetailVO.getBrand());
                otherWinbidDetailVO.setPrice(otherBidDetailVO.getPrice());
                otherWinbidDetailVO.setPriceTax(otherBidDetailVO.getPriceTax());
                otherWinbidDetailVO.setMoney(otherBidDetailVO.getMoney());
                otherWinbidDetailVO.setMoneyTax(otherBidDetailVO.getMoneyTax());
                otherWinbidDetailVO.setTax(otherBidDetailVO.getSellTax());
                otherWinbidDetailVO.setCalculateType(otherBidDetailVO.getCalculateType());
                otherWinbidDetailVO.setMemo(otherBidDetailVO.getMaterialMemo());
                otherWinbidDetailVO.setSupplierMemo(otherBidDetailVO.getMemo());
                otherWinbidDetailVO.setMoney(otherBidDetailVO.getMoney());
                otherWinbidDetailVO.setRate(otherBidDetailVO.getRate());
                otherWinbidDetailVO.setTenderNum(otherBidDetailVO.getTenderNum());
                otherWinbidDetailVO.setNum(otherBidDetailVO.getNum());
                otherWinbidDetailVOList.add(otherWinbidDetailVO);
            }
            winbidVONew.setOtherWinbidDetailList(otherWinbidDetailVOList);
            winbidVOList.add(winbidVONew);
        }
        String stringFb = JSONObject.toJSONString(winbidVOList);
        logger.info("推送供方中标信息:" +stringFb);
        //调用供方接口
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(winbidSavesUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("中标同步接口报错" + stringCommonResponse.getMsg());
        }

        return queryDetail(vo.getId());
    }

    @Override
    public OtherBidVO queryDbDetail(Long picketage) {

        return null;
    }

    @Override
    public OtherBidVO nextPaper(Long winnoticeId) {
        OtherBidEntity entity = new OtherBidEntity();
        OtherWinnoticeEntity otherWinnoticeEntity = otherWinnoticeService.selectById(winnoticeId);
        OtherInviteEntity otherInviteEntity = otherInviteService.selectById(otherWinnoticeEntity.getInviteId());
        entity.setInviteId(otherWinnoticeEntity.getInviteId());
        entity.setBidName(otherInviteEntity.getTenderName());
        entity.setPurchaseType(otherInviteEntity.getPurchaseType());
        entity.setWinnoticeId(winnoticeId);
        super.saveOrUpdate(entity, false);

        //回写中标公告状态
        otherWinnoticeEntity.setNextFlag(1);
        otherWinnoticeService.updateById(otherWinnoticeEntity);

        //回写招标阶段
        otherInviteEntity.setTenderStage(TenderStageEnum.BID_NOTICE_STATE.getTenderTypeCode());
        otherInviteService.updateById(otherInviteEntity);

        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getDescription());
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(3);
        processEntity.setFrontendUrl("other/winLetter");
        processService.saveOrUpdate(processEntity);

        OtherBidVO otherBidVO = BeanMapper.map(entity, OtherBidVO.class);
        return otherBidVO;
    }

    @Override
    public List<OtherPicketageSupplierVO> querySupplierList(Long picketageId) {
        OtherBidEntity otherBidEntity = super.selectById(picketageId);

        OtherWinnoticeEntity otherWinnoticeEntity = otherWinnoticeService.selectById(otherBidEntity.getWinnoticeId());
        LambdaQueryWrapper<OtherPicketageSupplierEntity> lambdaSupplierList = Wrappers.lambdaQuery();
        lambdaSupplierList.eq(OtherPicketageSupplierEntity::getPicketageId,otherWinnoticeEntity.getPicketageId());
        List<OtherPicketageSupplierEntity> listSupplier = otherPicketageSupplierService.list(lambdaSupplierList);
        List<OtherPicketageSupplierVO> otherPicketageSupplierVOS = BeanMapper.mapList(listSupplier, OtherPicketageSupplierVO.class);

        return otherPicketageSupplierVOS;
    }
    @Transactional
    @Override
    public OtherPicketageVO insertProcess(Long picketageId) {

        OtherPicketageEntity otherPicketageEntity = otherPicketageService.selectById(picketageId);
        OtherInviteEntity otherInviteEntity = otherInviteService.selectById(otherPicketageEntity.getInviteId());
        //回写招标阶段
        otherInviteEntity.setTenderStage(TenderStageEnum.BID_NOTICE_STATE.getTenderTypeCode());
        otherInviteService.updateById(otherInviteEntity);

        //回写定标数据
        otherPicketageEntity.setBidStatus(1);
        otherPicketageService.updateById(otherPicketageEntity);

        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(otherPicketageEntity.getBidId());
        processEntity.setBillName(TenderStageEnum.BID_NOTICE_STATE.getDescription());
        processEntity.setTenderId(otherInviteEntity.getId());
        processEntity.setType(3);
        processEntity.setFrontendUrl("other/winLetter");
        processService.saveOrUpdate(processEntity);
        OtherPicketageVO otherPicketageVO = BeanMapper.map(otherPicketageEntity, OtherPicketageVO.class);
        return otherPicketageVO;
    }

    @Override
    public List<OtherPicketageSupplierVO> querySupplierDetail(Long id) {
        OtherBidEntity otherBidEntity = super.selectById(id);
        return otherPicketageService.querySupplierList(otherBidEntity.getPicketageId());
    }
}
