package com.ejianc.business.tender.rent.service;

import com.ejianc.business.tender.rent.vo.RentDocumentRecordVO;
import com.ejianc.business.tender.rent.vo.RentDocumentSellVO;
import com.ejianc.business.tender.rent.vo.RentDocumentSupplierSellVO;
import com.ejianc.business.tender.rent.vo.RentDocumentVO;
import com.ejianc.business.tender.rent.bean.RentDocumentEntity;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

/**
 * 招标文件主表
 * 
 * @author generator
 * 
 */
public interface IRentDocumentService extends IBaseService<RentDocumentEntity> {

    RentDocumentVO publishDocument(Long id) throws Exception;

    RentDocumentVO bidDocument(Long id);

    RentDocumentVO queryDetail(Long id);

    RentDocumentVO queryDocDetail(Long id,Integer talkNum);


    List<RentDocumentSellVO> getSchemeDetail(RentDocumentSellVO rentDocumentSellVO);

    RentDocumentSupplierSellVO getSupplierSchemeDetail(Long supplierDetailId, Long documentId);

    RentDocumentVO extendDocument(RentDocumentRecordVO rentDocumentRecordVO);

    RentDocumentSupplierSellVO getSupplierSchemeTalkDetail(Long supplierDetailId, Long talkId);

    RentDocumentVO publishManyDocument(Long id) throws InvocationTargetException, IllegalAccessException;

    CommonResponse delSupplier(Long id);

    RentDocumentVO saveManyDocument(Long id);

    RentDocumentSupplierSellVO getSupplierSchemeDetailTalk(Long supplierDetailId, Long talkId);

    RentDocumentVO saveDocument(Long noticeId);

    RentDocumentVO queryDetailNum(Long documentId);

    Boolean supplierPushSell(HttpServletRequest request, MultipartFile file);

    String uploadById(Long attachId,Long inviteId);

    String deleteFileById(Long sourceId, List<String> fileNames);

    RentDocumentSupplierSellVO getSupplierSchemeDetailDb(Long schemeId, Long documentId);

    RentDocumentVO saveOrUpdates(RentDocumentVO saveorUpdateVO);

    RentDocumentVO queryDetail1(Long documentId, Integer num);

    /**
     * 检查所选专家数量
     * 规则：
     *      1.集团专家、项目专家比例1:2，集团专家向上取整
     *      2.评标专家数必须为单数
     * @param documentId
     * @return
     */
    CommonResponse<Boolean> checkExpertNum(Long documentId);


}
