package com.ejianc.business.tender.rent.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.rent.vo.RentDocumentExpertVO;
import com.ejianc.business.tender.rent.vo.RentDocumentVO;
import com.ejianc.business.tender.rent.bean.RentDocumentExpertEntity;
import com.ejianc.business.tender.rent.mapper.RentDocumentExpertMapper;
import com.ejianc.business.tender.rent.service.IRentDocumentExpertService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 招标文件专家表
 * 
 * @author generator
 * 
 */
@Service("rentDocumentExpertService")
public class RentDocumentExpertServiceImpl extends BaseServiceImpl<RentDocumentExpertMapper, RentDocumentExpertEntity> implements IRentDocumentExpertService {

    @Override
    public List<RentDocumentExpertEntity> addBatch(RentDocumentVO rentDocumentVO) {

        //先删后增
        LambdaQueryWrapper<RentDocumentExpertEntity> expertWrapper = Wrappers.lambdaQuery();
        expertWrapper.eq(RentDocumentExpertEntity::getDocumentId,rentDocumentVO.getId());
        super.remove(expertWrapper);

        //新增
        List<RentDocumentExpertVO> expertVOList = rentDocumentVO.getExpertVOList();
        if(CollectionUtils.isNotEmpty(expertVOList)){
            for (RentDocumentExpertVO rentDocument: expertVOList){
                rentDocument.setDocumentId(rentDocumentVO.getId());
                rentDocument.setId(null);
            }
            List<RentDocumentExpertEntity> rentDocumentExpertEntities = BeanMapper.mapList(expertVOList, RentDocumentExpertEntity.class);
            super.saveBatch(rentDocumentExpertEntities);
            return rentDocumentExpertEntities;
        }

        return null;
    }

    @Override
    public List<RentDocumentExpertEntity> deleteByIds(List<Long> vos) {
        Long pk = vos.stream().findFirst().get();
        RentDocumentExpertEntity rentDocumentExpertEntity = super.selectById(pk);
        Long documentId = rentDocumentExpertEntity.getDocumentId();
        super.removeByIds(vos,true);
        LambdaQueryWrapper<RentDocumentExpertEntity> expertWrapper = Wrappers.lambdaQuery();
        expertWrapper.eq(RentDocumentExpertEntity::getDocumentId,documentId);
        List<RentDocumentExpertEntity> list = super.list(expertWrapper);
        return list;
    }
}
