/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.abolish.service.impl;

import cn.hutool.core.date.DateTime;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.abolish.bean.FlowEntity;
import com.ejianc.business.tender.abolish.mapper.FlowMapper;
import com.ejianc.business.tender.abolish.service.IFlowService;
import com.ejianc.business.tender.abolish.vo.FlowBidTbVO;
import com.ejianc.business.tender.abolish.vo.FlowTbVO;
import com.ejianc.business.tender.abolish.vo.FlowVO;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.equipment.vo.EquipmentInviteDetailVO;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.vo.OtherInviteDetailVO;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.prosub.bean.ProsubInviteEntity;
import com.ejianc.business.tender.prosub.service.IProsubInviteService;
import com.ejianc.business.tender.prosub.vo.ProsubInviteVO;
import com.ejianc.business.tender.rent.bean.RentInviteEntity;
import com.ejianc.business.tender.rent.service.IRentInviteService;
import com.ejianc.business.tender.rent.vo.RentInviteDetailVO;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.rmat.vo.RmatInviteDetailVO;
import com.ejianc.business.tender.stuff.bean.StuffInviteEntity;
import com.ejianc.business.tender.stuff.service.IStuffInviteService;
import com.ejianc.business.tender.stuff.vo.StuffInviteDetailVO;
import com.ejianc.business.tender.stuff.vo.TenderStageEnum;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.service.ISubInviteService;
import com.ejianc.business.tender.sub.vo.SubInviteVO;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TreeNodeBUtil;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="flowService")
public class FlowServiceImpl
extends BaseServiceImpl<FlowMapper, FlowEntity>
implements IFlowService {
    @Value(value="${gysUrl.updateBidOutUrl}")
    private String updateBidOutUrl;
    @Value(value="${gysUrl.winbidSavesUrl}")
    private String winbidSaveUrl;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private CacheManager cacheManager;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "FLOW_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IEmployeeApi iEmployeeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private FlowServiceImpl service;
    @Autowired
    private IStuffInviteService stuffInviteService;
    @Autowired
    private ISubInviteService subInviteService;
    @Autowired
    private IProsubInviteService prosubInviteService;
    @Autowired
    private IEquipmentInviteService equipmentInviteService;
    @Autowired
    private IRentInviteService rentInviteService;
    @Autowired
    private IRmatInviteService rmatInviteService;
    @Autowired
    private IOtherInviteService otherInviteService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IProcessService processService;

    @Override
    public FlowVO saveFlow(FlowVO saveorUpdateVO) {
        FlowEntity entity = (FlowEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, FlowEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        FlowVO vo = (FlowVO)BeanMapper.map((Object)((Object)entity), FlowVO.class);
        if (0 == vo.getType()) {
            this.updateStuffAbolishType(vo.getTenderId().toString(), 1, TenderStageEnum.FLOW_STATE.getTenderTypeCode());
            StuffInviteEntity stuffInviteEntity = (StuffInviteEntity)((Object)this.stuffInviteService.selectById(vo.getTenderId()));
            vo.setStuffDetail(BeanMapper.mapList(stuffInviteEntity.getStuffDetail(), StuffInviteDetailVO.class));
        } else if (1 == vo.getType()) {
            this.updateSubAbolishType(vo.getTenderId().toString(), 1, TenderStageEnum.FLOW_STATE.getTenderTypeCode());
            SubInviteEntity subInviteEntity = (SubInviteEntity)((Object)this.subInviteService.selectById(vo.getTenderId()));
            SubInviteVO subInviteVO = (SubInviteVO)BeanMapper.map((Object)((Object)subInviteEntity), SubInviteVO.class);
            vo.setSubDetail(TreeNodeBUtil.buildTree((List)subInviteVO.getSubDetailRecord()));
        } else if (6 == vo.getType()) {
            this.updateProsubAbolishType(vo.getTenderId().toString(), 1, TenderStageEnum.FLOW_STATE.getTenderTypeCode());
            ProsubInviteEntity prosubInviteEntity = (ProsubInviteEntity)((Object)this.prosubInviteService.selectById(vo.getTenderId()));
            ProsubInviteVO prosubInviteVO = (ProsubInviteVO)BeanMapper.map((Object)((Object)prosubInviteEntity), ProsubInviteVO.class);
            vo.setProsubDetail(TreeNodeBUtil.buildTree((List)prosubInviteVO.getSubDetailRecord()));
        } else if (2 == vo.getType()) {
            this.updateEquipmentAbolishType(vo.getTenderId().toString(), 1, TenderStageEnum.FLOW_STATE.getTenderTypeCode());
            EquipmentInviteEntity equipmentInviteEntity = (EquipmentInviteEntity)((Object)this.equipmentInviteService.selectById(vo.getTenderId()));
            vo.setEquipmentDetail(BeanMapper.mapList(equipmentInviteEntity.getEquipmentDetail(), EquipmentInviteDetailVO.class));
        } else if (3 == vo.getType()) {
            this.updateRentAbolishType(vo.getTenderId().toString(), 1, TenderStageEnum.FLOW_STATE.getTenderTypeCode());
            RentInviteEntity rentInviteEntity = (RentInviteEntity)((Object)this.rentInviteService.selectById(vo.getTenderId()));
            vo.setRentDetail(BeanMapper.mapList(rentInviteEntity.getRentDetail(), RentInviteDetailVO.class));
        } else if (4 == vo.getType()) {
            this.updateRmatAbolishType(vo.getTenderId().toString(), 1, TenderStageEnum.FLOW_STATE.getTenderTypeCode());
            RmatInviteEntity rmatInviteEntity = (RmatInviteEntity)((Object)this.rmatInviteService.selectById(vo.getTenderId()));
            vo.setRmatDetail(BeanMapper.mapList(rmatInviteEntity.getRmatDetail(), RmatInviteDetailVO.class));
        } else if (5 == vo.getType()) {
            this.updateOtherAbolishType(vo.getTenderId().toString(), 1, TenderStageEnum.FLOW_STATE.getTenderTypeCode());
            OtherInviteEntity otherInviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(vo.getTenderId()));
            vo.setOtherDetail(BeanMapper.mapList(otherInviteEntity.getOtherDetail(), OtherInviteDetailVO.class));
        } else {
            throw new BusinessException("\u4e0d\u5b58\u5728\u62db\u6807\u7acb\u9879\u7c7b\u578b[" + vo.getType() + "]");
        }
        return vo;
    }

    @Override
    public FlowVO queryDetail(Long id) {
        FlowEntity entity = (FlowEntity)((Object)this.service.selectById(id));
        FlowVO vo = (FlowVO)BeanMapper.map((Object)((Object)entity), FlowVO.class);
        if (0 == vo.getType()) {
            StuffInviteEntity stuffInviteEntity = (StuffInviteEntity)((Object)this.stuffInviteService.selectById(entity.getTenderId()));
            vo.setStuffDetail(BeanMapper.mapList(stuffInviteEntity.getStuffDetail(), StuffInviteDetailVO.class));
        } else if (1 == vo.getType()) {
            SubInviteEntity subInviteEntity = (SubInviteEntity)((Object)this.subInviteService.selectById(vo.getTenderId()));
            SubInviteVO subInviteVO = (SubInviteVO)BeanMapper.map((Object)((Object)subInviteEntity), SubInviteVO.class);
            vo.setSubDetail(TreeNodeBUtil.buildTree((List)subInviteVO.getSubDetailRecord()));
        } else if (6 == vo.getType()) {
            ProsubInviteEntity prosubInviteEntity = (ProsubInviteEntity)((Object)this.prosubInviteService.selectById(vo.getTenderId()));
            ProsubInviteVO prosubInviteVO = (ProsubInviteVO)BeanMapper.map((Object)((Object)prosubInviteEntity), ProsubInviteVO.class);
            vo.setProsubDetail(TreeNodeBUtil.buildTree((List)prosubInviteVO.getSubDetailRecord()));
        } else if (2 == vo.getType()) {
            EquipmentInviteEntity equipmentInviteEntity = (EquipmentInviteEntity)((Object)this.equipmentInviteService.selectById(vo.getTenderId()));
            vo.setEquipmentDetail(BeanMapper.mapList(equipmentInviteEntity.getEquipmentDetail(), EquipmentInviteDetailVO.class));
        } else if (3 == vo.getType()) {
            RentInviteEntity rentInviteEntity = (RentInviteEntity)((Object)this.rentInviteService.selectById(vo.getTenderId()));
            vo.setRentDetail(BeanMapper.mapList(rentInviteEntity.getRentDetail(), RentInviteDetailVO.class));
        } else if (4 == vo.getType()) {
            RmatInviteEntity rmatInviteEntity = (RmatInviteEntity)((Object)this.rmatInviteService.selectById(vo.getTenderId()));
            vo.setRmatDetail(BeanMapper.mapList(rmatInviteEntity.getRmatDetail(), RmatInviteDetailVO.class));
        } else if (5 == vo.getType()) {
            OtherInviteEntity otherInviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(vo.getTenderId()));
            vo.setOtherDetail(BeanMapper.mapList(otherInviteEntity.getOtherDetail(), OtherInviteDetailVO.class));
        } else {
            throw new BusinessException("\u4e0d\u5b58\u5728\u62db\u6807\u7acb\u9879\u7c7b\u578b[" + vo.getType() + "]");
        }
        return vo;
    }

    @Override
    public void deleteFlow(List<FlowVO> vos) {
        FlowEntity flowEntity = (FlowEntity)((Object)this.service.selectById(vos.get(0).getId()));
        if (0 == flowEntity.getType()) {
            this.updateStuffAbolishType(flowEntity.getTenderId().toString(), 0, flowEntity.getTenderStage());
        } else if (1 == flowEntity.getType()) {
            this.updateSubAbolishType(flowEntity.getTenderId().toString(), 0, flowEntity.getTenderStage());
        } else if (2 == flowEntity.getType()) {
            this.updateEquipmentAbolishType(flowEntity.getTenderId().toString(), 0, flowEntity.getTenderStage());
        } else if (3 == flowEntity.getType()) {
            this.updateRentAbolishType(flowEntity.getTenderId().toString(), 0, flowEntity.getTenderStage());
        } else if (4 == flowEntity.getType()) {
            this.updateRmatAbolishType(flowEntity.getTenderId().toString(), 0, flowEntity.getTenderStage());
        } else if (5 == flowEntity.getType()) {
            this.updateOtherAbolishType(flowEntity.getTenderId().toString(), 0, flowEntity.getTenderStage());
        } else {
            throw new BusinessException("\u4e0d\u5b58\u5728\u62db\u6807\u7acb\u9879\u7c7b\u578b[" + flowEntity.getType() + "]");
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
    }

    @Override
    @Transactional
    public FlowVO publishFlow(Long id) {
        FlowEntity flowEntity = (FlowEntity)((Object)this.service.selectById(id));
        FlowBidTbVO flowBidTbVO = new FlowBidTbVO();
        flowBidTbVO.setTenantId(flowEntity.getTenantId());
        flowBidTbVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u6d41\u6807\u516c\u544a");
        flowBidTbVO.setSourceId(this.objToString(flowEntity.getTenderId()));
        flowBidTbVO.setSourceProjectId(this.objToString(flowEntity.getProjectId()));
        flowBidTbVO.setProjectName(flowEntity.getProjectName());
        flowBidTbVO.setProjectCode(flowEntity.getProjectCode());
        flowBidTbVO.setSourceOrgId(this.objToString(flowEntity.getOrgId()));
        flowBidTbVO.setOrgName(flowEntity.getOrgName());
        flowBidTbVO.setSourceUnitId(this.objToString(flowEntity.getUnitId()));
        flowBidTbVO.setUnitName(flowEntity.getUnitName());
        flowBidTbVO.setMemo(flowEntity.getMemo());
        flowBidTbVO.setWinbidType(Integer.valueOf(1));
        flowBidTbVO.setType(CommonUtils.getGysType(flowEntity.getType()));
        flowBidTbVO.setTenderName(flowEntity.getTenderName());
        flowBidTbVO.setTenderType(flowEntity.getTenderType());
        flowBidTbVO.setPurchaseName(flowEntity.getPurchaseName());
        flowBidTbVO.setSourceEmployeeId(this.objToString(flowEntity.getEmployeeId()));
        flowBidTbVO.setEmployeeName(flowEntity.getEmployeeName());
        flowBidTbVO.setEmployeeMobile(flowEntity.getEmployeeMobile());
        flowBidTbVO.setPurchaseType(flowEntity.getPurchaseType());
        flowBidTbVO.setContent(flowEntity.getContent());
        flowBidTbVO.setNoticeWinbidTime(flowEntity.getApplyTime());
        flowBidTbVO.setSystemId((String)this.proSupplierApi.getEjcCloudSystemCode().getData());
        ArrayList<FlowBidTbVO> list = new ArrayList<FlowBidTbVO>();
        list.add(flowBidTbVO);
        String stringFb = JSONObject.toJSONString(list);
        CommonResponse response = null;
        try {
            response = this.systemDataPushService.exchangeDataWithUniversal(this.winbidSaveUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
            if (!response.isSuccess()) {
                throw new BusinessException("\u8c03\u7528\u53d1\u5e03\u63a5\u53e3\u62a5\u9519" + response.getMsg());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u8c03\u7528\u53d1\u5e03\u63a5\u53e3\u62a5\u9519" + response.getMsg());
        }
        flowEntity.setPublishFlag(0);
        this.service.updateById((Object)flowEntity);
        FlowVO vo = (FlowVO)BeanMapper.map((Object)((Object)flowEntity), FlowVO.class);
        return vo;
    }

    @Override
    @Transactional
    public FlowTbVO updateBidOut(Long id) {
        FlowEntity flowEntity = (FlowEntity)((Object)((FlowMapper)this.baseMapper).selectById(id));
        FlowTbVO flowTbVO = new FlowTbVO();
        flowTbVO.setSourceId(this.objToString(flowEntity.getTenderId()));
        flowTbVO.setOutReason("\u5df2\u6d41\u6807");
        flowTbVO.setType(Integer.valueOf(1));
        flowTbVO.setSystemId((String)this.proSupplierApi.getEjcCloudSystemCode().getData());
        String stringFb = JSONObject.toJSONString((Object)flowTbVO);
        CommonResponse response = null;
        try {
            response = this.systemDataPushService.exchangeDataWithUniversal(this.updateBidOutUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
            if (!response.isSuccess()) {
                throw new BusinessException("\u8c03\u7528\u6d41\u6807\u63a5\u53e3\u62a5\u9519" + response.getMsg());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u8c03\u7528\u6d41\u6807\u63a5\u53e3\u62a5\u9519" + response.getMsg());
        }
        return flowTbVO;
    }

    @Override
    @Transactional
    public FlowVO flowBid(Long tenderId) {
        FlowVO vo;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(FlowEntity::getTenderId, (Object)tenderId);
        List list = this.service.list((Wrapper)lambda);
        QueryParam param = new QueryParam();
        param.getParams().put("tenderId", new Parameter("eq", (Object)tenderId));
        param.getOrderMap().put("createTime", "desc");
        List processEntityList = this.processService.queryList(param);
        if (!CollectionUtils.isNotEmpty((Collection)processEntityList)) {
            throw new BusinessException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff01");
        }
        ProcessEntity processEntity = (ProcessEntity)((Object)processEntityList.get(0));
        int type = processEntity.getType();
        if (0 == type) {
            vo = this.saveStuffFlow(tenderId, list, processEntity);
        } else if (1 == type) {
            vo = this.saveSubFlow(tenderId, list, processEntity);
        } else if (6 == type) {
            vo = this.saveProsubFlow(tenderId, list, processEntity);
        } else if (2 == type) {
            vo = this.saveEquipmentFlow(tenderId, list, processEntity);
        } else if (3 == type) {
            vo = this.saveRentFlow(tenderId, list, processEntity);
        } else if (4 == type) {
            vo = this.saveRmatFlow(tenderId, list, processEntity);
        } else if (5 == type) {
            vo = this.saveOtherFlow(tenderId, list, processEntity);
        } else {
            throw new BusinessException("\u4e0d\u5b58\u5728\u62db\u6807\u7acb\u9879\u7c7b\u578b[" + type + "]");
        }
        return vo;
    }

    private void updateStuffAbolishType(String tenderId, Integer abolishType, Integer tenderStage) {
        this.stuffInviteService.updateAbolishType(tenderId, abolishType);
        this.stuffInviteService.updateTenderStage(tenderId, tenderStage);
    }

    private void updateSubAbolishType(String tenderId, Integer abolishType, Integer tenderStage) {
        this.subInviteService.updateAbolishType(tenderId, abolishType);
        this.subInviteService.updateTenderStage(tenderId, tenderStage);
    }

    private void updateProsubAbolishType(String tenderId, Integer abolishType, Integer tenderStage) {
        this.prosubInviteService.updateAbolishType(tenderId, abolishType);
        this.prosubInviteService.updateTenderStage(tenderId, tenderStage);
    }

    private void updateEquipmentAbolishType(String tenderId, Integer abolishType, Integer tenderStage) {
        this.equipmentInviteService.updateAbolishType(tenderId, abolishType);
        this.equipmentInviteService.updateTenderStage(tenderId, tenderStage);
    }

    private void updateRentAbolishType(String tenderId, Integer abolishType, Integer tenderStage) {
        this.rentInviteService.updateAbolishType(tenderId, abolishType);
        this.rentInviteService.updateTenderStage(tenderId, tenderStage);
    }

    private void updateRmatAbolishType(String tenderId, Integer abolishType, Integer tenderStage) {
        this.rmatInviteService.updateAbolishType(tenderId, abolishType);
        this.rmatInviteService.updateTenderStage(tenderId, tenderStage);
    }

    private void updateOtherAbolishType(String tenderId, Integer abolishType, Integer tenderStage) {
        this.otherInviteService.updateAbolishType(tenderId, abolishType);
        this.otherInviteService.updateTenderStage(tenderId, tenderStage);
    }

    private FlowVO saveStuffFlow(Long tenderId, List<FlowEntity> list, ProcessEntity processEntity) {
        FlowEntity entity = new FlowEntity();
        StuffInviteEntity stuffInviteEntity = (StuffInviteEntity)((Object)this.stuffInviteService.selectById(tenderId));
        if (stuffInviteEntity.getAbolishType() == null) {
            stuffInviteEntity.setAbolishType(0);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            entity = list.get(0);
            if (stuffInviteEntity.getAbolishType() == 1) {
                FlowVO vo = (FlowVO)BeanMapper.map((Object)((Object)entity), FlowVO.class);
                vo.setStuffDetail(BeanMapper.mapList(stuffInviteEntity.getStuffDetail(), StuffInviteDetailVO.class));
                return vo;
            }
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setStageId(processEntity.getId());
        entity.setType(processEntity.getType());
        entity.setTenderStage(stuffInviteEntity.getTenderStage());
        entity.setPurchaseName(stuffInviteEntity.getPurchaseName());
        entity.setPurchaseType(stuffInviteEntity.getPurchaseType());
        entity.setProjectId(stuffInviteEntity.getProjectId());
        entity.setProjectName(stuffInviteEntity.getProjectName());
        entity.setProjectCode(stuffInviteEntity.getProjectCode());
        entity.setTenderId(stuffInviteEntity.getId());
        entity.setTenderName(stuffInviteEntity.getTenderName());
        entity.setTenderType(stuffInviteEntity.getTenderType());
        entity.setEmployeeId(this.sessionManager.getUserContext().getEmployeeId());
        entity.setEmployeeName(this.sessionManager.getUserContext().getEmployeeName());
        entity.setEmployeeMobile(((EmployeeVO)this.iEmployeeApi.getById(this.sessionManager.getUserContext().getEmployeeId()).getData()).getMobilePhone());
        entity.setUnitId(this.sessionManager.getUserContext().getOrgId());
        entity.setUnitName(this.sessionManager.getUserContext().getOrgName());
        entity.setApplyTime((Date)new DateTime());
        entity.setOrgId(stuffInviteEntity.getOrgId());
        entity.setOrgName(stuffInviteEntity.getOrgName());
        entity.setParentOrgId(stuffInviteEntity.getParentOrgId());
        entity.setParentOrgName(stuffInviteEntity.getParentOrgName());
        this.service.saveOrUpdate((Object)entity, false);
        FlowVO vo = (FlowVO)BeanMapper.map((Object)((Object)entity), FlowVO.class);
        vo.setStuffDetail(BeanMapper.mapList(stuffInviteEntity.getStuffDetail(), StuffInviteDetailVO.class));
        return vo;
    }

    private FlowVO saveSubFlow(Long tenderId, List<FlowEntity> list, ProcessEntity processEntity) {
        FlowEntity entity = new FlowEntity();
        SubInviteEntity subInviteEntity = (SubInviteEntity)((Object)this.subInviteService.selectById(tenderId));
        if (subInviteEntity.getAbolishType() == null) {
            subInviteEntity.setAbolishType(0);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            entity = list.get(0);
            if (subInviteEntity.getAbolishType() == 1) {
                FlowVO vo = (FlowVO)BeanMapper.map((Object)((Object)entity), FlowVO.class);
                SubInviteVO subInviteVO = (SubInviteVO)BeanMapper.map((Object)((Object)subInviteEntity), SubInviteVO.class);
                vo.setSubDetail(TreeNodeBUtil.buildTree((List)subInviteVO.getSubDetailRecord()));
                return vo;
            }
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setStageId(processEntity.getId());
        entity.setType(processEntity.getType());
        entity.setTenderStage(subInviteEntity.getTenderStage());
        entity.setPurchaseType(subInviteEntity.getPurchaseType());
        entity.setProjectId(subInviteEntity.getProjectId());
        entity.setProjectName(subInviteEntity.getProjectName());
        entity.setProjectCode(subInviteEntity.getProjectCode());
        entity.setTenderId(subInviteEntity.getId());
        entity.setTenderName(subInviteEntity.getTenderName());
        entity.setTenderType(subInviteEntity.getTenderType());
        entity.setEmployeeId(this.sessionManager.getUserContext().getEmployeeId());
        entity.setEmployeeName(this.sessionManager.getUserContext().getEmployeeName());
        entity.setEmployeeMobile(((EmployeeVO)this.iEmployeeApi.getById(this.sessionManager.getUserContext().getEmployeeId()).getData()).getMobilePhone());
        entity.setUnitId(this.sessionManager.getUserContext().getOrgId());
        entity.setUnitName(this.sessionManager.getUserContext().getOrgName());
        entity.setApplyTime((Date)new DateTime());
        entity.setOrgId(subInviteEntity.getOrgId());
        entity.setOrgName(subInviteEntity.getOrgName());
        entity.setParentOrgId(subInviteEntity.getParentOrgId());
        entity.setParentOrgName(subInviteEntity.getParentOrgName());
        this.service.saveOrUpdate((Object)entity, false);
        FlowVO vo = (FlowVO)BeanMapper.map((Object)((Object)entity), FlowVO.class);
        SubInviteVO subInviteVO = (SubInviteVO)BeanMapper.map((Object)((Object)subInviteEntity), SubInviteVO.class);
        vo.setSubDetail(TreeNodeBUtil.buildTree((List)subInviteVO.getSubDetailRecord()));
        return vo;
    }

    private FlowVO saveProsubFlow(Long tenderId, List<FlowEntity> list, ProcessEntity processEntity) {
        FlowEntity entity = new FlowEntity();
        ProsubInviteEntity prosubInviteEntity = (ProsubInviteEntity)((Object)this.prosubInviteService.selectById(tenderId));
        if (prosubInviteEntity.getAbolishType() == null) {
            prosubInviteEntity.setAbolishType(0);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            entity = list.get(0);
            if (prosubInviteEntity.getAbolishType() == 1) {
                FlowVO vo = (FlowVO)BeanMapper.map((Object)((Object)entity), FlowVO.class);
                ProsubInviteVO prosubInviteVO = (ProsubInviteVO)BeanMapper.map((Object)((Object)prosubInviteEntity), ProsubInviteVO.class);
                vo.setProsubDetail(TreeNodeBUtil.buildTree((List)prosubInviteVO.getSubDetailRecord()));
                return vo;
            }
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setStageId(processEntity.getId());
        entity.setType(processEntity.getType());
        entity.setTenderStage(prosubInviteEntity.getTenderStage());
        entity.setPurchaseType(prosubInviteEntity.getPurchaseType());
        entity.setProjectId(prosubInviteEntity.getProjectId());
        entity.setProjectName(prosubInviteEntity.getProjectName());
        entity.setProjectCode(prosubInviteEntity.getProjectCode());
        entity.setTenderId(prosubInviteEntity.getId());
        entity.setTenderName(prosubInviteEntity.getTenderName());
        entity.setTenderType(prosubInviteEntity.getTenderType());
        entity.setEmployeeId(this.sessionManager.getUserContext().getEmployeeId());
        entity.setEmployeeName(this.sessionManager.getUserContext().getEmployeeName());
        entity.setEmployeeMobile(((EmployeeVO)this.iEmployeeApi.getById(this.sessionManager.getUserContext().getEmployeeId()).getData()).getMobilePhone());
        entity.setUnitId(this.sessionManager.getUserContext().getOrgId());
        entity.setUnitName(this.sessionManager.getUserContext().getOrgName());
        entity.setApplyTime((Date)new DateTime());
        entity.setOrgId(prosubInviteEntity.getOrgId());
        entity.setOrgName(prosubInviteEntity.getOrgName());
        entity.setParentOrgId(prosubInviteEntity.getParentOrgId());
        entity.setParentOrgName(prosubInviteEntity.getParentOrgName());
        this.service.saveOrUpdate((Object)entity, false);
        FlowVO vo = (FlowVO)BeanMapper.map((Object)((Object)entity), FlowVO.class);
        ProsubInviteVO subInviteVO = (ProsubInviteVO)BeanMapper.map((Object)((Object)prosubInviteEntity), ProsubInviteVO.class);
        vo.setProsubDetail(TreeNodeBUtil.buildTree((List)subInviteVO.getSubDetailRecord()));
        return vo;
    }

    private FlowVO saveEquipmentFlow(Long tenderId, List<FlowEntity> list, ProcessEntity processEntity) {
        FlowEntity entity = new FlowEntity();
        EquipmentInviteEntity equipmentInviteEntity = (EquipmentInviteEntity)((Object)this.equipmentInviteService.selectById(tenderId));
        if (equipmentInviteEntity.getAbolishType() == null) {
            equipmentInviteEntity.setAbolishType(0);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            entity = list.get(0);
            if (equipmentInviteEntity.getAbolishType() == 1) {
                FlowVO vo = (FlowVO)BeanMapper.map((Object)((Object)entity), FlowVO.class);
                vo.setEquipmentDetail(BeanMapper.mapList(equipmentInviteEntity.getEquipmentDetail(), EquipmentInviteDetailVO.class));
                return vo;
            }
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setStageId(processEntity.getId());
        entity.setType(processEntity.getType());
        entity.setTenderStage(equipmentInviteEntity.getTenderStage());
        entity.setPurchaseName(equipmentInviteEntity.getPurchaseName());
        entity.setPurchaseType(equipmentInviteEntity.getPurchaseType());
        entity.setProjectId(equipmentInviteEntity.getProjectId());
        entity.setProjectName(equipmentInviteEntity.getProjectName());
        entity.setProjectCode(equipmentInviteEntity.getProjectCode());
        entity.setTenderId(equipmentInviteEntity.getId());
        entity.setTenderName(equipmentInviteEntity.getTenderName());
        entity.setTenderType(equipmentInviteEntity.getTenderType());
        entity.setEmployeeId(this.sessionManager.getUserContext().getEmployeeId());
        entity.setEmployeeName(this.sessionManager.getUserContext().getEmployeeName());
        entity.setEmployeeMobile(((EmployeeVO)this.iEmployeeApi.getById(this.sessionManager.getUserContext().getEmployeeId()).getData()).getMobilePhone());
        entity.setUnitId(this.sessionManager.getUserContext().getOrgId());
        entity.setUnitName(this.sessionManager.getUserContext().getOrgName());
        entity.setApplyTime((Date)new DateTime());
        entity.setOrgId(equipmentInviteEntity.getOrgId());
        entity.setOrgName(equipmentInviteEntity.getOrgName());
        entity.setParentOrgId(equipmentInviteEntity.getParentOrgId());
        entity.setParentOrgName(equipmentInviteEntity.getParentOrgName());
        this.service.saveOrUpdate((Object)entity, false);
        FlowVO vo = (FlowVO)BeanMapper.map((Object)((Object)entity), FlowVO.class);
        vo.setEquipmentDetail(BeanMapper.mapList(equipmentInviteEntity.getEquipmentDetail(), EquipmentInviteDetailVO.class));
        return vo;
    }

    private FlowVO saveRentFlow(Long tenderId, List<FlowEntity> list, ProcessEntity processEntity) {
        FlowEntity entity = new FlowEntity();
        RentInviteEntity rentInviteEntity = (RentInviteEntity)((Object)this.rentInviteService.selectById(tenderId));
        if (rentInviteEntity.getAbolishType() == null) {
            rentInviteEntity.setAbolishType(0);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            entity = list.get(0);
            if (rentInviteEntity.getAbolishType() == 1) {
                FlowVO vo = (FlowVO)BeanMapper.map((Object)((Object)entity), FlowVO.class);
                vo.setRentDetail(BeanMapper.mapList(rentInviteEntity.getRentDetail(), RentInviteDetailVO.class));
                return vo;
            }
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setStageId(processEntity.getId());
        entity.setType(processEntity.getType());
        entity.setTenderStage(rentInviteEntity.getTenderStage());
        entity.setPurchaseName(rentInviteEntity.getPurchaseName());
        entity.setPurchaseType(rentInviteEntity.getPurchaseType());
        entity.setProjectId(rentInviteEntity.getProjectId());
        entity.setProjectName(rentInviteEntity.getProjectName());
        entity.setProjectCode(rentInviteEntity.getProjectCode());
        entity.setTenderId(rentInviteEntity.getId());
        entity.setTenderName(rentInviteEntity.getTenderName());
        entity.setTenderType(rentInviteEntity.getTenderType());
        entity.setEmployeeId(this.sessionManager.getUserContext().getEmployeeId());
        entity.setEmployeeName(this.sessionManager.getUserContext().getEmployeeName());
        entity.setEmployeeMobile(((EmployeeVO)this.iEmployeeApi.getById(this.sessionManager.getUserContext().getEmployeeId()).getData()).getMobilePhone());
        entity.setUnitId(this.sessionManager.getUserContext().getOrgId());
        entity.setUnitName(this.sessionManager.getUserContext().getOrgName());
        entity.setApplyTime((Date)new DateTime());
        entity.setOrgId(rentInviteEntity.getOrgId());
        entity.setOrgName(rentInviteEntity.getOrgName());
        entity.setParentOrgId(rentInviteEntity.getParentOrgId());
        entity.setParentOrgName(rentInviteEntity.getParentOrgName());
        this.service.saveOrUpdate((Object)entity, false);
        FlowVO vo = (FlowVO)BeanMapper.map((Object)((Object)entity), FlowVO.class);
        vo.setRentDetail(BeanMapper.mapList(rentInviteEntity.getRentDetail(), RentInviteDetailVO.class));
        return vo;
    }

    private FlowVO saveRmatFlow(Long tenderId, List<FlowEntity> list, ProcessEntity processEntity) {
        FlowEntity entity = new FlowEntity();
        RmatInviteEntity rmatInviteEntity = (RmatInviteEntity)((Object)this.rmatInviteService.selectById(tenderId));
        if (rmatInviteEntity.getAbolishType() == null) {
            rmatInviteEntity.setAbolishType(0);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            entity = list.get(0);
            if (rmatInviteEntity.getAbolishType() == 1) {
                FlowVO vo = (FlowVO)BeanMapper.map((Object)((Object)entity), FlowVO.class);
                vo.setRmatDetail(BeanMapper.mapList(rmatInviteEntity.getRmatDetail(), RmatInviteDetailVO.class));
                return vo;
            }
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setStageId(processEntity.getId());
        entity.setType(processEntity.getType());
        entity.setTenderStage(rmatInviteEntity.getTenderStage());
        entity.setPurchaseName(rmatInviteEntity.getPurchaseName());
        entity.setPurchaseType(rmatInviteEntity.getPurchaseType());
        entity.setProjectId(rmatInviteEntity.getProjectId());
        entity.setProjectName(rmatInviteEntity.getProjectName());
        entity.setProjectCode(rmatInviteEntity.getProjectCode());
        entity.setTenderId(rmatInviteEntity.getId());
        entity.setTenderName(rmatInviteEntity.getTenderName());
        entity.setTenderType(rmatInviteEntity.getTenderType());
        entity.setEmployeeId(this.sessionManager.getUserContext().getEmployeeId());
        entity.setEmployeeName(this.sessionManager.getUserContext().getEmployeeName());
        entity.setEmployeeMobile(((EmployeeVO)this.iEmployeeApi.getById(this.sessionManager.getUserContext().getEmployeeId()).getData()).getMobilePhone());
        entity.setUnitId(this.sessionManager.getUserContext().getOrgId());
        entity.setUnitName(this.sessionManager.getUserContext().getOrgName());
        entity.setApplyTime((Date)new DateTime());
        entity.setOrgId(rmatInviteEntity.getOrgId());
        entity.setOrgName(rmatInviteEntity.getOrgName());
        entity.setParentOrgId(rmatInviteEntity.getParentOrgId());
        entity.setParentOrgName(rmatInviteEntity.getParentOrgName());
        this.service.saveOrUpdate((Object)entity, false);
        FlowVO vo = (FlowVO)BeanMapper.map((Object)((Object)entity), FlowVO.class);
        vo.setRmatDetail(BeanMapper.mapList(rmatInviteEntity.getRmatDetail(), RmatInviteDetailVO.class));
        return vo;
    }

    private FlowVO saveOtherFlow(Long tenderId, List<FlowEntity> list, ProcessEntity processEntity) {
        FlowEntity entity = new FlowEntity();
        OtherInviteEntity otherInviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(tenderId));
        if (otherInviteEntity.getAbolishType() == null) {
            otherInviteEntity.setAbolishType(0);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            entity = list.get(0);
            if (otherInviteEntity.getAbolishType() == 1) {
                FlowVO vo = (FlowVO)BeanMapper.map((Object)((Object)entity), FlowVO.class);
                vo.setOtherDetail(BeanMapper.mapList(otherInviteEntity.getOtherDetail(), OtherInviteDetailVO.class));
                return vo;
            }
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setStageId(processEntity.getId());
        entity.setType(processEntity.getType());
        entity.setTenderStage(otherInviteEntity.getTenderStage());
        entity.setPurchaseName(otherInviteEntity.getPurchaseName());
        entity.setPurchaseType(otherInviteEntity.getPurchaseType());
        entity.setProjectId(otherInviteEntity.getProjectId());
        entity.setProjectName(otherInviteEntity.getProjectName());
        entity.setProjectCode(otherInviteEntity.getProjectCode());
        entity.setTenderId(otherInviteEntity.getId());
        entity.setTenderName(otherInviteEntity.getTenderName());
        entity.setTenderType(otherInviteEntity.getTenderType());
        entity.setEmployeeId(this.sessionManager.getUserContext().getEmployeeId());
        entity.setEmployeeName(this.sessionManager.getUserContext().getEmployeeName());
        entity.setEmployeeMobile(((EmployeeVO)this.iEmployeeApi.getById(this.sessionManager.getUserContext().getEmployeeId()).getData()).getMobilePhone());
        entity.setUnitId(this.sessionManager.getUserContext().getOrgId());
        entity.setUnitName(this.sessionManager.getUserContext().getOrgName());
        entity.setApplyTime((Date)new DateTime());
        entity.setOrgId(otherInviteEntity.getOrgId());
        entity.setOrgName(otherInviteEntity.getOrgName());
        entity.setParentOrgId(otherInviteEntity.getParentOrgId());
        entity.setParentOrgName(otherInviteEntity.getParentOrgName());
        this.service.saveOrUpdate((Object)entity, false);
        FlowVO vo = (FlowVO)BeanMapper.map((Object)((Object)entity), FlowVO.class);
        vo.setOtherDetail(BeanMapper.mapList(otherInviteEntity.getOtherDetail(), OtherInviteDetailVO.class));
        return vo;
    }

    private String objToString(Object obj) {
        if (obj == null) {
            return null;
        }
        return String.valueOf(obj);
    }
}

