/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.equipment.controller;

import com.ejianc.business.tender.equipment.bean.EquipmentBidEntity;
import com.ejianc.business.tender.equipment.service.IEquipmentBidService;
import com.ejianc.business.tender.equipment.vo.EquipmentBidVO;
import com.ejianc.business.tender.equipment.vo.EquipmentPicketageSupplierVO;
import com.ejianc.business.tender.equipment.vo.EquipmentPicketageVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"equipmentBid"})
@Api(value="\u4e2d\u6807\u4e3b\u8868", tags={"\u4e2d\u6807\u4e3b\u8868"})
public class EquipmentBidController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "invite-bid-code";
    @Autowired
    private IEquipmentBidService service;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<EquipmentBidVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody EquipmentBidVO saveorUpdateVO) {
        EquipmentBidEntity entity = (EquipmentBidEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, EquipmentBidEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        EquipmentBidVO vo = (EquipmentBidVO)BeanMapper.map((Object)((Object)entity), EquipmentBidVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u751f\u6210\u4e2d\u6807\u901a\u77e5\u4e66\u63a5\u53e3")
    @RequestMapping(value={"/saveBid"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<EquipmentBidVO> saveBid(@RequestParam Long picketageId) {
        EquipmentBidVO equipmentBidVO = this.service.saveBid(picketageId);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)equipmentBidVO);
    }

    @ApiOperation(value="\u65b0\u589e\u8fdb\u5c55\u63a5\u53e3")
    @RequestMapping(value={"/insertProcess"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<EquipmentPicketageVO> insertProcess(@RequestParam Long picketageId) {
        EquipmentPicketageVO equipmentPicketageVO = this.service.insertProcess(picketageId);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)equipmentPicketageVO);
    }

    @ApiOperation(value="\u4e2d\u6807\u516c\u544a\u4e0b\u4e00\u6b65\u63a5\u53e3")
    @RequestMapping(value={"/nextPaper"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<EquipmentBidVO> nextPaper(@RequestParam Long winnoticeId) {
        EquipmentBidVO equipmentBidVO = this.service.nextPaper(winnoticeId);
        return CommonResponse.success((String)"\u521d\u59cb\u5316\u57fa\u7840\u6570\u636e\u6210\u529f\uff01", (Object)equipmentBidVO);
    }

    @ApiOperation(value="\u53d1\u5e03\u63a5\u53e3")
    @RequestMapping(value={"/publishBid"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<EquipmentBidVO> publishBid(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody EquipmentBidVO saveorUpdateVO) {
        EquipmentBidVO equipmentBidVO = this.service.publishBid(saveorUpdateVO);
        return CommonResponse.success((String)"\u53d1\u5e03\u6210\u529f\uff01", (Object)equipmentBidVO);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<EquipmentPicketageSupplierVO>> querySupplierDetail(@RequestParam Long id) {
        List<EquipmentPicketageSupplierVO> list = this.service.querySupplierDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", list);
    }

    @ApiOperation(value="\u5b9a\u6807\u4e0b\u4e00\u6b65\u67e5\u8be2\u8be6\u60c5\u63a5\u53e3")
    @RequestMapping(value={"/queryDbDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<EquipmentBidVO> queryDbDetail(@RequestParam Long picketage) {
        EquipmentBidVO equipmentBidVO = this.service.queryDbDetail(picketage);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)equipmentBidVO);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EquipmentBidVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

