/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.other.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.business.tender.other.bean.OtherBatPlanEntity;
import com.ejianc.business.tender.other.mapper.OtherBatPlanMapper;
import com.ejianc.business.tender.other.service.IOtherBatPlanDetailService;
import com.ejianc.business.tender.other.service.IOtherBatPlanService;
import com.ejianc.business.tender.other.vo.OtherBatPlanDetailVO;
import com.ejianc.business.tender.other.vo.OtherBatPlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="otherBatPlanService")
public class OtherBatPlanServiceImpl
extends BaseServiceImpl<OtherBatPlanMapper, OtherBatPlanEntity>
implements IOtherBatPlanService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CONDITION_TRUSTEES_ID = "employeeId";
    private static final String CONDITION_PROJECT_ID = "projectId";
    private static final String CONDITION_ORG_ID = "orgId";
    private static final String PURCHASE_TYPE = "purchaseType";
    private static final String UNIT_ID = "unitId";
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IOtherBatPlanDetailService detailService;

    @Override
    public IPage<OtherBatPlanVO> refOtherBatPlanData(QueryParam param, String condition, String searchObject) {
        IPage<OtherBatPlanVO> pageData;
        this.setDefaultParam(param);
        param.getParams().put("planState", new Parameter("eq", (Object)BatPlanEnum.PLAN_STATE_WAIT.getPlanState()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        if (StringUtils.isNotEmpty((CharSequence)searchObject)) {
            param.setSearchObject(null);
            JSONObject searchJson = JSONObject.parseObject((String)searchObject);
            this.logger.info("\u53c2\u7167\u67e5\u8be2searchObject\uff1a\u3010{}\u3011", (Object)searchJson);
            if (searchJson != null && !searchJson.isEmpty()) {
                for (Map.Entry entry : searchJson.entrySet()) {
                    param.getParams().put(entry.getKey(), new Parameter("like", entry.getValue()));
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            this.logger.info("\u53c2\u7167\u67e5\u8be2condition\uff1a\u3010{}\u3011", (Object)_con);
            if (_con.containsKey((Object)CONDITION_TRUSTEES_ID)) {
                param.getParams().put("trusteesId", new Parameter("eq", _con.get((Object)CONDITION_TRUSTEES_ID)));
            }
            if (_con.containsKey((Object)CONDITION_PROJECT_ID)) {
                Long projectId = Long.parseLong(_con.get((Object)CONDITION_PROJECT_ID).toString());
                CommonResponse projectResponse = this.projectPoolApi.queryProjectIdsByParentProjectId(projectId);
                if (!projectResponse.isSuccess()) {
                    throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
                }
                param.getParams().put(CONDITION_PROJECT_ID, new Parameter("in", projectResponse.getData()));
            }
            if (_con.containsKey((Object)CONDITION_ORG_ID)) {
                Long orgId = Long.valueOf(_con.get((Object)CONDITION_ORG_ID).toString());
                CommonResponse orgResp = this.iOrgApi.getOneById(orgId);
                OrgVO orgVO = (OrgVO)orgResp.getData();
                if (OrgVO.ORG_TYPE_DEPARTMENT.equals(orgVO.getOrgType())) {
                    param.getParams().put(CONDITION_ORG_ID, new Parameter("eq", (Object)orgId));
                } else {
                    param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
                }
            }
            if (_con.containsKey((Object)PURCHASE_TYPE)) {
                param.getParams().put(PURCHASE_TYPE, new Parameter("eq", _con.get((Object)PURCHASE_TYPE)));
            }
            if (_con.containsKey((Object)UNIT_ID)) {
                param.getParams().put(UNIT_ID, new Parameter("eq", _con.get((Object)UNIT_ID)));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(pageData = this.queryBatPlanVO(param)).getRecords())) {
            List OtherBatPlanVOS = pageData.getRecords();
            List idList = OtherBatPlanVOS.stream().map(BaseVO::getId).map(String::valueOf).collect(Collectors.toList());
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("planId", new Parameter("in", idList));
            List detailEntityList = this.detailService.queryList(detailParam);
            List detailVOList = BeanMapper.mapList((Iterable)detailEntityList, OtherBatPlanDetailVO.class);
            HashMap detailMap = new HashMap();
            for (OtherBatPlanDetailVO vo : detailVOList) {
                if (detailMap.containsKey(vo.getPlanId())) {
                    ((List)detailMap.get(vo.getPlanId())).add(vo);
                    continue;
                }
                ArrayList<OtherBatPlanDetailVO> mapList = new ArrayList<OtherBatPlanDetailVO>();
                mapList.add(vo);
                detailMap.put(vo.getPlanId(), mapList);
            }
            OtherBatPlanVOS.forEach(OtherBatPlanVO2 -> OtherBatPlanVO2.setOtherDetailRecord((List)detailMap.get(OtherBatPlanVO2.getId())));
        }
        return pageData;
    }

    private void setDefaultParam(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("planName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("trusteesName");
        fuzzyFields.add("purchaseName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        CommonResponse orgResponse = this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List orgVOList = (List)orgResponse.getData();
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put(CONDITION_ORG_ID, new Parameter("in", departmentIds));
        }
    }

    private IPage<OtherBatPlanVO> queryBatPlanVO(QueryParam param) {
        IPage page = super.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List OtherBatPlanVOS = BeanMapper.mapList((Iterable)page.getRecords(), OtherBatPlanVO.class);
        pageData.setRecords(OtherBatPlanVOS);
        return pageData;
    }

    @Override
    public void updateBatPlanByQuoteType(List<String> idList, Integer planState, Integer establishType) {
        List entityList;
        if (StringUtils.isEmpty((CharSequence)BatPlanEnum.getDescriptionByStateCode((Integer)planState))) {
            throw new BusinessException("\u8ba1\u5212\u72b6\u6001\u9519\u8bef");
        }
        if (CollectionUtils.isNotEmpty(idList) && CollectionUtils.isNotEmpty((Collection)(entityList = (List)super.listByIds(idList)))) {
            for (OtherBatPlanEntity entity : entityList) {
                if (establishType == 0 && BatPlanEnum.PLAN_STATE_OVER.getPlanState().equals(entity.getPlanState())) {
                    this.logger.info("\u91c7\u8d2d\u8ba1\u5212\u7f16\u7801\u3010{}\u3011\u8ba1\u5212\u540d\u79f0\u3010{}\u3011\u5df2\u91c7\u8d2d\u5b8c\u6210\uff01", (Object)entity.getBillCode(), (Object)entity.getPlanName());
                    throw new BusinessException("\u91c7\u8d2d\u8ba1\u5212\u7f16\u7801\u3010" + entity.getBillCode() + "\u3011\u8ba1\u5212\u540d\u79f0\u3010" + entity.getPlanName() + "\u3011\u5df2\u91c7\u8d2d\u5b8c\u6210\uff01");
                }
                entity.setPlanState(planState);
            }
            super.saveOrUpdateBatch((Collection)entityList);
        }
    }
}

