/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.other.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.business.tender.other.bean.OtherInviteDetailEntity;
import com.ejianc.business.tender.other.bean.OtherInviteDetailRecordEntity;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.bean.OtherPicketageRefsupplierEntity;
import com.ejianc.business.tender.other.service.IOtherBatPlanService;
import com.ejianc.business.tender.other.service.IOtherInviteDetailService;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.service.IOtherPicketageRefsupplierService;
import com.ejianc.business.tender.other.vo.OtherInviteDetailBidderVO;
import com.ejianc.business.tender.stuff.vo.TenderStageEnum;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="otherInvite")
public class OtherInviteBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IOtherInviteService service;
    @Autowired
    private IOtherInviteDetailService detailService;
    @Autowired
    private IOtherPicketageRefsupplierService picketageRefsupplierService;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IOtherBatPlanService otherBatPlanService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        if (BillStateEnum.COMMITED_STATE.getBillStateCode() == state || BillStateEnum.PASSED_STATE.getBillStateCode() == state) {
            OtherInviteEntity inviteEntity = (OtherInviteEntity)((Object)this.service.selectById(billId));
            if (inviteEntity.getEstablishType() == 1 && CollectionUtils.isNotEmpty(inviteEntity.getOtherDetailRecord())) {
                List<String> planIdList = inviteEntity.getOtherDetailRecord().stream().map(OtherInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct().collect(Collectors.toList());
                this.otherBatPlanService.updateBatPlanByQuoteType(planIdList, BatPlanEnum.PLAN_STATE_OVER.getPlanState(), 1);
            }
            List<OtherInviteDetailRecordEntity> otherDetailRecord = inviteEntity.getOtherDetailRecord();
            for (OtherInviteDetailRecordEntity detailRecordEntity : otherDetailRecord) {
                this.detailService.saveOrUpdate(BeanMapper.map((Object)((Object)detailRecordEntity), OtherInviteDetailEntity.class));
            }
            List<OtherInviteDetailBidderVO> detailBidderList = this.service.selectDetailBidder(billId);
            String tenderUnitNum = "";
            for (OtherInviteDetailBidderVO detailBidderVO : detailBidderList) {
                OtherPicketageRefsupplierEntity otherPicketageRefsupplierEntity = new OtherPicketageRefsupplierEntity();
                otherPicketageRefsupplierEntity.setPicketageId(billId);
                otherPicketageRefsupplierEntity.setPicketageName(inviteEntity.getTenderName() + "\u5b9a\u6807");
                otherPicketageRefsupplierEntity.setPicketageDate(new Date());
                otherPicketageRefsupplierEntity.setMoney(detailBidderVO.getSumMoney());
                otherPicketageRefsupplierEntity.setMoneyTax(detailBidderVO.getSumTaxMoney());
                otherPicketageRefsupplierEntity.setSupplierId(detailBidderVO.getSupplierId());
                otherPicketageRefsupplierEntity.setSupplierName(detailBidderVO.getSupplierName());
                otherPicketageRefsupplierEntity.setProjectId(inviteEntity.getProjectId());
                otherPicketageRefsupplierEntity.setProjectName(inviteEntity.getProjectName());
                otherPicketageRefsupplierEntity.setProjectCode(inviteEntity.getProjectCode());
                otherPicketageRefsupplierEntity.setOrgId(inviteEntity.getOrgId());
                otherPicketageRefsupplierEntity.setOrgName(inviteEntity.getOrgName());
                otherPicketageRefsupplierEntity.setParentOrgId(inviteEntity.getParentOrgId());
                otherPicketageRefsupplierEntity.setParentOrgName(inviteEntity.getParentOrgName());
                otherPicketageRefsupplierEntity.setOccupyFlag(0);
                otherPicketageRefsupplierEntity.setPicketageFlag(1);
                otherPicketageRefsupplierEntity.setSignStatus(0);
                otherPicketageRefsupplierEntity.setPurchaseType(inviteEntity.getPurchaseType());
                this.picketageRefsupplierService.saveOrUpdate((Object)otherPicketageRefsupplierEntity);
                BigDecimal sumNum = detailBidderVO.getSumNum().setScale(4, 4);
                tenderUnitNum = tenderUnitNum + detailBidderVO.getSupplierName() + "(" + sumNum + "),";
            }
            if (tenderUnitNum.length() > 1) {
                tenderUnitNum = tenderUnitNum.substring(0, tenderUnitNum.length() - 1);
            }
            inviteEntity.setTenderUnitNum(tenderUnitNum);
            this.service.saveOrUpdate((Object)inviteEntity);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OtherInviteEntity inviteEntity = (OtherInviteEntity)((Object)this.service.selectById(billId));
        if (inviteEntity.getOccupyState() != null && inviteEntity.getOccupyState() == 1) {
            return CommonResponse.error((String)"\u62db\u6807\u5df2\u88ab\u5360\u7528,\u4e0d\u80fd\u64a4\u56de!");
        }
        if (inviteEntity.getTenderStage() > 1) {
            return CommonResponse.error((String)("\u62db\u6807\u5904\u4e8e" + TenderStageEnum.getEnumByStateCode((Integer)inviteEntity.getTenderStage()).getDescription() + ",\u4e0d\u80fd\u64a4\u56de!"));
        }
        if (inviteEntity.getEstablishType() == 1) {
            QueryWrapper refWrapper = new QueryWrapper();
            refWrapper.eq((Object)"picketage_id", (Object)inviteEntity.getId());
            List refsupplierEntityList = this.picketageRefsupplierService.list((Wrapper)refWrapper);
            for (OtherPicketageRefsupplierEntity refsupplierEntity : refsupplierEntityList) {
                if (refsupplierEntity.getSignStatus() == 0) continue;
                return CommonResponse.error((String)"\u5b58\u5728\u5df2\u7b7e\u8ba2\u5408\u540c,\u4e0d\u80fd\u64a4\u56de!");
            }
            this.picketageRefsupplierService.remove((Wrapper)refWrapper);
        }
        this.detailService.delByInviteId(inviteEntity.getId());
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OtherInviteEntity inviteEntity = (OtherInviteEntity)((Object)this.service.selectById(billId));
        if (inviteEntity.getEstablishType() == 1 && CollectionUtils.isNotEmpty(inviteEntity.getOtherDetailRecord())) {
            List<String> planIdList = inviteEntity.getOtherDetailRecord().stream().map(OtherInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct().collect(Collectors.toList());
            this.otherBatPlanService.updateBatPlanByQuoteType(planIdList, BatPlanEnum.PLAN_STATE_OVER.getPlanState(), 1);
        }
        return CommonResponse.success();
    }

    public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other) {
        JSONArray arr = new JSONArray();
        this.logger.info("sign:{}", (Object)sign);
        if ("choseCostUser".equals(sign)) {
            OtherInviteEntity entity = (OtherInviteEntity)((Object)this.service.selectById(billId));
            Long projectId = entity.getProjectId();
            JSONObject jsonObject = new JSONObject();
            CommonResponse commonResponse = this.projectPoolApi.queryProjectPoolById(projectId);
            if (!commonResponse.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u5931\u8d25!");
            }
            JSONArray array = (JSONArray)commonResponse.getData();
            List vos = JSONObject.parseArray((String)array.toJSONString(), ProjectPoolSetVO.class);
            this.logger.info("vos:{}", (Object)JSONObject.toJSONString((Object)vos));
            ProjectPoolSetVO vo = (ProjectPoolSetVO)vos.get(0);
            Long costAdapter = vo.getCostAdapter();
            String costAdapterName = vo.getCostAdapterName();
            this.logger.info("userId:{}", (Object)costAdapter);
            this.logger.info("userName:{}", (Object)costAdapterName);
            jsonObject.put("userId", (Object)costAdapter);
            jsonObject.put("userName", (Object)costAdapterName);
            arr.add((Object)jsonObject);
        }
        return CommonResponse.success((Object)arr);
    }
}

