/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingEntity;
import com.ejianc.business.tender.expert.mapper.ExpertRecordMapper;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingService;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.sub.bean.SubDocumentEntity;
import com.ejianc.business.tender.sub.bean.SubDocumentSchemeEntity;
import com.ejianc.business.tender.sub.bean.SubDocumentSellEntity;
import com.ejianc.business.tender.sub.bean.SubDocumentSupplierEntity;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.bean.SubPicketageEntity;
import com.ejianc.business.tender.sub.bean.SubPicketageSupplierEntity;
import com.ejianc.business.tender.sub.bean.SubTalkEntity;
import com.ejianc.business.tender.sub.mapper.SubDocumentSchemeMapper;
import com.ejianc.business.tender.sub.mapper.SubPicketageMapper;
import com.ejianc.business.tender.sub.service.ISubDocumentSchemeService;
import com.ejianc.business.tender.sub.service.ISubDocumentSellService;
import com.ejianc.business.tender.sub.service.ISubDocumentService;
import com.ejianc.business.tender.sub.service.ISubDocumentSupplierService;
import com.ejianc.business.tender.sub.service.ISubInviteService;
import com.ejianc.business.tender.sub.service.ISubPicketageService;
import com.ejianc.business.tender.sub.service.ISubPicketageSupplierService;
import com.ejianc.business.tender.sub.service.ISubTalkService;
import com.ejianc.business.tender.sub.vo.SubDocumentDetailVO;
import com.ejianc.business.tender.sub.vo.SubDocumentSellVO;
import com.ejianc.business.tender.sub.vo.SubDocumentVO;
import com.ejianc.business.tender.sub.vo.SubPicketageSupplierVO;
import com.ejianc.business.tender.sub.vo.SubPicketageVO;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="subPicketageService")
public class SubPicketageServiceImpl
extends BaseServiceImpl<SubPicketageMapper, SubPicketageEntity>
implements ISubPicketageService {
    private static final String BILL_CODE = "SUB_PICKETAGE_CODE";
    @Autowired
    private IExpertEvaluatingService IExpertEvaluatingService;
    @Autowired
    private ISubInviteService subInviteService;
    @Autowired
    private ISubDocumentService subDocumentService;
    @Autowired
    private ISubDocumentSellService subDocumentSellService;
    @Autowired
    private ISubDocumentSchemeService subDocumentSchemeService;
    @Autowired
    private ISubDocumentSupplierService subDocumentSupplierService;
    @Autowired
    private SubDocumentSchemeMapper schemeMapper;
    @Autowired
    private IProcessService processService;
    @Autowired
    private ISubTalkService subTalkService;
    @Autowired
    private ISubPicketageSupplierService subPicketageSupplierService;
    @Autowired
    private ExpertRecordMapper recordMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmployeeApi employeeApi;

    @Override
    public SubPicketageVO savePicketage(Long evaluationId) {
        SubPicketageEntity entity = new SubPicketageEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        ExpertEvaluatingEntity subEvaluationEntity = (ExpertEvaluatingEntity)((Object)this.IExpertEvaluatingService.selectById(evaluationId));
        SubInviteEntity inviteEntity = (SubInviteEntity)((Object)this.subInviteService.selectById(subEvaluationEntity.getInviteId()));
        SubDocumentEntity subDocumentEntity = (SubDocumentEntity)((Object)this.subDocumentService.selectById(subEvaluationEntity.getDocumentId()));
        entity.setPicketageName(inviteEntity.getTenderName() + "\u5b9a\u6807");
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setEmployeeId(subDocumentEntity.getEmployeeId());
        entity.setEmployeeName(subDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(subDocumentEntity.getEmployeeMobile());
        entity.setValueType(subDocumentEntity.getValueType());
        SubInviteEntity subInviteEntity = (SubInviteEntity)((Object)this.subInviteService.selectById(subDocumentEntity.getInviteId()));
        entity.setDocumentId(subEvaluationEntity.getDocumentId());
        entity.setEvaluationId(subEvaluationEntity.getId());
        entity.setInviteId(subEvaluationEntity.getInviteId());
        entity.setGatherReason(subEvaluationEntity.getGatherReason());
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(this.sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(this.sessionManager.getUserContext().getEmployeeName());
        String mobilePhone = ((EmployeeVO)this.employeeApi.getById(this.sessionManager.getUserContext().getEmployeeId()).getData()).getMobilePhone();
        entity.setTrusteesPhone(mobilePhone);
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode((Integer)inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(1));
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());
        super.saveOrUpdate((Object)entity, false);
        SubPicketageVO vo = (SubPicketageVO)BeanMapper.map((Object)((Object)entity), SubPicketageVO.class);
        subInviteEntity.setTenderStage(5);
        this.subInviteService.updateById((Object)subInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u5b9a\u6807");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(1);
        processEntity.setFrontendUrl("sub/picketage");
        this.processService.saveOrUpdate((Object)processEntity);
        List<SubDocumentSchemeEntity> schemeList = this.schemeMapper.selectSupplier(subDocumentEntity.getId());
        for (SubDocumentSchemeEntity schemeEntity : schemeList) {
            BigDecimal score = this.recordMapper.selectScore(schemeEntity.getId(), schemeEntity.getSupplierId(), subDocumentEntity.getId());
            Boolean scoreBoolean = this.schemeMapper.updateScore(schemeEntity.getId(), schemeEntity.getSupplierId(), subDocumentEntity.getId(), score);
            if (scoreBoolean.booleanValue()) continue;
            throw new BusinessException("\u56de\u5199\u65b9\u6848\u5f97\u5206\u5931\u8d25!");
        }
        return vo;
    }

    @Override
    @Transactional
    public SubPicketageVO queryDetail(Long id) {
        SubPicketageEntity subPicketageEntity = (SubPicketageEntity)((Object)super.selectById((Serializable)id));
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(SubDocumentSupplierEntity::getDocumentId, (Object)subPicketageEntity.getDocumentId());
        List supplierEntityList = this.subDocumentSupplierService.list((Wrapper)lambdaSupplier);
        List talkNumList = supplierEntityList.stream().map(SubDocumentSupplierEntity::getTalkNum).collect(Collectors.toList());
        Integer talkNumMax = (Integer)talkNumList.stream().max(Integer::compareTo).get();
        SubDocumentEntity entity = (SubDocumentEntity)((Object)this.subDocumentService.selectById(subPicketageEntity.getDocumentId()));
        SubDocumentVO subDocumentVO = (SubDocumentVO)BeanMapper.map((Object)((Object)entity), SubDocumentVO.class);
        List subDocumentDetailList = subDocumentVO.getSubDocumentDetailList();
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(SubDocumentSellEntity::getDocumentId, (Object)subPicketageEntity.getDocumentId());
        lambdaSell.eq(SubDocumentSellEntity::getTalkNum, (Object)talkNumMax);
        lambdaSell.eq(SubDocumentSellEntity::getPassFlag, (Object)1);
        lambdaSell.orderByAsc(SubDocumentSellEntity::getSupplierId);
        lambdaSell.orderByAsc(SubDocumentSellEntity::getSchemeName);
        List sellList = this.subDocumentSellService.list((Wrapper)lambdaSell);
        List subDocumentSellVOS = BeanMapper.mapList((Iterable)sellList, SubDocumentSellVO.class);
        LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
        lambdaScheme.eq(SubDocumentSchemeEntity::getDocumentId, (Object)subPicketageEntity.getDocumentId());
        lambdaScheme.eq(SubDocumentSchemeEntity::getTalkNum, (Object)talkNumMax);
        lambdaScheme.orderByAsc(SubDocumentSchemeEntity::getSchemeName);
        List schemeList = this.subDocumentSchemeService.list((Wrapper)lambdaScheme);
        for (SubDocumentSchemeEntity subDocumentSchemeEntity : schemeList) {
            for (SubDocumentSellVO subDocumentSellVO : subDocumentSellVOS) {
                if (!subDocumentSellVO.getSchemeId().equals(subDocumentSchemeEntity.getId())) continue;
                subDocumentSellVO.setScore(subDocumentSchemeEntity.getScore());
            }
        }
        SubDocumentSellVO subDocumentSellFirst = (SubDocumentSellVO)subDocumentSellVOS.stream().findFirst().get();
        if (subDocumentSellFirst.getScore() == null) {
            subDocumentSellVOS.sort(Comparator.comparing(BaseVO::getCreateTime).reversed());
        }
        if (subDocumentSellFirst.getScore() != null) {
            subDocumentSellVOS.sort(Comparator.comparing(SubDocumentSellVO::getScore).reversed());
        }
        Map<Long, List<SubDocumentSellVO>> sellMap = subDocumentSellVOS.stream().collect(Collectors.groupingBy(SubDocumentSellVO::getDetailId));
        for (SubDocumentDetailVO subDocumentDetailVO : subDocumentDetailList) {
            List<SubDocumentSellVO> subDocumentSellEntities = sellMap.get(subDocumentDetailVO.getId());
            subDocumentDetailVO.setSubDocumentSellVOList(subDocumentSellEntities);
        }
        SubPicketageVO subPicketageVO = (SubPicketageVO)BeanMapper.map((Object)((Object)subPicketageEntity), SubPicketageVO.class);
        subPicketageVO.setSubDocumentDetailList(subDocumentDetailList);
        if (subDocumentSellFirst.getScore() == null) {
            subPicketageVO.setScoreStatus(Integer.valueOf(1));
        }
        if (subDocumentSellFirst.getScore() != null) {
            subPicketageVO.setScoreStatus(Integer.valueOf(0));
        }
        return subPicketageVO;
    }

    @Override
    public SubPicketageVO saveOrUpdates(SubPicketageVO saveorUpdateVO) {
        SubPicketageEntity entity = (SubPicketageEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, SubPicketageEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        BigDecimal money = BigDecimal.ZERO;
        BigDecimal moneyTax = BigDecimal.ZERO;
        List picketageSupplierListMoney = saveorUpdateVO.getPicketageSupplierList();
        for (SubPicketageSupplierVO subPicketageSupplierVO : picketageSupplierListMoney) {
            money = money.add(subPicketageSupplierVO.getMoney());
            moneyTax = moneyTax.add(subPicketageSupplierVO.getMoneyTax());
        }
        entity.setMoneyTax(moneyTax);
        entity.setMoney(money);
        super.saveOrUpdate((Object)entity, false);
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(SubPicketageSupplierEntity::getPicketageId, (Object)entity.getId());
        this.subPicketageSupplierService.remove((Wrapper)lambdaSupplier);
        List picketageSupplierList = saveorUpdateVO.getPicketageSupplierList();
        for (SubPicketageSupplierVO subPicketageSupplierVO : picketageSupplierList) {
            subPicketageSupplierVO.setTenderFlag(Integer.valueOf(0));
        }
        List subPicketageSupplierList = BeanMapper.mapList((Iterable)picketageSupplierList, SubPicketageSupplierEntity.class);
        this.subPicketageSupplierService.saveBatch(subPicketageSupplierList);
        List subDocumentDetailList = saveorUpdateVO.getSubDocumentDetailList();
        ArrayList documentSellVOArrayList = new ArrayList();
        for (SubDocumentDetailVO subDocumentDetailVO : subDocumentDetailList) {
            documentSellVOArrayList.addAll(subDocumentDetailVO.getSubDocumentSellVOList());
        }
        List subDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList, SubDocumentSellEntity.class);
        this.subDocumentSellService.saveOrUpdateBatch(subDocumentSellEntityList);
        SubPicketageVO subPicketageVO = this.queryDetail(saveorUpdateVO.getId());
        return subPicketageVO;
    }

    @Override
    public SubPicketageVO saveManyPicketage(Long documentId) {
        SubPicketageEntity entity = new SubPicketageEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        SubDocumentEntity documentEntity = (SubDocumentEntity)((Object)this.subDocumentService.selectById(documentId));
        documentEntity.setNextFlag(0);
        this.subDocumentService.saveOrUpdate((Object)documentEntity);
        LambdaQueryWrapper lambdaTalk = Wrappers.lambdaQuery();
        lambdaTalk.eq(SubTalkEntity::getBillId, (Object)documentId);
        SubTalkEntity subTalkEntity = (SubTalkEntity)((Object)this.subTalkService.getOne((Wrapper)lambdaTalk));
        if (subTalkEntity != null) {
            subTalkEntity.setNextFlag(0);
            this.subTalkService.updateById((Object)subTalkEntity);
        }
        SubDocumentEntity subDocumentEntity = (SubDocumentEntity)((Object)this.subDocumentService.selectById(documentId));
        SubInviteEntity inviteEntity = (SubInviteEntity)((Object)this.subInviteService.selectById(subDocumentEntity.getInviteId()));
        entity.setPicketageName(inviteEntity.getTenderName() + "\u5b9a\u6807");
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setEmployeeId(subDocumentEntity.getEmployeeId());
        entity.setEmployeeName(subDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(subDocumentEntity.getEmployeeMobile());
        entity.setValueType(subDocumentEntity.getValueType());
        SubInviteEntity subInviteEntity = (SubInviteEntity)((Object)this.subInviteService.selectById(subDocumentEntity.getInviteId()));
        entity.setDocumentId(documentId);
        entity.setInviteId(subDocumentEntity.getInviteId());
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(this.sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(this.sessionManager.getUserContext().getEmployeeName());
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode((Integer)inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(0));
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());
        super.saveOrUpdate((Object)entity, false);
        SubPicketageVO vo = (SubPicketageVO)BeanMapper.map((Object)((Object)entity), SubPicketageVO.class);
        subInviteEntity.setTenderStage(5);
        this.subInviteService.updateById((Object)subInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u5b9a\u6807");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(1);
        processEntity.setFrontendUrl("sub/picketage");
        this.processService.saveOrUpdate((Object)processEntity);
        return vo;
    }

    @Override
    public List<SubPicketageSupplierVO> querySupplierList(Long picketageId) {
        SubPicketageEntity subPicketageEntity = (SubPicketageEntity)((Object)super.selectById((Serializable)picketageId));
        List<SubPicketageSupplierEntity> picketageSupplierList = subPicketageEntity.getPicketageSupplierList();
        List list = BeanMapper.mapList(picketageSupplierList, SubPicketageSupplierVO.class);
        return list;
    }

    @Override
    public SubPicketageVO saveSupplierBatch(SubPicketageVO saveorUpdateVO) {
        SubPicketageEntity subPicketageEntity = (SubPicketageEntity)((Object)super.selectById((Serializable)saveorUpdateVO.getId()));
        List<SubPicketageSupplierEntity> picketageSupplierList = subPicketageEntity.getPicketageSupplierList();
        if (CollectionUtils.isNotEmpty(picketageSupplierList)) {
            return this.queryDetail(saveorUpdateVO.getId());
        }
        BigDecimal money = BigDecimal.ZERO;
        BigDecimal moneyTax = BigDecimal.ZERO;
        List subPicketageSupplierEntities = BeanMapper.mapList((Iterable)saveorUpdateVO.getPicketageSupplierList(), SubPicketageSupplierEntity.class);
        for (SubPicketageSupplierEntity subPicketageSupplierEntity : subPicketageSupplierEntities) {
            subPicketageSupplierEntity.setTenderFlag(0);
            money = money.add(subPicketageSupplierEntity.getMoney());
            moneyTax = moneyTax.add(subPicketageSupplierEntity.getMoneyTax());
        }
        this.subPicketageSupplierService.saveBatch(subPicketageSupplierEntities);
        subPicketageEntity.setMoney(money);
        subPicketageEntity.setMoneyTax(moneyTax);
        super.updateById((Object)subPicketageEntity);
        List subDocumentDetailList = saveorUpdateVO.getSubDocumentDetailList();
        ArrayList documentSellVOArrayList = new ArrayList();
        for (SubDocumentDetailVO subDocumentDetailVO : subDocumentDetailList) {
            documentSellVOArrayList.addAll(subDocumentDetailVO.getSubDocumentSellVOList());
        }
        List subDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList, SubDocumentSellEntity.class);
        this.subDocumentSellService.saveOrUpdateBatch(subDocumentSellEntityList);
        return this.queryDetail(saveorUpdateVO.getId());
    }
}

