package com.ejianc.business.tender.equipment.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.common.vo.SupplyFileVo;
import com.ejianc.business.tender.equipment.bean.*;
import com.ejianc.business.tender.equipment.service.*;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.equipment.vo.EquipmentNoticeSupplierDetailTbVO;
import com.ejianc.business.tender.equipment.vo.EquipmentNoticeSupplierVO;
import com.ejianc.business.tender.equipment.vo.EquipmentNoticeVO;
import com.ejianc.business.tender.equipment.bean.EquipmentNoticeEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentNoticeSupplierEntity;
import com.ejianc.business.tender.util.ThirdSystemUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 招标公告主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("equipmentNotice")
@Api(value = "招标公告主表", tags = {"招标公告主表"})
public class EquipmentNoticeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;

    @Value("${gysUrl.updateSupStatusUrl}")
    private String updateSupStatusUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;


    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "invite-notice-code";;//此处需要根据实际修改

    @Autowired
    private IEquipmentNoticeService service;

    @Autowired
    private IEquipmentInviteService inviteService;

    @Autowired
    private IEquipmentInviteDetailService inviteDetailService;

    @Autowired
    private IEquipmentInviteDetailRecordService inviteDetailRecordService;

    @Autowired
    private IEquipmentNoticeDetailService noticeDetailService;

    @Autowired
    private IProcessService processSerice;

    @Autowired
    private IEquipmentNoticeSupplierDetailService noticeSupplierDetailService;

    @Autowired
    private IEquipmentInviteSupplierService inviteSupplierService;

    @Autowired
    private IEquipmentNoticeSupplierService noticeSupplierService;

    @Autowired
    private IEquipmentNoticeChangeService changeService;

    @Autowired
    private CacheManager cacheManager;

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IShareSupplierApi shareSupplierApi;

    @Autowired
    private ISystemDataPushService systemDataPushService;

    private static final String BILL_SUPPLIER_TYPE = "BT211215000000005";
    @Value("${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private IAttachmentApi attachmentApi;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<EquipmentNoticeVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody EquipmentNoticeVO saveorUpdateVO) {
    	EquipmentNoticeEntity entity = BeanMapper.map(saveorUpdateVO, EquipmentNoticeEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	EquipmentNoticeVO vo = BeanMapper.map(entity, EquipmentNoticeVO.class);

//        //保存招标过程记录表
//        ProcessEntity processEntity = new ProcessEntity();
//        processEntity.setBillId(entity.getId());
//        processEntity.setBillName(entity.getNoticeName());
//        processEntity.setTenderId(entity.getId());
//        processEntity.setType(2);
//        processEntity.setFrontendUrl("equipment/invite/card");
//        processSerice.saveOrUpdate(processEntity);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EquipmentNoticeVO> queryDetail(@RequestParam Long id) {
    	EquipmentNoticeEntity entity = service.selectById(id);
    	EquipmentNoticeVO vo = BeanMapper.map(entity, EquipmentNoticeVO.class);
        //处理供应商附件信息
        if (!service.selectFile(vo)){
            CommonResponse.success("供应商附件查询失败！");
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EquipmentNoticeVO> vos) {
        service.removeByIds(vos.stream().map(EquipmentNoticeVO::getId).collect(Collectors.toList()),true);
        processSerice.remove(new LambdaQueryWrapper<ProcessEntity>().in(ProcessEntity::getBillId,vos.stream().map(EquipmentNoticeVO::getId).collect(Collectors.toList())));
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<EquipmentNoticeVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<EquipmentNoticeEntity> page = service.queryPage(param,false);
        IPage<EquipmentNoticeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), EquipmentNoticeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @ApiOperation("获取当前登录人手机号")
    @RequestMapping(value = "/queryPhone", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryPhone() {
        String mobilePhone = employeeApi.getById(sessionManager.getUserContext().getEmployeeId()).getData().getMobilePhone();
        return CommonResponse.success("查询列表数据成功！",mobilePhone);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<EquipmentNoticeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("EquipmentNotice-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refEquipmentNoticeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<EquipmentNoticeVO>> refEquipmentNoticeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<EquipmentNoticeEntity> page = service.queryPage(param,false);
        IPage<EquipmentNoticeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), EquipmentNoticeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @ApiOperation("点击下一步进行下个页面数据初始化")
    @RequestMapping(value = "/nextStep", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EquipmentNoticeEntity> nextStep(String id) throws InvocationTargetException, IllegalAccessException {
        //主表赋值
        EquipmentInviteEntity equipmentInviteEntity = inviteService.selectById(id);
        EquipmentNoticeEntity equipmentNoticeEntity = new EquipmentNoticeEntity();
        BeanUtils.copyProperties(equipmentNoticeEntity, equipmentInviteEntity);
        equipmentNoticeEntity.setNoticeName(equipmentInviteEntity.getTenderName());
        equipmentNoticeEntity.setInviteId(equipmentInviteEntity.getId());
        equipmentNoticeEntity.setId(null);
        equipmentNoticeEntity.setCreateTime(null);
        equipmentNoticeEntity.setUpdateTime(null);
        equipmentNoticeEntity.setBillCode(null);
        equipmentNoticeEntity.setBillState(null);
        equipmentNoticeEntity.setCreateUserCode(null);
        equipmentNoticeEntity.setUpdateUserCode(null);
        equipmentNoticeEntity.setSyncEsFlag(null);
        equipmentNoticeEntity.setVersion(null);
        equipmentNoticeEntity.setTenantId(null);
        equipmentNoticeEntity.setMemo(null);
        equipmentNoticeEntity.setEmployeeId(null);
        equipmentNoticeEntity.setEmployeeName(null);
        service.saveOrUpdate(equipmentNoticeEntity);
        //子表赋值
        List<EquipmentInviteDetailEntity> equipmentInviteDetailList = inviteDetailService.list(new LambdaQueryWrapper<EquipmentInviteDetailEntity>().eq(EquipmentInviteDetailEntity::getInviteId,id).eq(EquipmentInviteDetailEntity::getDr,0));
        EquipmentNoticeDetailEntity equipmentNoticeDetailEntity = new EquipmentNoticeDetailEntity();
        if (CollectionUtil.isNotEmpty(equipmentInviteDetailList)){
            for (EquipmentInviteDetailEntity equipmentInviteDetailEntity : equipmentInviteDetailList) {
                BeanUtils.copyProperties(equipmentNoticeDetailEntity, equipmentInviteDetailEntity);
                equipmentNoticeDetailEntity.setNoticeId(equipmentNoticeEntity.getId());
                equipmentNoticeDetailEntity.setId(null);
                equipmentNoticeDetailEntity.setCreateTime(null);
                equipmentNoticeDetailEntity.setUpdateTime(null);
                equipmentNoticeDetailEntity.setCreateUserCode(null);
                equipmentNoticeDetailEntity.setUpdateUserCode(null);
                equipmentNoticeDetailEntity.setSyncEsFlag(null);
                equipmentNoticeDetailEntity.setVersion(null);
                equipmentNoticeDetailEntity.setTenantId(null);
                noticeDetailService.saveOrUpdate(equipmentNoticeDetailEntity);
            }
        }
        //供应商
        List<EquipmentInviteSupplierEntity> equipmentInviteSupplierList = inviteSupplierService.list(new LambdaQueryWrapper<EquipmentInviteSupplierEntity>().eq(EquipmentInviteSupplierEntity::getInviteId, id).eq(EquipmentInviteSupplierEntity::getDr, 0));
        EquipmentNoticeSupplierDetailEntity equipmentNoticeSupplierDetailEntity = new EquipmentNoticeSupplierDetailEntity();
        if (CollectionUtil.isNotEmpty(equipmentInviteSupplierList)){
            for (EquipmentInviteSupplierEntity equipmentInviteSupplierEntity : equipmentInviteSupplierList) {
                BeanUtils.copyProperties(equipmentNoticeSupplierDetailEntity, equipmentInviteSupplierEntity);
                equipmentNoticeSupplierDetailEntity.setInviteId(equipmentNoticeEntity.getInviteId());
                equipmentNoticeSupplierDetailEntity.setId(null);
                equipmentNoticeSupplierDetailEntity.setCreateTime(null);
                equipmentNoticeSupplierDetailEntity.setUpdateTime(null);
                equipmentNoticeSupplierDetailEntity.setCreateUserCode(null);
                equipmentNoticeSupplierDetailEntity.setUpdateUserCode(null);
                equipmentNoticeSupplierDetailEntity.setSyncEsFlag(null);
                equipmentNoticeSupplierDetailEntity.setVersion(null);
                equipmentNoticeSupplierDetailEntity.setTenantId(null);
                noticeSupplierDetailService.saveOrUpdate(equipmentNoticeSupplierDetailEntity);
            }
        }
        //回写招标阶段
        Integer tenderStage = 2;
        inviteService.updateTenderStage(id,tenderStage);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(equipmentNoticeEntity.getId());
        processEntity.setBillName("招标公告");
        processEntity.setTenderId(equipmentNoticeEntity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("equipment/notice");
        processSerice.saveOrUpdate(processEntity);
        return CommonResponse.success("初始化数据成功", equipmentNoticeEntity);
    }
    @ApiOperation("延长截止时间")
    @RequestMapping(value = "/extend", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse extend(@RequestBody EquipmentNoticeChangeEntity equipmentNoticeChangeEntity) {
        service.updateEndTime(equipmentNoticeChangeEntity.getNoticeId(), equipmentNoticeChangeEntity.getNewTime());
        EquipmentNoticeEntity equipmentNoticeEntity = service.selectById(equipmentNoticeChangeEntity.getNoticeId());
        //调用第三方报名接口
        Map<String, Object> map = new HashMap<>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("sourceId", equipmentNoticeEntity.getInviteId());
        map.put("noticeEndTime",sdf.format(equipmentNoticeChangeEntity.getNewTime()));
        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(updateTimeUrl, RequestMethod.POST, JSON.toJSONString(map), appId,appSecret,appHost);
            if (!response.isSuccess()){
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }
        changeService.saveOrUpdate(equipmentNoticeChangeEntity);
        return CommonResponse.success("延长截止时间成功！");
    }

    @ApiOperation("发布公告")
    @RequestMapping(value = "/publish", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse publish(@RequestBody EquipmentNoticeVO equipmentNoticeVO) throws InvocationTargetException, IllegalAccessException {
        return service.publish(equipmentNoticeVO);
    }
    @ApiOperation("报名情况")
    @RequestMapping(value = "/signUp", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> signUp(HttpServletRequest request) {
        logger.info("进入报名接口request-{},file-{}", request);
        String notice = request.getParameter("bmNoticeVO");
        logger.info("报名实体信息-{}",notice);
        EquipmentNoticeSupplierVO equipmentNoticeSupplierVO = JSON.parseObject(notice, new TypeReference<EquipmentNoticeSupplierVO>() { });

        EquipmentNoticeSupplierEntity equipmentNoticeSupplierEntity = BeanMapper.map(equipmentNoticeSupplierVO, EquipmentNoticeSupplierEntity.class);
        equipmentNoticeSupplierEntity.setNoticeId(service.selectNotice(equipmentNoticeSupplierVO.getSourceId()));
        equipmentNoticeSupplierEntity.setSourceSupplierTenantId(equipmentNoticeSupplierVO.getTenantId().toString());
        equipmentNoticeSupplierEntity.setSupplierId(Long.valueOf(equipmentNoticeSupplierVO.getSourceSupplierId()));
        SupplierDTO supplierVO = shareSupplierApi.queryById(Long.valueOf(equipmentNoticeSupplierVO.getSourceSupplierId())).getData();
        equipmentNoticeSupplierEntity.setSupplierName(supplierVO.getName());
        equipmentNoticeSupplierEntity.setSupplierEmployeeId(equipmentNoticeSupplierVO.getEmployeeId());
        equipmentNoticeSupplierEntity.setSupplierEmployeeName(equipmentNoticeSupplierVO.getEmployeeName());
        equipmentNoticeSupplierEntity.setSupplierEmployeeMobile(equipmentNoticeSupplierVO.getEmployeeMobile());
        equipmentNoticeSupplierEntity.setId(null);
        equipmentNoticeSupplierEntity.setState(0);
        //查询是否已经报名
        LambdaQueryWrapper<EquipmentNoticeEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(EquipmentNoticeEntity::getInviteId, equipmentNoticeSupplierVO.getSourceId());
        List<EquipmentNoticeEntity> noticeEntityList = service.list(queryWrapper);
        LambdaQueryWrapper<EquipmentNoticeSupplierEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(EquipmentNoticeSupplierEntity::getSourceSupplierId, equipmentNoticeSupplierVO.getSourceSupplierId())
                .eq(EquipmentNoticeSupplierEntity::getNoticeId, noticeEntityList.get(0).getId())
                .eq(EquipmentNoticeSupplierEntity::getDr, 0);
        List<EquipmentNoticeSupplierEntity> supplierEntityList = noticeSupplierService.list(lambdaQueryWrapper);
        if (CollectionUtil.isNotEmpty(supplierEntityList)) {
            noticeSupplierService.removeById(supplierEntityList.get(0).getId());
        }
        boolean b = noticeSupplierService.saveOrUpdate(equipmentNoticeSupplierEntity);
        //处理附件
        List<SupplyFileVo> pzList = equipmentNoticeSupplierVO.getSupplyFileList();
        logger.info("报名文件:{}", JSONObject.toJSONString(pzList));
        if(CollectionUtils.isNotEmpty(pzList)){
            List<AttachmentVO> list = new ArrayList<>();
            pzList.forEach(e->{
                AttachmentVO attachmentVO = new AttachmentVO();
                attachmentVO.setBillType(BILL_SUPPLIER_TYPE);
                attachmentVO.setSourceId(equipmentNoticeSupplierEntity.getId());
                attachmentVO.setSourceType("BmSupplierFileType");
                attachmentVO.setFilePath(e.getFilePath());
                attachmentVO.setOnlinePath(e.getFilePath());
                attachmentVO.setFileName(e.getFileName());
                attachmentVO.setId(e.getFileId());
                list.add(attachmentVO);
                logger.info("保存文件信息:{}", JSONObject.toJSONString(attachmentVO));
            });
            CommonResponse<String> stringCommonResponse = attachmentApi.insertBatch(list);
            logger.info(request+"报名文件上传结果-{}",JSONObject.toJSONString(stringCommonResponse));
        }
//        //删除之前附件
//        CommonResponse<List<AttachmentVO>> fileResp = attachmentApi
//                .queryListBySourceId(equipmentNoticeSupplierEntity.getId(), BILL_SUPPLIER_TYPE, "BmSupplierFileType", null);
//        // 查询成功并有相应的文件
//        if (fileResp.isSuccess() && CollectionUtils.isNotEmpty(fileResp.getData())) {
//            logger.info("删除文件信息：{}", JSONObject.toJSONString(fileResp.getData()));
//            String ids = fileResp.getData().stream().map(AttachmentVO::getId).map(String::valueOf)
//                    .collect(Collectors.joining(","));
//            attachmentApi.delete(ids);
//        }
////        logger.info(request + "报名文件名称- {}" + file.getOriginalFilename());
////        Boolean upFlag = new ThirdSystemUtils().upFile(BASE_HOST,"BmSupplierFileType",Long.toString(equipmentNoticeSupplierEntity.getId()),BILL_SUPPLIER_TYPE,file,request);
////        logger.info(request+"报名文件上传结果-{}",upFlag);
//        String authority = request.getHeader("authority");
//        String nameSourceTypeMapping = request.getParameter("fileSourceType");
//        Map mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);
//        FileUtil.getInstance()
//                .handleReqFile((MultipartHttpServletRequest) request, mp, BILL_SUPPLIER_TYPE, authority, Long.toString(equipmentNoticeSupplierEntity.getId()));

        return CommonResponse.success("报名情况接口掉用成功",b);
    }

    @ApiOperation("剔除供应商")
    @RequestMapping(value = "/deleteSupplier", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse deleteSupplier(@RequestBody EquipmentNoticeSupplierVO equipmentNoticeSupplierVO) {
        List<EquipmentNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<>();
        EquipmentNoticeEntity equipmentNoticeEntity = service.selectById(equipmentNoticeSupplierVO.getNoticeId());
        EquipmentNoticeSupplierDetailTbVO equipmentNoticeSupplierDetailTbVO = new EquipmentNoticeSupplierDetailTbVO();
        equipmentNoticeSupplierDetailTbVO.setSourceId(equipmentNoticeEntity.getInviteId().toString());
        equipmentNoticeSupplierDetailTbVO.setTenantId(equipmentNoticeSupplierVO.getTenantId());
        equipmentNoticeSupplierDetailTbVO.setSourceSupplierId(equipmentNoticeSupplierVO.getSupplierId().toString());
        equipmentNoticeSupplierDetailTbVO.setOutReason(equipmentNoticeSupplierVO.getOutReason()==null?"超时未报名":equipmentNoticeSupplierVO.getOutReason());
        supplierDetailTbVOList.add(equipmentNoticeSupplierDetailTbVO);

        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(updateSupStatusUrl, RequestMethod.POST, JSON.toJSONString(supplierDetailTbVOList), appId,appSecret,appHost);
            if (!response.isSuccess()){
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }
        //更新供应商状态
        noticeSupplierService.updateState(equipmentNoticeSupplierVO.getId());
        return CommonResponse.success("剔除供应商成功");
    }

}
