package com.ejianc.business.tender.equipment.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.common.vo.SupplyFileVo;
import com.ejianc.business.tender.equipment.bean.*;
import com.ejianc.business.tender.equipment.mapper.EquipmentDocumentMapper;
import com.ejianc.business.tender.equipment.mapper.EquipmentDocumentSellMapper;
import com.ejianc.business.tender.equipment.mapper.EquipmentDocumentSupplierDetailMapper;
import com.ejianc.business.tender.equipment.mapper.EquipmentDocumentSupplierMapper;
import com.ejianc.business.tender.equipment.service.*;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.equipment.vo.*;
import com.ejianc.business.tender.stuff.vo.StuffDocumentDetailVO;
import com.ejianc.business.tender.util.SendMsgUtils;
import com.ejianc.business.tender.util.ThirdSystemUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 招标文件主表
 *
 * @author generator
 *
 */
@Service("equipmentDocumentService")
public class EquipmentDocumentServiceImpl extends BaseServiceImpl<EquipmentDocumentMapper, EquipmentDocumentEntity> implements IEquipmentDocumentService {
    @Autowired
    private IEquipmentDocumentSupplierService equipmentDocumentSupplierService;
    @Autowired
    private EquipmentDocumentSupplierDetailMapper supplierDetailMapper;
    @Autowired
    private EquipmentDocumentSupplierMapper supplierMapper;
    @Autowired
    private IEquipmentDocumentSchemeService equipmentDocumentSchemeService;
    @Autowired
    private IEquipmentDocumentSellService equipmentDocumentSellService;
    @Autowired
    private EquipmentDocumentSellMapper equipmentDocumentSellMapper;
    @Autowired
    private IEquipmentDocumentRecordService equipmentDocumentRecordService;
    @Autowired
    private IEquipmentDocumentDetailService equipmentDocumentDetailService;
    @Autowired
    private IEquipmentTalkService equipmentTalkService;
    @Autowired
    private IEquipmentTalkRecordService equipmentTalkRecordService;
    @Autowired
    private IEquipmentInviteService equipmentInviteService;
    @Autowired
    private IEquipmentDocumentExpertService documentExpertService;
    @Autowired
    private IEquipmentDocumentSupplierDetailService supplierDetailService;
    @Autowired
    private IEquipmentDocumentSupplierDetailService documentSupplierDetailService;
    @Autowired
    private IEquipmentDocumentService service;
    @Autowired
    private IProcessService processService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private IEquipmentNoticeService equipmentNoticeService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Value("${gysUrl.delFileUrl}")
    private String delFileUrl;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Value("${gysUrl.saveWjUrl}")
    private String saveWjUrl;
    @Value("${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value("${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value("${gysUrl.updateSupStatusUrl}")
    private String updateSupStatusUrl;
    @Value("${gysUrl.addFileUrl}")
    private String addFileUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_SUPPLIER_TYPE = "BT202202000001";
    private static final String BILL_TYPE = "BT211119000000003";
    private static final String SOURCE_TYPE = "documentBill02";

    private final Logger logger = LoggerFactory.getLogger(getClass());
    private static final String BILL_CODE = "invite-document-code";//此处需要根据实际修改

    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IEquipmentNoticeSupplierService equipmentNoticeSupplierService;




    @Transactional
    @Override
    public EquipmentDocumentVO publishDocument(Long id) {
        //更新发布状态
        EquipmentDocumentEntity equipmentDocumentEntity = super.selectById(id);
        equipmentDocumentEntity.setPublishFlag(0);
        super.updateById(equipmentDocumentEntity);

        //推送供应商
        EquipmentDocumentSupplierTbVO equipmentDocumentSupplierTbVO = new EquipmentDocumentSupplierTbVO();
        equipmentDocumentSupplierTbVO.setSourceId(equipmentDocumentEntity.getInviteId().toString());
        equipmentDocumentSupplierTbVO.setSourceType("郑州一建招标文件");
        equipmentDocumentSupplierTbVO.setNoticeType(1);
        equipmentDocumentSupplierTbVO.setProjectLinkName(equipmentDocumentEntity.getProjectLinkName());
        equipmentDocumentSupplierTbVO.setProjectLinkPhone(equipmentDocumentEntity.getProjectLinkPhone());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatStart = simpleDateFormat.format(equipmentDocumentEntity.getOfferStartTime());
        equipmentDocumentSupplierTbVO.setOfferStartTime(formatStart);
        String formatEnd = simpleDateFormat.format(equipmentDocumentEntity.getOfferEndTime());
        equipmentDocumentSupplierTbVO.setOfferEndTime(formatEnd);
        equipmentDocumentSupplierTbVO.setContent(equipmentDocumentEntity.getDocumentContent());
        equipmentDocumentSupplierTbVO.setBrandFlag(equipmentDocumentEntity.getBrandFlag());
        equipmentDocumentSupplierTbVO.setMemo(equipmentDocumentEntity.getMemo());
        equipmentDocumentSupplierTbVO.setTenderName(equipmentDocumentEntity.getDocumentName());
        CommonResponse<String> stringCommonResponse = proSupplierApi.getEjcCloudSystemCode();
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("招标文件获取systemId失败" + stringCommonResponse.getMsg());
        }
        equipmentDocumentSupplierTbVO.setSystemId(stringCommonResponse.getData());

        //处理附件
        //查询招标文件
        CommonResponse<List<AttachmentVO>> zbwjFile = attachmentApi.queryListBySourceId(equipmentDocumentEntity.getId(), BILL_TYPE, SOURCE_TYPE, null);
        String zbwjIds = null;
        List<Long> zbwjAttachIdList = new ArrayList<>();
        if(zbwjFile.isSuccess()){
            List<AttachmentVO> data = zbwjFile.getData();
            zbwjAttachIdList = data.stream().map(AttachmentVO::getId).collect(Collectors.toList());
            zbwjIds = zbwjAttachIdList.stream().map(p -> String.valueOf(p)).collect(Collectors.joining(","));
        }

        Map<String, String> fileMap = new HashMap<>();
        fileMap.put("fileIds",zbwjIds);
        String zbwjFileByte = null;
        try {
            zbwjFileByte = ReferHttpClientUtils.getAndHeader(BASE_HOST + "ejc-file-web/attachment/batchdownflow", fileMap);
        } catch (GeneralSecurityException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        //招标文件stream处理
        JSONObject jsonZbwj = JSON.parseObject(zbwjFileByte);
        Map<String, String> zbwjParam = JSONObject.parseObject(jsonZbwj.toJSONString(), new TypeReference<Map<String, String>>(){});
        String dataZbwj = zbwjParam.get("data");
        JSONObject zbwListJson = JSON.parseObject(dataZbwj);
        Map<String, byte[]> zbwjMap = JSONObject.parseObject(zbwListJson.toJSONString(), new TypeReference<Map<String, byte[]>>(){});
        Map<String, InputStream> streamMap = new HashMap<>();
        zbwjMap.forEach((key,value) ->{
            streamMap.put(key,new ByteArrayInputStream(value));
        });

        String stringFb = JSONObject.toJSONString(equipmentDocumentSupplierTbVO);
        Map<String,String> params = new HashMap<>();
        params.put("noticeEntity", stringFb);
        Map<String, Map<String, InputStream>> files = null;
        if (!streamMap.isEmpty()){
            files = new HashMap<>();
            files.put("file",streamMap);
        }

        //推送供方
        CommonResponse<String> stringCommonResponses = systemDataPushService.exchangeDataAndFilesWithUniversal(saveWjUrl,params,files, appId, appSecret, appHost);
        if(!stringCommonResponses.isSuccess()) {
            throw new BusinessException("招标文件发布推送供方接口报错" + stringCommonResponses.getMsg());
        }

        EquipmentDocumentVO equipmentDocumentVO = queryDetail(id);
        return equipmentDocumentVO;
    }




    @Override
    public EquipmentDocumentVO bidDocument(Long id) {
        //更新开标状态
        EquipmentDocumentEntity equipmentDocumentEntity = super.selectById(id);
        equipmentDocumentEntity.setBidFlag(0);
        equipmentDocumentEntity.setBidTime(new Date());
        super.updateById(equipmentDocumentEntity);
        EquipmentDocumentVO equipmentDocumentVO = queryDetail(id);
//        开标之后给专家发送微信+内部消息通知：xx专家您好，XXX（项目名称）已开标，后续的评标开始时间我们会以短信+消息
        List<EquipmentDocumentExpertEntity> entityList = documentExpertService.list(new QueryWrapper<EquipmentDocumentExpertEntity>().eq("document_id", equipmentDocumentVO.getId()).eq("dr", 0));
        for (EquipmentDocumentExpertEntity entity : entityList) {
            //审批通过给专家发内部消息
            List<String> messageType = new ArrayList<>();
            //系统消息
            messageType.add("sys");
            //微信消息
            //messageType.add("weChat");
            List<String> sender = new ArrayList<>();
            sender.add(entity.getExpertId() + "");
            String name = equipmentDocumentVO.getPurchaseType()==0?equipmentDocumentVO.getProjectName():equipmentDocumentVO.getOrgName();
            logger.info("发送信息给专家:>----------" + sender);
            String subject = entity.getExpertName() + "专家您好，" +name+ "已开标，后续的评标开始时间我们会以短信+消息的形式通知您，请注意查看，避免遗忘";
            String content = entity.getExpertName() + "专家您好，" +name+ "已开标，后续的评标开始时间我们会以短信+消息的形式通知您，请注意查看，避免遗忘";
            logger.info("发送信息的内容:>----------" + content);
            new SendMsgUtils().sendSysMsg(sender, subject, content, pushMessageApi);
        }
        return equipmentDocumentVO;
    }

    @Override
    public EquipmentDocumentVO queryDetail(Long id) {
        return queryDocDetail(id,0);
    }
    @Override
    public EquipmentDocumentVO queryDetail1(Long id, Integer num) {
        return queryDocDetail(id,num);
    }

    @Override
    public EquipmentDocumentVO queryDetailNum(Long id) {
        EquipmentDocumentSchemeEntity equipmentDocumentSchemeEntity = equipmentDocumentSchemeService.list(new QueryWrapper<EquipmentDocumentSchemeEntity>().eq("document_id", id).orderByDesc("talk_num")).get(0);
        return queryDocDetail(id,equipmentDocumentSchemeEntity.getTalkNum());
    }

    @Transactional
    @Override
    public Boolean supplierPushSell(HttpServletRequest request, MultipartFile file) {

        logger.info("进入报价接口request-{},file-{}", request, file);
        String notice = request.getParameter("bjNoticeVO");
        logger.info("实体信息-{}",notice);
        EquipmentSupplierSellVO pushVO = JSON.parseObject(notice, new TypeReference<EquipmentSupplierSellVO>() { });

        //处理业务数据
        //noticeType,类型(0-公告，1-文件,2-询价,3-竞争性,4-洽商谈判
        //转换轮数
        EquipmentInviteEntity equipmentInviteEntity = equipmentInviteService.selectById(Long.parseLong(pushVO.getSourceId()));
        Integer tenderStage = equipmentInviteEntity.getTenderStage();
        //招标阶段(3-招标文件,6-竞争性谈判文件,7-洽商谈判,8-单一来源文件,9-紧急文件,10-询价公告
        Integer talkNum = null;
        if (tenderStage == 3 || tenderStage == 6 || tenderStage == 8 || tenderStage == 9 || tenderStage == 10){
            talkNum = 0;
        }
        if (tenderStage == 7){
            //查询轮数
            LambdaQueryWrapper<EquipmentTalkEntity> lambdaTalk = Wrappers.<EquipmentTalkEntity>lambdaQuery();
            lambdaTalk.eq(EquipmentTalkEntity::getInviteId, Long.parseLong(pushVO.getSourceId()));
            EquipmentTalkEntity equipmentTalkEntity = equipmentTalkService.getOne(lambdaTalk);
            talkNum = equipmentTalkEntity.getTalkNum();
        }

        //转换
        long sourceSupplierId = Long.parseLong(pushVO.getSourceSupplierId());
        SupplierDTO supplierVO = shareSupplierApi.queryById(sourceSupplierId).getData();

        //处理供应商信息
        Long inviteId = Long.parseLong(pushVO.getSourceId());
        LambdaQueryWrapper<EquipmentDocumentEntity> lambdaDocument = Wrappers.<EquipmentDocumentEntity>lambdaQuery();
        lambdaDocument.eq(EquipmentDocumentEntity::getInviteId, inviteId);
        EquipmentDocumentEntity equipmentDocumentEntity = baseMapper.selectOne(lambdaDocument);
        //先删后增
        //根据供应商主键和招标文件主键查询供应商信息,判断新增和修改
        LambdaQueryWrapper<EquipmentDocumentSupplierEntity> lambdaSupplier = Wrappers.<EquipmentDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(EquipmentDocumentSupplierEntity::getSupplierId, sourceSupplierId);
        lambdaSupplier.eq(EquipmentDocumentSupplierEntity::getDocumentId,equipmentDocumentEntity.getId());
        lambdaSupplier.eq(EquipmentDocumentSupplierEntity::getTalkNum,talkNum);
        EquipmentDocumentSupplierEntity equipmentDocumentSupplierEntity = equipmentDocumentSupplierService.getOne(lambdaSupplier);

        Long documentSupplierId = null;
        if (equipmentDocumentSupplierEntity != null){
            //更新供应商信息
            equipmentDocumentSupplierEntity.setOfferTime(new Date());
            equipmentDocumentSupplierEntity.setLinkName(pushVO.getEmployeeName());
            equipmentDocumentSupplierEntity.setLinkMobile(pushVO.getEmployeeMobile());
            equipmentDocumentSupplierEntity.setTaxMemo(pushVO.getInvoiceNote());
            equipmentDocumentSupplierService.updateById(equipmentDocumentSupplierEntity);
            documentSupplierId = equipmentDocumentSupplierEntity.getId();

            //删除方案信息
            LambdaQueryWrapper<EquipmentDocumentSchemeEntity> lambdaScheme = Wrappers.<EquipmentDocumentSchemeEntity>lambdaQuery();
            lambdaScheme.eq(EquipmentDocumentSchemeEntity::getDocumentSupplierId,equipmentDocumentSupplierEntity.getId() );
            equipmentDocumentSchemeService.remove(lambdaScheme);
        }
        if (equipmentDocumentSupplierEntity == null){
            //新增供应商信息
            EquipmentDocumentSupplierEntity equipmentDocumentSupplierEntityAdd = new EquipmentDocumentSupplierEntity();
            equipmentDocumentSupplierEntityAdd.setSupplierName(supplierVO.getName());
            equipmentDocumentSupplierEntityAdd.setSupplierId(sourceSupplierId);
            equipmentDocumentSupplierEntityAdd.setSupplierTenantId(supplierVO.getTenant());
            equipmentDocumentSupplierEntityAdd.setLinkName(pushVO.getEmployeeName());
            equipmentDocumentSupplierEntityAdd.setLinkMobile(pushVO.getEmployeeMobile());
            equipmentDocumentSupplierEntityAdd.setTaxMemo(pushVO.getInvoiceNote());
            equipmentDocumentSupplierEntityAdd.setOfferTime(new Date());
            equipmentDocumentSupplierEntityAdd.setDocumentId(equipmentDocumentEntity.getId());
            equipmentDocumentSupplierEntityAdd.setTalkNum(talkNum);
            equipmentDocumentSupplierService.save(equipmentDocumentSupplierEntityAdd);
            documentSupplierId = equipmentDocumentSupplierEntityAdd.getId();
        }

        //处理方案信息
        List<EquipmentSupplierSellSchemeVO> schemeList = pushVO.getPurchaseSchemeList();
        List<EquipmentDocumentSchemeEntity> equipmentDocumentSchemeEntityArrayList = new ArrayList<>();
        //所有报价详情信息
        List<EquipmentDocumentSellVO> equipmentDocumentSellVOList = new ArrayList<>();
        for (EquipmentSupplierSellSchemeVO supplierSellSchemeVO : schemeList){
            EquipmentDocumentSchemeEntity equipmentDocumentSchemeEntity = new EquipmentDocumentSchemeEntity();
            equipmentDocumentSchemeEntity.setDocumentSupplierId(documentSupplierId);
            equipmentDocumentSchemeEntity.setDocumentId(equipmentDocumentEntity.getId());
            equipmentDocumentSchemeEntity.setSupplierId(sourceSupplierId);
            equipmentDocumentSchemeEntity.setSupplierTenantId(supplierVO.getTenant());
            equipmentDocumentSchemeEntity.setSupplierName(supplierVO.getName());
            equipmentDocumentSchemeEntity.setSchemeName(supplierSellSchemeVO.getSchemeName());
            equipmentDocumentSchemeEntity.setMoney(supplierSellSchemeVO.getMoney());
            equipmentDocumentSchemeEntity.setMoneyTax(supplierSellSchemeVO.getMoneyTax());
            equipmentDocumentSchemeEntity.setTalkNum(talkNum);
            equipmentDocumentSchemeEntity.setId(IdWorker.getId());
            equipmentDocumentSchemeEntity.setPassFlag(1);
            equipmentDocumentSchemeEntityArrayList.add(equipmentDocumentSchemeEntity);

            //处理报价详情与方案的关联关系
            List<EquipmentSupplierSellSchemeDetailVO> schemeDetailList = supplierSellSchemeVO.getPurchaseSchemeDetailList();
            for (EquipmentSupplierSellSchemeDetailVO supplierSellSchemeDetailVO : schemeDetailList){
                EquipmentDocumentSellVO equipmentDocumentSellVO = new EquipmentDocumentSellVO();
//                equipmentDocumentSellVO.setProjectId(equipmentDocumentEntity.getProjectId());
//                equipmentDocumentSellVO.setProjectName(equipmentDocumentEntity.getProjectName());
                equipmentDocumentSellVO.setSchemeId(equipmentDocumentSchemeEntity.getId());
                equipmentDocumentSellVO.setDocumentId(equipmentDocumentEntity.getId());
                equipmentDocumentSellVO.setSupplierId(sourceSupplierId);
                equipmentDocumentSellVO.setSupplierTenantId(supplierVO.getTenant());
                equipmentDocumentSellVO.setSupplierName(supplierVO.getName());
                equipmentDocumentSellVO.setMaterialId(Long.parseLong(supplierSellSchemeDetailVO.getSourceMaterialId()));
                equipmentDocumentSellVO.setMaterialName(supplierSellSchemeDetailVO.getMaterialName());
                equipmentDocumentSellVO.setMaterialCode(supplierSellSchemeDetailVO.getMaterialCode());
                equipmentDocumentSellVO.setMaterialTypeId(Long.parseLong(supplierSellSchemeDetailVO.getSourceMaterialTypeId()));
                equipmentDocumentSellVO.setMaterialTypeName(supplierSellSchemeDetailVO.getMaterialTypeName());
                equipmentDocumentSellVO.setUnit(supplierSellSchemeDetailVO.getUnit());
                equipmentDocumentSellVO.setSpec(supplierSellSchemeDetailVO.getSpec());
//                equipmentDocumentSellVO.setNum(supplierSellSchemeDetailVO.getNum());
                equipmentDocumentSellVO.setRate(supplierSellSchemeDetailVO.getRate());
                equipmentDocumentSellVO.setDetailRate(supplierSellSchemeDetailVO.getDetailRate());
                equipmentDocumentSellVO.setPrice(supplierSellSchemeDetailVO.getPrice());
                equipmentDocumentSellVO.setPriceTax(supplierSellSchemeDetailVO.getPriceTax());
//                equipmentDocumentSellVO.setMoney(supplierSellSchemeDetailVO.getMoney());
//                equipmentDocumentSellVO.setMoneyTax(supplierSellSchemeDetailVO.getMoneyTax());
//                equipmentDocumentSellVO.setSellTax(supplierSellSchemeDetailVO.getTax());
                equipmentDocumentSellVO.setSchemeName(supplierSellSchemeVO.getSchemeName());
                equipmentDocumentSellVO.setMaterialBrand(supplierSellSchemeDetailVO.getBrand());
                equipmentDocumentSellVO.setBrand(supplierSellSchemeDetailVO.getSupplierBrand());
                equipmentDocumentSellVO.setMemo(supplierSellSchemeDetailVO.getSupplierMemo());
                equipmentDocumentSellVO.setMaterialMemo(supplierSellSchemeDetailVO.getMemo());
                equipmentDocumentSellVO.setCalculateType(supplierSellSchemeDetailVO.getCalculateType());
                equipmentDocumentSellVO.setReferFlag(2);
                equipmentDocumentSellVO.setPassFlag(1);
                equipmentDocumentSellVO.setTalkNum(talkNum);

                equipmentDocumentSellVOList.add(equipmentDocumentSellVO);

            }

        }
        //新增方案
        equipmentDocumentSchemeService.saveBatch(equipmentDocumentSchemeEntityArrayList);

        //处理报价详情信息
        //删除报价信息
        LambdaQueryWrapper<EquipmentDocumentSellEntity> lambdaSell = Wrappers.<EquipmentDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(EquipmentDocumentSellEntity::getSupplierId,sourceSupplierId);
        lambdaSell.eq(EquipmentDocumentSellEntity::getTalkNum,talkNum);
        lambdaSell.eq(EquipmentDocumentSellEntity::getDocumentId,equipmentDocumentEntity.getId());
        equipmentDocumentSellService.remove(lambdaSell);

        //处理报价详情信息
        LambdaQueryWrapper<EquipmentDocumentDetailEntity> lambdaDetail = Wrappers.<EquipmentDocumentDetailEntity>lambdaQuery();
        lambdaDetail.eq(EquipmentDocumentDetailEntity::getDocumentId,equipmentDocumentEntity.getId());
        List<EquipmentDocumentDetailEntity> equipmentDocumentDetailList = equipmentDocumentDetailService.list(lambdaDetail);

        List<EquipmentDocumentSellEntity> equipmentDocumentSellEntityArrayList = new ArrayList<>();
        for (EquipmentDocumentDetailEntity equipmentDocumentDetailEntity : equipmentDocumentDetailList){
            for (EquipmentDocumentSellVO equipmentDocumentSellVO : equipmentDocumentSellVOList){
                //判断是否只有分类
                if (equipmentDocumentDetailEntity.getMaterialId() != null) {
                    if (equipmentDocumentDetailEntity.getMaterialTypeId().equals(equipmentDocumentSellVO.getMaterialTypeId()) &&
                            equipmentDocumentDetailEntity.getMaterialId().equals(equipmentDocumentSellVO.getMaterialId()) &&
                            equipmentDocumentDetailEntity.getRate().equals(equipmentDocumentSellVO.getDetailRate())){
                        EquipmentDocumentSellEntity equipmentDocumentSellEntity = BeanMapper.map(equipmentDocumentSellVO, EquipmentDocumentSellEntity.class);
                        equipmentDocumentSellEntity.setDetailId(equipmentDocumentDetailEntity.getId());
                        equipmentDocumentSellEntity.setProjectId(equipmentDocumentDetailEntity.getDetailProjectId());
                        equipmentDocumentSellEntity.setProjectName(equipmentDocumentDetailEntity.getDetailProjectName());
                        equipmentDocumentSellEntity.setNum(equipmentDocumentDetailEntity.getNum());
                        equipmentDocumentSellEntity.setMoney(equipmentDocumentDetailEntity.getNum().multiply(equipmentDocumentSellEntity.getPrice()));
                        equipmentDocumentSellEntity.setMoneyTax(equipmentDocumentDetailEntity.getNum().multiply(equipmentDocumentSellEntity.getPriceTax()));
                        equipmentDocumentSellEntity.setSellTax(equipmentDocumentSellEntity.getMoneyTax().subtract(equipmentDocumentSellEntity.getMoney()));
                        equipmentDocumentSellEntityArrayList.add(equipmentDocumentSellEntity);
                    }
                }
                if (equipmentDocumentDetailEntity.getMaterialId() == null) {
                    if (equipmentDocumentDetailEntity.getMaterialTypeId().equals(equipmentDocumentSellVO.getMaterialTypeId()) &&
                            equipmentDocumentDetailEntity.getRate().equals(equipmentDocumentSellVO.getDetailRate())){
                        EquipmentDocumentSellEntity equipmentDocumentSellEntity = BeanMapper.map(equipmentDocumentSellVO, EquipmentDocumentSellEntity.class);
                        equipmentDocumentSellEntity.setDetailId(equipmentDocumentDetailEntity.getId());
                        equipmentDocumentSellEntity.setProjectId(equipmentDocumentDetailEntity.getDetailProjectId());
                        equipmentDocumentSellEntity.setProjectName(equipmentDocumentDetailEntity.getDetailProjectName());
                        equipmentDocumentSellEntity.setNum(equipmentDocumentDetailEntity.getNum());
                        equipmentDocumentSellEntity.setMoney(equipmentDocumentDetailEntity.getNum().multiply(equipmentDocumentSellEntity.getPrice()));
                        equipmentDocumentSellEntity.setMoneyTax(equipmentDocumentDetailEntity.getNum().multiply(equipmentDocumentSellEntity.getPriceTax()));
                        equipmentDocumentSellEntity.setSellTax(equipmentDocumentSellEntity.getMoneyTax().subtract(equipmentDocumentSellEntity.getMoney()));
                        equipmentDocumentSellEntityArrayList.add(equipmentDocumentSellEntity);
                    }
                }

            }

        }
        //新增报价信息
        equipmentDocumentSellService.saveBatch(equipmentDocumentSellEntityArrayList);

        //先删除附件
        if(documentSupplierId != null){
            logger.info("删除供应商[{}]附件信息，billType[{}]，sourceType[supplierFileType]",documentSupplierId, BILL_SUPPLIER_TYPE);
//            CommonResponse<String> deleteRtn = attachmentApi.deleteFileByParam(documentSupplierId, BILL_SUPPLIER_TYPE,"supplierFileType");
            CommonResponse<List<AttachmentVO>> attachmentResponse = attachmentApi.queryListBySourceId(documentSupplierId,BILL_SUPPLIER_TYPE,"supplierFileType",null);
            List<AttachmentVO> attachmentVOList = attachmentResponse.getData();
            if (CollectionUtils.isNotEmpty(attachmentVOList)){
                logger.info("开始删除附件信息-----");
                String ids = attachmentVOList.stream().map(AttachmentVO::getId).map(String::valueOf).collect(Collectors.joining(","));
                CommonResponse<String> deleteResponse = attachmentApi.delete(ids);
                logger.info("删除文件结束，删除结果：{}",deleteResponse.getData());
            }
        }
        //处理附件
//        if(file != null){
//            logger.info(request+"报价文件名称- {}",file.getOriginalFilename());
//            logger.info(request+"供应商表主键- {}",documentSupplierId);
//            Boolean upFlag = new ThirdSystemUtils().upFile(BASE_HOST,"supplierFileType",Long.toString(documentSupplierId),BILL_SUPPLIER_TYPE,file,request);
//            logger.info(request+"文件上传结果-{}",upFlag);
//        }
        List<SupplyFileVo> pzList = pushVO.getSupplyFileList();
        logger.info("报名文件:{}", JSONObject.toJSONString(pzList));
        if(CollectionUtils.isNotEmpty(pzList)){
            List<AttachmentVO> list = new ArrayList<>();
            for (SupplyFileVo e : pzList) {
                AttachmentVO attachmentVO = new AttachmentVO();
                attachmentVO.setBillType(BILL_SUPPLIER_TYPE);
                attachmentVO.setSourceId(documentSupplierId);
                attachmentVO.setSourceType("supplierFileType");
                attachmentVO.setFilePath(e.getFilePath());
                attachmentVO.setOnlinePath(e.getFilePath());
                attachmentVO.setFileName(e.getFileName());
                attachmentVO.setId(e.getFileId());
                list.add(attachmentVO);
                logger.info("保存文件信息:{}", JSONObject.toJSONString(attachmentVO));
            }
            CommonResponse<String> stringCommonResponse = attachmentApi.insertBatch(list);
            logger.info(request+"报名文件上传结果-{}",JSONObject.toJSONString(stringCommonResponse));
        }
        return true;
    }

    @Override
    public String uploadById(Long attachId,Long inviteId) {
        Map<String, String> fileMap = new HashMap<>();
        fileMap.put("fileIds",Long.toString(attachId));
        String wjFileByte = null;
        try {
            wjFileByte = ReferHttpClientUtils.getAndHeader(BASE_HOST + "ejc-file-web/attachment/batchdownflow", fileMap);
        } catch (GeneralSecurityException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        //文件stream处理
        JSONObject jsonwj = JSON.parseObject(wjFileByte);
        Map<String, String> zbwjParam = JSONObject.parseObject(jsonwj.toJSONString(), new TypeReference<Map<String, String>>(){});
        String datawj = zbwjParam.get("data");
        JSONObject wListJson = JSON.parseObject(datawj);
        Map<String, byte[]> wjMap = JSONObject.parseObject(wListJson.toJSONString(), new TypeReference<Map<String, byte[]>>(){});
        Map<String, InputStream> streamMap = new HashMap<>();
        wjMap.forEach((key,value) ->{
            streamMap.put(key,new ByteArrayInputStream(value));
        });


        Map<String,String> params = new HashMap<>();
        params.put("sourceId", Long.toString(inviteId));
        Map<String,String> headers = new HashMap<>();
        Map<String, Map<String, InputStream>> files = new HashMap<>();
        files.put("file",streamMap);

        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataAndFilesWithUniversal(addFileUrl, params, files, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("附件批量修改同步供方接口报错" + stringCommonResponse.getMsg());
        }
        return null;
    }

    @Override
    public String deleteFileById(Long sourceId, List<String> fileNames) {
        Map<String,Object> map = new HashMap<>();
        map.put("sourceId",sourceId);
        map.put("fileNames",fileNames);
        String stringInfo = JSONObject.toJSONString(map);
        //调用供方接口
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(delFileUrl, RequestMethod.POST, stringInfo, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
                throw new BusinessException("附加批量删除同步供方接口报错" + response.getMsg());
            }
        return "同步成功";
    }

    @Override
    public EquipmentDocumentSupplierSellVO getSupplierSchemeDetailDb(Long schemeId, Long documentId) {

        EquipmentDocumentEntity equipmentDocumentEntity = super.selectById(documentId);
        EquipmentDocumentSupplierSellVO equipmentDocumentSupplierSellVO = new EquipmentDocumentSupplierSellVO();
        EquipmentDocumentSchemeEntity equipmentDocumentSchemeEntity = equipmentDocumentSchemeService.selectById(schemeId);
        EquipmentDocumentSupplierEntity equipmentDocumentSupplierEntity = equipmentDocumentSupplierService.selectById(equipmentDocumentSchemeEntity.getDocumentSupplierId());
        Long supplierDetailId = equipmentDocumentSupplierEntity.getId();
        equipmentDocumentSupplierSellVO.setLinkName(equipmentDocumentSupplierEntity.getLinkName());
        equipmentDocumentSupplierSellVO.setSupplierName(equipmentDocumentSupplierEntity.getSupplierName());
        equipmentDocumentSupplierSellVO.setLinkMobile(equipmentDocumentSupplierEntity.getLinkMobile());
        equipmentDocumentSupplierSellVO.setOfferTime(equipmentDocumentSupplierEntity.getOfferTime());
        equipmentDocumentSupplierSellVO.setTaxMemo(equipmentDocumentSupplierEntity.getTaxMemo());
        equipmentDocumentSupplierSellVO.setPurchaseType(equipmentDocumentEntity.getPurchaseType());
        LambdaQueryWrapper<EquipmentDocumentSchemeEntity> lambdaScheme = Wrappers.<EquipmentDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(EquipmentDocumentSchemeEntity::getDocumentSupplierId,supplierDetailId);
        List<EquipmentDocumentSchemeEntity> equipmentDocumentSchemeEntityList = equipmentDocumentSchemeService.list(lambdaScheme);
        List<EquipmentDocumentSchemeVO> equipmentDocumentSchemeVOList = BeanMapper.mapList(equipmentDocumentSchemeEntityList, EquipmentDocumentSchemeVO.class);

        //获取报价方案详情
        LambdaQueryWrapper<EquipmentDocumentSellEntity> lambdaSell = Wrappers.<EquipmentDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(EquipmentDocumentSellEntity::getDocumentId,equipmentDocumentSupplierEntity.getDocumentId());
        List<EquipmentDocumentSellEntity> equipmentDocumentSellEntityList = equipmentDocumentSellService.list(lambdaSell);
        List<EquipmentDocumentSellVO> equipmentDocumentSellVOList = BeanMapper.mapList(equipmentDocumentSellEntityList, EquipmentDocumentSellVO.class);
        Map<Long, List<EquipmentDocumentSellVO>> sellMap = equipmentDocumentSellVOList.stream().
                collect(Collectors.groupingBy(EquipmentDocumentSellVO::getSchemeId));
        for (EquipmentDocumentSchemeVO equipmentDocumentSchemeVO : equipmentDocumentSchemeVOList){
            List<EquipmentDocumentSellVO> equipmentDocumentSellVOS = sellMap.get(equipmentDocumentSchemeVO.getId());
            equipmentDocumentSchemeVO.setEquipmentDocumentSellList(equipmentDocumentSellVOS);
        }
        equipmentDocumentSupplierSellVO.setEquipmentDocumentSchemeList(equipmentDocumentSchemeVOList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if (fileInfo != null){
            if (fileInfo.containsKey("attachId")){
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                equipmentDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")){
                equipmentDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }

        return equipmentDocumentSupplierSellVO;
    }

    @Override
    public EquipmentDocumentVO saveOrUpdates(EquipmentDocumentVO saveorUpdateVO) {
        EquipmentDocumentEntity entity = BeanMapper.map(saveorUpdateVO, EquipmentDocumentEntity.class);
        service.saveOrUpdate(entity, false);
        EquipmentDocumentVO vo = BeanMapper.map(entity, EquipmentDocumentVO.class);
        EquipmentInviteEntity subInviteEntity = equipmentInviteService.selectById(entity.getInviteId());
        List<EquipmentInviteDetailRecordVO> subInviteDetailRecordVOS = BeanMapper.mapList(subInviteEntity.getEquipmentDetailRecord(), EquipmentInviteDetailRecordVO.class);
        vo.setEquipmentDetailRecord(subInviteDetailRecordVOS);
        return vo;
    }


    @Override
    public EquipmentDocumentVO queryDocDetail(Long id,Integer talkNum) {

        EquipmentDocumentEntity entity = super.selectById(id);
        EquipmentDocumentVO equipmentDocumentVO = BeanMapper.map(entity, EquipmentDocumentVO.class);

        equipmentDocumentVO.setEquipmentDocumentSchemeList(null);
        equipmentDocumentVO.setEquipmentDocumentSellList(null);
        //处理报名供应商信息
        if(equipmentDocumentVO.getNoticeId()!=null){
            LambdaQueryWrapper<EquipmentNoticeSupplierEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(EquipmentNoticeSupplierEntity::getNoticeId, entity.getNoticeId());
            wrapper.ne(EquipmentNoticeSupplierEntity::getState, 1);
            List<EquipmentNoticeSupplierEntity> list = equipmentNoticeSupplierService.list(wrapper);//未剔除的报名供应商
            if(CollectionUtils.isNotEmpty(list)){
                List<EquipmentNoticeSupplierVO> noticeSupplierVOS = BeanMapper.mapList(list, EquipmentNoticeSupplierVO.class);
                Map<Long, EquipmentDocumentSupplierVO> documentSupplierVOMap = new HashMap<>();
                if(CollectionUtils.isNotEmpty(equipmentDocumentVO.getEquipmentDocumentSupplierList())){
                    documentSupplierVOMap = equipmentDocumentVO.getEquipmentDocumentSupplierList().stream().filter(t->t.getSupplierId()!=null).collect(Collectors.toMap(EquipmentDocumentSupplierVO::getSupplierId, item -> item, (v1, v2) -> v2));
                }
                for (EquipmentNoticeSupplierVO noticeSupplier :  noticeSupplierVOS) {
                    if(documentSupplierVOMap.containsKey(noticeSupplier.getSupplierId())){
                        noticeSupplier.setDocumentType(0);//已报价
                    }else {
                        noticeSupplier.setDocumentType(1);//未报价
                    }
                }
                equipmentDocumentVO.setEquipmentDocumentSupplierDetail(noticeSupplierVOS);
            }
        }
        //处理报价信息,开标之前不能显示
        //按供应商查看报价()
        LambdaQueryWrapper<EquipmentDocumentSupplierEntity> lambda = Wrappers.<EquipmentDocumentSupplierEntity>lambdaQuery();
        lambda.eq(EquipmentDocumentSupplierEntity::getDocumentId, id);
        lambda.eq(EquipmentDocumentSupplierEntity::getTalkNum, talkNum);
        List<EquipmentDocumentSupplierEntity> supplierList = equipmentDocumentSupplierService.list(lambda);

        if (CollectionUtils.isNotEmpty(supplierList)){
            List<EquipmentDocumentSupplierVO> equipmentDocumentSupplierVOS = BeanMapper.mapList(supplierList, EquipmentDocumentSupplierVO.class);
            LambdaQueryWrapper<EquipmentDocumentSchemeEntity> lambdaScheme = Wrappers.<EquipmentDocumentSchemeEntity>lambdaQuery();
            lambdaScheme.eq(EquipmentDocumentSchemeEntity::getDocumentId, id);
            lambdaScheme.eq(EquipmentDocumentSchemeEntity::getTalkNum, talkNum);
            lambdaScheme.orderByAsc(EquipmentDocumentSchemeEntity::getSchemeName);
            List<EquipmentDocumentSchemeEntity> schemeList = equipmentDocumentSchemeService.list(lambdaScheme);
            Map<Long, List<EquipmentDocumentSchemeEntity>> schemeMap = schemeList.stream().
                    collect(Collectors.groupingBy(EquipmentDocumentSchemeEntity::getDocumentSupplierId));
            //是否开标,0-是,1-否
            if (entity.getBidFlag() == 0){
                for (EquipmentDocumentSupplierVO equipmentDocumentSupplierEntity : equipmentDocumentSupplierVOS){
                    List<EquipmentDocumentSchemeEntity> equipmentDocumentSchemeEntities = schemeMap.get(equipmentDocumentSupplierEntity.getId());
                    String schemeMoney  = "";
                    for (EquipmentDocumentSchemeEntity equipmentDocumentSchemeEntity : equipmentDocumentSchemeEntities){
                        schemeMoney = schemeMoney + equipmentDocumentSchemeEntity.getSchemeName() + ":" + equipmentDocumentSchemeEntity.getMoneyTax().setScale(2,BigDecimal.ROUND_HALF_DOWN) + "元" + ";";
                    }
                    int length = schemeMoney.length();
                    String schemeMoneyNew = schemeMoney.substring(0, length - 1);
                    equipmentDocumentSupplierEntity.setSchemeMoney(schemeMoneyNew);
                }

                //处理供应商附件信息
                if (CollectionUtils.isNotEmpty(equipmentDocumentSupplierVOS)){
                    List<Long> attachIds = equipmentDocumentSupplierVOS.stream().map(EquipmentDocumentSupplierVO::getId).collect(Collectors.toList());
                    Map<String, List<Long>> map = new HashMap<>();
                    map.put("sourceIds",attachIds);
                    JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(map));
                    CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(itemJSONObj);
                    if (listCommonResponse.isSuccess()){
                        List<AttachmentVO> data = listCommonResponse.getData();
                        if (CollectionUtils.isNotEmpty(data)){
                            Map<Long, AttachmentVO> attacMap = data.stream().collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                            for (EquipmentDocumentSupplierVO equipmentDocumentSupplierVO : equipmentDocumentSupplierVOS){
                                AttachmentVO attachmentVO = attacMap.get(equipmentDocumentSupplierVO.getId());
                                if(attachmentVO != null){
                                    equipmentDocumentSupplierVO.setAttachId(attachmentVO.getId());
                                    equipmentDocumentSupplierVO.setFileName(attachmentVO.getFileName());
                                }
                            }
                        }
                    }
                }
            }

            //是否开标,0-是,1-否
//            if (entity.getBidFlag() == 1){
//                for (EquipmentDocumentSupplierVO equipmentDocumentSupplierVO : equipmentDocumentSupplierVOS){
//                    equipmentDocumentSupplierVO.setRegisterDate(null);
//                }
//            }
            //按供应商查看报价
            equipmentDocumentVO.setEquipmentDocumentSupplierList(equipmentDocumentSupplierVOS);
            //前端键值重复设计
            equipmentDocumentVO.setEquipmentDocumentSupplierSchemeList(equipmentDocumentSupplierVOS);
            //按材料查看报价
            List<EquipmentDocumentDetailVO> equipmentDocumentDetailList = equipmentDocumentVO.getEquipmentDocumentDetailList();
            //获取材料明细报价
            LambdaQueryWrapper<EquipmentDocumentSellEntity> lambdaSell = Wrappers.<EquipmentDocumentSellEntity>lambdaQuery();
            lambdaSell.eq(EquipmentDocumentSellEntity::getDocumentId, id);
            lambdaSell.eq(EquipmentDocumentSellEntity::getTalkNum, talkNum);
            lambdaSell.orderByAsc(EquipmentDocumentSellEntity::getSupplierId);
            lambdaSell.orderByAsc(EquipmentDocumentSellEntity::getSchemeName);
            List<EquipmentDocumentSellEntity> sellList = equipmentDocumentSellService.list(lambdaSell);
            if (CollectionUtils.isNotEmpty(sellList)){
                List<EquipmentDocumentSellVO> equipmentDocumentSellVOS = BeanMapper.mapList(sellList, EquipmentDocumentSellVO.class);
                for (EquipmentDocumentSellVO equipmentDocumentSellVO : equipmentDocumentSellVOS){
                    //是否开标,0-是,1-否
                    if (entity.getBidFlag() == 1){
                        equipmentDocumentSellVO.setPrice(null);
                        equipmentDocumentSellVO.setPriceTax(null);
                        equipmentDocumentSellVO.setMoney(null);
                        equipmentDocumentSellVO.setMoneyTax(null);
                        equipmentDocumentSellVO.setSellTax(null);
                        equipmentDocumentSellVO.setTenderNum(null);
                        equipmentDocumentSellVO.setTenderMoney(null);
                        equipmentDocumentSellVO.setTenderFlag(null);
                    }
                    if (entity.getBidFlag() == 0){
                        equipmentDocumentSellVO.setTenderNum(null);
                        equipmentDocumentSellVO.setTenderMoney(null);
                        equipmentDocumentSellVO.setTenderFlag(null);
                    }
                }
                Map<Long, List<EquipmentDocumentSellVO>> sellMap = equipmentDocumentSellVOS.stream().
                        collect(Collectors.groupingBy(EquipmentDocumentSellVO::getDetailId));
                for (EquipmentDocumentDetailVO equipmentDocumentDetailVO : equipmentDocumentDetailList){
                    List<EquipmentDocumentSupplierVO> documentSupplierVOS = new ArrayList<>();
                    List<EquipmentDocumentSellVO> equipmentDocumentSellEntities = sellMap.get(equipmentDocumentDetailVO.getId());
                    Map<Long, List<EquipmentDocumentSellVO>> sellDetailMap = equipmentDocumentSellEntities.stream().
                            collect(Collectors.groupingBy(EquipmentDocumentSellVO::getSupplierId));
                    sellDetailMap.forEach((key,value) ->{
                        EquipmentDocumentSupplierVO equipmentDocumentSupplierVO = new EquipmentDocumentSupplierVO();
                        equipmentDocumentSupplierVO.setSupplierId(key);
                        EquipmentDocumentSellVO equipmentDocumentSellVO = value.stream().findFirst().get();
                        equipmentDocumentSupplierVO.setSupplierName(equipmentDocumentSellVO.getSupplierName());
                        equipmentDocumentSupplierVO.setEquipmentDocumentSellVOList(value);
                        documentSupplierVOS.add(equipmentDocumentSupplierVO);
                    });
                    equipmentDocumentDetailVO.setEquipmentDocumentSupplierVOList(documentSupplierVOS);
                }
                //区分报价详情信息
                List<EquipmentDocumentDetailVO> equipmentDocumentDetailSellList = equipmentDocumentVO.getEquipmentDocumentDetailList();
                equipmentDocumentVO.setEquipmentDocumentDetailSellList(equipmentDocumentDetailSellList);
            }
        }

        return equipmentDocumentVO;
    }


    @Override
    public List<EquipmentDocumentSellVO> getSchemeDetail(EquipmentDocumentSellVO equipmentDocumentSellVO) {
        LambdaQueryWrapper<EquipmentDocumentSellEntity> lambdaSell = Wrappers.<EquipmentDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(EquipmentDocumentSellEntity::getSupplierId,equipmentDocumentSellVO.getSupplierId() );
        lambdaSell.eq(EquipmentDocumentSellEntity::getDocumentId,equipmentDocumentSellVO.getDocumentId() );
        lambdaSell.eq(EquipmentDocumentSellEntity::getSchemeId,equipmentDocumentSellVO.getSchemeId() );
        List<EquipmentDocumentSellEntity> list = equipmentDocumentSellService.list(lambdaSell);
        List<EquipmentDocumentSellVO> equipmentDocumentSellVOList = BeanMapper.mapList(list,EquipmentDocumentSellVO.class);
        return equipmentDocumentSellVOList;
    }

    @Override
    public EquipmentDocumentSupplierSellVO getSupplierSchemeDetail(Long supplierDetailId, Long documentId) {
        EquipmentDocumentEntity equipmentDocumentEntity = super.selectById(documentId);
        EquipmentDocumentSupplierSellVO equipmentDocumentSupplierSellVO = new EquipmentDocumentSupplierSellVO();
        EquipmentDocumentSupplierEntity equipmentDocumentSupplierEntity = equipmentDocumentSupplierService.selectById(supplierDetailId);
        equipmentDocumentSupplierSellVO.setLinkName(equipmentDocumentSupplierEntity.getLinkName());
        equipmentDocumentSupplierSellVO.setSupplierId(equipmentDocumentSupplierEntity.getSupplierId());
        equipmentDocumentSupplierSellVO.setSupplierName(equipmentDocumentSupplierEntity.getSupplierName());
        equipmentDocumentSupplierSellVO.setLinkMobile(equipmentDocumentSupplierEntity.getLinkMobile());
        equipmentDocumentSupplierSellVO.setOfferTime(equipmentDocumentSupplierEntity.getOfferTime());
        equipmentDocumentSupplierSellVO.setTaxMemo(equipmentDocumentSupplierEntity.getTaxMemo());
        equipmentDocumentSupplierSellVO.setPurchaseType(equipmentDocumentEntity.getPurchaseType());
        LambdaQueryWrapper<EquipmentDocumentSchemeEntity> lambdaScheme = Wrappers.<EquipmentDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(EquipmentDocumentSchemeEntity::getDocumentSupplierId,supplierDetailId);
        List<EquipmentDocumentSchemeEntity> equipmentDocumentSchemeEntityList = equipmentDocumentSchemeService.list(lambdaScheme);
        List<EquipmentDocumentSchemeVO> equipmentDocumentSchemeVOList = BeanMapper.mapList(equipmentDocumentSchemeEntityList, EquipmentDocumentSchemeVO.class);

        //获取报价方案详情
        LambdaQueryWrapper<EquipmentDocumentSellEntity> lambdaSell = Wrappers.<EquipmentDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(EquipmentDocumentSellEntity::getDocumentId,equipmentDocumentSupplierEntity.getDocumentId());
        List<EquipmentDocumentSellEntity> equipmentDocumentSellEntityList = equipmentDocumentSellService.list(lambdaSell);
        List<EquipmentDocumentSellVO> equipmentDocumentSellVOList = BeanMapper.mapList(equipmentDocumentSellEntityList, EquipmentDocumentSellVO.class);
        Map<Long, List<EquipmentDocumentSellVO>> sellMap = equipmentDocumentSellVOList.stream().
                collect(Collectors.groupingBy(EquipmentDocumentSellVO::getSchemeId));
        for (EquipmentDocumentSchemeVO equipmentDocumentSchemeVO : equipmentDocumentSchemeVOList){
            List<EquipmentDocumentSellVO> equipmentDocumentSellVOS = sellMap.get(equipmentDocumentSchemeVO.getId());
            equipmentDocumentSchemeVO.setEquipmentDocumentSellList(equipmentDocumentSellVOS);
        }
        equipmentDocumentSupplierSellVO.setEquipmentDocumentSchemeList(equipmentDocumentSchemeVOList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if (fileInfo != null){
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                equipmentDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                equipmentDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }

        return equipmentDocumentSupplierSellVO;
    }
    @Transactional
    @Override
    public EquipmentDocumentVO extendDocument(EquipmentDocumentRecordVO equipmentDocumentRecordVO) {
        EquipmentDocumentRecordEntity equipmentDocumentRecordEntity = BeanMapper.map(equipmentDocumentRecordVO, EquipmentDocumentRecordEntity.class);
        equipmentDocumentRecordService.save(equipmentDocumentRecordEntity);
        EquipmentDocumentEntity equipmentDocumentEntity = super.selectById(equipmentDocumentRecordVO.getDocumentId());
        equipmentDocumentEntity.setOfferEndTime(equipmentDocumentRecordVO.getNewTime());
        boolean b = super.updateById(equipmentDocumentEntity);

        //推送供方
        EquipmentSupplierSellVO supplierSellVO = new EquipmentSupplierSellVO();
        supplierSellVO.setSourceId(Long.toString(equipmentDocumentEntity.getInviteId()));
        supplierSellVO.setOfferEndTime(equipmentDocumentRecordVO.getNewTime());

        String stringFb = JSONObject.toJSONString(supplierSellVO);
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(updateTimeUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("招标文件同步供方接口报错" + stringCommonResponse.getMsg());
        }

        EquipmentDocumentVO equipmentDocumentVO = queryDetail(equipmentDocumentRecordVO.getDocumentId());
        return equipmentDocumentVO;
    }

    @Override
    public EquipmentDocumentSupplierSellVO getSupplierSchemeTalkDetail(Long supplierDetailId, Long talkId) {

        EquipmentTalkEntity equipmentTalkEntity = equipmentTalkService.selectById(talkId);
        Integer talkNum = equipmentTalkEntity.getTalkNum();
        if(equipmentTalkEntity.getPublishFlag() == 1){
            talkNum = talkNum - 1;
        }
        List<EquipmentTalkVO> talkVOArrayList = new ArrayList<>();
        String name = null;
        for (int a = 0;a <= talkNum;a++){
            EquipmentTalkVO equipmentTalkVO = new EquipmentTalkVO();
            equipmentTalkVO.setTalkNum(a);
            if (a == 0){
                name = "首次报价";
            }else {
                name = "第" + a + "轮报价";
            }
            equipmentTalkVO.setTalkNumName(name);
            talkVOArrayList.add(equipmentTalkVO);
        }

        EquipmentDocumentSupplierSellVO equipmentDocumentSupplierSellVO = new EquipmentDocumentSupplierSellVO();
        EquipmentDocumentSupplierEntity equipmentDocumentSupplierEntity = equipmentDocumentSupplierService.selectById(supplierDetailId);
        equipmentDocumentSupplierSellVO.setLinkName(equipmentDocumentSupplierEntity.getLinkName());
        equipmentDocumentSupplierSellVO.setLinkMobile(equipmentDocumentSupplierEntity.getLinkMobile());
        equipmentDocumentSupplierSellVO.setOfferTime(equipmentDocumentSupplierEntity.getOfferTime());
        equipmentDocumentSupplierSellVO.setTaxMemo(equipmentDocumentSupplierEntity.getTaxMemo());
        equipmentDocumentSupplierSellVO.setSupplierName(equipmentDocumentSupplierEntity.getSupplierName());

        for (EquipmentTalkVO equipmentTalkVO : talkVOArrayList){
            LambdaQueryWrapper<EquipmentDocumentSchemeEntity> lambdaScheme = Wrappers.<EquipmentDocumentSchemeEntity>lambdaQuery();
            lambdaScheme.eq(EquipmentDocumentSchemeEntity::getDocumentId,equipmentDocumentSupplierEntity.getDocumentId());
            lambdaScheme.eq(EquipmentDocumentSchemeEntity::getSupplierId,equipmentDocumentSupplierEntity.getSupplierId());
            lambdaScheme.eq(EquipmentDocumentSchemeEntity::getTalkNum,equipmentTalkVO.getTalkNum());
            List<EquipmentDocumentSchemeEntity> equipmentDocumentSchemeEntityList = equipmentDocumentSchemeService.list(lambdaScheme);
            if(CollectionUtils.isEmpty(equipmentDocumentSchemeEntityList)){
                continue;
            }
            List<EquipmentDocumentSchemeVO> equipmentDocumentSchemeVOList = BeanMapper.mapList(equipmentDocumentSchemeEntityList, EquipmentDocumentSchemeVO.class);

            //获取报价方案详情
            List<Long> schemePkList = equipmentDocumentSchemeVOList.stream().map(EquipmentDocumentSchemeVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper<EquipmentDocumentSellEntity> lambdaSell = Wrappers.<EquipmentDocumentSellEntity>lambdaQuery();
            lambdaSell.in(EquipmentDocumentSellEntity::getSchemeId,schemePkList);
            List<EquipmentDocumentSellEntity> equipmentDocumentSellEntityList = equipmentDocumentSellService.list(lambdaSell);
            List<EquipmentDocumentSellVO> equipmentDocumentSellVOList = BeanMapper.mapList(equipmentDocumentSellEntityList, EquipmentDocumentSellVO.class);
            Map<Long, List<EquipmentDocumentSellVO>> sellMap = equipmentDocumentSellVOList.stream().
                    collect(Collectors.groupingBy(EquipmentDocumentSellVO::getSchemeId));
            for (EquipmentDocumentSchemeVO equipmentDocumentSchemeVO : equipmentDocumentSchemeVOList){
                List<EquipmentDocumentSellVO> equipmentDocumentSellVOS = sellMap.get(equipmentDocumentSchemeVO.getId());
                equipmentDocumentSchemeVO.setEquipmentDocumentSellList(equipmentDocumentSellVOS);
            }
            equipmentTalkVO.setEquipmentDocumentSchemeList(equipmentDocumentSchemeVOList);
        }
        equipmentDocumentSupplierSellVO.setEquipmentTalkVOList(talkVOArrayList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if(fileInfo != null){
            if (fileInfo.containsKey("attachId")){
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                equipmentDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")){
                equipmentDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }


        return equipmentDocumentSupplierSellVO;
    }

    private Map<String,Object> getFileInfo(Long sourceId) {
        Map<String, Object> map = new HashMap<>();
        //查询附件
        CommonResponse<List<AttachmentVO>> attachResponse = attachmentApi.queryListBySourceId(sourceId, BILL_SUPPLIER_TYPE, "supplierFileType", null);
        if (attachResponse.isSuccess()){
            List<AttachmentVO> data = attachResponse.getData();
            if(CollectionUtils.isNotEmpty(data)){
                AttachmentVO attachmentVO = data.stream().findFirst().get();
                if(attachmentVO != null){
                    map.put("fileName",attachmentVO.getFileName());
                    map.put("attachId",attachmentVO.getId());
                }


            }
        }
        return map;
    }

    @Override
    public EquipmentDocumentVO publishManyDocument(Long id) throws InvocationTargetException, IllegalAccessException {
        //更新发布状态
        EquipmentDocumentEntity equipmentDocumentEntity = super.selectById(id);
        equipmentDocumentEntity.setPublishFlag(0);
        super.updateById(equipmentDocumentEntity);


        EquipmentNoticeSupplierTbVO equipmentNoticeSupplierTbVO = new EquipmentNoticeSupplierTbVO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        equipmentNoticeSupplierTbVO.setSourceType("郑州一建招标文件");
        equipmentNoticeSupplierTbVO.setSourceId(equipmentDocumentEntity.getInviteId().toString());
        EquipmentInviteEntity inviteEntity = equipmentInviteService.selectById(equipmentDocumentEntity.getInviteId());
        if (equipmentDocumentEntity.getTenderType()==2){
            equipmentNoticeSupplierTbVO.setNoticeType(2);
        }else {
            equipmentNoticeSupplierTbVO.setNoticeType(3);
        }
        if (equipmentDocumentEntity.getPurchaseType()==1){
            equipmentNoticeSupplierTbVO.setSourceProjectId(null);
            equipmentNoticeSupplierTbVO.setProjectName(null);
            equipmentNoticeSupplierTbVO.setProjectCode(null);
        }else {
            equipmentNoticeSupplierTbVO.setSourceProjectId(equipmentDocumentEntity.getProjectId().toString());
            equipmentNoticeSupplierTbVO.setProjectName(equipmentDocumentEntity.getProjectName());
            equipmentNoticeSupplierTbVO.setProjectCode(equipmentDocumentEntity.getProjectCode());
        }

        equipmentNoticeSupplierTbVO.setSourceOrgId(equipmentDocumentEntity.getOrgId().toString());
        equipmentNoticeSupplierTbVO.setOrgName(equipmentDocumentEntity.getOrgName());
        equipmentNoticeSupplierTbVO.setSourceUnitId(equipmentDocumentEntity.getUnitId().toString());
        equipmentNoticeSupplierTbVO.setUnitName(equipmentDocumentEntity.getUnitName());
        equipmentNoticeSupplierTbVO.setMemo(equipmentDocumentEntity.getMemo());
        equipmentNoticeSupplierTbVO.setType("PURCHASE");
        equipmentNoticeSupplierTbVO.setTenderName(equipmentDocumentEntity.getDocumentName());
        equipmentNoticeSupplierTbVO.setTenderType(equipmentDocumentEntity.getTenderType());
        equipmentNoticeSupplierTbVO.setPurchaseType(equipmentDocumentEntity.getPurchaseType().toString());
        equipmentNoticeSupplierTbVO.setPurchaseName(equipmentDocumentEntity.getPurchaseName());
        equipmentNoticeSupplierTbVO.setSourceEmployeeId(equipmentDocumentEntity.getEmployeeId().toString());
        equipmentNoticeSupplierTbVO.setEmployeeName(equipmentDocumentEntity.getEmployeeName());
        equipmentNoticeSupplierTbVO.setEmployeeMobile(equipmentDocumentEntity.getEmployeeMobile());
        equipmentNoticeSupplierTbVO.setValueType(equipmentDocumentEntity.getValueType());
        equipmentNoticeSupplierTbVO.setContent(equipmentDocumentEntity.getDocumentContent());
        equipmentNoticeSupplierTbVO.setOfferStartTime(sdf.format(equipmentDocumentEntity.getOfferStartTime()));
        equipmentNoticeSupplierTbVO.setOfferEndTime(sdf.format(equipmentDocumentEntity.getOfferEndTime()));
        equipmentNoticeSupplierTbVO.setBrandFlag(equipmentDocumentEntity.getBrandFlag());
        equipmentNoticeSupplierTbVO.setProjectLinkName(equipmentDocumentEntity.getProjectLinkName());
        equipmentNoticeSupplierTbVO.setProjectLinkPhone(equipmentDocumentEntity.getProjectLinkPhone());
        equipmentNoticeSupplierTbVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());
        equipmentNoticeSupplierTbVO.setMaterialContentId(inviteEntity.getPurchaseId());
        equipmentNoticeSupplierTbVO.setMaterialContent(inviteEntity.getPurchaseName());
        equipmentNoticeSupplierTbVO.setSettlementClause(inviteEntity.getSettlementClause());
        //插入物资
        List<EquipmentNoticeDetailTbVO> equipmentNoticeDetailVOS = new ArrayList<>();
        List<EquipmentDocumentDetailVO> documentDetailEntityList =  baseMapper.selectSumDetail(equipmentDocumentEntity.getId());
        for (EquipmentDocumentDetailVO equipmentDocumentDetailEntity : documentDetailEntityList) {
            EquipmentNoticeDetailTbVO equipmentNoticeDetailTbVO = new EquipmentNoticeDetailTbVO();
            BeanUtils.copyProperties(equipmentNoticeDetailTbVO,equipmentDocumentDetailEntity);
            equipmentNoticeDetailTbVO.setNum(equipmentDocumentDetailEntity.getSumNum());
            equipmentNoticeDetailTbVO.setMoney(equipmentDocumentDetailEntity.getSumMoney());
            equipmentNoticeDetailTbVO.setMoneyTax(equipmentDocumentDetailEntity.getSumMoneyTax());
            equipmentNoticeDetailTbVO.setSourceId(equipmentDocumentEntity.getInviteId().toString());
            equipmentNoticeDetailTbVO.setSourceMaterialId(equipmentDocumentDetailEntity.getMaterialId()==null?null:equipmentDocumentDetailEntity.getMaterialId().toString());
            equipmentNoticeDetailTbVO.setSourceMaterialTypeId(equipmentDocumentDetailEntity.getMaterialTypeId().toString());
            equipmentNoticeDetailVOS.add(equipmentNoticeDetailTbVO);
        }
        equipmentNoticeSupplierTbVO.setPurchaseDetailList(equipmentNoticeDetailVOS);
        //是否是邀请招标
        if (equipmentDocumentEntity.getTenderType()!=2){
            List<EquipmentDocumentSupplierDetailEntity> detailEntityList = supplierDetailService.list(new LambdaQueryWrapper<EquipmentDocumentSupplierDetailEntity>().eq(EquipmentDocumentSupplierDetailEntity::getInviteId, equipmentDocumentEntity.getInviteId()).eq(EquipmentDocumentSupplierDetailEntity::getDr, 0));
            List<EquipmentNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<>();
            for (EquipmentDocumentSupplierDetailEntity supplierDetailEntity : detailEntityList) {
                EquipmentNoticeSupplierDetailTbVO equipmentNoticeSupplierDetailTbVO = new EquipmentNoticeSupplierDetailTbVO();
                equipmentNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
                equipmentNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
                //todo
//                HashMap<Long, Long> hashMap = new HashMap<>();
//                hashMap.put(1406947724700246112L,1471726626618441730L);
//                hashMap.put(1406947724700246113L,1471729176256151553L);
//                hashMap.put(1406947724700246114L,1471731643794554881L);
//                hashMap.put(527888337260777477L,1472852233918054402L);
//
//                //云南建设总承包公司测试用户
//                hashMap.put(528220972239556690L,1473189202070044674L);
//                hashMap.put(528222266413027386L,1473189172567310338L);
//                hashMap.put(528222429273657395L,1473189113180160002L);
//                hashMap.put(528222690796900362L,1473190529172996098L);
                equipmentNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));

                supplierDetailTbVOList.add(equipmentNoticeSupplierDetailTbVO);
            }
            equipmentNoticeSupplierTbVO.setApplyList(supplierDetailTbVOList);
        }
        String stringFb = JSONObject.toJSONString(equipmentNoticeSupplierTbVO);
        //调用第三方报名接口
//        CommonResponse<JSONObject> response = null;
//        logger.info("发布内容"+stringFb);
//        try {
//            response = new ThirdSystemUtils().sendPostReq(tokenUrl,saveOrUpdateUrl, stringFb,cacheManager);
//            if(!response.isSuccess()) {
//                throw new BusinessException("招标文件同步供方接口报错" + response.getMsg());
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//            throw new BusinessException("招标文件同步供方接口报错" + response.getMsg());
//        }
        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, stringFb, appId,appSecret,appHost);
            if (!response.isSuccess()){
                throw new BusinessException("招标文件同步供方接口报错" + response.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            throw new BusinessException("招标文件同步供方接口报错" + response.getMsg());
        }
        return queryDetail(id);
    }
    @Override
    public CommonResponse delSupplier(Long id) {
        EquipmentDocumentEntity equipmentDocumentEntity = baseMapper.selectById(id);
        List<EquipmentDocumentSupplierEntity> equipmentDocumentSupplierList = supplierMapper.selectList(new QueryWrapper<EquipmentDocumentSupplierEntity>().eq("document_id", equipmentDocumentEntity.getId()).eq("dr", 0));
        List<EquipmentDocumentSupplierDetailEntity> supplierDetailList = supplierDetailMapper.selectList(new QueryWrapper<EquipmentDocumentSupplierDetailEntity>().eq("invite_id", equipmentDocumentEntity.getInviteId()).eq("dr", 0));
        List<Long> oldIds = new ArrayList<>();
        List<Long> newIds = new ArrayList<>();
        equipmentDocumentSupplierList.stream().forEach(it->oldIds.add(it.getSupplierId()));
        supplierDetailList.stream().forEach(it->newIds.add(it.getSupplierId()));
        List<Long> newId = newIds.stream().filter(it -> !oldIds.contains(it)).collect(Collectors.toList());
        List<EquipmentDocumentSupplierDetailEntity> newRequestList = supplierDetailList.stream().filter(it -> newId.contains(it.getSupplierId())).collect(Collectors.toList());
        //装填数据
        List<EquipmentNoticeSupplierDetailTbVO> signVOList = new ArrayList<>();
        for (EquipmentDocumentSupplierDetailEntity supplierDetailEntity : newRequestList) {
            EquipmentNoticeSupplierDetailTbVO equipmentNoticeSupplierDetailTbVO = new EquipmentNoticeSupplierDetailTbVO();
            equipmentNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
            equipmentNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
            equipmentNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));

            equipmentNoticeSupplierDetailTbVO.setOutReason("超时未报价");
            signVOList.add(equipmentNoticeSupplierDetailTbVO);
        }
        logger.info("剔除的供应商"+JSON.toJSONString(signVOList));
        //调用第三方接口
        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, JSON.toJSONString(signVOList), appId,appSecret,appHost);
            if (!response.isSuccess()){
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }
        return CommonResponse.success("剔除供应商成功");
    }

    @Override
    public EquipmentDocumentVO saveManyDocument(Long id) {
        EquipmentDocumentEntity equipmentDocumentEntity = new EquipmentDocumentEntity();
        //查询招标主表信息
        EquipmentInviteEntity inviteEntity = equipmentInviteService.selectById(id);
        //复制主表
        equipmentDocumentEntity.setInviteId(inviteEntity.getId());
        equipmentDocumentEntity.setDocumentName(inviteEntity.getTenderName());
        if (inviteEntity.getPurchaseType()==0){
            equipmentDocumentEntity.setProjectId(inviteEntity.getProjectId());
            equipmentDocumentEntity.setProjectName(inviteEntity.getProjectName());
            equipmentDocumentEntity.setProjectCode(inviteEntity.getProjectCode());
        }
        equipmentDocumentEntity.setPurchaseId(inviteEntity.getPurchaseId());
        equipmentDocumentEntity.setPurchaseName(inviteEntity.getPurchaseName());
        equipmentDocumentEntity.setPurchaseType(inviteEntity.getPurchaseType());
        equipmentDocumentEntity.setOrgId(inviteEntity.getOrgId());
        equipmentDocumentEntity.setOrgName(inviteEntity.getOrgName());
        equipmentDocumentEntity.setParentOrgId(inviteEntity.getParentOrgId());
        equipmentDocumentEntity.setParentOrgName(inviteEntity.getParentOrgName());
        equipmentDocumentEntity.setValueType(inviteEntity.getValueType());
        equipmentDocumentEntity.setUnitId(inviteEntity.getUnitId());
        equipmentDocumentEntity.setUnitName(inviteEntity.getUnitName());
        equipmentDocumentEntity.setTenderType(inviteEntity.getTenderType());
        equipmentDocumentEntity.setSettlementClause(inviteEntity.getSettlementClause());

        //设置计价方式
        equipmentDocumentEntity.setBidFlag(1);
        equipmentDocumentEntity.setPublishFlag(1);
        equipmentDocumentEntity.setNextFlag(1);


        //复制物资详情
        List<EquipmentInviteDetailEntity> equipmentNoticeDetailList = inviteEntity.getEquipmentDetail();
        List<EquipmentDocumentDetailEntity> equipmentDocumentDetailList = BeanMapper.mapList(equipmentNoticeDetailList, EquipmentDocumentDetailEntity.class);
        for (EquipmentDocumentDetailEntity equipmentDocumentDetailEntity : equipmentDocumentDetailList){
            equipmentDocumentDetailEntity.setId(null);
        }
        equipmentDocumentEntity.setEquipmentDocumentDetailList(equipmentDocumentDetailList);

        //复制供应商
        List<EquipmentInviteSupplierEntity> supplierDetailList = inviteEntity.getSupplierDetail();
        List<EquipmentDocumentSupplierDetailEntity> equipmentDocumentSupplierDetailVOS = BeanMapper.mapList(supplierDetailList, EquipmentDocumentSupplierDetailEntity.class);
        for (EquipmentDocumentSupplierDetailEntity equipmentDocumentSupplierDetailVO : equipmentDocumentSupplierDetailVOS) {
            equipmentDocumentSupplierDetailVO.setId(null);
            documentSupplierDetailService.saveOrUpdate(equipmentDocumentSupplierDetailVO);
        }

        service.saveOrUpdate(equipmentDocumentEntity, false);

        ProcessEntity processEntity = new ProcessEntity();
        //回写招标阶段
        switch(inviteEntity.getTenderType()){
            case 3:
                inviteEntity.setTenderStage(6);
                processEntity.setBillName("竞争性谈判");
                break;
            case 4:
                inviteEntity.setTenderStage(8);
                processEntity.setBillName("单一来源");
                break;
            case 5:
                inviteEntity.setTenderStage(9);
                processEntity.setBillName("紧急招标");
                break;
            case 2:
                inviteEntity.setTenderStage(10);
                processEntity.setBillName("询价公告");
                break;
        }
        equipmentInviteService.updateById(inviteEntity);
        //回写进展表
        processEntity.setBillId(equipmentDocumentEntity.getId());
        processEntity.setTenderId(id);
        processEntity.setType(2);
        processEntity.setFrontendUrl("equipment/fourJzDyJjXj");
        processService.saveOrUpdate(processEntity);
        EquipmentDocumentVO vo = BeanMapper.map(equipmentDocumentEntity, EquipmentDocumentVO.class);
        return vo;
    }

    @Override
    public EquipmentDocumentSupplierSellVO getSupplierSchemeDetailTalk(Long supplierDetailId, Long talkId) {
        //获取轮数
        EquipmentTalkRecordEntity equipmentTalkRecordEntity = equipmentTalkRecordService.selectById(talkId);
        Integer talkNum = equipmentTalkRecordEntity.getTalkNum();
        if (equipmentTalkRecordEntity.getPublishFlag() == 1){
            talkNum = talkNum - 1;
        }

        //
        EquipmentDocumentSupplierSellVO equipmentDocumentSupplierSellVO = new EquipmentDocumentSupplierSellVO();
        EquipmentDocumentSupplierEntity equipmentDocumentSupplierEntity = equipmentDocumentSupplierService.selectById(supplierDetailId);
        equipmentDocumentSupplierSellVO.setLinkName(equipmentDocumentSupplierEntity.getLinkName());
        equipmentDocumentSupplierSellVO.setLinkMobile(equipmentDocumentSupplierEntity.getLinkMobile());
        equipmentDocumentSupplierSellVO.setOfferTime(equipmentDocumentSupplierEntity.getOfferTime());
        equipmentDocumentSupplierSellVO.setTaxMemo(equipmentDocumentSupplierEntity.getTaxMemo());
        LambdaQueryWrapper<EquipmentDocumentSchemeEntity> lambdaScheme = Wrappers.<EquipmentDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(EquipmentDocumentSchemeEntity::getDocumentSupplierId,supplierDetailId);
        List<EquipmentDocumentSchemeEntity> equipmentDocumentSchemeEntityList = equipmentDocumentSchemeService.list(lambdaScheme);
        List<EquipmentDocumentSchemeVO> equipmentDocumentSchemeVOList = BeanMapper.mapList(equipmentDocumentSchemeEntityList, EquipmentDocumentSchemeVO.class);

        //获取报价方案详情
        LambdaQueryWrapper<EquipmentDocumentSellEntity> lambdaSell = Wrappers.<EquipmentDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(EquipmentDocumentSellEntity::getDocumentId,equipmentDocumentSupplierEntity.getDocumentId());
        lambdaSell.eq(EquipmentDocumentSellEntity::getTalkNum,talkNum);
        List<EquipmentDocumentSellEntity> equipmentDocumentSellEntityList = equipmentDocumentSellService.list(lambdaSell);
        List<EquipmentDocumentSellVO> equipmentDocumentSellVOList = BeanMapper.mapList(equipmentDocumentSellEntityList, EquipmentDocumentSellVO.class);
        Map<Long, List<EquipmentDocumentSellVO>> sellMap = equipmentDocumentSellVOList.stream().
                collect(Collectors.groupingBy(EquipmentDocumentSellVO::getSchemeId));
        for (EquipmentDocumentSchemeVO equipmentDocumentSchemeVO : equipmentDocumentSchemeVOList){
            List<EquipmentDocumentSellVO> equipmentDocumentSellVOS = sellMap.get(equipmentDocumentSchemeVO.getId());
            equipmentDocumentSchemeVO.setEquipmentDocumentSellList(equipmentDocumentSellVOS);
        }
        equipmentDocumentSupplierSellVO.setEquipmentDocumentSchemeList(equipmentDocumentSchemeVOList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if (fileInfo != null){
            if (fileInfo.containsKey("attachId")){
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                equipmentDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")){
                equipmentDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }


        return equipmentDocumentSupplierSellVO;
    }

    @Override
    public EquipmentDocumentVO saveDocument(Long noticeId) {
        EquipmentDocumentEntity entity = new EquipmentDocumentEntity();
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //查询公告主表信息
        EquipmentNoticeEntity equipmentNoticeEntity = equipmentNoticeService.selectById(noticeId);
        EquipmentInviteEntity equipmentInvite = equipmentInviteService.selectById(equipmentNoticeEntity.getInviteId());

        //复制物资详情
        List<EquipmentInviteDetailEntity> equipmentInviteDetailList = equipmentInvite.getEquipmentDetail();
        List<EquipmentDocumentDetailEntity> equipmentDocumentDetailList = BeanMapper.mapList(equipmentInviteDetailList, EquipmentDocumentDetailEntity.class);

        for (EquipmentDocumentDetailEntity equipmentDocumentDetailEntity : equipmentDocumentDetailList){
            equipmentDocumentDetailEntity.setId(null);
        }

        entity.setEquipmentDocumentDetailList(equipmentDocumentDetailList);


        //复制主表信息
        entity.setProjectId(equipmentNoticeEntity.getProjectId());
        entity.setNoticeId(noticeId);
        entity.setProjectName(equipmentNoticeEntity.getProjectName());
        entity.setOrgId(equipmentNoticeEntity.getOrgId());
        entity.setOrgName(equipmentNoticeEntity.getOrgName());
        entity.setParentOrgId(equipmentNoticeEntity.getParentOrgId());
        entity.setParentOrgName(equipmentNoticeEntity.getParentOrgName());
        entity.setProjectCode(equipmentNoticeEntity.getProjectCode());
        entity.setDocumentName(equipmentNoticeEntity.getNoticeName());
        entity.setEmployeeId(equipmentNoticeEntity.getEmployeeId());
        entity.setEmployeeName(equipmentNoticeEntity.getEmployeeName());
        entity.setEmployeeMobile(equipmentNoticeEntity.getEmployeeMobile());
        entity.setInviteId(equipmentNoticeEntity.getInviteId());
        entity.setPurchaseId(equipmentNoticeEntity.getPurchaseId());
        entity.setPurchaseName(equipmentNoticeEntity.getPurchaseName());
        entity.setPurchaseType(equipmentNoticeEntity.getPurchaseType());
        entity.setTenderType(equipmentNoticeEntity.getTenderType());
        //设置计价方式
        EquipmentInviteEntity equipmentInviteEntity = equipmentInviteService.selectById(equipmentNoticeEntity.getInviteId());
        entity.setValueType(equipmentInviteEntity.getValueType());
        entity.setBidFlag(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);

        service.saveOrUpdate(entity, false);

        //回写招标阶段
        equipmentInviteEntity.setTenderStage(3);
        equipmentInviteService.updateById(equipmentInviteEntity);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("招标文件");
        processEntity.setTenderId(equipmentNoticeEntity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("equipment/document");
        processService.saveOrUpdate(processEntity);
        EquipmentDocumentVO vo = BeanMapper.map(entity, EquipmentDocumentVO.class);
        return vo;
    }

    @Override
    public CommonResponse<Boolean> checkExpertNum(Long documentId) {
        //根据documentId查询数据库中专家数量
        List<EquipmentDocumentExpertEntity> expertEntityList = documentExpertService.list(Wrappers.<EquipmentDocumentExpertEntity>lambdaQuery()
                .eq(EquipmentDocumentExpertEntity::getDocumentId, documentId)
                .eq(EquipmentDocumentExpertEntity::getDr, 0)
        );
        int totalNum = expertEntityList.size();
        if(totalNum < 3){
            return CommonResponse.error("所选专家数量至少为3人！",false);
        }
        //判断专家数量是否为单数
        if(totalNum % 2 == 0){
            return CommonResponse.error("所选专家数量必须为单数！",false);
        }

        /**
         * !!!数据量大时会损失精度，目前业务不可能超过，所以进行强制转换
         */
        //筛选出库中集团、项目专家数量
        int departmentExpertNum = (int)expertEntityList.stream().filter(entity -> "集团".equals(entity.getExpertFromName())).count();
        int projectExpertNum = (int)expertEntityList.stream().filter(entity -> "项目".equals(entity.getExpertFromName())).count();
        //实际需要的数量
        int trueDepartmentExpertNum = (int)Math.ceil(totalNum * 1.0 / 3);
        int trueProjectExpertNum = totalNum - trueDepartmentExpertNum;
        if(departmentExpertNum != trueDepartmentExpertNum || projectExpertNum != trueProjectExpertNum){
            return CommonResponse.error("所选专家数量不符合要求！" +
                    "集团专家" + trueDepartmentExpertNum + "个," +
                    "项目专家" + trueProjectExpertNum + "个！",false);
        }
        return CommonResponse.success("专家选取成功！",true);
    }



}
