package com.ejianc.business.tender.equipment.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.assist.material.vo.MaterialBatchPlanEnum;
import com.ejianc.business.pro.rmat.vo.BatchPlanEnum;
import com.ejianc.business.purchaseplan.vo.PurchasePlanEnum;
import com.ejianc.business.tender.common.service.IMessageService;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteDetailEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentService;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteDetailService;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.equipment.service.IEquipmentPicketageRefsupplierService;
import com.ejianc.business.tender.equipment.vo.EquipmentInviteDetailVO;
import com.ejianc.business.tender.equipment.bean.EquipmentPicketageRefsupplierEntity;
import com.ejianc.business.tender.equipment.vo.EquipmentInviteDetailBidderVO;
import com.ejianc.business.tender.rmat.bean.RmatInviteDetailRecordEntity;
import com.ejianc.business.tender.stuff.vo.TenderStageEnum;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("equipmentInvite")
public class EquipmentInviteBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IPushMessageApi pushMessageApi;

	@Autowired
	private IEquipmentInviteService service;

	@Autowired
	private IEquipmentInviteDetailService detailService;

	@Autowired
	private IEquipmentPicketageRefsupplierService picketageRefsupplierService;

	@Autowired
	private IProjectPoolApi projectPoolApi;
	@Autowired
	private IMessageService messageService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		if(BillStateEnum.COMMITED_STATE.getBillStateCode() == state ||BillStateEnum.PASSED_STATE.getBillStateCode() == state) {
			EquipmentInviteEntity inviteEntity = service.selectById(billId);
			List<EquipmentInviteDetailVO> detailVOList = new ArrayList<>();
			if (inviteEntity.getPurchaseType()==0){
				 detailVOList = service.selectSumDetail(billId);
			}else {
				 detailVOList  =  service.selectOrgSumDetail(billId);
			}
			for (EquipmentInviteDetailVO equipmentInviteDetailVO : detailVOList) {
				equipmentInviteDetailVO.setNum(equipmentInviteDetailVO.getSumNum());
				equipmentInviteDetailVO.setMoney(equipmentInviteDetailVO.getSumMoney());
				equipmentInviteDetailVO.setMoneyTax(equipmentInviteDetailVO.getSumMoneyTax());
				equipmentInviteDetailVO.setPlanNum(equipmentInviteDetailVO.getSumPlanNum());
				detailService.saveOrUpdate(BeanMapper.map(equipmentInviteDetailVO, EquipmentInviteDetailEntity.class));
			}
			if (inviteEntity.getEstablishType()==1){
				// 获取采购计划ID
				if (CollectionUtils.isNotEmpty(inviteEntity.getEquipmentDetailRecord())) {
					// 释放采购计划
					service.updateApiState(inviteEntity, PurchasePlanEnum.PLAN_STATE_OVER.getPlanState(), PurchasePlanEnum.PLAN_STATE_OVER.getPlanState());
				}
			}
			List<EquipmentInviteDetailBidderVO> detailBidderList =  service.selectDetailBidder(billId);
			String tenderUnitNum = "";
			for (EquipmentInviteDetailBidderVO detailBidderVO : detailBidderList) {
				EquipmentPicketageRefsupplierEntity equipmentPicketageRefsupplierEntity = new EquipmentPicketageRefsupplierEntity();
				equipmentPicketageRefsupplierEntity.setPicketageId(billId);
				equipmentPicketageRefsupplierEntity.setPicketageName(inviteEntity.getTenderName()+"定标");
				equipmentPicketageRefsupplierEntity.setPicketageDate(new Date());
				equipmentPicketageRefsupplierEntity.setMoney(detailBidderVO.getSumMoney());
				equipmentPicketageRefsupplierEntity.setMoneyTax(detailBidderVO.getSumTaxMoney());
				equipmentPicketageRefsupplierEntity.setSupplierId(detailBidderVO.getSupplierId());
				equipmentPicketageRefsupplierEntity.setSupplierName(detailBidderVO.getSupplierName());
				equipmentPicketageRefsupplierEntity.setProjectId(detailBidderVO.getDetailProjectId());
				equipmentPicketageRefsupplierEntity.setProjectName(detailBidderVO.getDetailProjectName());
				//如果是项目招标，子表orgId为项目部id
				if (inviteEntity.getPurchaseType()==0){
					Map<Long, ProjectPoolSetVO> proMap = new HashMap<>();
					CommonResponse<JSONArray> jsonArrayCommonResponse = projectPoolApi.queryProjectByIds(Collections.singletonList(detailBidderVO.getDetailProjectId()));
					if (jsonArrayCommonResponse.isSuccess()){
						JSONArray data = jsonArrayCommonResponse.getData();
						List<ProjectPoolSetVO> projectRegisterVOS = data.toJavaList(ProjectPoolSetVO.class);
						proMap = projectRegisterVOS.stream().collect(Collectors.toMap(ProjectPoolSetVO::getId, Function.identity()));
						ProjectPoolSetVO projectPoolSetVO = proMap.get(detailBidderVO.getDetailProjectId());
						if (projectPoolSetVO != null){
							equipmentPicketageRefsupplierEntity.setOrgId(projectPoolSetVO.getProjectDepartmentId());
							equipmentPicketageRefsupplierEntity.setOrgName(projectPoolSetVO.getProjectDepartmentName());
						}
					}
				}else {
					equipmentPicketageRefsupplierEntity.setOrgId(detailBidderVO.getDetailOrgId());
					equipmentPicketageRefsupplierEntity.setOrgName(detailBidderVO.getDetailOrgName());
				}
				//暂时使用主表
//				equipmentPicketageRefsupplierEntity.setProjectId(inviteEntity.getProjectId());
//				equipmentPicketageRefsupplierEntity.setProjectName(inviteEntity.getProjectName());
//				equipmentPicketageRefsupplierEntity.setProjectCode(inviteEntity.getProjectCode());
//				equipmentPicketageRefsupplierEntity.setOrgId(inviteEntity.getOrgId());
//				equipmentPicketageRefsupplierEntity.setOrgName(inviteEntity.getOrgName());
//				equipmentPicketageRefsupplierEntity.setParentOrgId(inviteEntity.getParentOrgId());
//				equipmentPicketageRefsupplierEntity.setParentOrgName(inviteEntity.getParentOrgName());
				equipmentPicketageRefsupplierEntity.setOccupyFlag(0);
				equipmentPicketageRefsupplierEntity.setPicketageFlag(1);
				equipmentPicketageRefsupplierEntity.setSignStatus(0);
				equipmentPicketageRefsupplierEntity.setPurchaseType(inviteEntity.getPurchaseType());
				equipmentPicketageRefsupplierEntity.setCategoryId(inviteEntity.getCategoryId());
				equipmentPicketageRefsupplierEntity.setCategoryName(inviteEntity.getCategoryName());
				picketageRefsupplierService.saveOrUpdate(equipmentPicketageRefsupplierEntity);
				BigDecimal sumNum = detailBidderVO.getSumNum().setScale(4,BigDecimal.ROUND_HALF_UP);
				tenderUnitNum+=detailBidderVO.getSupplierName()+"("+sumNum+"),";
			}
			if (tenderUnitNum.length() > 1) {
				tenderUnitNum = tenderUnitNum.substring(0,tenderUnitNum.length() -1);
			}
			inviteEntity.setTenderUnitNum(tenderUnitNum);
			service.saveOrUpdate(inviteEntity);
			if(inviteEntity.getEstablishType() == 0){
				//招标立项
				//发送首席消息
				CommonResponse<JSONArray> commonResponse = projectPoolApi.queryProjectPoolById(inviteEntity.getProjectId());
				if(commonResponse.isSuccess()){
					JSONArray array = commonResponse.getData();
					List<ProjectPoolSetVO> vos = JSONObject.parseArray(array.toJSONString(), ProjectPoolSetVO.class);
					ProjectPoolSetVO vo = vos.get(0);
					Long costAdapter = vo.getCostAdapter();
					messageService.sendSys(
							"设备购置招标："+inviteEntity.getTenderName()+"已完成立项!",
							inviteEntity.getId(),
							costAdapter+"",
							"equipment%2finvite%2fcard"
					);
				}

			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		EquipmentInviteEntity inviteEntity = service.selectById(billId);
		if (inviteEntity.getOccupyState()!= null && inviteEntity.getOccupyState()==1){
			return CommonResponse.error("招标已被占用,不能撤回!");
		}
		if (inviteEntity.getTenderStage()>1){
			return CommonResponse.error("招标处于"+ TenderStageEnum.getEnumByStateCode(inviteEntity.getTenderStage()).getDescription()+",不能撤回!");
		}
		if (inviteEntity.getEstablishType()==1){
			QueryWrapper<EquipmentPicketageRefsupplierEntity> refWrapper = new QueryWrapper<>();
			refWrapper.eq("picketage_id",inviteEntity.getId());
			List<EquipmentPicketageRefsupplierEntity> refsupplierEntityList = picketageRefsupplierService.list(refWrapper);
			for (EquipmentPicketageRefsupplierEntity refsupplierEntity : refsupplierEntityList) {
				if (refsupplierEntity.getSignStatus()!=0){
					return CommonResponse.error("存在已签订合同,不能撤回!");
				}
			}
			picketageRefsupplierService.remove(refWrapper);
		}
		detailService.delByInviteId(inviteEntity.getId());
//		QueryWrapper<EquipmentInviteDetailEntity> detailWrapper = new QueryWrapper<>();
//		detailWrapper.eq("invite_id",inviteEntity.getId());
//		detailService.remove(detailWrapper);
		return CommonResponse.success();
//        return CommonResponse.error("该功能不支持！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		EquipmentInviteEntity inviteEntity = service.selectById(billId);
		if (inviteEntity.getEstablishType()==1){
			// 获取采购计划ID
			if (CollectionUtils.isNotEmpty(inviteEntity.getEquipmentDetailRecord())) {
				// 释放采购计划
				service.updateApiState(inviteEntity, PurchasePlanEnum.PLAN_STATE_EXEC.getPlanState(), PurchasePlanEnum.PLAN_STATE_EXEC.getPlanState());
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 审批--获取当前节点的审批人---从服务中选择
	 *
	 * @param billId 单据id
	 * @param billTypeCode 单据类型编码
	 * @param sign 节点标志
	 * @return
	 */
	@Override
	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other){
		JSONArray arr = new JSONArray();
		logger.info("sign:{}",sign);

		//根据标识判断是否（成本相关人员审批的）节点
		if ("choseCostUser".equals(sign)){
			//获取表单详情数据

			//根据项目id获取项目基本信息中的成本对接人信息
			EquipmentInviteEntity entity = service.selectById(billId);
			Long projectId = entity.getProjectId();

			JSONObject jsonObject = new JSONObject();
			CommonResponse<JSONArray> commonResponse = projectPoolApi.queryProjectPoolById(projectId);


			if(!commonResponse.isSuccess()){
				throw new BusinessException("查询项目失败!");
			}
			JSONArray array = commonResponse.getData();
			List<ProjectPoolSetVO> vos = JSONObject.parseArray(array.toJSONString(), ProjectPoolSetVO.class);

			logger.info("vos:{}",JSONObject.toJSONString(vos));

			ProjectPoolSetVO vo = vos.get(0);
			Long costAdapter = vo.getCostAdapter();
			String costAdapterName = vo.getCostAdapterName();

			logger.info("userId:{}",costAdapter);
			logger.info("userName:{}",costAdapterName);


			jsonObject.put("userId",costAdapter);
			jsonObject.put("userName",costAdapterName);

			arr.add(jsonObject);

		}
		return CommonResponse.success(arr);
	}

}
