package com.ejianc.business.tender.rent.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.rent.vo.RentPicketageSupplierVO;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rent.bean.RentPicketageSupplierEntity;
import com.ejianc.business.tender.rent.mapper.RentPicketageSupplierMapper;
import com.ejianc.business.tender.rent.service.IRentInviteService;
import com.ejianc.business.tender.rent.service.IRentPicketageService;
import com.ejianc.business.tender.rent.service.IRentPicketageSupplierService;
import com.ejianc.business.tender.rent.service.IRentWinnoticeService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 定标供应商表
 * 
 * @author generator
 * 
 */
@Service("rentPicketageSupplierService")
public class RentPicketageSupplierServiceImpl extends BaseServiceImpl<RentPicketageSupplierMapper, RentPicketageSupplierEntity> implements IRentPicketageSupplierService {
    @Autowired
    private IRentPicketageSupplierService rentPicketageSupplierService;
    @Autowired
    private IRentPicketageService rentPicketageService;
    @Autowired
    private IRentWinnoticeService rentWinnoticeService;
    @Autowired
    private IRentInviteService rentInviteService;
    @Autowired
    private IProcessService processService;
    @Override
    public List<RentPicketageSupplierVO> queryDetail(Long id) {
        LambdaQueryWrapper<RentPicketageSupplierEntity> lambdaSupplierList = Wrappers.lambdaQuery();
        lambdaSupplierList.eq(RentPicketageSupplierEntity::getPicketageId,id);
        List<RentPicketageSupplierEntity> listSupplier = rentPicketageSupplierService.list(lambdaSupplierList);
        List<RentPicketageSupplierVO> rentPicketageSupplierVOS = BeanMapper.mapList(listSupplier, RentPicketageSupplierVO.class);

        return rentPicketageSupplierVOS;
    }
}
