package com.ejianc.business.tender.rmat.controller;

import java.io.Serializable;

import com.ejianc.business.tender.other.service.IOtherPicketageService;
import com.ejianc.business.tender.rent.service.IRentPicketageService;
import com.ejianc.business.tender.rmat.service.IRmatPicketageService;
import com.ejianc.business.tender.rmat.bean.RmatAdviceEntity;
import com.ejianc.business.tender.rmat.bean.RmatPicketageEntity;
import com.ejianc.business.tender.rmat.vo.RmatAdviceVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.tender.rmat.bean.RmatAdviceEntity;
import com.ejianc.business.tender.rmat.service.IRmatAdviceService;
import com.ejianc.business.tender.rmat.vo.RmatAdviceVO;

/**
 * 周转材-中标通知书
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("rmatAdvice")
public class RmatAdviceController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "rmat-advice-code";//此处需要根据实际修改
    @Autowired
    private IRmatPicketageService rmatPicketageService;
    @Autowired
    private IRmatAdviceService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RmatAdviceVO> saveOrUpdate(@RequestBody RmatAdviceVO saveOrUpdateVO) {
        RmatAdviceEntity entity = BeanMapper.map(saveOrUpdateVO, RmatAdviceEntity.class);
        if(entity.getBillCode() == null){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setScFlag(0);
        service.saveOrUpdate(entity, false);
        RmatAdviceVO vo = BeanMapper.map(entity, RmatAdviceVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RmatAdviceVO> queryDetail(Long id) {
        RmatAdviceEntity entity = service.selectById(id);
        RmatPicketageEntity rmatPicketageEntity = rmatPicketageService.selectById(entity.getPicketageId());
        RmatAdviceVO vo = BeanMapper.map(entity, RmatAdviceVO.class);
        vo.setTrusteesId(rmatPicketageEntity.getTrusteesId());
        vo.setTrusteesName(rmatPicketageEntity.getTrusteesName());
        vo.setTrusteesPhone(rmatPicketageEntity.getTrusteesPhone());
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @RequestMapping(value = "/queryAdviceList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<RmatAdviceVO>> queryAdviceList(@RequestParam Long id) {
        List<RmatAdviceVO> list = service.queryAdviceList(id);
        return CommonResponse.success("查询详情数据成功！",list);
    }
    /**
     * @Description 发布接口
     * @param id
     */
    @RequestMapping(value = "/sendAdvice", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> sendAdvice(Long id) {
        String s = service.sendAdvice(id);
        return CommonResponse.success("发送成功！",s);
    }
}
