package com.ejianc.business.tender.stuff.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.stuff.bean.*;
import com.ejianc.business.tender.stuff.mapper.StuffBidDetailMapper;
import com.ejianc.business.tender.stuff.service.*;
import com.ejianc.business.tender.stuff.vo.*;
import com.ejianc.business.tender.util.ThirdSystemUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.number.MathUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.sun.org.apache.bcel.internal.generic.ARRAYLENGTH;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.tender.stuff.mapper.StuffBidMapper;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;

/**
 * 中标主表
 * 
 * @author generator
 * 
 */
@Service("stuffBidService")
public class StuffBidServiceImpl extends BaseServiceImpl<StuffBidMapper, StuffBidEntity> implements IStuffBidService{
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IStuffPicketageService stuffPicketageService;
    @Autowired
    private IStuffNoticeService stuffNoticeService;
    @Autowired
    private IStuffWinnoticeService stuffWinnoticeService;
    @Autowired
    private IStuffDocumentService stuffDocumentService;
    @Autowired
    private IStuffInviteService stuffInviteService;
    @Autowired
    private IStuffBidDetailService stuffBidDetailService;
    @Autowired
    private IStuffDocumentSellService stuffDocumentSellService;
    @Autowired
    private IStuffBidSupplierService stuffBidSupplierService;
    @Autowired
    private IStuffDocumentSupplierService stuffDocumentSupplierService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IStuffPicketageSupplierService stuffPicketageSupplierService;
    @Autowired
    private IOrgApi iOrgApi;
    @Value("${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;

    @Value("${gysUrl.winbidSavesUrl}")
    private String winbidSavesUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    private org.slf4j.Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CacheManager cacheManager;
    private static final String BILL_CODE = "invite-bid-code";//此处需要根据实际修改
    @Override
    public StuffBidVO saveBid(Long picketageId) {
        StuffBidEntity entity = new StuffBidEntity();
        entity.setPicketageId(picketageId);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        StuffPicketageEntity stuffPicketageEntity = stuffPicketageService.selectById(picketageId);
        StuffInviteEntity inviteEntity = stuffInviteService.selectById(stuffPicketageEntity.getInviteId());
        entity.setInviteId(stuffPicketageEntity.getInviteId());
        entity.setBidName(inviteEntity.getTenderName());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        super.saveOrUpdate(entity, false);
        StuffBidVO vo = BeanMapper.map(entity, StuffBidVO.class);

        //回写定标数据
//        stuffPicketageEntity.setBidStatus(1);
        stuffPicketageEntity.setBidId(entity.getId());
        stuffPicketageService.updateById(stuffPicketageEntity);

        //处理供应商信息
        //获取材料明细报价
        LambdaQueryWrapper<StuffDocumentSellEntity> lambdaSell = Wrappers.<StuffDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(StuffDocumentSellEntity::getDocumentId, stuffPicketageEntity.getDocumentId());
        lambdaSell.eq(StuffDocumentSellEntity::getTenderFlag, 1);
        List<StuffDocumentSellEntity> sellList = stuffDocumentSellService.list(lambdaSell);
        List<StuffDocumentSellVO> stuffDocumentSellVOS = BeanMapper.mapList(sellList, StuffDocumentSellVO.class);
        Map<Long, List<StuffDocumentSellVO>> sellMap = stuffDocumentSellVOS.stream().
                collect(Collectors.groupingBy(StuffDocumentSellVO::getSupplierId));

        //查看供应商信息
        LambdaQueryWrapper<StuffDocumentSupplierEntity> lambdaSupplier = Wrappers.<StuffDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(StuffDocumentSupplierEntity::getDocumentId, stuffPicketageEntity.getDocumentId());
        lambdaSupplier.eq(StuffDocumentSupplierEntity::getTalkNum, 0);
        List<StuffDocumentSupplierEntity> supplierList = stuffDocumentSupplierService.list(lambdaSupplier);
        Map<Long, StuffDocumentSupplierEntity> supplierEntityMap = supplierList.stream().collect(Collectors.toMap(StuffDocumentSupplierEntity::getSupplierId, Function.identity(),(k1, k2) -> k2));

        //遍历map,组合数据返回
        ArrayList<StuffBidSupplierVO> supplierVOList = new ArrayList<>();
        List<StuffBidDetailEntity> stuffBidDetailEntityList = new ArrayList<>();
        sellMap.forEach((key,value) -> {
            StuffBidSupplierVO stuffBidSupplierVO = new StuffBidSupplierVO();
            stuffBidSupplierVO.setSupplierId(key);
            stuffBidSupplierVO.setSupplierName(value.stream().findFirst().get().getSupplierName());
            StuffDocumentSupplierEntity stuffDocumentSupplierEntity = supplierEntityMap.get(key);
            stuffBidSupplierVO.setLinkName(stuffDocumentSupplierEntity.getLinkName());
            stuffBidSupplierVO.setSupplierMobile(stuffDocumentSupplierEntity.getLinkMobile());
            stuffBidSupplierVO.setId(IdWorker.getId());

            //汇总中标金额
            BigDecimal tenderMoneyTax = BigDecimal.ZERO;
            BigDecimal tenderMoney = BigDecimal.ZERO;

            for (StuffDocumentSellVO stuffDocumentSellVO : value) {
                //汇总金额
                tenderMoneyTax = tenderMoneyTax
                        .add(stuffDocumentSellVO.getTenderMoneyTax() == null ? BigDecimal.ZERO : stuffDocumentSellVO
                                .getTenderMoneyTax());
                tenderMoney = tenderMoney
                        .add(stuffDocumentSellVO.getTenderMoney() == null ? BigDecimal.ZERO : stuffDocumentSellVO
                                .getTenderMoney());
                StuffBidDetailEntity stuffBidDetailEntity = BeanMapper.map(stuffDocumentSellVO, StuffBidDetailEntity.class);
                stuffBidDetailEntity.setMoney(stuffDocumentSellVO.getTenderMoney());
                stuffBidDetailEntity.setMoneyTax(stuffDocumentSellVO.getTenderMoneyTax());
                stuffBidDetailEntity.setId(null);
                stuffBidDetailEntity.setBidSupplierId(stuffBidSupplierVO.getId());
                stuffBidDetailEntity.setBidId(entity.getId());
                stuffBidDetailEntityList.add(stuffBidDetailEntity);

            }
            stuffBidSupplierVO.setMoneyTax(tenderMoneyTax);
            stuffBidSupplierVO.setMoney(tenderMoney);
            stuffBidSupplierVO.setBidId(entity.getId());
            supplierVOList.add(stuffBidSupplierVO);
        });

        //新增供应商
        List<StuffBidSupplierEntity> stuffBidSupplierEntities = BeanMapper.mapList(supplierVOList, StuffBidSupplierEntity.class);
        stuffBidSupplierService.saveBatch(stuffBidSupplierEntities);
        stuffBidDetailService.saveBatch(stuffBidDetailEntityList);

        //回写中标供应商和数量
        String tenderUnitNum = "";
        //查询中标供应商
        List<StuffBidDetailEntity> bidDetailEntityList = baseMapper.selectBidSupplier(entity.getId());
        for (StuffBidDetailEntity stuffBidDetailEntity : bidDetailEntityList) {
            StuffBidSupplierEntity supplierEntity = stuffBidSupplierService.selectById(stuffBidDetailEntity.getBidSupplierId());
            BigDecimal sumNum = stuffBidDetailEntity.getTenderNum().setScale(4,BigDecimal.ROUND_HALF_UP);
            String name = supplierEntity.getSupplierName()+"("+sumNum+"),";
            tenderUnitNum += name;
        }
        if (tenderUnitNum.length() > 1) {
            tenderUnitNum = tenderUnitNum.substring(0,tenderUnitNum.length() -1);
        }
        inviteEntity.setTenderUnitNum(tenderUnitNum);
        stuffInviteService.saveOrUpdate(inviteEntity);

        StuffBidVO stuffBidVO = BeanMapper.map(entity, StuffBidVO.class);
        return stuffBidVO;
    }

    @Override
    public StuffBidVO queryDetail(Long bidId) {
        StuffBidEntity stuffBidEntity = super.selectById(bidId);
        StuffBidVO stuffBidVO = BeanMapper.map(stuffBidEntity, StuffBidVO.class);
        //组合数据
        List<StuffBidDetailVO> stuffBidDetailList  = stuffBidVO.getStuffBidDetailList();
        Map<Long, List<StuffBidDetailVO>> detailMap = stuffBidDetailList.stream().
                collect(Collectors.groupingBy(StuffBidDetailVO::getBidSupplierId));
        List<StuffBidSupplierVO> stuffBidSupplierList = stuffBidVO.getStuffBidSupplierList();
        for (StuffBidSupplierVO stuffBidSupplierVO : stuffBidSupplierList){
            stuffBidSupplierVO.setStuffBidDetailList(detailMap.get(stuffBidSupplierVO.getId()));
        }
        stuffBidVO.setStuffBidSupplierList(stuffBidSupplierList);
        return stuffBidVO;
//
    }
    @Transactional
    @Override
    public StuffBidVO publishBid(StuffBidVO saveorUpdateVO) {
        StuffBidEntity entity = super.selectById(saveorUpdateVO.getId());
        entity.setBidContent(saveorUpdateVO.getBidContent());
        entity.setBidName(saveorUpdateVO.getBidName());
        entity.setPublishFlag(0);
        entity.setBillState(1);
//        super.updateById(entity);
        StuffBidVO vo = BeanMapper.map(entity, StuffBidVO.class);

        //回写定标数据
//        StuffPicketageEntity stuffPicketageEntity = stuffPicketageService.selectById(entity.getPicketageId());
//        stuffPicketageEntity.setBidStatus(2);
//        stuffPicketageService.updateById(stuffPicketageEntity);

        //获取中标信息
        StuffInviteEntity stuffInviteEntity = stuffInviteService.selectById(entity.getInviteId());
        WinbidVO winbidVO = new WinbidVO();
        winbidVO.setSourceId(Long.toString(entity.getInviteId()));
        winbidVO.setBillCode(stuffInviteEntity.getBillCode());
        if (winbidVO.getPurchaseType()==null || winbidVO.getPurchaseType()==1){
            winbidVO.setSourceProjectId(null);
        }else {
            winbidVO.setSourceProjectId(Long.toString(stuffInviteEntity.getProjectId()));
        }
        winbidVO.setProjectName(stuffInviteEntity.getProjectName());
        winbidVO.setProjectCode(stuffInviteEntity.getProjectCode());
        winbidVO.setSourceOrgId(Long.toString(stuffInviteEntity.getOrgId()));
        winbidVO.setOrgName(stuffInviteEntity.getOrgName());
        winbidVO.setUnitName(stuffInviteEntity.getUnitName());
        winbidVO.setSourceUnitId(Long.toString(stuffInviteEntity.getUnitId()));
        winbidVO.setType("MATERIAL");
        winbidVO.setTenderName(stuffInviteEntity.getTenderName());
        winbidVO.setTenderType(stuffInviteEntity.getTenderType());
        winbidVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());

//        HashMap<Long, Long> hashMap = new HashMap<>();
//        hashMap.put(1406947724700246112L,1471726626618441730L);
//        hashMap.put(1406947724700246113L,1471729176256151553L);
//        hashMap.put(1406947724700246114L,1471731643794554881L);
//        hashMap.put(527888337260777477L,1472852233918054402L);
//
//        //云南建设总承包公司测试用户
//        hashMap.put(528220972239556690L,1473189202070044674L);
//        hashMap.put(528222266413027386L,1473189172567310338L);
//        hashMap.put(528222429273657395L,1473189113180160002L);
//        hashMap.put(528222690796900362L,1473190529172996098L);

        LambdaQueryWrapper<StuffDocumentEntity> lambdaDoc = Wrappers.<StuffDocumentEntity>lambdaQuery();
        lambdaDoc.eq(StuffDocumentEntity::getInviteId, entity.getInviteId());
        StuffDocumentEntity stuffDocumentEntity = stuffDocumentService.getOne(lambdaDoc);
        winbidVO.setNoticeBidTime(stuffDocumentEntity.getBidTime());
        winbidVO.setNoticeWinbidTime(new Date());

        if (stuffInviteEntity.getTenderType()==2 || stuffInviteEntity.getTenderType()==3 ||stuffInviteEntity.getTenderType()==4 ||stuffInviteEntity.getTenderType()==5){
            winbidVO.setSourceEmployeeId(Long.toString(stuffDocumentEntity.getEmployeeId()));
            winbidVO.setEmployeeName(stuffDocumentEntity.getEmployeeName());
            winbidVO.setEmployeeMobile(stuffDocumentEntity.getEmployeeMobile());
            winbidVO.setPurchaseType(stuffDocumentEntity.getPurchaseType());
        }else {
            //查询招标公告
            LambdaQueryWrapper<StuffNoticeEntity> lambdaNotice = Wrappers.<StuffNoticeEntity>lambdaQuery();
            lambdaNotice.eq(StuffNoticeEntity::getInviteId, entity.getInviteId());
            StuffNoticeEntity noticeEntity = stuffNoticeService.getOne(lambdaNotice);
            winbidVO.setSourceEmployeeId(Long.toString(noticeEntity.getEmployeeId()));
            winbidVO.setEmployeeName(noticeEntity.getEmployeeName());
            winbidVO.setEmployeeMobile(noticeEntity.getEmployeeMobile());
            winbidVO.setPurchaseType(noticeEntity.getPurchaseType());
        }

        //处理供应商信息
        StuffBidVO stuffBidVO = queryDetail(entity.getId());
        List<StuffBidSupplierVO> stuffBidSupplierList = stuffBidVO.getStuffBidSupplierList();
        //转换数据,推送供应商中标信息
        List<WinbidVO> winbidVOList = new ArrayList<>();
        for (StuffBidSupplierVO stuffBidSupplierVO : stuffBidSupplierList){
            WinbidVO winbidVONew = BeanMapper.map(winbidVO,WinbidVO.class);
            SupplierDTO supplierVO = shareSupplierApi.queryById(stuffBidSupplierVO.getSupplierId()).getData();
            winbidVONew.setTenantId(supplierVO.getTenant());
            winbidVONew.setWinbidMoneyTax(stuffBidSupplierVO.getMoneyTax());
            winbidVONew.setWinbidMoney(stuffBidSupplierVO.getMoney());
            winbidVONew.setContent(stuffBidVO.getBidContent());
            winbidVONew.setWinbidType(0);

            List<StuffBidDetailVO> stuffBidDetailList = stuffBidSupplierVO.getStuffBidDetailList();
            Map<String,List<StuffBidDetailVO>> map = new HashMap<>();
            for (StuffBidDetailVO stuffBidDetailVO : stuffBidDetailList){
                String s = null;
                if (stuffBidDetailVO.getMaterialId() == null){
                     s = stuffBidDetailVO.getMaterialTypeId().toString() +
                             (stuffBidDetailVO.getCalculateType() == null ? "" : stuffBidDetailVO.getCalculateType().toString()) +
                             stuffBidDetailVO.getRate() + stuffBidDetailVO.getSchemeId();
                }
                if (stuffBidDetailVO.getMaterialId() != null){
                    if(stuffBidDetailVO.getCalculateType()==null){
                        s = stuffBidDetailVO.getMaterialId().toString() + stuffBidDetailVO.getMaterialTypeId().toString() +
                                 stuffBidDetailVO.getRate() + stuffBidDetailVO.getSchemeId();
                    }else {
                        s = stuffBidDetailVO.getMaterialId().toString() + stuffBidDetailVO.getMaterialTypeId().toString() +
                                stuffBidDetailVO.getCalculateType().toString() + stuffBidDetailVO.getRate() + stuffBidDetailVO.getSchemeId();
                    }
                }
                if (map.containsKey(s)){
                    List<StuffBidDetailVO> stuffBidDetailVOS = map.get(s);
                    stuffBidDetailVOS.add(stuffBidDetailVO);
                    map.put(s,stuffBidDetailVOS);
                }else {
                    List<StuffBidDetailVO> stuffBidDetailVOList = new ArrayList<>();
                    stuffBidDetailVOList.add(stuffBidDetailVO);
                    map.put(s,stuffBidDetailVOList);
                }
            }
            //处理中标详情数据
            List<WinbidDetailVO> winbidDetailVOList = new ArrayList<>();
            map.forEach((key,value) ->{
                BigDecimal tenderNum = BigDecimal.ZERO;
                BigDecimal money = BigDecimal.ZERO;
                BigDecimal moneyTax = BigDecimal.ZERO;
                BigDecimal tax = BigDecimal.ZERO;
                for (StuffBidDetailVO stuffBidDetailVOLast : value){
                    tenderNum = tenderNum.add((stuffBidDetailVOLast.getTenderNum() == null) ? BigDecimal.ZERO : stuffBidDetailVOLast.getTenderNum());
                    money = money.add((stuffBidDetailVOLast.getMoney() == null) ? BigDecimal.ZERO : stuffBidDetailVOLast.getMoney());
                    moneyTax = moneyTax.add((stuffBidDetailVOLast.getMoneyTax() == null) ? BigDecimal.ZERO : stuffBidDetailVOLast.getMoneyTax());
                    tax = tax.add((stuffBidDetailVOLast.getSellTax() == null) ? BigDecimal.ZERO : stuffBidDetailVOLast.getSellTax());
                }
                StuffBidDetailVO first = value.stream().findFirst().get();
                WinbidDetailVO winbidDetailVO = new WinbidDetailVO();
                winbidDetailVO.setSourceId(Long.toString(entity.getInviteId()));
                winbidDetailVO.setSourceMaterialId(first.getMaterialId() == null ? null : Long.toString(first.getMaterialId()));
                winbidDetailVO.setMaterialName(first.getMaterialName());
                winbidDetailVO.setMaterialCode(first.getMaterialCode());
                winbidDetailVO.setSourceMaterialTypeId(Long.toString(first.getMaterialTypeId()));
                winbidDetailVO.setMaterialTypeName(first.getMaterialTypeName());
                winbidDetailVO.setUnit(first.getUnit());
                winbidDetailVO.setSpec(first.getSpec());
                winbidDetailVO.setBrand(first.getMaterialBrand());
                winbidDetailVO.setSupplierBrand(first.getBrand());
                winbidDetailVO.setPrice(first.getPrice());
                winbidDetailVO.setPriceTax(first.getPriceTax());
                winbidDetailVO.setMoney(money);
                winbidDetailVO.setMoneyTax(moneyTax);
                winbidDetailVO.setTax(tax);
                winbidDetailVO.setCalculateType(first.getCalculateType());
                winbidDetailVO.setMemo(first.getMaterialMemo());
                winbidDetailVO.setSupplierMemo(first.getMemo());
                winbidDetailVO.setMoney(money);
                winbidDetailVO.setRate(first.getRate());
                winbidDetailVO.setTenderNum(tenderNum);
                winbidDetailVO.setNum(first.getNum());
                winbidDetailVOList.add(winbidDetailVO);
            });
            winbidVONew.setWinbidDetailList(winbidDetailVOList);
            winbidVOList.add(winbidVONew);
        }
        String stringFb = JSONObject.toJSONString(winbidVOList);
        logger.info("推送供方中标信息:" +stringFb);
        //调用供方接口
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(winbidSavesUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("中标同步接口报错" + stringCommonResponse.getMsg());
        }
        //        try {
//            response = new ThirdSystemUtils().sendPostReq(tokenUrl,winbidSavesUrl, stringFb,cacheManager);
//            if(!response.isSuccess()) {
//                throw new BusinessException("中标同步接口报错" + response.getMsg());
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//            throw new BusinessException("中标同步接口报错" + response.getMsg());
//        }
        return queryDetail(vo.getId());
    }

    @Override
    public StuffBidVO queryDbDetail(Long picketage) {

        return null;
    }

    @Override
    public StuffBidVO nextPaper(Long winnoticeId) {
        StuffBidEntity entity = new StuffBidEntity();
        StuffWinnoticeEntity stuffWinnoticeEntity = stuffWinnoticeService.selectById(winnoticeId);
        StuffInviteEntity stuffInviteEntity = stuffInviteService.selectById(stuffWinnoticeEntity.getInviteId());
        entity.setInviteId(stuffWinnoticeEntity.getInviteId());
        entity.setBidName(stuffInviteEntity.getTenderName());
        entity.setPurchaseType(stuffInviteEntity.getPurchaseType());
        entity.setWinnoticeId(winnoticeId);
        super.saveOrUpdate(entity, false);

        //回写中标公告状态
        stuffWinnoticeEntity.setNextFlag(1);
        stuffWinnoticeService.updateById(stuffWinnoticeEntity);

        //回写招标阶段
        stuffInviteEntity.setTenderStage(TenderStageEnum.BID_NOTICE_STATE.getTenderTypeCode());
        stuffInviteService.updateById(stuffInviteEntity);

        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getDescription());
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(0);
        processEntity.setFrontendUrl("stuff/winLetter");
        processService.saveOrUpdate(processEntity);

        StuffBidVO stuffBidVO = BeanMapper.map(entity, StuffBidVO.class);
        return stuffBidVO;
    }

    @Override
    public List<StuffPicketageSupplierVO> querySupplierList(Long picketageId) {
        StuffBidEntity stuffBidEntity = super.selectById(picketageId);

        StuffWinnoticeEntity stuffWinnoticeEntity = stuffWinnoticeService.selectById(stuffBidEntity.getWinnoticeId());
        LambdaQueryWrapper<StuffPicketageSupplierEntity> lambdaSupplierList = Wrappers.lambdaQuery();
        lambdaSupplierList.eq(StuffPicketageSupplierEntity::getPicketageId,stuffWinnoticeEntity.getPicketageId());
        List<StuffPicketageSupplierEntity> listSupplier = stuffPicketageSupplierService.list(lambdaSupplierList);
        List<StuffPicketageSupplierVO> stuffPicketageSupplierVOS = BeanMapper.mapList(listSupplier, StuffPicketageSupplierVO.class);

        return stuffPicketageSupplierVOS;
    }
    @Transactional
    @Override
    public StuffPicketageVO insertProcess(Long picketageId) {

        StuffPicketageEntity stuffPicketageEntity = stuffPicketageService.selectById(picketageId);
        StuffInviteEntity stuffInviteEntity = stuffInviteService.selectById(stuffPicketageEntity.getInviteId());
        //回写招标阶段
        stuffInviteEntity.setTenderStage(TenderStageEnum.BID_NOTICE_STATE.getTenderTypeCode());
        stuffInviteService.updateById(stuffInviteEntity);

        //回写定标数据
        stuffPicketageEntity.setBidStatus(1);
        stuffPicketageService.updateById(stuffPicketageEntity);

        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(stuffPicketageEntity.getBidId());
        processEntity.setBillName(TenderStageEnum.BID_NOTICE_STATE.getDescription());
        processEntity.setTenderId(stuffInviteEntity.getId());
        processEntity.setType(0);
        processEntity.setFrontendUrl("stuff/winLetter");
        processService.saveOrUpdate(processEntity);
        StuffPicketageVO stuffPicketageVO = BeanMapper.map(stuffPicketageEntity, StuffPicketageVO.class);
        return stuffPicketageVO;
    }

    @Override
    public List<StuffPicketageSupplierVO> querySupplierDetail(Long id) {
        StuffBidEntity stuffBidEntity = super.selectById(id);
        return stuffPicketageService.querySupplierList(stuffBidEntity.getPicketageId());
    }
}
