package com.ejianc.business.tender.common.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.tender.common.service.ICheckService;
import com.ejianc.business.tender.common.service.IMessageService;
import com.ejianc.business.tender.common.vo.CheckVo;
import com.ejianc.business.tender.stuff.mapper.StuffDocumentMapper;
import com.ejianc.business.tender.stuff.vo.StuffDocumentVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.List;


/**
 * 流程表
 *
 * @author generator
 */
@Controller
@RequestMapping("messageTender")
public class MessageController implements Serializable {

    @Autowired
    private IMessageService service;

    @Autowired
    private StuffDocumentMapper mapper;

    @Autowired
    private IProjectPoolApi projectPoolApi;
    /**
     * 公开招采倒计时结束时，报价单位不足3家
     */
    @PostMapping(value = "/queryDocListLtThree")
    public CommonResponse<List<JSONObject>> queryDocListLtThree(HttpServletRequest request) {
        List<StuffDocumentVO> taskinstVOS = mapper.queryDocListLtThree();
        //发送消息
        if(CollectionUtils.isNotEmpty(taskinstVOS)) {
            for (StuffDocumentVO taskEntity : taskinstVOS) {
                CommonResponse<JSONArray> commonResponse = projectPoolApi.queryProjectPoolById(taskEntity.getProjectId());
                if(commonResponse.isSuccess()){
                    JSONArray array = commonResponse.getData();
                    List<ProjectPoolSetVO> vos = JSONObject.parseArray(array.toJSONString(), ProjectPoolSetVO.class);
                    ProjectPoolSetVO vo = vos.get(0);
                    Long costAdapter = vo.getCostAdapter();
                    service.sendSys(
                            "招标文件："+taskEntity.getDocumentName()+"报价时间已截止，报价不足三家!",
                            taskEntity.getId(),
                            costAdapter+"",
                            taskEntity.getMemo()+"%2ffourJzDyJjXj"
                    );
                }
                try {
                    //睡眠0.1s
                    Thread.currentThread().sleep(100);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return CommonResponse.success("执行成功！");
    }



}
