package com.ejianc.business.tender.common.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.supplier.api.ICheckSupplierApi;
import com.ejianc.business.pro.supplier.dto.CheckSupplierDTO;
import com.ejianc.business.pro.supplier.vo.CertificateVO;
import com.ejianc.business.pro.supplier.vo.LimitVO;
import com.ejianc.business.tender.common.service.ICheckService;
import com.ejianc.business.tender.common.service.IMessageService;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.prosub.bean.ProsubInviteEntity;
import com.ejianc.business.tender.prosub.service.IProsubInviteService;
import com.ejianc.business.tender.rent.bean.RentInviteEntity;
import com.ejianc.business.tender.rent.service.IRentInviteService;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.stuff.bean.StuffInviteEntity;
import com.ejianc.business.tender.stuff.service.IStuffInviteService;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.service.ISubInviteService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.share.vo.SubleadersVO;
import com.ejianc.foundation.share.vo.dto.CertsDTO;
import com.ejianc.foundation.supplier.api.IShareSubleadersApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@Service("messageService")
public class MessageServiceImpl implements IMessageService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Override
    public boolean sendSys(String message,Long id,String userId,String url){

        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);//发送企业微信标志
        channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        String[] receivers = {userId};
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType("earlywarning");//预警消息
        parameter.setSubject(message);// 标题
        parameter.setContent("内容");// 内容
        parameter.setPcUrl("/ejc-tender-frontend/#/stuff/invite/card?id="+id);// pc端url
        parameter.setMobileUrl("/ejc-tender-frontend/#/stuff/invite/card?id="+id);// 移动端url
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        JSONObject weixineeParams = new JSONObject();
        weixineeParams.put("agentid","1000036");//企业微信应用id
        weixineeParams.put("secret", "dBMuo3hXenzW-6B3U8BfscMDQWSr3ET1nfwUaqDPi40");//企业微信secret
        weixineeParams.put("msgtype", "textcard");
        weixineeParams.put("title", "立项完成提醒");
        weixineeParams.put("description",message);
        weixineeParams.put("url", ("https://pms.zzyjjt.com/portal/sso/index?&userid="+userId+
                "&targeturl=https%3a%2f%2fpms.zzyjjt.com%2fejc-tender-frontend%2f%23%2f" +
                url+"%3fid%3d"+id));//移动端点击的url
        weixineeParams.put("btntxt", "点击查看");
        parameter.setWeixineeParams(weixineeParams);

        CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
        if (result.isSuccess()) {
            return true;
        } else {
            return false;
        }
    }
}
